/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.entitymap.engine.valengine;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.bean.EntityMapMatchBean;
import kd.tmc.fbp.service.entitymap.engine.valengine.AbstractSetValEngine;
import org.apache.commons.lang3.tuple.Pair;

public class Hs2EStrategy
extends AbstractSetValEngine {
    @Override
    public void execute(DynamicObject[] srcBills, DynamicObject[] tagBills, EntityMapMatchBean entityMapMatchBean) {
        if ((srcBills = this.getSrcBillInfo(srcBills, tagBills, entityMapMatchBean)) == null) {
            return;
        }
        this.fieldPushBizByDyn(srcBills, tagBills, entityMapMatchBean);
    }

    @Override
    public void execute(DynamicObject[] srcBills, IDataModel tagModel, EntityMapMatchBean entityMapMatchBean) {
        this.fieldPushBizByModel(srcBills, tagModel, entityMapMatchBean);
    }

    private void fieldPushBizByModel(DynamicObject[] srcBills, IDataModel tagModel, EntityMapMatchBean entityMapMatchBean) {
        List<Pair<String[], String[]>> rowMapInfolist = entityMapMatchBean.getRowMapInfolist();
        String[] tagMatchFieldArray = entityMapMatchBean.getTagMatchFieldArray();
        String[] srcMatchFieldArray = entityMapMatchBean.getSrcMatchFieldArray();
        for (Pair<String[], String[]> rowMapInfo : rowMapInfolist) {
            String[] srcFieldArray = (String[])rowMapInfo.getKey();
            String[] targeFieldArray = (String[])rowMapInfo.getValue();
            if (targeFieldArray.length > 1) {
                Map srcBillMap = Arrays.stream(srcBills).collect(Collectors.toMap(o -> o.get(srcMatchFieldArray[0]), Function.identity(), (k1, k2) -> k1));
                DynamicObjectCollection tagEntryInfos = tagModel.getEntryEntity(tagMatchFieldArray[0]);
                for (int i = 0; i < tagEntryInfos.size(); ++i) {
                    DynamicObject tagEntry = (DynamicObject)tagEntryInfos.get(i);
                    Object tagMatchInfo = tagEntry.get(tagMatchFieldArray[1]);
                    DynamicObject srcInfo = (DynamicObject)srcBillMap.get(tagMatchInfo);
                    if (EmptyUtil.isEmpty((DynamicObject)srcInfo)) continue;
                    this.setPageModelByDynObj(tagModel, targeFieldArray[1], srcInfo.get(srcFieldArray[0]), i);
                }
                continue;
            }
            this.setPageModelByDynObj(tagModel, targeFieldArray[0], srcBills[0].get(srcFieldArray[0]));
        }
    }

    private void fieldPushBizByDyn(DynamicObject[] srcBills, DynamicObject[] tagBills, EntityMapMatchBean entityMapMatchBean) {
        List<Pair<String[], String[]>> rowMapInfolist = entityMapMatchBean.getRowMapInfolist();
        String[] tagMatchFieldArray = entityMapMatchBean.getTagMatchFieldArray();
        String[] srcMatchFieldArray = entityMapMatchBean.getSrcMatchFieldArray();
        DynamicObject tagBill = tagBills[0];
        for (Pair<String[], String[]> rowMapInfo : rowMapInfolist) {
            String[] srcFieldArray = (String[])rowMapInfo.getKey();
            String[] targeFieldArray = (String[])rowMapInfo.getValue();
            if (targeFieldArray.length > 1) {
                Map srcBillMap = Arrays.stream(srcBills).collect(Collectors.toMap(o -> o.get(srcMatchFieldArray[0]), Function.identity(), (k1, k2) -> k1));
                DynamicObjectCollection tagEntryInfos = tagBill.getDynamicObjectCollection(tagMatchFieldArray[0]);
                for (DynamicObject tagEntry : tagEntryInfos) {
                    Object tagMatchInfo = tagEntry.get(tagMatchFieldArray[1]);
                    DynamicObject srcInfo = (DynamicObject)srcBillMap.get(tagMatchInfo);
                    if (EmptyUtil.isEmpty((DynamicObject)srcInfo)) continue;
                    this.setTagBillBySrcVal(tagEntry, targeFieldArray[1], srcInfo.get(srcFieldArray[0]));
                }
                continue;
            }
            this.setTagBillBySrcVal(tagBill, targeFieldArray[0], srcBills[0].get(srcFieldArray[0]));
        }
    }
}

