/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.entitymap.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BizRangeTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.entitymap.bean.EntityMapMatchBean;
import kd.tmc.fbp.service.entitymap.service.IEntityMapService;

public abstract class AbstractEntityMapService
implements IEntityMapService {
    protected static Log logger = LogFactory.getLog(AbstractEntityMapService.class);

    @Override
    public void execute(DynamicObject tagBill, Long entityMapId) {
        try {
            logger.info("AbstractEntityMapService msc exec bizType:{}  start...");
            EntityMapMatchBean entityMapMatchBean = EntityMapMatchBean.buildEntityModelBean(entityMapId);
            if (EmptyUtil.isNoEmpty((Object)entityMapMatchBean)) {
                this.executeBiz(null, new DynamicObject[]{tagBill}, entityMapMatchBean);
            }
            logger.info("AbstractEntityMapService msc exec bizType:{}  end...");
        }
        catch (Exception e) {
            logger.info("AbstractEntityMapService exec error");
            logger.error((Throwable)e);
        }
    }

    @Override
    public void execute(DynamicObject[] srcBills, DynamicObject[] tagBills, String bizType) {
        EntityMapMatchBean entityMapMatchBean = null;
        try {
            logger.info("AbstractEntityMapService sc exec bizType:{}  start...", (Object)bizType);
            entityMapMatchBean = EntityMapMatchBean.buildEntityModelBean(srcBills[0].getDynamicObjectType().getName(), tagBills[0].getDynamicObjectType().getName(), bizType);
            if (EmptyUtil.isNoEmpty((Object)entityMapMatchBean)) {
                this.executeBiz(srcBills, tagBills, entityMapMatchBean);
            } else {
                logger.info("AbstractEntityMapService sc exec bizType:{} no find entityMapMatchBean ...", (Object)bizType);
            }
            logger.info("AbstractEntityMapService sc exec bizType:{}  end...", (Object)bizType);
        }
        catch (Exception e) {
            logger.info("AbstractEntityMapService sc exec error");
            if (null != entityMapMatchBean) {
                logger.info(entityMapMatchBean.toString());
            }
            logger.error((Throwable)e);
        }
    }

    @Override
    public void execute(DynamicObject[] srcBills, IDataModel tagModel, String bizType) {
        try {
            logger.info("AbstractEntityMapService pagesc exec bizType:{}  start...", (Object)bizType);
            EntityMapMatchBean.setNeedChangeReverse(BizRangeTypeEnum.CHANGE.getValue().equals(bizType));
            EntityMapMatchBean entityMapMatchBean = EntityMapMatchBean.buildEntityModelBean(srcBills[0].getDynamicObjectType().getName(), tagModel.getDataEntityType().getName(), bizType);
            EntityMapMatchBean.setNeedChangeReverse(false);
            if (EmptyUtil.isNoEmpty((Object)entityMapMatchBean)) {
                this.executeBiz(srcBills, tagModel, entityMapMatchBean);
            }
            logger.info("AbstractEntityMapService pagesc exec bizType:{}  end...", (Object)bizType);
        }
        catch (Exception e) {
            logger.info("AbstractEntityMapService pagesc exec error");
            logger.error((Throwable)e);
        }
    }

    protected void executeBiz(DynamicObject[] srcBills, DynamicObject[] tagBills, EntityMapMatchBean entityMapMatchBean) {
    }

    protected void executeBiz(DynamicObject[] srcBills, IDataModel tagModel, EntityMapMatchBean entityMapMatchBean) {
    }

    @Override
    public List<String> getExtSelectorProp(String scrEntity, String tagEntity, String bizType, boolean isSrcProp) {
        ArrayList<String> fieldList = new ArrayList<String>();
        DynamicObjectCollection entityMaps = this.getEntityMapProps(scrEntity, tagEntity, bizType, this.getOpSelectProp());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entityMaps)) {
            fieldList.addAll(entityMaps.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString(isSrcProp ? "entryentity.srcfield" : "entryentity.targetfield"))).map(o -> o.getString(isSrcProp ? "entryentity.srcfield" : "entryentity.targetfield")).collect(Collectors.toSet()));
        }
        return fieldList;
    }

    @Override
    public List<String> getExtSelectorProp(List<String> scrEntitys, List<String> tagEntitys, String bizType, boolean isSrcProp) {
        ArrayList<String> fieldList = new ArrayList<String>();
        DynamicObjectCollection entityMaps = this.getEntityMapProps(scrEntitys, tagEntitys, bizType, this.getOpSelectProp());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entityMaps)) {
            fieldList.addAll(entityMaps.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString(isSrcProp ? "entryentity.srcfield" : "entryentity.targetfield"))).map(o -> o.getString(isSrcProp ? "entryentity.srcfield" : "entryentity.targetfield")).collect(Collectors.toSet()));
        }
        return fieldList;
    }

    private DynamicObjectCollection getEntityMapProps(String scrEntity, String tagEntity, String bizType, String selectProps) {
        QFilter qFilter = new QFilter("biztype", "=", (Object)bizType).and("srcentity.number", "=", (Object)scrEntity).and("tagentity.number", "=", (Object)tagEntity).and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"fbd_entitymapmodel", (String)selectProps, (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection getEntityMapProps(List<String> scrEntitys, List<String> tagEntitys, String bizType, String selectProps) {
        QFilter qFilter = new QFilter("biztype", "=", (Object)bizType).and("srcentity.number", "in", scrEntitys).and("tagentity.number", "in", tagEntitys).and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"fbd_entitymapmodel", (String)selectProps, (QFilter[])qFilter.toArray());
    }

    private String getOpSelectProp() {
        return "id,entryentity.srcfield,entryentity.targetfield";
    }
}

