/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.interest;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.inst.bean.CalcIntInfo;
import kd.tmc.fbp.service.inst.helper.IntBillDetailHelper;
import kd.tmc.fbp.service.inst.helper.IntSegmentHelper;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;

public abstract class AbstractIntCallStragety
implements IIntCallStragety {
    protected static final Log logger = LogFactory.getLog(AbstractIntCallStragety.class);
    protected int ROUND;
    protected int SCALE;

    private void init(BizBillInfo bizBill) {
        this.ROUND = bizBill.getRound().getRound();
        if (bizBill.getScale() != null) {
            this.SCALE = bizBill.getScale();
        } else {
            DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)bizBill.getCurrencyId(), (String)"bd_currency", (String)"amtprecision");
            this.SCALE = currency.getInt("amtprecision");
        }
    }

    @Override
    public IntBillInfo callInt(IntCalRequest request) {
        logger.info("call int paramer\uff1a" + SerializationUtils.toJsonString((Object)request));
        this.truncateDate(request);
        BizBillInfo bizBill = request.getBizBill();
        this.init(bizBill);
        Date payDate = bizBill.getEndDate();
        this.initDateByHTRule(bizBill);
        Date beginDate = bizBill.getBeginDate();
        Date endDate = bizBill.getEndDate();
        if (endDate.before(beginDate) || EmptyUtil.isEmpty((Collection)request.getRateList())) {
            logger.info("---endDate.before(beginDate)------");
            return null;
        }
        List<IntBillDetailInfo> detailList = this.getSubRate(request.getRateList(), beginDate, endDate);
        logger.info("\u5229\u7387\u5206\u6bb5\uff1a" + SerializationUtils.toJsonString(detailList));
        detailList = this.getSubPrinciple(request, detailList);
        logger.info("\u672c\u91d1\u5206\u6bb5\uff1a" + SerializationUtils.toJsonString(detailList));
        if (IntCalMethodEnum.compcallint != bizBill.getIntCalMethod() && !bizBill.isCalCompInt()) {
            detailList = this.mergeDetail(detailList);
        }
        detailList = this.getSubForActAct(detailList, bizBill);
        BigDecimal totalInt = this.callInt(detailList, bizBill);
        IntBillInfo intBill = this.genIntBill(detailList, payDate, totalInt);
        this.setCallIntDate(intBill, detailList, bizBill);
        logger.info("call int intBill: " + SerializationUtils.toJsonString((Object)intBill));
        return intBill;
    }

    private void initDateByHTRule(BizBillInfo bizBill) {
        Date endDate = bizBill.getEndDate();
        Date beginDate = bizBill.getBeginDate();
        IntHTRuleEnum rule = bizBill.getHtRule();
        switch (rule) {
            case headnotail: {
                bizBill.setEndDate(DateUtils.getLastDay((Date)endDate, (int)1));
                break;
            }
            case noheadnotail: {
                bizBill.setBeginDate(DateUtils.getNextDay((Date)beginDate, (int)1));
                bizBill.setEndDate(DateUtils.getLastDay((Date)endDate, (int)1));
                break;
            }
            case noheadtail: {
                bizBill.setBeginDate(DateUtils.getNextDay((Date)beginDate, (int)1));
                break;
            }
        }
    }

    protected List<IntBillDetailInfo> getSubRate(Set<RateInfo> rateList, Date beginDate, Date endDate) {
        List<IntBillDetailInfo> detailList = IntSegmentHelper.getSubRate(rateList, beginDate, endDate);
        return IntSegmentHelper.orderAGenEndDateAndDays(detailList, endDate);
    }

    protected List<IntBillDetailInfo> getSubPrinciple(IntCalRequest request, List<IntBillDetailInfo> detailList) {
        return IntSegmentHelper.getSubPrinciple(detailList, request.getBizBill(), request.getRepayList(), request.isPreInt());
    }

    protected List<IntBillDetailInfo> getSubForActAct(List<IntBillDetailInfo> detailList, BizBillInfo bizBill) {
        return IntSegmentHelper.splitForActAct(detailList, bizBill.getStartIntDate(), bizBill.getBasis());
    }

    protected List<IntBillDetailInfo> mergeDetail(List<IntBillDetailInfo> detailList) {
        return IntBillDetailHelper.mergeDetailByRateAndPrinciple(detailList);
    }

    protected abstract BigDecimal callInt(List<IntBillDetailInfo> var1, BizBillInfo var2);

    protected BigDecimal callInt(CalcIntInfo calcIntInfo) {
        switch (calcIntInfo.getCalMethod()) {
            case onecallint: {
                return this.callOneInt(calcIntInfo);
            }
            case periodcallint: {
                return this.callPeriodInt(calcIntInfo);
            }
            case compcallint: {
                return this.callCompInt(calcIntInfo);
            }
        }
        return this.callTotalInt(calcIntInfo);
    }

    protected BigDecimal callOneInt(CalcIntInfo calcIntInfo) {
        return calcIntInfo.callOneInt(this.SCALE, this.ROUND);
    }

    protected BigDecimal callPeriodInt(CalcIntInfo calcIntInfo) {
        return calcIntInfo.callPeriodInt(this.SCALE, this.ROUND);
    }

    protected BigDecimal callTotalInt(CalcIntInfo calcIntInfo) {
        return calcIntInfo.callTotalInt(this.SCALE, this.ROUND);
    }

    protected BigDecimal callCompInt(CalcIntInfo calcIntInfo) {
        return calcIntInfo.callCompInt(this.SCALE, this.ROUND);
    }

    protected IntBillInfo genIntBill(List<IntBillDetailInfo> detailList, Date payDate, BigDecimal totalInt) {
        IntBillInfo intBill = new IntBillInfo();
        intBill.setBizDate(payDate);
        intBill.setAmount(totalInt.setScale(this.SCALE, this.ROUND));
        intBill.setDetails(detailList);
        return intBill;
    }

    private void setCallIntDate(IntBillInfo intBill, List<IntBillDetailInfo> detailList, BizBillInfo bizBill) {
        if (EmptyUtil.isEmpty(detailList)) {
            return;
        }
        IntBillDetailInfo detail = detailList.stream().min(Comparator.comparing(IntBillDetailInfo::getBeginDate)).orElse(null);
        if (detail != null) {
            intBill.setBeginDate(detail.getBeginDate());
        }
        if ((detail = (IntBillDetailInfo)detailList.stream().max(Comparator.comparing(IntBillDetailInfo::getEndDate)).orElse(null)) != null) {
            intBill.setEndDate(detail.getEndDate());
        }
    }

    private void truncateDate(IntCalRequest request) {
        Set rateList;
        List repayList;
        BizBillInfo bizBill = request.getBizBill();
        bizBill.setBeginDate(DateUtils.truncateDate((Date)bizBill.getBeginDate()));
        bizBill.setEndDate(DateUtils.truncateDate((Date)bizBill.getEndDate()));
        if (bizBill.getStartIntDate() != null) {
            bizBill.setStartIntDate(DateUtils.truncateDate((Date)bizBill.getStartIntDate()));
        }
        if (EmptyUtil.isNoEmpty((Object)(repayList = request.getRepayList()))) {
            repayList.forEach(d -> d.setBizDate(DateUtils.truncateDate((Date)d.getBizDate())));
        }
        if (EmptyUtil.isNoEmpty((Object)(rateList = request.getRateList()))) {
            rateList.forEach(d -> d.setEffectiveDate(DateUtils.truncateDate((Date)d.getEffectiveDate())));
        }
    }
}

