/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.interest;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.inst.bean.CalcIntInfo;
import kd.tmc.fbp.service.inst.helper.IntSegmentHelper;
import kd.tmc.fbp.service.inst.interest.AbstractIntCallStragety;

public class DBDXIntCallStragety
extends AbstractIntCallStragety {
    @Override
    protected List<IntBillDetailInfo> getSubRate(Set<RateInfo> rateList, Date beginDate, Date endDate) {
        List<IntBillDetailInfo> detailList = IntSegmentHelper.getSubRateByDebx(rateList, beginDate);
        return IntSegmentHelper.orderAGenEndDateAndDays(detailList, endDate);
    }

    @Override
    protected BigDecimal callInt(List<IntBillDetailInfo> details, BizBillInfo bizBill) {
        BigDecimal totalInt = BigDecimal.ZERO;
        DynamicObject repayScheme = TmcDataServiceHelper.loadSingleFromCache((Object)bizBill.getRepaySchemeId(), (String)"cfm_repayagingcheme", (String)"period");
        BigDecimal period = RepaySchemeEnum.getMonthByPeriod((String)repayScheme.getString("period"));
        for (IntBillDetailInfo detail : details) {
            CalcIntInfo calcIntInfo = CalcIntInfo.build(detail.getBeginDate(), detail.getEndDate(), bizBill.getLoanAmount(), detail.getRate(), bizBill.getBasis()).setStartIntDate(bizBill.getStartIntDate());
            calcIntInfo.setLastTotalInt(totalInt);
            BigDecimal amount = this.callDBDXInt(calcIntInfo, period, bizBill.getPeriod());
            detail.setAmount(amount);
            totalInt = totalInt.add(amount);
            calcIntInfo.setCurTotalInt(totalInt);
            detail.setBasisDay(calcIntInfo.getBasisDay());
        }
        return totalInt;
    }

    protected BigDecimal callDBDXInt(CalcIntInfo calcIntInfo, BigDecimal totalPeriod, int period) {
        boolean isMorePeriod;
        BigDecimal principle = calcIntInfo.getPrinciple();
        BigDecimal yearRate = calcIntInfo.getRate();
        BigDecimal intAmt = BigDecimal.ZERO;
        boolean bl = isMorePeriod = totalPeriod.compareTo(BigDecimal.ONE) > 0;
        if (isMorePeriod) {
            intAmt = principle.multiply(yearRate).divide(Constants.ONE_HUNDRED.multiply(totalPeriod), this.SCALE, this.ROUND);
        }
        Date beginDate = calcIntInfo.getBeginDate();
        Date endDate = calcIntInfo.getEndDate();
        if (period == 1 && !DateUtils.isSameDay((Date)beginDate, (Date)endDate)) {
            if (isMorePeriod) {
                endDate = DateUtils.getLastMonth((Date)endDate, (int)1);
            }
            CalcIntInfo calcIntInfo1 = CalcIntInfo.build(beginDate, endDate, principle, yearRate, calcIntInfo.getBasis()).setStartIntDate(calcIntInfo.getStartIntDate());
            BigDecimal zorePeriodInt = this.callTotalInt(calcIntInfo1);
            intAmt = intAmt.add(zorePeriodInt);
            calcIntInfo.setBasisDay(calcIntInfo1.getBasisDay());
        } else {
            calcIntInfo.setBasisDay(TermHelper.getBasis_YearDay((Date)beginDate, (Date)endDate, (BasisEnum)calcIntInfo.getBasis()));
        }
        return intAmt;
    }

    @Override
    protected List<IntBillDetailInfo> getSubForActAct(List<IntBillDetailInfo> detailList, BizBillInfo bizBill) {
        return detailList;
    }
}

