/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.interest;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.service.inst.bean.CalcIntInfo;
import kd.tmc.fbp.service.inst.helper.IntSegmentHelper;
import kd.tmc.fbp.service.inst.interest.AbstractIntCallStragety;

public class DEBXIntCallStragety
extends AbstractIntCallStragety {
    @Override
    protected List<IntBillDetailInfo> getSubPrinciple(IntCalRequest request, List<IntBillDetailInfo> detailList) {
        List repayList = request.getRepayList();
        BizBillInfo bizBill = request.getBizBill();
        Date endDate = bizBill.getEndDate();
        this.callSubPrinciple(detailList, bizBill, repayList, bizBill.getPeriod());
        return IntSegmentHelper.orderAGenEndDateAndDays(detailList, endDate);
    }

    @Override
    protected BigDecimal callInt(List<IntBillDetailInfo> details, BizBillInfo bizBill) {
        BigDecimal amount = BigDecimal.ZERO;
        for (IntBillDetailInfo detail : details) {
            amount = amount.add(detail.getAmount());
            int basisDay = TermHelper.getBasis_YearDay((Date)detail.getBeginDate(), (Date)detail.getEndDate(), (BasisEnum)bizBill.getBasis());
            detail.setBasisDay(basisDay);
        }
        return amount;
    }

    @Override
    protected List<IntBillDetailInfo> getSubRate(Set<RateInfo> rateList, Date beginDate, Date endDate) {
        List<IntBillDetailInfo> detailList = IntSegmentHelper.getSubRateByDebx(rateList, beginDate);
        return IntSegmentHelper.orderAGenEndDateAndDays(detailList, endDate);
    }

    public void callSubPrinciple(List<IntBillDetailInfo> detailList, BizBillInfo bizBill, List<PlanCallResult> repayList, int period) {
        BigDecimal principle = bizBill.getLoanAmount();
        for (IntBillDetailInfo detail : detailList) {
            BigDecimal repayAmt = this.callSubPrinciple(detail, bizBill, principle, repayList, period);
            principle = principle.subtract(repayAmt);
        }
    }

    public BigDecimal callSubPrinciple(IntBillDetailInfo detail, BizBillInfo bizBill, BigDecimal principle, List<PlanCallResult> repayList, int period) {
        BigDecimal amount;
        int totalPeriod = repayList.size();
        BigDecimal periodRate = this.callPeriodRate(bizBill, detail.getRate(), period);
        if (totalPeriod == period) {
            amount = principle;
            for (PlanCallResult repayBill : repayList) {
                amount = amount.subtract(repayBill.getPrinciple());
            }
            detail.setPrinciple(amount);
        } else {
            BigDecimal molecular = principle.multiply(periodRate).multiply(Constants.ONE.add(periodRate).pow(period - 1));
            BigDecimal denominator = Constants.ONE.add(periodRate).pow(totalPeriod).subtract(Constants.ONE);
            amount = molecular.divide(denominator, this.SCALE, this.ROUND);
            detail.setPrinciple(amount);
        }
        BigDecimal intAmt = this.callDEBJInt(bizBill.getLoanAmount(), periodRate, totalPeriod, period);
        if (period == 1 && !DateUtils.isSameDay((Date)bizBill.getBeginDate(), (Date)detail.getEndDate())) {
            Date endDate = DateUtils.getLastMonth((Date)detail.getEndDate(), (int)1);
            BigDecimal zorePeriodInt = this.callTotalInt(CalcIntInfo.build(bizBill.getBeginDate(), endDate, principle, detail.getRate(), bizBill.getBasis()).setStartIntDate(bizBill.getStartIntDate()));
            intAmt = intAmt.add(zorePeriodInt);
        }
        detail.setAmount(intAmt);
        return amount;
    }

    protected BigDecimal callDEBJInt(BigDecimal loanAmt, BigDecimal periodRate, int totalPeriod, int period) {
        BigDecimal molecular = loanAmt.multiply(periodRate).multiply(Constants.ONE.add(periodRate).pow(totalPeriod).subtract(Constants.ONE.add(periodRate).pow(period - 1)));
        BigDecimal denominator = Constants.ONE.add(periodRate).pow(totalPeriod).subtract(Constants.ONE);
        return molecular.divide(denominator, this.SCALE, this.ROUND);
    }

    private BigDecimal callPeriodRate(BizBillInfo bizBill, BigDecimal yearRate, int period) {
        DynamicObject repayScheme = TmcDataServiceHelper.loadSingleFromCache((Object)bizBill.getRepaySchemeId(), (String)"cfm_repayagingcheme", (String)"period");
        return yearRate.divide(Constants.ONE_HUNDRED.multiply(RepaySchemeEnum.getMonthByPeriod((String)repayScheme.getString("period"))), 20, this.ROUND);
    }

    @Override
    protected List<IntBillDetailInfo> getSubForActAct(List<IntBillDetailInfo> detailList, BizBillInfo bizBill) {
        return detailList;
    }
}

