/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.interest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.model.interest.BalanceRateInfo;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.inst.bean.CalcIntInfo;
import kd.tmc.fbp.service.inst.helper.IntBillDetailHelper;
import kd.tmc.fbp.service.inst.interest.AbstractIntCallStragety;

public class ZHYEIntCallNewStragety
extends AbstractIntCallStragety {
    @Override
    protected BigDecimal callInt(List<IntBillDetailInfo> details, BizBillInfo bizBill) {
        BigDecimal totalInt = BigDecimal.ZERO;
        int seq = 0;
        for (IntBillDetailInfo detail : details) {
            CalcIntInfo calcIntInfo = CalcIntInfo.build(detail.getBeginDate(), detail.getEndDate(), detail.getPrinciple(), detail.getRate(), bizBill.getBasis(), bizBill.getIntCalMethod()).setLastTotalInt(totalInt).setStartIntDate(bizBill.getStartIntDate());
            detail.setLastTotalInt(totalInt);
            BigDecimal amount = this.callInt(calcIntInfo);
            detail.setAmount(amount);
            totalInt = InterTypeEnum.overdue == detail.getIntType() ? totalInt.subtract(amount) : totalInt.add(amount);
            calcIntInfo.setCurTotalInt(totalInt);
            detail.setSeq(++seq);
            detail.setBasisDay(calcIntInfo.getBasisDay());
        }
        return totalInt;
    }

    @Override
    protected List<IntBillDetailInfo> mergeDetail(List<IntBillDetailInfo> detailList) {
        return detailList;
    }

    @Override
    protected List<IntBillDetailInfo> getSubPrinciple(IntCalRequest request, List<IntBillDetailInfo> detailList) {
        List balanceList = request.getRepayList();
        BizBillInfo bizBill = request.getBizBill();
        balanceList.sort(Comparator.comparing(PlanCallResult::getBizDate));
        detailList.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        List<BalanceRateInfo> balanceRateInfoList = this.getBalanceRateList(detailList, balanceList, bizBill);
        List<IntBillDetailInfo> detailInfos = this.calcIntBillDetailInfos(bizBill.isCalOverInt(), balanceRateInfoList);
        detailInfos = this.addZeroIntBillDetailInfo(request, detailList, detailInfos);
        return detailInfos;
    }

    private List<IntBillDetailInfo> addZeroIntBillDetailInfo(IntCalRequest request, List<IntBillDetailInfo> detailList, List<IntBillDetailInfo> detailInfos) {
        if (detailInfos.isEmpty()) {
            return detailInfos;
        }
        Date reqBeginDate = request.getBizBill().getBeginDate();
        Date reqEndDate = request.getBizBill().getEndDate();
        Map<Date, List<IntBillDetailInfo>> detailInfoMap = detailInfos.stream().collect(Collectors.groupingBy(IntBillDetailInfo::getBeginDate));
        Date lastEndDate = null;
        int size = detailInfos.size();
        for (int i = 0; i < size; ++i) {
            Date nextDay;
            List list;
            IntBillDetailInfo detail;
            IntBillDetailInfo detailInfo = detailInfos.get(i);
            Date beginDate = detailInfo.getBeginDate();
            if (i == 0 && beginDate.after(reqBeginDate)) {
                detail = this.buildIntBillDetailInfo(detailList, reqBeginDate, DateUtils.getLastDay((Date)beginDate, (int)1), detailInfo);
                list = detailInfoMap.computeIfAbsent(detail.getBeginDate(), d -> new ArrayList(1));
                list.add(detail);
            }
            if (lastEndDate != null && (nextDay = DateUtils.getNextDay(lastEndDate, (int)1)).before(beginDate)) {
                IntBillDetailInfo lastDetailInfo = detailInfos.get(i - 1);
                IntBillDetailInfo detail2 = this.buildIntBillDetailInfo(detailList, nextDay, DateUtils.getLastDay((Date)beginDate, (int)1), lastDetailInfo);
                List list2 = detailInfoMap.computeIfAbsent(detail2.getBeginDate(), d -> new ArrayList(1));
                list2.add(detail2);
            }
            lastEndDate = detailInfo.getEndDate();
            if (i != detailInfos.size() - 1 || !detailInfo.getEndDate().before(reqEndDate)) continue;
            detail = this.buildIntBillDetailInfo(detailList, DateUtils.getNextDay((Date)detailInfo.getEndDate(), (int)1), reqEndDate, detailInfo);
            list = detailInfoMap.computeIfAbsent(detail.getBeginDate(), d -> new ArrayList(1));
            list.add(detail);
        }
        ArrayList<IntBillDetailInfo> intBillDetailInfos = new ArrayList<IntBillDetailInfo>(detailInfoMap.size());
        for (List<IntBillDetailInfo> list : detailInfoMap.values()) {
            intBillDetailInfos.addAll(list);
        }
        intBillDetailInfos.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        for (int i = 0; i < intBillDetailInfos.size(); ++i) {
            intBillDetailInfos.get(i).setSeq(i + 1);
        }
        return intBillDetailInfos;
    }

    private IntBillDetailInfo buildIntBillDetailInfo(List<IntBillDetailInfo> detailList, Date beginDate, Date endDate, IntBillDetailInfo lastDetailInfo) {
        IntBillDetailInfo detail = new IntBillDetailInfo();
        detail.setBeginDate(beginDate);
        detail.setEndDate(endDate);
        detail.setPrinciple(BigDecimal.ZERO);
        IntBillDetailInfo rateInfo = IntBillDetailHelper.getNearestRateInfo(detailList, beginDate);
        detail.setRate(rateInfo != null ? rateInfo.getRate() : BigDecimal.ZERO);
        detail.setBasisDay(lastDetailInfo.getBasisDay());
        detail.setDays(DateUtils.getDiffDays((Date)detail.getBeginDate(), (Date)detail.getEndDate()));
        detail.setAmount(BigDecimal.ZERO);
        detail.setLastTotalInt(lastDetailInfo.getLastTotalInt());
        return detail;
    }

    protected List<IntBillDetailInfo> calcIntBillDetailInfos(boolean isCalOverInt, List<BalanceRateInfo> balanceRateInfoList) {
        List<Object> billDetailList = new ArrayList(16);
        Map<BigDecimal, List<BalanceRateInfo>> rateListMap = balanceRateInfoList.stream().collect(Collectors.groupingBy(BalanceRateInfo::calcRate));
        for (Map.Entry<BigDecimal, List<BalanceRateInfo>> rateEntry : rateListMap.entrySet()) {
            BigDecimal rate = rateEntry.getKey();
            List<BalanceRateInfo> balanceRateList = this.mergeBalanceByBizDate(rateEntry.getValue());
            balanceRateList.sort(Comparator.comparing(BalanceRateInfo::getBizDate));
            Date nextBizDate = null;
            BigDecimal lastPrinciple = BigDecimal.ZERO;
            IntBillDetailInfo detailInfo = null;
            int size = balanceRateList.size() - 1;
            for (int i = 0; i <= size; ++i) {
                boolean isChangeZero;
                BalanceRateInfo floatRateInfo = balanceRateList.get(i);
                Date bizDate = floatRateInfo.getBizDate();
                BigDecimal principle = floatRateInfo.getPrinciple();
                boolean isNotContinus = nextBizDate != null && nextBizDate.compareTo(bizDate) != 0;
                boolean isChangeNegativeAmt = this.isNegativeAmt(principle) != this.isNegativeAmt(lastPrinciple);
                boolean bl = isChangeZero = this.isZero(principle) != this.isZero(lastPrinciple);
                if (i == 0 || isNotContinus || isChangeNegativeAmt || isChangeZero) {
                    detailInfo = new IntBillDetailInfo();
                    detailInfo.setRate(rate);
                    detailInfo.setPrinciple(BigDecimal.ZERO);
                    detailInfo.setBeginDate(bizDate);
                    detailInfo.setDays(0);
                    billDetailList.add(detailInfo);
                }
                nextBizDate = DateUtils.getNextDay((Date)bizDate, (int)1);
                this.updateIntBillDetailInfo(isCalOverInt, detailInfo, bizDate, principle);
                lastPrinciple = principle;
            }
        }
        billDetailList = billDetailList.stream().filter(b -> EmptyUtil.isNoEmpty((BigDecimal)b.getPrinciple())).collect(Collectors.toList());
        billDetailList.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        logger.info("\u8ba1\u7b97\u672c\u91d1\u5229\u7387\u660e\u7ec6: {}", (Object)SerializationUtils.toJsonString(billDetailList));
        return billDetailList;
    }

    private void updateIntBillDetailInfo(boolean isCalOverInt, IntBillDetailInfo detailInfo, Date bizDate, BigDecimal principle) {
        if (detailInfo == null) {
            return;
        }
        boolean negativeAmt = this.isNegativeAmt(principle);
        if ((!negativeAmt || isCalOverInt) && detailInfo.getPrinciple() != null) {
            detailInfo.setPrinciple(detailInfo.getPrinciple().add(principle != null ? principle.abs() : BigDecimal.ZERO));
        }
        InterTypeEnum interTypeEnum = negativeAmt ? InterTypeEnum.overdue : InterTypeEnum.normal;
        detailInfo.setIntType(interTypeEnum);
        detailInfo.setDays(detailInfo.getDays() + 1);
        detailInfo.setEndDate(bizDate);
    }

    private List<BalanceRateInfo> mergeBalanceByBizDate(List<BalanceRateInfo> balanceRateList) {
        boolean isMerge = false;
        Map<String, List<BalanceRateInfo>> mergeBizDateMap = balanceRateList.stream().collect(Collectors.groupingBy(BalanceRateInfo::groupByBizDate));
        for (Map.Entry<String, List<BalanceRateInfo>> entry : mergeBizDateMap.entrySet()) {
            List<BalanceRateInfo> mergeList = entry.getValue();
            if (mergeList.size() <= 1) continue;
            BalanceRateInfo balanceRateInfo = mergeList.get(0);
            for (int i = mergeList.size() - 1; i >= 1; --i) {
                balanceRateInfo.setPrinciple(balanceRateInfo.getPrinciple().add(mergeList.get(i).getPrinciple()));
                mergeList.remove(i);
            }
            isMerge = true;
        }
        if (isMerge) {
            ArrayList<BalanceRateInfo> balanceRateInfos = new ArrayList<BalanceRateInfo>(16);
            for (List<BalanceRateInfo> infos : mergeBizDateMap.values()) {
                balanceRateInfos.addAll(infos);
            }
            return balanceRateInfos;
        }
        return balanceRateList;
    }

    protected List<BalanceRateInfo> getBalanceRateList(List<IntBillDetailInfo> detailList, List<PlanCallResult> balanceList, BizBillInfo bizBill) {
        if (EmptyUtil.isEmpty(balanceList)) {
            return Collections.emptyList();
        }
        Date beginDate = bizBill.getBeginDate();
        Date endDate = bizBill.getEndDate();
        BigDecimal overBp = BigDecimal.ZERO;
        if (bizBill.isCalOverInt() && bizBill.getOverPoint() != null) {
            overBp = bizBill.getOverPoint().divide(Constants.ONE_HUNDRED, 10, 4);
        }
        ArrayList<BalanceRateInfo> balanceRateFloatList = new ArrayList<BalanceRateInfo>(16);
        TreeMap<Date, List<PlanCallResult>> dateListMap = new TreeMap<Date, List<PlanCallResult>>(balanceList.stream().collect(Collectors.groupingBy(PlanCallResult::getBizDate)));
        this.addNotContinusBalance(beginDate, endDate, dateListMap);
        for (Map.Entry<Date, List<PlanCallResult>> entry : dateListMap.entrySet()) {
            Date bizDate = entry.getKey();
            List<PlanCallResult> balances = entry.getValue();
            for (PlanCallResult balance : balances) {
                boolean isOverBp;
                if (bizDate.before(beginDate) || bizDate.after(endDate)) continue;
                BalanceRateInfo balanceRateInfo = new BalanceRateInfo();
                BigDecimal principle = balance.getPrinciple();
                balanceRateInfo.setPrinciple(principle);
                balanceRateInfo.setFloatRate(balance.getFloatRate()).setBizDate(bizDate);
                IntBillDetailInfo rateInfo = IntBillDetailHelper.getNearestRateInfo(detailList, bizDate);
                balanceRateInfo.setRate(rateInfo != null ? rateInfo.getRate() : BigDecimal.ZERO);
                boolean isOverAmt = this.isNegativeAmt(principle);
                balanceRateInfo.setInterType(isOverAmt ? InterTypeEnum.overdue : InterTypeEnum.normal);
                boolean bl = isOverBp = overBp != null && overBp.abs().compareTo(BigDecimal.ZERO) > 0;
                if (isOverAmt && isOverBp) {
                    BigDecimal floatRate = balanceRateInfo.getFloatRate();
                    balanceRateInfo.setFloatRate(floatRate != null ? floatRate.add(overBp) : overBp);
                }
                balanceRateFloatList.add(balanceRateInfo);
            }
        }
        logger.info("\u672c\u91d1\u548c\u5229\u7387\u5408\u5e76\u4fe1\u606f\u5217\u8868: {}", (Object)SerializationUtils.toJsonString(balanceRateFloatList));
        return balanceRateFloatList;
    }

    private void addNotContinusBalance(Date beginDate, Date endDate, TreeMap<Date, List<PlanCallResult>> dateListMap) {
        Map.Entry<Date, List<PlanCallResult>> beforeEntry;
        Date lastDate = null;
        Date tempDate = beginDate;
        Date lastKeyDate = dateListMap.lastKey();
        if (lastKeyDate.before(beginDate)) {
            dateListMap.put(beginDate, dateListMap.get(lastKeyDate));
        }
        if ((beforeEntry = dateListMap.floorEntry(beginDate)) != null && !dateListMap.containsKey(beginDate)) {
            dateListMap.put(beginDate, beforeEntry.getValue());
        }
        while (tempDate.compareTo(endDate) <= 0) {
            if (lastDate != null && !dateListMap.containsKey(tempDate)) {
                List<PlanCallResult> balances = dateListMap.get(lastDate);
                dateListMap.put(tempDate, balances != null ? balances : Collections.emptyList());
            }
            lastDate = tempDate;
            tempDate = DateUtils.getNextDay((Date)tempDate, (int)1);
        }
    }

    private boolean isNegativeAmt(BigDecimal amount) {
        return amount != null && amount.compareTo(Constants.ZERO) < 0;
    }

    private boolean isZero(BigDecimal amount) {
        return amount != null && amount.compareTo(Constants.ZERO) == 0;
    }

    @Override
    protected BigDecimal callTotalInt(CalcIntInfo calcIntInfo) {
        return calcIntInfo.callTotalIntForZhye(this.SCALE, this.ROUND);
    }

    @Override
    protected BigDecimal callCompInt(CalcIntInfo calcIntInfo) {
        return calcIntInfo.callCompIntForZhye(this.SCALE, this.ROUND);
    }
}

