/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.inst.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RepayPlanCallRequest;
import kd.tmc.fbp.common.model.interest.RepaySchemeInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fbp.service.inst.plan.AbstractPlanCallStragety;

public class IntPlanCallStragety
extends AbstractPlanCallStragety {
    public List<PlanCallResult> callPlan(IntCalRequest request) {
        this.logger.info("\u751f\u6210\u5229\u606f\u7ed3\u606f/\u6536\u76ca\u8ba1\u5212\u8bf7\u6c42\u53c2\u6570: {}", (Object)SerializationUtils.toJsonString((Object)request));
        RepayPlanCallRequest callRequest = new RepayPlanCallRequest();
        BizBillInfo bizBill = request.getBizBill();
        callRequest.setBeginDate(bizBill.getBeginDate()).setEndDate(bizBill.getEndDate()).setRepayWay(bizBill.getRepayWay()).setBalanceList(request.getRepayList()).setSettleIntMode(bizBill.getSettleIntMode());
        RepaySchemeInfo schemeInfo = this.trans2RepaySchemeInfo(bizBill.getIntSchemeId());
        callRequest.setSchemeInfo(schemeInfo);
        return this.createPlan(callRequest);
    }

    protected RepaySchemeInfo trans2RepaySchemeInfo(Long schemeId) {
        if (schemeId == null) {
            return null;
        }
        DynamicObject schemeObj = TmcDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cfm_inscheme");
        if (schemeObj == null) {
            return null;
        }
        RepaySchemeInfo schemeInfo = new RepaySchemeInfo();
        schemeInfo.setRepayScheme(RepaySchemeEnum.getByValue((String)schemeObj.getString("intereststpd")));
        schemeInfo.setRepayMonths(ListUtils.strToIntList((String)schemeObj.getString("intereststmh")));
        String day = schemeObj.getString("intereststday");
        if (EmptyUtil.isNotBlank((CharSequence)day)) {
            schemeInfo.setRepayDay(Integer.valueOf(Integer.parseInt(day)));
        }
        schemeInfo.setOffetDay(Integer.valueOf(schemeObj.getInt("offetday")));
        schemeInfo.setRepayMonthSettle(Boolean.valueOf(schemeObj.getBoolean("drawmonthsettle")));
        return schemeInfo;
    }

    @Override
    protected PlanCallResult createPlanByCycle(Date bizDate, boolean isLast, Integer offetDay) {
        PlanCallResult result = new PlanCallResult();
        if (isLast) {
            result.setBizDate(bizDate);
        } else {
            result.setBizDate(DateUtils.getNextDay((Date)bizDate, (int)1));
        }
        return result;
    }

    protected List<PlanCallResult> DQHX(RepayPlanCallRequest callRequest) {
        return callRequest.getBalanceList();
    }

    protected List<PlanCallResult> HBHX(RepayPlanCallRequest callRequest) {
        return callRequest.getBalanceList();
    }

    protected List<PlanCallResult> FQHX(RepayPlanCallRequest callRequest) {
        RepaySchemeInfo schemeInfo = callRequest.getSchemeInfo();
        if (schemeInfo == null) {
            return callRequest.getBalanceList();
        }
        switch (schemeInfo.getRepayScheme()) {
            case TOYEAR: 
            case TOQUARTER: 
            case TOMONTH: 
            case TOHALFYEAR: {
                return this.doToCycle(callRequest);
            }
            case YEAR: 
            case HALFYEAR: 
            case QUARTER: 
            case MONTH: {
                return this.doCycle(callRequest);
            }
            case DAY: {
                return this.doByDay(callRequest);
            }
            case ENDINTEREST: {
                return this.YKK(callRequest.getEndDate());
            }
        }
        return callRequest.getBalanceList();
    }

    protected List<PlanCallResult> YKK(Date bizDate) {
        ArrayList<PlanCallResult> repayList = new ArrayList<PlanCallResult>(1);
        PlanCallResult result = new PlanCallResult();
        result.setBizDate(bizDate);
        repayList.add(result);
        return repayList;
    }

    @Override
    public List<PlanCallResult> createPlan(RepayPlanCallRequest callRequest) {
        switch (callRequest.getRepayWay()) {
            case bqhblsbq: {
                return this.DQHX(callRequest);
            }
            case zdyhk: {
                SettleIntModeEnum settleIntMode = callRequest.getSettleIntMode();
                if (settleIntMode == null) {
                    return Collections.EMPTY_LIST;
                }
                switch (settleIntMode) {
                    case gdpljx: {
                        return this.FQHX(callRequest);
                    }
                    case ykx: {
                        return this.YKK(callRequest.getEndDate());
                    }
                }
                return Collections.EMPTY_LIST;
            }
            case bqhbdqhx: 
            case dqhbdqhx: {
                return this.FQHX(callRequest);
            }
        }
        return this.HBHX(callRequest);
    }
}

