/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.paywriteback;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.RefundPayBillInfo;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.refund.SourceBillInfo;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.IPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackOperateEnum;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public abstract class AbstractPayBillWriteBackService
implements IPayBillWriteBackService {
    private static final Log logger = LogFactory.getLog(AbstractPayBillWriteBackService.class);
    private static final String TMC_FBP_MSERVICE = "tmc-fbp-mservice";
    private static final String SELECT_FIELDS = "id,billno,actpayamt,entry.e_sourcebillid,entry.e_actamt";
    private static final String ENTRY_E_SOURCEBILLID = "entry.e_sourcebillid";
    private static final String E_SOURCEBILLID = "e_sourcebillid";
    private static final Set<String> HEAD_SOURCEBILLID_ENTITYS = new HashSet<String>(Arrays.asList("fbd_suretybill", "fbd_suretyreleasebill", "fbd_surety_append", "lc_buyerint", "tm_rateswap", "tm_structdeposit", "tm_bond", "tm_bond_float", "tm_forex_options", "tm_bond_fix", "tm_businessbill"));

    @Override
    public void execute(Object params) {
        if (params instanceof List) {
            this.doExecute((List)params);
        } else if (params instanceof RefundRenoteOrCancelParam) {
            this.doExecute((RefundRenoteOrCancelParam)params);
        } else if (params instanceof Map) {
            this.doExecute((Map)params);
        }
    }

    private void doExecute(List<Map<String, Object>> params) {
        if (EmptyUtil.isEmpty(params)) {
            logger.error("paybillwriteback in param empty");
            return;
        }
        this.checkEntryChange(params);
        this.doPayBillWriteBack(params);
    }

    protected void checkEntryChange(List<Map<String, Object>> params) {
        Map<String, Object> param = params.get(0);
        String operate = (String)param.get("operate");
        if (PayBillWriteBackOperateEnum.isSaveOrSubmitValidate(operate)) {
            DynamicObject info = (DynamicObject)param.get("info");
            DynamicObjectCollection entrys = QueryServiceHelper.query((String)"cas_paybill", (String)ENTRY_E_SOURCEBILLID, (QFilter[])new QFilter("id", "=", (Object)info.getLong("id")).toArray());
            if (entrys.isEmpty()) {
                return;
            }
            Set oldSourcebillIds = entrys.stream().map(s -> s.getLong(ENTRY_E_SOURCEBILLID)).collect(Collectors.toSet());
            HashSet sourcebillIds = new HashSet(oldSourcebillIds);
            Set newSourcebillIds = info.getDynamicObjectCollection("entry").stream().map(e -> e.getLong(E_SOURCEBILLID)).collect(Collectors.toSet());
            sourcebillIds.removeAll(newSourcebillIds);
            if (!sourcebillIds.isEmpty()) {
                throw new KDBizException(this.loadKDString("%s\u5931\u8d25: \u4e0d\u5141\u8bb8\u5220\u9664\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u3002", "AbstractPayBillWriteBackService_09", PayBillWriteBackOperateEnum.getName(operate)));
            }
            newSourcebillIds.removeAll(oldSourcebillIds);
            if (!newSourcebillIds.isEmpty()) {
                throw new KDBizException(this.loadKDString("%s\u5931\u8d25: \u4ed8\u6b3e\u5355\u7684\u6e90\u5355id\u88ab\u7be1\u6539\u3002", "AbstractPayBillWriteBackService_08", PayBillWriteBackOperateEnum.getName(operate)));
            }
        }
    }

    private void doExecute(Map<String, Object> param) {
        String paramJson = SerializationUtils.toJsonString(param);
        logger.info("refund or renote param:{}", (Object)paramJson);
        String operate = (String)param.get("operate");
        if (PayBillWriteBackOperateEnum.isRefundOrRenote(operate)) {
            RefundRenoteOrCancelParam params = (RefundRenoteOrCancelParam)SerializationUtils.fromJsonString((String)paramJson, RefundRenoteOrCancelParam.class);
            this.doExecute(params);
        }
    }

    private void doExecute(RefundRenoteOrCancelParam param) {
        logger.info("RefundRenoteOrCancelParam:{}", (Object)SerializationUtils.toJsonString((Object)param));
        String operate = param.getOperate();
        List refundPayInfos = param.getRefundPayInfos();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(refundPayInfos.size());
        for (RefundPayBillInfo refundPayInfo : refundPayInfos) {
            List entryInfos = refundPayInfo.getEntryInfos();
            HashMap entryInfoMap = new HashMap(entryInfos.size());
            for (RefundEntryInfo entryInfo : entryInfos) {
                HashMap<String, Object> map = new HashMap<String, Object>(20);
                map.put("operate", operate);
                List sourceInfos = entryInfo.getSourceInfos();
                if (EmptyUtil.isEmpty((Collection)sourceInfos)) {
                    throw new KDBizException(this.loadKDString("%s\u5931\u8d25: \u4f20\u5165\u6e90\u5355\u4fe1\u606f\u53c2\u6570\u4e3a\u7a7a\u3002", "AbstractPayBillWriteBackService_10", PayBillWriteBackOperateEnum.getName(operate)));
                }
                SourceBillInfo sourceBillInfo = (SourceBillInfo)sourceInfos.get(0);
                Long sourceBillId = sourceBillInfo.getSourcePk();
                Map entryMap = (Map)entryInfoMap.get(sourceBillId);
                if (entryMap != null) {
                    entryMap.put("refundamt", entryInfo.getRefundAmt().add((BigDecimal)entryMap.get("refundamt")));
                    continue;
                }
                map.put("sourcebillid", sourceBillId);
                map.put("targetpk", refundPayInfo.getTargetPk());
                map.put("targetbillno", entryInfo.getTargetBillNo());
                map.put("sourceentity", sourceBillInfo.getSourceEntity());
                map.put("amount", entryInfo.getAmount());
                map.put("bizdate", entryInfo.getBizdate());
                map.put("currencypk", entryInfo.getCurrencyPk());
                map.put("isdiffcur", entryInfo.getDiffCur());
                map.put("dpamt", entryInfo.getDpAmt());
                map.put("dpcurrency", entryInfo.getDpCurrency());
                map.put("refundamt", entryInfo.getRefundAmt());
                map.put("remainRefundAmt", refundPayInfo.getTotalRemainRefundAmt());
                map.put("refunddes", entryInfo.getReason());
                map.put("settletnumber", refundPayInfo.getSettletnumber());
                map.put("paydate", entryInfo.getPaydate());
                map.put("agreedrate", entryInfo.getAgreedRate());
                map.put("description", null);
                map.put("paymentidentify", null);
                params.add(map);
                entryInfoMap.put(sourceBillId, map);
            }
        }
        this.doExecute(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPayBillWriteBack(List<Map<String, Object>> params) {
        long startTime = System.currentTimeMillis();
        try {
            List<PayBillWriteBackParam> writeBackParams = this.getPayBillWriteBackParams(params);
            logger.info("paybillwriteback start, paybill:{}", (Object)SerializationUtils.toJsonString(writeBackParams));
            this.mergeBySourceBillId(writeBackParams);
            this.beforePayBillWriteBack(writeBackParams);
            writeBackParams.forEach(this::doExecute);
        }
        finally {
            logger.info("paybillwriteback end, total time :{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    protected boolean beforePayBillWriteBack(List<PayBillWriteBackParam> writeBackParams) {
        List sourceBillIds = writeBackParams.stream().filter(p -> EmptyUtil.isEmpty((Long)p.getPayBill().getSourceBillId())).collect(Collectors.toList());
        if (!sourceBillIds.isEmpty()) {
            String operate = writeBackParams.get(0).getOperate();
            throw new KDBizException(this.loadKDString("%s\u5931\u8d25: \u751f\u6210\u4ed8\u6b3e\u5355\u5b58\u5728\u6e90\u5355id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5botp\u662f\u5426\u6709\u914d\u7f6e\u5355\u636e\u5934\u548c\u4ed8\u6b3e\u660e\u7ec6\u7684\u6e90\u5355ID\u5b57\u6bb5\u6620\u5c04\u3002", "AbstractPayBillWriteBackService_07", PayBillWriteBackOperateEnum.getName(operate)));
        }
        return true;
    }

    private List<PayBillWriteBackParam> getPayBillWriteBackParams(List<Map<String, Object>> params) {
        ArrayList<PayBillWriteBackParam> writeBackParams = new ArrayList<PayBillWriteBackParam>(10);
        for (Map<String, Object> param : params) {
            String operate = param.get("operate").toString();
            DynamicObject info = (DynamicObject)param.get("info");
            if (info == null) {
                writeBackParams.addAll(this.buildWriteBackParams(operate, param));
                continue;
            }
            writeBackParams.addAll(this.buildWriteBackParams(operate, info));
        }
        return writeBackParams;
    }

    protected void mergeBySourceBillId(List<PayBillWriteBackParam> writeBackParams) {
        HashMap<Long, PayBillWriteBackParam> writeBackParamMap = new HashMap<Long, PayBillWriteBackParam>(writeBackParams.size());
        for (int i = writeBackParams.size() - 1; i >= 0; --i) {
            PayBillWriteBackParam writeBackParam = writeBackParams.get(i);
            PayBillWriteBackParam.PayBillInfo payBill = writeBackParam.getPayBill();
            Long sourceBillId = payBill.getSourceBillId();
            if (EmptyUtil.isEmpty((Long)sourceBillId)) continue;
            if (writeBackParamMap.containsKey(sourceBillId)) {
                PayBillWriteBackParam.PayBillInfo payBill2 = ((PayBillWriteBackParam)writeBackParamMap.get(sourceBillId)).getPayBill();
                payBill2.setAmount(payBill2.getAmount().add(payBill.getAmount())).setRefundamt(payBill2.getRefundamt().add(payBill.getRefundamt()));
                writeBackParams.remove(i);
                continue;
            }
            writeBackParamMap.put(sourceBillId, writeBackParam);
        }
    }

    private List<PayBillWriteBackParam> buildWriteBackParams(String operate, Map<String, Object> applyMap) {
        PayBillWriteBackParam writeBackParam = new PayBillWriteBackParam();
        writeBackParam.setOperate(operate);
        PayBillWriteBackParam.PayBillInfo payBill = writeBackParam.getPayBill();
        Long sourceBillId = (Long)applyMap.get("sourcepk");
        if (EmptyUtil.isEmpty((Long)sourceBillId)) {
            sourceBillId = (Long)applyMap.get("sourcebillid");
        }
        payBill.setPayBillId((Long)applyMap.get("targetpk")).setSourceBillEntryId((Long)applyMap.get("sourceentrypk")).setPayBillNo((String)applyMap.get("targetbillno")).setSourceBillId(sourceBillId).setSourceBillType((String)applyMap.get("sourceentity")).setSourceBillNumber(null).setAmount((BigDecimal)applyMap.get("amount")).setBizDate((Date)applyMap.get("bizdate")).setCurrencypk((Long)applyMap.get("currencypk")).setDiffCur((Boolean)applyMap.get("isdiffcur")).setDpAmt((BigDecimal)applyMap.get("dpamt")).setDpcurrency((Long)applyMap.get("dpcurrency")).setRefundamt((BigDecimal)applyMap.get("refundamt")).setRemainRefundAmt((BigDecimal)applyMap.get("remainRefundAmt")).setRefundDesc((String)applyMap.get("refunddes")).setSettletNumber((String)applyMap.get("settletnumber")).setPayDate((Date)applyMap.get("paydate")).setAgreedrate((BigDecimal)applyMap.get("agreedrate")).setDescription((String)applyMap.get("description")).setPaymentidentify((Long)applyMap.get("paymentidentify")).setSettleTag((String)applyMap.get("settletag"));
        if (applyMap.containsKey("iscommitbe")) {
            payBill.setCommitBe((Boolean)applyMap.get("iscommitbe"));
        }
        if (applyMap.containsKey("bankreturnmsg")) {
            payBill.setBankReturnMsg((String)applyMap.get("bankreturnmsg"));
        }
        return Collections.singletonList(writeBackParam);
    }

    private List<PayBillWriteBackParam> buildWriteBackParams(String operate, DynamicObject info) {
        ArrayList<PayBillWriteBackParam> writeBackParams = new ArrayList<PayBillWriteBackParam>(10);
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
        Map<Long, List<DynamicObject>> entryMap = entrys.stream().collect(Collectors.groupingBy(e -> e.getLong(E_SOURCEBILLID)));
        if (entryMap.size() > 1) {
            for (DynamicObject entry : entrys) {
                PayBillWriteBackParam writeBackParam = this.buildWriteBackParam(operate, info);
                writeBackParam.getPayBill().setSourceBillId(entry.getLong(E_SOURCEBILLID)).setSourceBillNumber(null).setAmount(entry.getBigDecimal("e_actamt")).setDpAmt(entry.getBigDecimal("e_actamt")).setSourceBillEntryId(entry.getLong("e_sourcebillentryid"));
                writeBackParams.add(writeBackParam);
            }
        } else {
            PayBillWriteBackParam writeBackParam = this.buildWriteBackParam(operate, info);
            long sourcebillid = info.getLong("sourcebillid");
            long sourcebillEntryId = 0L;
            if (!entrys.isEmpty()) {
                DynamicObject entry = (DynamicObject)entrys.get(0);
                if (entry.getLong(E_SOURCEBILLID) > 0L) {
                    sourcebillid = entry.getLong(E_SOURCEBILLID);
                }
                sourcebillEntryId = entry.getLong("e_sourcebillentryid");
            }
            writeBackParam.getPayBill().setSourceBillId(sourcebillid).setSourceBillEntryId(sourcebillEntryId).setSourceBillNumber(info.getString("sourcebillnumber")).setAmount(info.getBigDecimal("actpayamt")).setDpAmt(info.getBigDecimal("dpamt"));
            writeBackParams.add(writeBackParam);
        }
        return writeBackParams;
    }

    private PayBillWriteBackParam buildWriteBackParam(String operate, DynamicObject info) {
        PayBillWriteBackParam param = new PayBillWriteBackParam();
        param.setOperate(operate);
        PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
        payBill.setPayBillId(info.getLong("id")).setPayBillNo(info.getString("billno")).setSourceBillType(info.getString("sourcebilltype")).setBizDate(info.getDate("bizdate")).setCurrencypk(info.getDynamicObject("currency").getLong("id")).setDiffCur(info.getBoolean("isdiffcur")).setDpcurrency(info.getDynamicObject("dpcurrency") != null ? Long.valueOf(info.getDynamicObject("dpcurrency").getLong("id")) : null).setSettletNumber(info.getString("settletnumber")).setPayDate(info.getDate("paydate")).setDescription(info.getString("description")).setPaymentidentify(info.getDynamicObject("paymentidentify") != null ? Long.valueOf(info.getDynamicObject("paymentidentify").getLong("id")) : null).setSettleTag(info.getString("settletag"));
        return param;
    }

    protected void doExecute(PayBillWriteBackParam param) {
        DynamicObject sourceBill = this.getSourceBill(param);
        PayBillWriteBackOperateEnum operateEnum = PayBillWriteBackOperateEnum.getByValue(param.getOperate());
        if (operateEnum == null) {
            this.doOtherExecute(param, sourceBill);
            return;
        }
        PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
        if (EmptyUtil.isEmpty((String)payBill.getSourceBillType())) {
            payBill.setSourceBillType(sourceBill.getDataEntityType().getName());
        }
        switch (operateEnum) {
            case SAVE: {
                this.doSaveExecute(param, sourceBill);
                break;
            }
            case SUBMIT: {
                this.doSubmitExecute(param, sourceBill);
                break;
            }
            case AUDIT: {
                this.doAuditExecute(param, sourceBill);
                break;
            }
            case PAY: {
                this.doPayExecute(param, sourceBill);
                break;
            }
            case CANCELPAY: {
                this.doCancelPayExecute(param, sourceBill);
                break;
            }
            case CHARGEBACK: {
                this.doChargebackExecute(param, sourceBill);
                break;
            }
            case REFUND: {
                this.doRefundExecute(param, sourceBill);
                break;
            }
            case RENOTE: {
                this.doRenoteExecute(param, sourceBill);
                break;
            }
            case RENOTEVALIDATE: {
                this.doRenoteValidateExecute(param, sourceBill);
                break;
            }
            case REFUNDVALIDATE: {
                this.doRefundValidateExecute(param, sourceBill);
                break;
            }
            case CANCELREFUND: {
                this.doCancelRefundExecute(param, sourceBill);
                break;
            }
            case CANCELRENOTE: {
                this.doCancelRenoteExecute(param, sourceBill);
                break;
            }
            case DELETE: {
                this.doDeleteExecute(param, sourceBill);
                break;
            }
            case SAVEVALIDATE: {
                this.doSaveValidateExecute(param, sourceBill);
                break;
            }
            case SUBMITVALIDATE: {
                this.doSubmitValidateExecute(param, sourceBill);
                break;
            }
            case AUDITVALIDATE: {
                this.doAuditValidateExecute(param, sourceBill);
                break;
            }
            case PAYVALIDATE: {
                this.doPayValidateExecute(param, sourceBill);
                break;
            }
            case CANCELPAYVALIDATE: {
                this.doCancelPayValidateExecute(param, sourceBill);
                break;
            }
            case CANCELRENOTEVALIDATE: {
                this.doCancelRenoteValidateExecute(param, sourceBill);
                break;
            }
            case REBACK: {
                this.doRebackExecute(param, sourceBill);
                break;
            }
            case CHARGEBACKVALIDATE: {
                this.doChargeBackValidateExecute(param, sourceBill);
                break;
            }
            case CANCELREFUNDVALIDATE: {
                this.doCancelRefundValidateExecute(param, sourceBill);
                break;
            }
            case SYNCSTATUS: {
                this.doSyncStatusExecute(param, sourceBill);
                break;
            }
            default: {
                this.doOtherExecute(param, sourceBill);
            }
        }
    }

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doAuditExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doPayExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doCancelPayExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doRefundExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doRefundValidateExecute(param, sourceBill);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doRenoteValidateExecute(param, sourceBill);
        this.cachePayBillIds(param);
    }

    private String getEntityName(PayBillWriteBackParam param, DynamicObject sourceBill) {
        Object dataEntityType = sourceBill == null || sourceBill.getDataEntityType().getName().equals("PlainObject") ? MetadataServiceHelper.getDataEntityType((String)param.getPayBill().getSourceBillType()) : sourceBill.getDataEntityType();
        return dataEntityType.getDisplayName().toString();
    }

    protected void doCancelRefundExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doCancelRefundValidateExecute(param, sourceBill);
    }

    protected void doCancelRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.doCancelRenoteValidateExecute(param, sourceBill);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.cachePayBillIds(param);
    }

    private String getCacheKey(String sourceBillType) {
        return String.format("tmc_paybillwriteback_%s", sourceBillType);
    }

    private void cachePayBillIds(PayBillWriteBackParam param) {
        PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
        if (EmptyUtil.isNoEmpty((String)payBill.getSourceBillType())) {
            DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
            String cacheKey = this.getCacheKey(payBill.getSourceBillType());
            String payBillIds = (String)cache.get(cacheKey);
            String payBillId = payBill.getPayBillId().toString();
            cache.put(cacheKey, (Object)(EmptyUtil.isNoEmpty((String)payBillIds) ? payBillIds + "," + payBillId : payBillId), 60);
        }
    }

    protected Set<Long> getCachePayBillIds(PayBillWriteBackParam param) {
        String sourceBillType = param.getPayBill().getSourceBillType();
        if (EmptyUtil.isNoEmpty((String)sourceBillType)) {
            String payBillIds = (String)TmcCacheHelper.getSessionlessCacheInstance().get(this.getCacheKey(sourceBillType));
            return EmptyUtil.isNoEmpty((String)payBillIds) ? Arrays.stream(payBillIds.split(",")).map(Long::parseLong).collect(Collectors.toSet()) : new HashSet<Long>(1);
        }
        return new HashSet<Long>(1);
    }

    protected void doOtherExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkPayBill(param, sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkPayBill(param, sourceBill);
    }

    protected void doAuditValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkPayBill(param, sourceBill);
    }

    protected void doCancelRenoteValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: %2$s\u5355\u636e\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u652f\u6301\u53d6\u6d88\u9000\u7968\u3002", (String)"AbstractPayBillWriteBackService_05", (String)TMC_FBP_MSERVICE, (Object[])new Object[0]), PayBillWriteBackOperateEnum.CANCELRENOTE.getName(), this.getEntityName(param, sourceBill)));
    }

    protected void doCancelRefundValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: %2$s\u5355\u636e\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u652f\u6301\u53d6\u6d88\u9000\u6b3e\u3002", (String)"AbstractPayBillWriteBackService_14", (String)TMC_FBP_MSERVICE, (Object[])new Object[0]), PayBillWriteBackOperateEnum.CANCELREFUND.getName(), this.getEntityName(param, sourceBill)));
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkPayBill(param, sourceBill);
    }

    protected void doCancelPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doRebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doChargeBackValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doRenoteValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        PayBillWriteBackParam.PayBillInfo payBill = param.getPayBill();
        if (payBill.getRemainRefundAmt().compareTo(BigDecimal.ZERO) > 0) {
            throw new KDBizException(this.loadKDString("%1$s\u5931\u8d25: %2$s\u5355\u636e\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u652f\u6301\u90e8\u5206\u9000\u7968\u3002", "AbstractPayBillWriteBackService_11", PayBillWriteBackOperateEnum.RENOTE.getName(), this.getEntityName(param, sourceBill)));
        }
    }

    protected void doRefundValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25: %2$s\u5355\u636e\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u652f\u6301\u9000\u6b3e\u3002", (String)"AbstractPayBillWriteBackService_13", (String)TMC_FBP_MSERVICE, (Object[])new Object[0]), PayBillWriteBackOperateEnum.REFUND.getName(), this.getEntityName(param, sourceBill)));
    }

    protected void doSyncStatusExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected abstract DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo var1);

    protected DynamicObject getSourceBill(PayBillWriteBackParam param) {
        return this.getSourceBill(param.getPayBill());
    }

    protected abstract Long getSourceBillCurrencyId(DynamicObject var1);

    protected Long getSourceBillCurrencyId(PayBillWriteBackParam param, DynamicObject sourceBill) {
        return this.getSourceBillCurrencyId(sourceBill);
    }

    protected abstract BigDecimal getSourceBillPayAmount(DynamicObject var1);

    protected BigDecimal getSourceBillPayAmount(PayBillWriteBackParam param, DynamicObject sourceBill) {
        return this.getSourceBillPayAmount(sourceBill);
    }

    protected DynamicObjectCollection batchGetRepayBillBySourceBill(DynamicObject sourceBill, Set<Long> excludePayBillIds) {
        ArrayList<String> billStatus = new ArrayList<String>(4);
        billStatus.addAll(Arrays.asList("G", "F"));
        String entityNumber = sourceBill.getDataEntityType().getName();
        if ("cfm_feebill".equals(entityNumber)) {
            billStatus.addAll(Arrays.asList("H", "I"));
        }
        QFilter filter = new QFilter("billstatus", "not in", billStatus);
        QFilter sourceFilter = HEAD_SOURCEBILLID_ENTITYS.contains(entityNumber) ? new QFilter("sourcebillid", "=", sourceBill.get("id")) : new QFilter(ENTRY_E_SOURCEBILLID, "=", sourceBill.get("id"));
        filter = filter.and(sourceFilter);
        if (EmptyUtil.isNoEmpty(excludePayBillIds)) {
            filter = filter.and("id", "not in", excludePayBillIds);
        }
        return QueryServiceHelper.query((String)"cas_paybill", (String)SELECT_FIELDS, (QFilter[])filter.toArray(), (String)"createtime desc");
    }

    protected BigDecimal batchGetSourceBillLockPayAmount(DynamicObject sourceBill, Set<Long> excludePayBillIds) {
        DynamicObjectCollection paybills = this.batchGetRepayBillBySourceBill(sourceBill, excludePayBillIds);
        return paybills.stream().map(p -> p.getBigDecimal("entry.e_actamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    protected DynamicObjectCollection getRepayBillBySourceBill(DynamicObject sourceBill, Long excludePayBillId) {
        return this.batchGetRepayBillBySourceBill(sourceBill, EmptyUtil.isNoEmpty((Long)excludePayBillId) ? Collections.singleton(excludePayBillId) : Collections.emptySet());
    }

    protected BigDecimal getSourceBillLockPayAmount(PayBillWriteBackParam param, DynamicObject sourceBill) {
        return this.getSourceBillLockPayAmount(sourceBill, param.getPayBill().getPayBillId());
    }

    protected BigDecimal getSourceBillLockPayAmount(DynamicObject sourceBill, Long payBillId) {
        DynamicObjectCollection paybills = this.getRepayBillBySourceBill(sourceBill, payBillId);
        return paybills.stream().map(p -> p.getBigDecimal("entry.e_actamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    protected DynamicObject getLatestPayBill(DynamicObject sourceBill, Set<Long> payBillIds) {
        DynamicObjectCollection cols;
        QFilter filter = new QFilter(ENTRY_E_SOURCEBILLID, "=", sourceBill.get("id"));
        if (EmptyUtil.isNoEmpty(payBillIds)) {
            filter = filter.and("id", "not in", payBillIds);
        }
        return EmptyUtil.isNoEmpty((DynamicObjectCollection)(cols = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billno,actpayamt", (QFilter[])filter.toArray(), (String)"createtime desc", (int)1))) ? (DynamicObject)cols.get(0) : null;
    }

    protected String getSourceBillNo(DynamicObject sourceBill) {
        return sourceBill.getString("billno");
    }

    protected void checkPayBill(PayBillWriteBackParam param, DynamicObject sourceBill) {
        BigDecimal lockPayAmount;
        String operate = PayBillWriteBackOperateEnum.getName(param.getOperate());
        String entityName = this.getEntityName(param, sourceBill);
        if (sourceBill == null) {
            throw new KDBizException(this.loadKDString("%1$s\u5931\u8d25: %2$s\u5355\u636e\u4e0d\u5b58\u5728\u3002", "AbstractPayBillWriteBackService_12", operate, entityName));
        }
        PayBillWriteBackParam.PayBillInfo payBillInfo = param.getPayBill();
        Long currencyId = this.getSourceBillCurrencyId(param, sourceBill);
        BigDecimal payAmount = payBillInfo.getAmount();
        if (payAmount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(this.loadKDString("%s\u5931\u8d25: \u4e0d\u5141\u8bb8\u4ed8\u6b3e\u5355\u5206\u5f55\u884c\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u3002", "AbstractPayBillWriteBackService_06", operate));
        }
        BigDecimal billPayAmount = this.getSourceBillPayAmount(param, sourceBill);
        BigDecimal canPayAmount = billPayAmount.subtract(lockPayAmount = this.getSourceBillLockPayAmount(param, sourceBill));
        canPayAmount = canPayAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : canPayAmount;
        String sourceBillNo = this.getSourceBillNo(sourceBill);
        StringBuilder sb = new StringBuilder();
        if (!payBillInfo.isDiffCur()) {
            if (payAmount.compareTo(canPayAmount) > 0) {
                int curPrecision = this.getCurPrecision(currencyId);
                sb.append(this.loadKDString("%1$s\u5931\u8d25: \u4ed8\u6b3e\u91d1\u989d[%2$s]\u8d85\u8fc7%3$s\u5355\u636e\u7684\u6e90\u5355[%4$s]\u53ef\u652f\u4ed8\u91d1\u989d[%5$s]\u3002", "AbstractPayBillWriteBackService_01", operate, payAmount.setScale(curPrecision, RoundingMode.HALF_UP), entityName, sourceBillNo, canPayAmount.setScale(curPrecision, RoundingMode.HALF_UP).toPlainString()));
            }
            if (payBillInfo.getCurrencypk().compareTo(currencyId) != 0) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(this.loadKDString("%1$s\u5931\u8d25: \u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u5e01\u79cd\u4e0d\u7b49\u4e8e%2$s\u5355\u636e\u7684\u6e90\u5355[%3$s]\u7684\u5e01\u79cd\u3002", "AbstractPayBillWriteBackService_02", operate, entityName, sourceBillNo));
            }
        } else {
            if (payAmount.compareTo(canPayAmount) > 0) {
                int curPrecision = this.getCurPrecision(currencyId);
                sb.append(this.loadKDString("%1$s\u5931\u8d25: \u6536\u6b3e\u91d1\u989d[%2$s]\u8d85\u8fc7%3$s\u5355\u636e\u7684\u6e90\u5355[%4$s]\u53ef\u652f\u4ed8\u91d1\u989d[%5$s]\u3002", "AbstractPayBillWriteBackService_03", operate, payAmount.setScale(curPrecision, RoundingMode.HALF_UP), entityName, sourceBillNo, canPayAmount.setScale(curPrecision, RoundingMode.HALF_UP)));
            }
            if (payBillInfo.getCurrencypk().compareTo(currencyId) != 0) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(this.loadKDString("%1$s\u5931\u8d25: \u4ed8\u6b3e\u5355\u7684\u6536\u6b3e\u5e01\u79cd\u4e0d\u7b49\u4e8e%2$s\u5355\u636e\u7684\u6e90\u5355[%3$s]\u7684\u5e01\u79cd\u3002", "AbstractPayBillWriteBackService_04", operate, entityName, sourceBillNo));
            }
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
    }

    private String loadKDString(String description, String resourceID, Object ... args) {
        return String.format(ResManager.loadKDString((String)description, (String)resourceID, (String)TMC_FBP_MSERVICE, (Object[])new Object[0]), args);
    }

    protected void DBTxBizUpdate(DynamicObject sourceBill) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject)sourceBill);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
    }

    private int getCurPrecision(Long currencyId) {
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"amtprecision");
        return currency.getInt("amtprecision");
    }
}

