/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.recwriteback;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.IRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackOperateEnum;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;

public abstract class AbstractRecBillWriteBackService
implements IRecBillWriteBackService {
    protected static final Log logger = LogFactory.getLog(AbstractRecBillWriteBackService.class);
    private static final String TMC_FBP_MSERVICE = "tmc-fbp-mservice";
    private static final String E_SOURCEBILLID = "e_sourcebillid";

    @Override
    public void execute(Object params) {
        if (params instanceof List) {
            this.doExecute((List)params);
        }
    }

    private void doExecute(List<Map<String, Object>> params) {
        if (EmptyUtil.isEmpty(params)) {
            logger.error("writeback param is empty");
            return;
        }
        this.doRecBillWriteBack(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecBillWriteBack(List<Map<String, Object>> params) {
        long startTime = System.currentTimeMillis();
        try {
            List<RecBillWriteBackParam> writeBackParams = this.getRecBillWriteBackParams(params);
            logger.info("recbillwriteback start, recbill:{}", (Object)SerializationUtils.toJsonString(writeBackParams));
            this.mergeBySourceBillId(writeBackParams);
            writeBackParams.forEach(this::doExecute);
        }
        finally {
            logger.info("recbillwriteback end, total time :{}ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private List<RecBillWriteBackParam> getRecBillWriteBackParams(List<Map<String, Object>> params) {
        ArrayList<RecBillWriteBackParam> writeBackParams = new ArrayList<RecBillWriteBackParam>(10);
        for (Map<String, Object> param : params) {
            String operate = param.get("operation").toString();
            DynamicObject info = (DynamicObject)param.get("info");
            if (info == null) {
                writeBackParams.addAll(this.buildWriteBackParams(operate, param));
                continue;
            }
            writeBackParams.addAll(this.buildWriteBackParams(operate, info));
        }
        return writeBackParams;
    }

    protected void mergeBySourceBillId(List<RecBillWriteBackParam> writeBackParams) {
        HashMap<Long, RecBillWriteBackParam> writeBackParamMap = new HashMap<Long, RecBillWriteBackParam>(writeBackParams.size());
        for (int i = writeBackParams.size() - 1; i >= 0; --i) {
            RecBillWriteBackParam writeBackParam = writeBackParams.get(i);
            RecBillWriteBackParam.RecBillInfo recBill = writeBackParam.getRecBill();
            Long sourceBillId = recBill.getSourceBillId();
            if (EmptyUtil.isEmpty((Long)sourceBillId)) continue;
            if (writeBackParamMap.containsKey(sourceBillId)) {
                RecBillWriteBackParam.RecBillInfo recBill2 = ((RecBillWriteBackParam)writeBackParamMap.get(sourceBillId)).getRecBill();
                recBill2.setAmount(recBill2.getAmount().add(recBill.getAmount()));
                recBill2.setFee(recBill2.getFee().add(recBill.getFee()));
                writeBackParams.remove(i);
                continue;
            }
            writeBackParamMap.put(sourceBillId, writeBackParam);
        }
    }

    private List<RecBillWriteBackParam> buildWriteBackParams(String operate, DynamicObject info) {
        ArrayList<RecBillWriteBackParam> writeBackParams = new ArrayList<RecBillWriteBackParam>(10);
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
        Map<Long, List<DynamicObject>> entryMap = entrys.stream().collect(Collectors.groupingBy(e -> e.getLong(E_SOURCEBILLID)));
        if (entryMap.size() > 1) {
            for (DynamicObject entry : entrys) {
                RecBillWriteBackParam writeBackParam = this.buildWriteBackParam(operate, info);
                writeBackParam.getRecBill().setSourceBillId(entry.getLong(E_SOURCEBILLID)).setSourceBillNumber(null).setAmount(entry.getBigDecimal("e_actamt")).setLocalamt(entry.getBigDecimal("e_localamt"));
                writeBackParams.add(writeBackParam);
            }
        } else {
            DynamicObject entry;
            RecBillWriteBackParam writeBackParam = this.buildWriteBackParam(operate, info);
            long sourcebillid = info.getLong("sourcebillid");
            if (!entrys.isEmpty() && (entry = (DynamicObject)entrys.get(0)).getLong(E_SOURCEBILLID) > 0L) {
                sourcebillid = entry.getLong(E_SOURCEBILLID);
            }
            writeBackParam.getRecBill().setSourceBillId(sourcebillid).setSourceBillNumber(info.getString("sourcebillnumber")).setAmount(info.getBigDecimal("actrecamt")).setLocalamt(info.getBigDecimal("localamt"));
            writeBackParams.add(writeBackParam);
        }
        return writeBackParams;
    }

    private List<RecBillWriteBackParam> buildWriteBackParams(String operate, Map<String, Object> applyMap) {
        RecBillWriteBackParam writeBackParam = new RecBillWriteBackParam();
        writeBackParam.setOperate(operate);
        RecBillWriteBackParam.RecBillInfo recBill = writeBackParam.getRecBill();
        Long sourceBillId = (Long)applyMap.get("sourcepk");
        if (EmptyUtil.isEmpty((Long)sourceBillId)) {
            sourceBillId = (Long)applyMap.get("sourcebillid");
        }
        recBill.setRecBillId((Long)applyMap.get("targetpk")).setRecBillNo((String)applyMap.get("targetbillno")).setSourceBillId(sourceBillId).setSourceBillType((String)applyMap.get("sourceentity")).setSourceBillNumber(null).setAmount((BigDecimal)applyMap.get("amount")).setBizDate((Date)applyMap.get("bizdate")).setCurrencyId((Long)applyMap.get("currencypk")).setFee((BigDecimal)applyMap.get("fee")).setSettletNumber((String)applyMap.get("settletnumber")).setPayeeDate((Date)applyMap.get("payeedate")).setDescription((String)applyMap.get("txt_description"));
        if (EmptyUtil.isEmpty((Long)recBill.getSourceBillId())) {
            DynamicObject receiveBill = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"sourcebillid,sourcebilltype,sourcebillnumber", (QFilter[])new QFilter("id", "=", (Object)recBill.getRecBillId()).toArray());
            recBill.setSourceBillId(receiveBill.getLong("sourcebillid"));
            recBill.setSourceBillType(receiveBill.getString("sourcebilltype"));
            recBill.setSourceBillNumber(receiveBill.getString("sourcebillnumber"));
        }
        return Collections.singletonList(writeBackParam);
    }

    private RecBillWriteBackParam buildWriteBackParam(String operate, DynamicObject info) {
        RecBillWriteBackParam param = new RecBillWriteBackParam();
        param.setOperate(operate);
        RecBillWriteBackParam.RecBillInfo recBill = param.getRecBill();
        recBill.setRecBillId(info.getLong("id")).setRecBillNo(info.getString("billno")).setSourceBillType(info.getString("sourcebilltype")).setBizDate(info.getDate("bizdate")).setCurrencyId(info.getLong("currency.id")).setSettletNumber(info.getString("settletnumber")).setPayeeDate(info.getDate("payeedate")).setLocalamt(info.getBigDecimal("localamt")).setFee(info.getBigDecimal("fee")).setDescription(info.getString("txt_description"));
        return param;
    }

    protected void doExecute(RecBillWriteBackParam param) {
        DynamicObject sourceBill = this.getSourceBill(param);
        RecBillWriteBackOperateEnum operateEnum = RecBillWriteBackOperateEnum.getByValue(param.getOperate());
        if (operateEnum == null) {
            this.doOtherExecute(param, sourceBill);
            return;
        }
        switch (operateEnum) {
            case SAVE: {
                this.doSaveExecute(param, sourceBill);
                break;
            }
            case SUBMIT: {
                this.doSubmitExecute(param, sourceBill);
                break;
            }
            case AUDIT: {
                this.doAuditExecute(param, sourceBill);
                break;
            }
            case RECEIVE: {
                this.doReceiveExecute(param, sourceBill);
                break;
            }
            case CANCELRECEIVE: {
                this.doCancelReceiveExecute(param, sourceBill);
                break;
            }
            case DELETE: {
                this.doDeleteExecute(param, sourceBill);
                break;
            }
            case SAVEVALIDATE: {
                this.doSaveValidateExecute(param, sourceBill);
                break;
            }
            case SUBMITVALIDATE: {
                this.doSubmitValidateExecute(param, sourceBill);
                break;
            }
            case AUDITVALIDATE: {
                this.doAuditValidateExecute(param, sourceBill);
                break;
            }
            case RECSUREVALIDATE: {
                this.doRecSureValidateExecute(param, sourceBill);
                break;
            }
            case CANCELRECEIVEVALIDATE: {
                this.doCancelReceiveValidateExecute(param, sourceBill);
                break;
            }
            default: {
                this.doOtherExecute(param, sourceBill);
            }
        }
    }

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.doSubmitValidateExecute(param, sourceBill);
    }

    protected void doAuditExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doReceiveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkRecBill(param, sourceBill);
    }

    protected void doCancelReceiveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doOtherExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkRecBill(param, sourceBill);
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkRecBill(param, sourceBill);
    }

    protected void doAuditValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkRecBill(param, sourceBill);
    }

    protected void doRecSureValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.checkRecBill(param, sourceBill);
    }

    protected void doCancelReceiveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
    }

    protected abstract DynamicObject getSourceBill(RecBillWriteBackParam var1);

    protected abstract Long getSourceBillCurrencyId(RecBillWriteBackParam var1, DynamicObject var2);

    protected abstract BigDecimal getSourceBillRecAmount(RecBillWriteBackParam var1, DynamicObject var2);

    protected DynamicObjectCollection getRecBillBySourceBill(DynamicObject sourceBill, String selectProps, Long excludeRecbillId) {
        QFilter filter = new QFilter("sourcebillid", "=", sourceBill.get("id")).and("billstatus", "!=", (Object)"G");
        if (EmptyUtil.isNoEmpty((Long)excludeRecbillId)) {
            filter = filter.and("id", "!=", (Object)excludeRecbillId);
        }
        return QueryServiceHelper.query((String)"cas_recbill", (String)selectProps, (QFilter[])filter.toArray(), (String)"createtime desc");
    }

    protected DynamicObjectCollection getRecBillBySourceBill(DynamicObject sourceBill, Long excludeRecbillId) {
        return this.getRecBillBySourceBill(sourceBill, "id,billno,actrecamt,fee", excludeRecbillId);
    }

    protected BigDecimal getSourceBillLockRecAmount(DynamicObject sourceBill, Long recbillId) {
        DynamicObjectCollection recBills = this.getRecBillBySourceBill(sourceBill, recbillId);
        return recBills.stream().map(p -> p.getBigDecimal("actrecamt").add(p.getBigDecimal("fee"))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    protected String getSourceBillNo(DynamicObject sourceBill) {
        return sourceBill.getString("billno");
    }

    protected void checkRecBill(RecBillWriteBackParam param, DynamicObject sourceBill) {
        BigDecimal lockRecAmount;
        String operate = RecBillWriteBackOperateEnum.getName(param.getOperate());
        String entityName = this.getEntityName(param, sourceBill);
        if (sourceBill == null) {
            throw new KDBizException(this.loadKDString("%1$s\u5931\u8d25: %2$s\u5355\u636e\u4e0d\u5b58\u5728\u3002", "AbstractRecBillWriteBackService_01", operate, entityName));
        }
        RecBillWriteBackParam.RecBillInfo recBillInfo = param.getRecBill();
        BigDecimal recAmount = recBillInfo.getRecAmount();
        if (recAmount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(this.loadKDString("%s\u5931\u8d25: \u4e0d\u5141\u8bb8\u6536\u6b3e\u5355\u5206\u5f55\u884c\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u3002", "AbstractRecBillWriteBackService_02", operate));
        }
        Long currencyId = this.getSourceBillCurrencyId(param, sourceBill);
        BigDecimal billRecAmount = this.getSourceBillRecAmount(param, sourceBill);
        BigDecimal canRecAmount = billRecAmount.subtract(lockRecAmount = this.getSourceBillLockRecAmount(sourceBill, recBillInfo.getRecBillId()));
        canRecAmount = canRecAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : canRecAmount;
        String sourceBillNo = this.getSourceBillNo(sourceBill);
        StringBuilder sb = new StringBuilder();
        if (recAmount.compareTo(canRecAmount) > 0) {
            int curPrecision = this.getCurPrecision(currencyId);
            sb.append(this.loadKDString("%1$s\u5931\u8d25: \u5e94\u6536\u91d1\u989d[%2$s]\u8d85\u8fc7%3$s\u5355\u636e\u7684\u6e90\u5355[%4$s]\u53ef\u6536\u6b3e\u91d1\u989d[%5$s]\u3002", "AbstractRecBillWriteBackService_03", operate, recAmount.setScale(curPrecision, RoundingMode.HALF_UP).toPlainString(), entityName, sourceBillNo, canRecAmount.setScale(curPrecision, RoundingMode.HALF_UP).toPlainString()));
        }
        if (recBillInfo.getCurrencyId().compareTo(currencyId) != 0) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(this.loadKDString("%1$s\u5931\u8d25: \u6536\u6b3e\u5355\u7684\u6536\u6b3e\u5e01\u79cd\u4e0d\u7b49\u4e8e%2$s\u5355\u636e\u7684\u6e90\u5355[%3$s]\u7684\u5e01\u79cd\u3002", "AbstractRecBillWriteBackService_04", operate, entityName, sourceBillNo));
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
    }

    private String loadKDString(String description, String resourceID, Object ... args) {
        return String.format(ResManager.loadKDString((String)description, (String)resourceID, (String)TMC_FBP_MSERVICE, (Object[])new Object[0]), args);
    }

    private String getEntityName(RecBillWriteBackParam param, DynamicObject sourceBill) {
        Object dataEntityType = sourceBill == null || sourceBill.getDataEntityType().getName().equals("PlainObject") ? MetadataServiceHelper.getDataEntityType((String)param.getRecBill().getSourceBillType()) : sourceBill.getDataEntityType();
        return dataEntityType.getDisplayName().toString();
    }

    protected void DBTxBizUpdate(DynamicObject sourceBill) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject)sourceBill);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
    }

    protected void DBTxBizSave(DynamicObject sourceBill) {
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceBill});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private int getCurPrecision(Long currencyId) {
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"amtprecision");
        return currency.getInt("amtprecision");
    }
}

