/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.report;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.FileUtils;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.util.DateUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UpdateReportMetaDataService
implements IUpgradeService {
    private static final String EXISTDATA = "select fid from T_TMC_METADATACOPY";
    private static final String INSERTDATA = "insert into T_TMC_METADATACOPY (fid,fbillstatus,fbillno) VALUES (?,?,?)";
    private static final String FORM_UPDATEPATH_CHILD = "update t_meta_formdesign set finheritpath = ? ,fversion = ?, fdata = ?, fmodifydate = ? where fid = ?";
    private static final String ENTITY_UPDATEPATH_CHILD = "update t_meta_entitydesign set finheritpath = ? ,fversion = ?, fdata = ?, fmodifydate = ? where fid = ?";
    private static final Log logger = LogFactory.getLog(UpdateReportMetaDataService.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";
    private static final String TMC_METADATACOPY = "tmc_metadatacopy";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        DataSet dataSet = DB.queryDataSet((String)"kd.tmc.fbp.service.report.UpdateReportMetaDataService", (DBRoute)DBRouteConst.TMC, (String)EXISTDATA);
        if (dataSet.count("fid", true) > 0) {
            logger.info("\u5df2\u6267\u884c\u8fc7\u8d44\u91d1\u62a5\u8868\u5143\u6570\u636e\u5347\u7ea7\uff0c\u4e0d\u518d\u91cd\u590d\u6267\u884c");
            dataSet.close();
            return null;
        }
        dataSet.close();
        logger.info("\u5f00\u59cb\u6267\u884c\u8d44\u91d1\u62a5\u8868\u5143\u6570\u636e\u5347\u7ea7");
        HashMap<Pair, List<String>> metaIdOfUpdateType = new HashMap<Pair, List<String>>(16);
        metaIdOfUpdateType.put(Pair.of((Object)"1b760aa100003bac,2S5TV=DV+NXV", (Object)"1b760aa100003bac,2QKLQ0MM7W10"), Collections.singletonList("2S5UUWIT1Z3L"));
        metaIdOfUpdateType.put(Pair.of((Object)"1b760aa100003bac,/KFLGO9I11C7", (Object)"1b760aa100003bac,2QKLQ0MM7W10"), Arrays.asList("039TEK8MRBY+", "03PXB1E++U/E", "2NWO2Z8VN1VM", "2NX5SPU8OIDC", "0543=0/I79M/", "0542K/P0ZW4R", "03PHMGKCA0A9", "045FS6TXTP/E"));
        metaIdOfUpdateType.put(Pair.of((Object)"<InheritPath>1b760aa100003bac,2E=B6OLOEXM/", (Object)"<InheritPath>1b760aa100003bac,2QKLQ0MM7W10"), Arrays.asList("2QGCPS=BJSS=", "2Q3ZLE6=0MY5", "2ECL4+A4B38N"));
        metaIdOfUpdateType.put(Pair.of((Object)"1b760aa100003bac,0T956US5NG6X", (Object)"1b760aa100003bac,2QKLQ0MM7W10"), Arrays.asList("0THMH5SB96/K", "0THINOX=FQJW", "0TF6WRLV/5MV", "0TF15N9MNA16", "0TEW+80CVE1A", "0TFDDPG2TM+Z"));
        metaIdOfUpdateType.put(Pair.of((Object)"1b760aa100003bac", (Object)"1b760aa100003bac,2QKLQ0MM7W10"), Arrays.asList("2RIZ6CPXS9JD", "2YAQY4ZYD3P4", "3DOE5/PTEITA", "2U83RR1S0S/+", "22N011A47C+/", "2A+UI=02GQ3T", "1UDUQ3XJD=D9", "33ZGRBGFFRBZ", "22C2YEX65LF2", "232P4NPG9/JH", "2S9OJ44WNOHG", "2=745SE64KSN", "2=8KQ/U23513", "2S+YW49N+1LW", "2SG80GBVMSDG", "2S5YL2WP5ZD9", "2S/H2J34SVH6", "2S/4YK=R/7H+"));
        long billId = DBServiceHelper.genGlobalLongId();
        try {
            DB.execute((DBRoute)DBRouteConst.TMC, (String)INSERTDATA, (Object[])new Object[]{billId, BillStatusEnum.SAVE.getValue(), DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")});
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u4e00\u6761\u6570\u636e\u5931\u8d25\uff1a" + e);
            return null;
        }
        List attachments = AttachmentServiceHelper.getAttachments((String)TMC_METADATACOPY, (Object)billId, (String)"attachmentpanel");
        for (Map.Entry entry : metaIdOfUpdateType.entrySet()) {
            Pair key = (Pair)entry.getKey();
            List value = (List)entry.getValue();
            this.updateChildMetaDatas(value, (String)key.getLeft(), (String)key.getRight(), billId, attachments);
        }
        AttachmentServiceHelper.upload((String)TMC_METADATACOPY, (Object)billId, (String)"attachmentpanel", (List)attachments);
        logger.info("\u7ed3\u675f\u6267\u884c\u8d44\u91d1\u62a5\u8868\u5143\u6570\u636e\u5347\u7ea7");
        return null;
    }

    private void updateChildMetaDatas(List<String> id, String oldParentInheritPath, String newParentInheritPath, Long billId, List<Map<String, Object>> attachments) {
        Set<String> childMetaSet = this.findChildMetaData(new HashSet<String>(id));
        childMetaSet.removeAll(id);
        DynamicObjectCollection MetaDatas = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number,parentid,inheritpath,bizappid", (QFilter[])new QFilter[]{new QFilter("id", "in", childMetaSet)});
        for (DynamicObject metaData : MetaDatas) {
            String bizAppID = metaData.getString("bizappid");
            String bizNumber = metaData.getString("number");
            String oldInheritPath = metaData.getString("inheritpath");
            DesignFormMeta oldFormMeta = (DesignFormMeta)BusinessDataReader.read((Object)metaData.getString("id"), (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
            DesignEntityMeta oldEntityMeta = null;
            try {
                oldEntityMeta = (DesignEntityMeta)BusinessDataReader.read((Object)metaData.getString("id"), (IDataEntityType)OrmUtils.getDataEntityType(DesignEntityMeta.class), (Boolean)false);
            }
            catch (Exception e) {
                logger.info("\u5143\u6570\u636e\u6ca1\u6709\u5b9e\u4f53\uff1a" + bizNumber);
            }
            String metaID = metaData.getString("id");
            String newInheritPath = oldInheritPath.replace(oldParentInheritPath, newParentInheritPath);
            String newFormMeta = oldFormMeta.getDataXml().replaceFirst("<InheritPath>" + oldParentInheritPath, "<InheritPath>" + newParentInheritPath);
            String newEntityMeta = null;
            if (oldEntityMeta != null) {
                newEntityMeta = oldEntityMeta.getDataXml().replaceFirst("<InheritPath>" + oldParentInheritPath, "<InheritPath>" + newParentInheritPath);
            }
            Date date = new Date();
            long newVersion = date.getTime();
            this.exportPageSource(billId, bizAppID, metaID.toString(), bizNumber, attachments);
            this.executeDB(bizNumber, metaID, newInheritPath, newFormMeta, newEntityMeta, date, newVersion);
        }
    }

    private void executeDB(String bizNumber, Object metaID, String newInheritPath, String newFormMeta, String newEntityMeta, Date date, long newVersion) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRouteConst.META, (String)FORM_UPDATEPATH_CHILD, (Object[])new Object[]{newInheritPath, newVersion, newFormMeta, date, metaID});
                if (newEntityMeta != null) {
                    DB.execute((DBRoute)DBRouteConst.META, (String)ENTITY_UPDATEPATH_CHILD, (Object[])new Object[]{newInheritPath, newVersion, newEntityMeta, date, metaID});
                }
            }
            catch (Exception e) {
                logger.error("\u4fee\u6539\u5143\u6570\u636e" + bizNumber + "\u53d1\u751f\u9519\u8bef\uff1a" + e);
                tx.markRollback();
            }
        }
    }

    private Set<String> findChildMetaData(Set<String> id) {
        Set<String> childMetaData = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("parentid", "in", id)}).stream().map(m -> m.getString("id")).collect(Collectors.toSet());
        if (childMetaData.isEmpty()) {
            return new HashSet<String>();
        }
        childMetaData.addAll(this.findChildMetaData(childMetaData));
        return childMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportPageSource(Long billId, String bizAppId, String bizId, String bizNumber, List<Map<String, Object>> attachments) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppNumber = appMeta.getNumber();
        String appVersion = appMeta.getAppElement().getVersion();
        String appNumberPath = USER_HOME + File.separator + DOWNLOADPATH + File.separator + bizAppNumber;
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), Charsets.UTF_8).toString();
        String traceIdPath = appNumberPath + File.separator + traceIdHash;
        String localPath = traceIdPath + File.separator + "datamodel" + File.separator + appVersion + File.separator + "main" + File.separator + bizAppNumber;
        ArrayList fileList = new ArrayList();
        DevportalUtil.expFormMetadata((String)bizId, (String)localPath, (String)"EXPORT_PAGE");
        InputStream in = null;
        try {
            String fileName = bizNumber + ".zip";
            DevportalUtil.zipFiles((String)bizNumber, (String)localPath, fileList);
            String downloadFile = FileUtils.cleanString((String)(localPath + File.separator + fileName));
            Path downloadPath = Paths.get(DevportalUtil.checkFilePath((String)downloadFile), new String[0]);
            in = Files.newInputStream(downloadPath, new OpenOption[0]);
            int size = 0;
            HashMap<String, Object> attaMap = new HashMap<String, Object>();
            size = in.available();
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String url = cache.saveAsUrl(fileName, in, 600);
            String prefix = RequestContext.get().getClientFullContextPath();
            if (!prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            url = prefix + url;
            logger.info("\u6587\u4ef6 " + fileName + " \u5df2\u4e0a\u4f20\u81f3\u4e34\u65f6\u6587\u4ef6\u670d\u52a1\u5668, \u5176\u4e34\u65f6\u5b58\u50a8\u8def\u5f84: " + url);
            attaMap.put("name", fileName);
            attaMap.put("size", size);
            attaMap.put("type", "zip");
            attaMap.put("uid", "rc-upload-" + new Date().getTime() + "-" + new SecureRandom().nextInt(100));
            attaMap.put("status", "success");
            attaMap.put("entityNum", TMC_METADATACOPY);
            long time = new Date().getTime();
            attaMap.put("createdate", time);
            attaMap.put("lastModified", time);
            String path = AttachmentServiceHelper.saveTempToFileService((String)url, (String)TmcAppEnum.FBP.getId(), (String)TMC_METADATACOPY, (Object)billId, (String)fileName);
            logger.info("\u6587\u4ef6 " + fileName + " \u5df2\u4e0a\u4f20\u81f3\u6b63\u5f0f\u6587\u4ef6\u670d\u52a1\u5668, \u5176\u5b58\u50a8\u8def\u5f84: " + path);
            attaMap.put("url", path);
            attachments.add(attaMap);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }
}

