/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.service.snap;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.bean.TdaLog;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SnapScheduleService {
    private static final Log logger = LogFactory.getLog(SnapScheduleService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(List<DynamicObject> setList, QFilter[] filters, String bathno) {
        for (DynamicObject scheduleSet : setList) {
            long time = System.nanoTime();
            TdaLog dtaLog = new TdaLog();
            ThreadCache.put((Object)"isSnapExcute", (Object)"true");
            ThreadCache.put((Object)"bathno", (Object)bathno);
            String formid = null;
            try {
                String queryplugin = scheduleSet.getString("queryplugin");
                String schemeid = scheduleSet.getString("queryitem");
                if (EmptyUtil.isNoEmpty((DynamicObject)scheduleSet.getDynamicObject("reportform"))) {
                    formid = scheduleSet.getDynamicObject("reportform").getString("number");
                }
                dtaLog = SnapDataHelper.createScheduleLog((String)formid, (DynamicObject)scheduleSet, (String)bathno, (Pair)SnapDataHelper.getOrgAndOrgViewId((QFilter[])filters));
                IDataSnapExecute service = (IDataSnapExecute)Class.forName(queryplugin).newInstance();
                if (EmptyUtil.isEmpty((String)formid)) {
                    logger.info("formid \u4e3a\u7a7a" + queryplugin);
                    continue;
                }
                service.execute(formid, schemeid, filters, bathno);
            }
            catch (Exception e) {
                dtaLog.setException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            catch (Throwable throwable) {
                dtaLog.setException(JSON.toJSONString((Object)throwable.getStackTrace()));
                logger.error(JSON.toJSONString((Object)throwable.getStackTrace()));
            }
            finally {
                Long costMs = (System.nanoTime() - time) / 1000L / 1000L;
                if (!EmptyUtil.isNoEmpty((Object)dtaLog)) continue;
                dtaLog.setCosttime(costMs);
                if (ThreadCache.exists((Object)"tdalogdesc")) {
                    dtaLog.setDesc((String)ThreadCache.get((Object)"tdalogdesc"));
                }
                SnapDataHelper.saveLog((TdaLog)dtaLog);
            }
        }
    }

    private List<DynamicObject> loadSnapScheduleSet(List<String> reports) {
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and(new QFilter("reportform.number", "in", reports));
        Map snapSchedules = TmcDataServiceHelper.loadFromCache((String)"fcs_snapschedule", (String)"reportform,queryitem,queryparam,queryplugin", (QFilter[])filter.toArray());
        return snapSchedules.values().stream().collect(Collectors.toList());
    }
}

