/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import kd.tmc.fbp.common.helper.TmcDigestHelper;

public class BalanceUpdateInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KEY_COL = "accountbank:%s,bizdate:%s,company:%s,currency:%s,";
    private Long id;
    private Long bizBillId;
    private Long companyId;
    private Long currencyId;
    private Date bizDate;
    private BigDecimal amount;
    private BigDecimal valiBalance;
    private BigDecimal lstBalance;
    private BigDecimal debitAmount;
    private BigDecimal creditAmount;
    private BigDecimal freezeAmount;

    public static BalanceUpdateInfo build(Long bizBillId, Long companyId, Long currencyId) {
        return new BalanceUpdateInfo().setBizBillId(bizBillId).setCompanyId(companyId).setCurrencyId(currencyId);
    }

    public BigDecimal calcAmount() {
        return this.lstBalance.add(this.creditAmount).subtract(this.debitAmount);
    }

    public String genKeyCol() {
        String keyCol = String.format(KEY_COL, this.bizBillId, new Timestamp(this.bizDate.getTime()), this.companyId, this.currencyId);
        return TmcDigestHelper.getSHA256Base64Str(keyCol);
    }

    public Long getId() {
        return this.id;
    }

    public BalanceUpdateInfo setId(Long id) {
        this.id = id;
        return this;
    }

    public Long getBizBillId() {
        return this.bizBillId;
    }

    public BalanceUpdateInfo setBizBillId(Long bizBillId) {
        this.bizBillId = bizBillId;
        return this;
    }

    public Long getCompanyId() {
        return this.companyId;
    }

    public BalanceUpdateInfo setCompanyId(Long companyId) {
        this.companyId = companyId;
        return this;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public BalanceUpdateInfo setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
        return this;
    }

    public Date getBizDate() {
        return this.bizDate;
    }

    public BalanceUpdateInfo setBizDate(Date bizDate) {
        this.bizDate = bizDate;
        return this;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BalanceUpdateInfo setAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public BigDecimal getValiBalance() {
        return this.valiBalance;
    }

    public BalanceUpdateInfo setValiBalance(BigDecimal valiBalance) {
        this.valiBalance = valiBalance;
        return this;
    }

    public BigDecimal getLstBalance() {
        return this.lstBalance;
    }

    public BalanceUpdateInfo setLstBalance(BigDecimal lstBalance) {
        this.lstBalance = lstBalance;
        return this;
    }

    public BigDecimal getDebitAmount() {
        return this.debitAmount;
    }

    public BalanceUpdateInfo setDebitAmount(BigDecimal debitAmount) {
        this.debitAmount = debitAmount;
        return this;
    }

    public BigDecimal getCreditAmount() {
        return this.creditAmount;
    }

    public BalanceUpdateInfo setCreditAmount(BigDecimal creditAmount) {
        this.creditAmount = creditAmount;
        return this;
    }

    public BigDecimal getFreezeAmount() {
        return this.freezeAmount;
    }

    public BalanceUpdateInfo setFreezeAmount(BigDecimal freezeAmount) {
        this.freezeAmount = freezeAmount;
        return this;
    }
}

