/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.bean.tc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.bean.tc.FreqPeriodBean;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;

public class FreqPeriodListBean
implements Serializable {
    private Date startDate;
    private Date endDate;
    private boolean isStub;
    private boolean isStubFront;
    private Date firstRegularDate;
    private Date lastRegularEndDate;
    private PayFrequeEnum freqEnum;
    private AdjustMethodEnum adjustMethodEnum;
    private DynamicObjectCollection wc;
    private boolean useAjd = false;
    private List<FreqPeriodBean> periods = new ArrayList<FreqPeriodBean>(10);

    public FreqPeriodListBean(Date startDate, Date endDate, boolean isStub, boolean isStubFront, Date firstRegularDate, Date lastRegularEndDate, PayFrequeEnum freqEnum, AdjustMethodEnum adjustMethodEnum, DynamicObjectCollection wc, boolean useAjd) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.isStub = isStub;
        this.isStubFront = isStubFront;
        this.firstRegularDate = firstRegularDate;
        this.lastRegularEndDate = lastRegularEndDate;
        this.freqEnum = freqEnum;
        this.adjustMethodEnum = adjustMethodEnum;
        this.wc = wc;
        this.useAjd = useAjd;
        this.generatePeriods();
    }

    private void generatePeriods() {
        LinkedList<Date> linkedDates = new LinkedList<Date>();
        Date baseDate = this.endDate;
        if (this.isStub && !this.isStubFront) {
            Date forwardDate = this.lastRegularEndDate;
            do {
                forwardDate = PayFrequeEnum.getNextDateByPayfreq(forwardDate, this.freqEnum);
                linkedDates.addLast(forwardDate);
            } while (forwardDate.before(this.endDate));
            baseDate = this.lastRegularEndDate;
        }
        linkedDates.addFirst(baseDate);
        Date prevDate = baseDate;
        do {
            prevDate = PayFrequeEnum.getLastDateByPayfreq(prevDate, this.freqEnum);
            linkedDates.addFirst(prevDate);
        } while (prevDate.compareTo(this.startDate) >= 0);
        ArrayList<Date> unadjustDates = new ArrayList<Date>(linkedDates.size());
        unadjustDates.addAll(linkedDates);
        for (int i = 0; i < unadjustDates.size() - 1; ++i) {
            FreqPeriodBean p = FreqPeriodBean.of((Date)unadjustDates.get(i), (Date)unadjustDates.get(i + 1), TradeBusinessHelper.callAdjustSettleDate(this.wc, (Date)unadjustDates.get(i), this.adjustMethodEnum), TradeBusinessHelper.callAdjustSettleDate(this.wc, (Date)unadjustDates.get(i + 1), this.adjustMethodEnum));
            this.periods.add(p);
        }
    }

    public Date getPeriodStartDate(FreqPeriodBean period) {
        if (this.useAjd) {
            return period.getAdjStartDate();
        }
        return period.getStartDate();
    }

    public Date getPeriodEndDate(FreqPeriodBean period) {
        if (this.useAjd) {
            return period.getAdjEndDate();
        }
        return period.getEndDate();
    }

    public List<FreqPeriodBean> locatePeriod(Date startDate, Date endDate) {
        ArrayList<FreqPeriodBean> result = new ArrayList<FreqPeriodBean>();
        FreqPeriodBean firstPeriod = null;
        for (int i = 0; i < this.periods.size(); ++i) {
            FreqPeriodBean period = this.periods.get(i);
            if (firstPeriod == null && this.getPeriodStartDate(period).compareTo(startDate) <= 0 && this.getPeriodEndDate(period).compareTo(startDate) > 0) {
                result.add(period);
                if (this.getPeriodEndDate(period).compareTo(endDate) >= 0) break;
                firstPeriod = period;
                continue;
            }
            if (firstPeriod != null && this.getPeriodStartDate(period).compareTo(endDate) < 0 && this.getPeriodEndDate(period).compareTo(endDate) >= 0) {
                result.add(period);
                break;
            }
            if (firstPeriod == null) continue;
            result.add(period);
        }
        return result;
    }

    public Date getFirstRegularDate() {
        return this.firstRegularDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isStub() {
        return this.isStub;
    }

    public boolean isStubFront() {
        return this.isStubFront;
    }

    public Date getLastRegularEndDate() {
        return this.lastRegularEndDate;
    }

    public PayFrequeEnum getFreqEnum() {
        return this.freqEnum;
    }

    public AdjustMethodEnum getAdjustMethodEnum() {
        return this.adjustMethodEnum;
    }

    public DynamicObjectCollection getWc() {
        return this.wc;
    }
}

