/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.builder.mode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.CRExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.tmc.fbp.common.builder.ISingleTaskContext;
import kd.tmc.fbp.common.builder.mode.FormulaVariableMode;
import kd.tmc.fbp.common.builder.mode.IGetValueMode;
import kd.tmc.fbp.common.builder.mode.IVariableMode;
import kd.tmc.fbp.common.builder.mode.SourceBillFieldMode;
import kd.tmc.fbp.common.builder.mode.UnknownVariableMode;

public class FormulaMode<T>
implements IGetValueMode<T> {
    protected String formula;
    protected ISingleTaskContext taskContext;
    protected List<IVariableMode> vars = new ArrayList<IVariableMode>();
    protected FunctionManage funcLib;
    protected CRExpressionContext expContext;
    protected Set<String> funcs = new HashSet<String>();
    protected Expr expr;

    public FormulaMode(ISingleTaskContext taskContext, String formula) {
        this.taskContext = taskContext;
        this.funcLib = taskContext.getFuncLib();
        this.setFormula(formula);
        this.expContext = new CRExpressionContext(null, null, null);
    }

    public final void setFormula(String formula) {
        this.CompileFormula(formula);
    }

    public String getFormula() {
        return this.formula;
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    public Set<String> getFuncs() {
        return this.funcs;
    }

    @Override
    public T GetValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        this.expContext.setActiveRow(sourceRow);
        this.expContext.setFldProperties(fldProperties);
        Map<String, Object> ctx = this.getVarValues(this.expContext);
        try {
            BOSUDFunction[] funcInstances = this.createUDFunctions(this.expContext);
            Object v = FormulaEngine.execExcelFormula((Expr)this.expr, ctx, (UDFunction[])funcInstances);
            return (T)v;
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.formula);
            sb.append("  \r\n");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u53d6\u503c\u51fa\u9519\uff1a%s", (String)"FormulaMode_1", (String)"tmc-fbp-common", (Object[])new Object[0]), exp.getMessage());
            sb.append(errorMsg);
            throw new KDBizException(exp, BosErrorCode.expressionParseFailed, new Object[]{sb.toString()});
        }
    }

    private BOSUDFunction[] createUDFunctions(CRExpressionContext expContext) {
        if (this.getFuncs().isEmpty()) {
            return null;
        }
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>();
        for (String funcName : this.getFuncs()) {
            if (!this.funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)this.funcLib.getFuncMap().get(funcName)).getInstance((ExpressionContext)expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[instances.size()]);
    }

    protected Map<String, Object> getVarValues(CRExpressionContext expContext) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        for (IVariableMode var : this.getVars()) {
            OutValue value = new OutValue();
            if (!expContext.tryGetValue(var.getVar(), value).booleanValue()) {
                ctx.put(var.getVar(), null);
                continue;
            }
            Object item = value.get();
            if (item instanceof String) {
                item = ((String)item).trim();
            }
            ctx.put(var.getVar(), item);
        }
        return ctx;
    }

    protected Object GetSingleFieldValue(Map<String, DynamicProperty> fldProperties, DynamicObject activeRow, DynamicObject extRow, IVariableMode var) {
        Object fldValue = var.GetValue(fldProperties, activeRow, extRow);
        return fldValue;
    }

    protected void CompileFormula(String formula) {
        UDFunctionVisitor mainEntityType;
        this.formula = formula;
        String[] varStrings = new String[]{};
        try {
            varStrings = FormulaEngine.extractVariables((String)this.formula);
            this.expr = FormulaEngine.parseFormula((String)this.formula);
            mainEntityType = new UDFunctionVisitor();
            this.expr.accept((Visitor)mainEntityType);
            this.funcs.addAll(mainEntityType.getFuncNames());
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.formula);
            sb.append("  \r\n");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\uff1a%s", (String)"FormulaMode_2", (String)"tmc-fbp-common", (Object[])new Object[0]), exp.getMessage());
            sb.append(errorMsg);
            throw new KDBizException(exp, BosErrorCode.expressionParseFailed, new Object[]{sb.toString()});
        }
        mainEntityType = this.taskContext.getSrcEntityType();
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            IVariableMode var = this.buildVarMode((MainEntityType)mainEntityType, varString, keyItems);
            this.vars.add(var);
        }
    }

    protected IVariableMode buildVarMode(MainEntityType mainEntityType, String varString, String[] keyItems) {
        IVariableMode var = null;
        IDataEntityProperty property = mainEntityType.findProperty(keyItems[0]);
        if (property == null && mainEntityType.getProperties().containsKey((Object)keyItems[0])) {
            property = (IDataEntityProperty)mainEntityType.getProperties().get((Object)keyItems[0]);
        }
        if (property != null) {
            var = new SourceBillFieldMode(varString, keyItems, property);
        } else {
            String fun;
            Set funcNames = this.funcLib.getFuncMap().keySet();
            int funStartIndex = varString.indexOf(40);
            var = funStartIndex >= 0 ? (funcNames.contains(fun = varString.substring(0, funStartIndex)) ? new FormulaVariableMode(this.taskContext, varString) : new UnknownVariableMode(varString, keyItems)) : new UnknownVariableMode(varString, keyItems);
        }
        return var;
    }
}

