/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.compare.data.CompareData;
import kd.tmc.fbp.common.compare.data.ComparePropValue;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.strategy.ICompareStrategy;

public class CompareEngine {
    public static final String ID = "id";
    private List<Map<String, Object>> srcDataList;
    private List<Map<String, Object>> tarDataList;

    public CompareEngine(List<Map<String, Object>> srcDataList, List<Map<String, Object>> tarDataList) {
        this.srcDataList = srcDataList;
        this.tarDataList = tarDataList;
    }

    public List<CompareResult> compare(ICompareStrategy strategy) {
        return strategy.compare(this.transDataToValList(this.srcDataList), this.transDataToValList(this.tarDataList));
    }

    private List<CompareData> transDataToValList(List<Map<String, Object>> dataList) {
        return dataList.stream().map(o -> {
            Object id = o.get(ID);
            HashSet<ComparePropValue> propValueSet = new HashSet<ComparePropValue>(o.size());
            for (Map.Entry entry : o.entrySet()) {
                ComparePropValue propValue = new ComparePropValue();
                propValue.setId(id);
                propValue.setData(entry.getValue());
                propValue.setPropName((String)entry.getKey());
                propValueSet.add(propValue);
            }
            return propValueSet;
        }).flatMap(Collection::stream).collect(Collectors.groupingBy(ComparePropValue::getPropName, Collectors.toSet())).entrySet().stream().map(o -> new CompareData((String)o.getKey(), (Set)o.getValue())).collect(Collectors.toList());
    }
}

