/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.compare.CompareException;
import kd.tmc.fbp.common.compare.comparator.ComparatorFactory;
import kd.tmc.fbp.common.compare.comparator.IComparator;
import kd.tmc.fbp.common.compare.data.CompareData;
import kd.tmc.fbp.common.compare.data.ComparePropValue;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.data.CompareRuleGroup;
import kd.tmc.fbp.common.compare.result.CompareUnitResult;

public class CompareUnit {
    private IComparator comparator;
    private CompareRule compareRule;
    private Set<ComparePropValue> srcValList;
    private Set<ComparePropValue> tarValList;
    private boolean isComplete;
    private List<CompareUnitResult> result;

    public CompareUnit() {
    }

    public CompareUnit(IComparator comparator, CompareRule compareRule, Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList) {
        this.comparator = comparator;
        this.compareRule = compareRule;
        this.srcValList = srcValList;
        this.tarValList = tarValList;
    }

    public List<CompareUnitResult> compare() {
        if (this.isComplete) {
            throw new CompareException(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u5339\u914d\u5e76\u91ca\u653e\u8d44\u6e90, \u8bf7\u76f4\u63a5\u8c03\u7528getResult\u65b9\u6cd5\u8fd4\u56de\u7ed3\u679c\u3002", (String)"CompareUnit_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
        }
        this.result = this.comparator.compare(this.srcValList, this.tarValList, this.compareRule);
        this.tarValList = null;
        this.srcValList = null;
        this.isComplete = true;
        return this.result;
    }

    public void skip() {
        this.result = new ArrayList<CompareUnitResult>();
    }

    public static List<CompareUnit> fromPropValList(List<CompareData> srcDataList, List<CompareData> tarDataList, CompareRuleGroup ruleGroup) {
        ArrayList<CompareUnit> result = new ArrayList<CompareUnit>(ruleGroup.getCompareRuleList().size());
        Set<Object> srcIdSet = ruleGroup.getSrcIdSet();
        Set<Object> tarIdSet = ruleGroup.getTarIdSet();
        String matchRel = ruleGroup.getMatchRel();
        for (CompareRule rule : ruleGroup.getCompareRuleList()) {
            CompareUnit grp = new CompareUnit();
            for (CompareData srcData : srcDataList) {
                if (!srcData.getPropName().equals(rule.getPropNameSrc())) continue;
                if (srcIdSet == null) {
                    grp.setSrcValList(new HashSet<ComparePropValue>(srcData.getPropValues()));
                    continue;
                }
                Set srcPropValSet = srcData.getPropValues().stream().filter(o -> srcIdSet.contains(o.getId())).collect(Collectors.toSet());
                grp.setSrcValList(new HashSet<ComparePropValue>(srcPropValSet));
            }
            for (CompareData tarData : tarDataList) {
                if (!tarData.getPropName().equals(rule.getPropNameTgt())) continue;
                if (tarIdSet == null) {
                    grp.setTarValList(new HashSet<ComparePropValue>(tarData.getPropValues()));
                    continue;
                }
                Set tarPropValSet = tarData.getPropValues().stream().filter(o -> tarIdSet.contains(o.getId())).collect(Collectors.toSet());
                grp.setTarValList(new HashSet<ComparePropValue>(tarPropValSet));
            }
            grp.setComparator(ComparatorFactory.getComparator(rule, matchRel));
            grp.setCompareRule(rule);
            result.add(grp);
        }
        return result;
    }

    public List<CompareUnitResult> getResult() {
        return this.result;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public IComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(IComparator comparator) {
        this.comparator = comparator;
    }

    public Set<ComparePropValue> getSrcValList() {
        return this.srcValList;
    }

    public void setSrcValList(Set<ComparePropValue> srcValList) {
        this.srcValList = srcValList;
    }

    public Set<ComparePropValue> getTarValList() {
        return this.tarValList;
    }

    public void setTarValList(Set<ComparePropValue> tarValList) {
        this.tarValList = tarValList;
    }

    public CompareRule getCompareRule() {
        return this.compareRule;
    }

    public void setCompareRule(CompareRule compareRule) {
        this.compareRule = compareRule;
    }
}

