/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class StopWatchWithSummary {
    private static Log logger = LogFactory.getLog(StopWatchWithSummary.class);
    private Stopwatch stopwatch;
    private Map<String, Long> summaryMap = new HashMap<String, Long>();
    private Map<String, Long> countMap = new HashMap<String, Long>();
    private String currKey;

    private StopWatchWithSummary() {
    }

    public static StopWatchWithSummary createUnstarted() {
        StopWatchWithSummary summary = new StopWatchWithSummary();
        summary.stopwatch = Stopwatch.createUnstarted();
        return summary;
    }

    public static StopWatchWithSummary createUnstarted(Ticker ticker) {
        StopWatchWithSummary summary = new StopWatchWithSummary();
        summary.stopwatch = Stopwatch.createUnstarted((Ticker)ticker);
        return summary;
    }

    public static StopWatchWithSummary createStarted() {
        StopWatchWithSummary summary = new StopWatchWithSummary();
        summary.stopwatch = Stopwatch.createStarted();
        return summary;
    }

    public static StopWatchWithSummary createStarted(String key) {
        StopWatchWithSummary summary = new StopWatchWithSummary();
        summary.stopwatch = Stopwatch.createStarted();
        summary.currKey = key;
        return summary;
    }

    public static StopWatchWithSummary createStarted(Ticker ticker) {
        StopWatchWithSummary summary = new StopWatchWithSummary();
        summary.stopwatch = Stopwatch.createStarted((Ticker)ticker);
        return summary;
    }

    public static StopWatchWithSummary createStarted(Ticker ticker, String key) {
        StopWatchWithSummary summary = new StopWatchWithSummary();
        summary.stopwatch = Stopwatch.createStarted((Ticker)ticker);
        summary.currKey = key;
        return summary;
    }

    public boolean isRunning() {
        return this.stopwatch.isRunning();
    }

    public StopWatchWithSummary start() {
        if (this.stopwatch.isRunning()) {
            this.stop();
        }
        this.stopwatch.start();
        return this;
    }

    public StopWatchWithSummary start(String key) {
        if (this.stopwatch.isRunning()) {
            this.reset();
        }
        this.stopwatch.start();
        this.currKey = key;
        return this;
    }

    public StopWatchWithSummary stop() {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
        }
        return this;
    }

    public StopWatchWithSummary nextStep(String key) {
        this.reset();
        this.start(key);
        return this;
    }

    public StopWatchWithSummary reset() {
        long elapsed = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.summary(elapsed);
        this.stopwatch.reset();
        return this;
    }

    public long elapsed(TimeUnit desiredUnit) {
        return this.stopwatch.elapsed(desiredUnit);
    }

    private void summary(long elapsed) {
        if (this.currKey == null) {
            return;
        }
        Long totalTime = this.summaryMap.get(this.currKey);
        Long totalCount = this.countMap.get(this.currKey);
        if (totalTime == null) {
            totalTime = elapsed;
            totalCount = 0L;
        } else {
            totalTime = totalTime + elapsed;
        }
        Long l = totalCount;
        Long l2 = totalCount = Long.valueOf(totalCount + 1L);
        this.summaryMap.put(this.currKey, totalTime);
        this.countMap.put(this.currKey, totalCount);
        this.currKey = null;
    }

    public void printSummary() {
        this.reset();
        long totalTime = this.summaryMap.values().stream().mapToLong(o -> o).sum();
        StringBuilder summaryRes = new StringBuilder();
        summaryRes.append(ResManager.loadKDString((String)"\u603b\u8fd0\u884c\u65f6\u95f4: %d ms", (String)"StopWatchWithSummary_0", (String)"tmc-fbp-common", (Object[])new Object[]{totalTime})).append('\n');
        summaryRes.append("-----------------------------------------").append('\n');
        summaryRes.append(ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u95f4(ms)\t\t\u8fd0\u884c\u6b21\u6570\t\t\u8017\u65f6\u6bd4\u4f8b\t\t\u4efb\u52a1\u540d", (String)"StopWatchWithSummary_1", (String)"tmc-fbp-common", (Object[])new Object[0])).append('\n');
        this.summaryMap.entrySet().stream().sorted((o1, o2) -> (int)((Long)o2.getValue() - (Long)o1.getValue())).forEach(entry -> {
            Long elapsedTime = (Long)entry.getValue();
            Long count = this.countMap.get(entry.getKey());
            int timePercent = (int)((double)elapsedTime.longValue() * 100.0 / (double)totalTime);
            summaryRes.append(String.format("%010d\t\t%06d\t\t%02d%%\t\t\t%s", elapsedTime, count, timePercent, entry.getKey())).append('\n');
        });
        summaryRes.append("-----------------------------------------").append('\n');
        logger.info(summaryRes.toString());
    }
}

