/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.api.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.exception.UnsupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.compare.CompareEngine;
import kd.tmc.fbp.common.compare.api.CompareApi;
import kd.tmc.fbp.common.compare.api.bean.CompareRuleBean;
import kd.tmc.fbp.common.compare.api.bean.CompareRuleConfigBean;
import kd.tmc.fbp.common.compare.api.transfer.CompareDataTransfer;
import kd.tmc.fbp.common.compare.config.CompareStrategyEnum;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.strategy.CompareStrategyFactory;
import kd.tmc.fbp.common.compare.strategy.ICompareStrategy;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class CompareApiImpl
implements CompareApi {
    private List<String> errMsgList = new ArrayList<String>();

    @Override
    public List<CompareResult> compare(List<Object> srcIdList, QFilter[] tarFilterArr, String srcEntityType, String tarEntityType, String orgProp) {
        throw new UnsupportedException(ResManager.loadKDString((String)"\u6682\u672a\u652f\u6301\u7684API\u3002", (String)"CompareApiImpl_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
    }

    @Override
    public List<CompareResult> compare(List<Object> srcIdList, List<Object> tarIdList, String srcEntityType, String tarEntityType, String orgProp) {
        ArrayList<CompareResult> resultList = new ArrayList<CompareResult>();
        Map<Long, List<Object>> srcIdGroupedMap = this.groupSrcIdListByOrgId(srcIdList, srcEntityType, orgProp);
        for (Map.Entry<Long, List<Object>> entry : srcIdGroupedMap.entrySet()) {
            Long orgId = entry.getKey();
            List<Object> groupedIdList = entry.getValue();
            CompareRuleBean compareRuleBean = this.queryCompareRule(srcEntityType, tarEntityType, orgId);
            if (compareRuleBean == null) {
                this.errMsgList.add(ResManager.loadKDString((String)"\u7ec4\u7ec7ID:%s, \u5bf9\u5e94\u7684\u5339\u914d\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"CompareApiImpl_1", (String)"tmc-fbp-common", (Object[])new Object[]{orgId.toString()}));
                continue;
            }
            CompareDataTransfer transfer = new CompareDataTransfer(compareRuleBean);
            List<Map<String, Object>> srcDataList = transfer.transSrcData(groupedIdList);
            List<Map<String, Object>> tarDataList = transfer.transTarData(tarIdList);
            CompareEngine compareEngine = new CompareEngine(srcDataList, tarDataList);
            ICompareStrategy strategy = CompareStrategyFactory.createMultiRuleStrategy(transfer.transCompareRule(), compareRuleBean.getStrategy());
            resultList.addAll(compareEngine.compare(strategy));
        }
        return resultList;
    }

    private Map<Long, List<Object>> groupSrcIdListByOrgId(List<Object> srcIdList, String srcEntityType, String orgProp) {
        DynamicObjectCollection resultList = QueryServiceHelper.query((String)srcEntityType, (String)String.join((CharSequence)",", "id", orgProp), (QFilter[])new QFilter[]{new QFilter("id", "in", srcIdList)});
        return resultList.stream().collect(Collectors.groupingBy(o -> o.getLong(orgProp), Collectors.mapping(o -> o.get("id"), Collectors.toList())));
    }

    private CompareRuleBean queryCompareRule(String srcEntityType, String tarEntityType, Long orgId) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter srcAndTarFilter = new QFilter("entitytypesrc", "=", (Object)srcEntityType).and(new QFilter("entitytypetar", "=", (Object)tarEntityType));
        QFilter orgFilter = new QFilter("entryentityorg.orgconfig", "=", (Object)orgId);
        QFilter entireOrgFilter = new QFilter("forentireorg", "=", (Object)"1");
        DynamicObject compareRule = TmcDataServiceHelper.loadSingleFromCache((String)"fbd_comparerule", (String)"id", (QFilter[])new QFilter[]{enableFilter, srcAndTarFilter, orgFilter});
        if (compareRule == null) {
            compareRule = TmcDataServiceHelper.loadSingleFromCache((String)"fbd_comparerule", (String)"id", (QFilter[])new QFilter[]{enableFilter, srcAndTarFilter, entireOrgFilter});
        }
        if (compareRule == null) {
            return null;
        }
        DynamicObject compareRuleObj = TmcDataServiceHelper.loadSingleFromCache((Object)compareRule.getLong("id"), (String)"fbd_comparerule");
        DynamicObject srcObj = compareRuleObj.getDynamicObject("entitytypesrc");
        DynamicObject tarObj = compareRuleObj.getDynamicObject("entitytypetar");
        String strategy = compareRuleObj.getString("strategy");
        List<List<CompareRuleConfigBean>> configList = compareRuleObj.getDynamicObjectCollection("entryentity").stream().map(o -> o.getString("ruleconfigval_TAG")).filter(StringUtils::isNotEmpty).map(o -> JSON.parseArray((String)o, CompareRuleConfigBean.class)).collect(Collectors.toList());
        CompareRuleBean compareRuleBean = new CompareRuleBean();
        compareRuleBean.setSrcEntityType(srcObj.getString("number"));
        compareRuleBean.setTarEntityType(tarObj.getString("number"));
        compareRuleBean.setConfigList(configList);
        compareRuleBean.setStrategy(CompareStrategyEnum.fromVal(strategy));
        return compareRuleBean;
    }
}

