/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.comparator;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.compare.CompareException;
import kd.tmc.fbp.common.compare.comparator.AbstractComparator;
import kd.tmc.fbp.common.compare.data.ComparePropValue;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.result.CompareUnitResult;

public class DateDiffComparator
extends AbstractComparator {
    private static final DateFormat FMT = new SimpleDateFormat("yyyy-MM-dd");
    private static Log log = LogFactory.getLog(DateDiffComparator.class);

    @Override
    public List<CompareUnitResult> compare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, CompareRule rule) {
        Map<String, CompareUnitResult> model = this.buildCompareModel(srcValList);
        this.compare(model, tarValList, rule);
        return new ArrayList<CompareUnitResult>(model.values());
    }

    private Map<String, CompareUnitResult> buildCompareModel(Set<ComparePropValue> srcValList) {
        HashMap<String, CompareUnitResult> model = new HashMap<String, CompareUnitResult>();
        for (ComparePropValue srcVal : srcValList) {
            String key = (String)srcVal.getData();
            CompareUnitResult compareResult = (CompareUnitResult)model.get(key);
            if (compareResult == null) {
                compareResult = new CompareUnitResult();
                model.put(key, compareResult);
            }
            compareResult.getSrcIdSet().add(srcVal.getId());
        }
        return model;
    }

    private void compare(Map<String, CompareUnitResult> model, Set<ComparePropValue> tarValList, CompareRule rule) {
        int dayDiff;
        try {
            dayDiff = Integer.parseInt(rule.getExtraVal().toString());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u5dee\u53c2\u6570\u914d\u7f6e\u9519\u8bef, \u8bf7\u68c0\u67e5\u3002", (String)"DateDiffComparator_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
        }
        for (ComparePropValue tarVal : tarValList) {
            Date date;
            try {
                date = FMT.parse((String)tarVal.getData());
            }
            catch (ParseException e) {
                log.error((Throwable)e);
                throw new CompareException(e.getMessage());
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, -dayDiff);
            for (int i = -dayDiff; i <= dayDiff; ++i) {
                String key = FMT.format(calendar.getTime());
                CompareUnitResult compareResult = model.get(key);
                if (compareResult != null) {
                    compareResult.getTarIdSet().add(tarVal.getId());
                }
                calendar.add(5, 1);
            }
        }
    }
}

