/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.comparator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.tmc.fbp.common.compare.comparator.AbstractComparator;
import kd.tmc.fbp.common.compare.data.ComparePropValue;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.result.CompareUnitResult;

public class TrieComparator
extends AbstractComparator {
    private static final int DIRECT_REVERSE = -1;
    private static final int DIRECT_BOTH = 0;
    private static final int DIRECT_NORMAL = 1;

    @Override
    public List<CompareUnitResult> compare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, CompareRule rule) {
        List<CompareUnitResult> resultList;
        Integer type = null;
        try {
            type = (Integer)rule.getExtraVal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == null) {
            type = 1;
        }
        if (type == 0) {
            resultList = this.doCompare(srcValList, tarValList, false);
            resultList.addAll(this.doCompare(srcValList, tarValList, true));
        } else {
            resultList = type == -1 ? this.doCompare(srcValList, tarValList, true) : this.doCompare(srcValList, tarValList, false);
        }
        return resultList;
    }

    private List<CompareUnitResult> doCompare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, boolean isReversed) {
        ArrayList<CompareUnitResult> resultList = new ArrayList<CompareUnitResult>();
        if (isReversed) {
            Set<ComparePropValue> temp = tarValList;
            tarValList = srcValList;
            srcValList = temp;
        }
        TireTree tree = this.buildTree(tarValList);
        for (ComparePropValue srcVal : srcValList) {
            String srcStr = this.getStringValue(srcVal.getData());
            Set<TireTreeNode> nodeSet = tree.find(srcStr);
            if (nodeSet.isEmpty()) continue;
            HashSet<Object> srcIdSet = new HashSet<Object>();
            HashSet<Object> tarIdSet = new HashSet<Object>();
            HashSet<Object> idSet = new HashSet<Object>();
            for (TireTreeNode node : nodeSet) {
                idSet.addAll(node.getIds());
            }
            if (isReversed) {
                srcIdSet.addAll(idSet);
                tarIdSet.add(srcVal.getId());
            } else {
                srcIdSet.add(srcVal.getId());
                tarIdSet.addAll(idSet);
            }
            CompareUnitResult result = new CompareUnitResult(srcIdSet, tarIdSet);
            resultList.add(result);
        }
        return resultList;
    }

    private TireTree buildTree(Set<ComparePropValue> valSet) {
        TireTree tree = new TireTree();
        for (ComparePropValue propVal : valSet) {
            String str = this.getStringValue(propVal.getData());
            char[] chArr = str.toCharArray();
            TireTreeNode node = tree.getRoot();
            for (int i = 0; i < chArr.length; ++i) {
                node = node.addChild(chArr[i]);
                if (i != chArr.length - 1) continue;
                node.getIds().add(propVal.getId());
            }
        }
        tree.calcMinDistance();
        return tree;
    }

    class TireTreeNode {
        char ch;
        int minDistance;
        Map<Character, TireTreeNode> childMap;
        List<TireTreeNode> childList;
        Set<Object> idSet;
        static final int THREHOLD = 6;

        TireTreeNode() {
            this.childList = new ArrayList<TireTreeNode>();
        }

        TireTreeNode(Character ch) {
            this.ch = ch.charValue();
            this.childList = new ArrayList<TireTreeNode>();
            this.idSet = new HashSet<Object>();
        }

        TireTreeNode getChild(char ch) {
            TireTreeNode node = null;
            if (this.childList != null) {
                for (TireTreeNode child : this.childList) {
                    if (child.ch != ch) continue;
                    node = child;
                    break;
                }
            } else {
                node = this.childMap.computeIfAbsent(Character.valueOf(ch), o -> new TireTreeNode(Character.valueOf(ch)));
            }
            return node;
        }

        List<TireTreeNode> getAllChild() {
            if (this.childList != null) {
                return this.childList;
            }
            return new ArrayList<TireTreeNode>(this.childMap.values());
        }

        TireTreeNode addChild(char ch) {
            TireTreeNode node = this.getChild(ch);
            if (node != null) {
                return node;
            }
            node = new TireTreeNode(Character.valueOf(ch));
            if (this.childList != null) {
                if (this.childList.size() < 6) {
                    this.childList.add(node);
                } else {
                    this.childMap = new HashMap<Character, TireTreeNode>(this.childList.size() + 1);
                    for (TireTreeNode child : this.childList) {
                        this.childMap.put(Character.valueOf(child.ch), child);
                    }
                    this.childMap.put(Character.valueOf(ch), node);
                    this.childList = null;
                }
            } else {
                this.childMap.put(Character.valueOf(ch), node);
            }
            return node;
        }

        Set<Object> getIds() {
            return this.idSet;
        }
    }

    class TireTree {
        TireTreeNode root;

        TireTree() {
            this.root = new TireTreeNode();
        }

        TireTreeNode getRoot() {
            return this.root;
        }

        Set<TireTreeNode> find(String target) {
            HashSet<TireTreeNode> nodeSet = new HashSet<TireTreeNode>();
            char[] chArr = target.toCharArray();
            block0: for (int i = 0; i < chArr.length; ++i) {
                TireTreeNode node = this.root;
                for (int j = i; j < chArr.length; ++j) {
                    char ch = chArr[j];
                    int len = chArr.length - j;
                    if (len < node.minDistance || (node = node.getChild(ch)) == null) continue block0;
                    if (node.getIds().isEmpty()) continue;
                    nodeSet.add(node);
                }
            }
            return nodeSet;
        }

        void calcMinDistance() {
            this.doCalcMinDistance(this.root);
        }

        int doCalcMinDistance(TireTreeNode node) {
            int minDistance = Integer.MAX_VALUE;
            List<TireTreeNode> children = node.getAllChild();
            for (TireTreeNode child : children) {
                minDistance = Math.min(minDistance, this.doCalcMinDistance(child));
            }
            return minDistance == Integer.MAX_VALUE ? 1 : minDistance;
        }
    }
}

