/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.data;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.compare.data.CompareData;
import kd.tmc.fbp.common.compare.data.ComparePropValue;

public class CompareDataGetter {
    private List<CompareData> compareData;
    private Map<String, Set<ComparePropValue>> propValMap;

    public CompareDataGetter(List<CompareData> compareData) {
        this.compareData = compareData;
        this.initProp();
    }

    private void initProp() {
        this.propValMap = this.compareData.stream().collect(Collectors.toMap(CompareData::getPropName, CompareData::getPropValues, (a, b) -> a));
    }

    public Object getCompareValue(String propName, Object id) {
        Set<ComparePropValue> valList = this.propValMap.get(propName);
        if (valList == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027%s\u4e0d\u5b58\u5728\u3002", (String)"CompareDataGetter_0", (String)"tmc-fbp-common", (Object[])new Object[]{propName}));
        }
        for (ComparePropValue value : valList) {
            if (!value.getId().equals(id)) continue;
            return value.getData();
        }
        return null;
    }
}

