/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.compare.strategy;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.compare.StopWatchWithSummary;
import kd.tmc.fbp.common.compare.data.CompareData;
import kd.tmc.fbp.common.compare.data.ComparePropValue;
import kd.tmc.fbp.common.compare.data.CompareRule;
import kd.tmc.fbp.common.compare.data.CompareRuleGroup;
import kd.tmc.fbp.common.compare.result.CompareResult;
import kd.tmc.fbp.common.compare.strategy.ICompareStrategy;
import kd.tmc.fbp.common.compare.strategy.MultiResultHandler;
import kd.tmc.fbp.common.compare.strategy.StandardCompareStrategy;
import kd.tmc.fbp.common.enums.MatchRelEnum;

public abstract class AbstractMultiRuleCompareStrategy
implements ICompareStrategy {
    private List<CompareRuleGroup> ruleList;
    private StopWatchWithSummary watch = StopWatchWithSummary.createUnstarted();
    private boolean enableMultiRes;

    public AbstractMultiRuleCompareStrategy(List<List<CompareRule>> ruleList) {
        this.ruleList = ruleList.stream().map(CompareRuleGroup::new).collect(Collectors.toList());
    }

    public AbstractMultiRuleCompareStrategy(List<CompareRuleGroup> ruleList, boolean enableMultiRes) {
        this.ruleList = ruleList;
        this.enableMultiRes = enableMultiRes;
    }

    @Override
    public List<CompareResult> compare(List<CompareData> srcDataList, List<CompareData> tarDataList) {
        this.watch.nextStep(ResManager.loadKDString((String)"\u62f7\u8d1d\u6570\u636e\u6e90", (String)"AbstractMultiRuleCompareStrategy_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
        List<CompareData> srcDataListCopy = this.copyCompareData(srcDataList);
        List<CompareData> tarDataListCopy = this.copyCompareData(tarDataList);
        LinkedList<CompareResult> successList = new LinkedList<CompareResult>();
        for (CompareRuleGroup compareRules : this.ruleList) {
            this.watch.nextStep(ResManager.loadKDString((String)"\u6267\u884c\u5339\u914d\u7b97\u6cd5", (String)"AbstractMultiRuleCompareStrategy_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
            StandardCompareStrategy strategy = new StandardCompareStrategy(compareRules);
            List<CompareResult> resultList = strategy.compare(srcDataListCopy, tarDataListCopy);
            this.watch.nextStep(ResManager.loadKDString((String)"\u5904\u7406\u672c\u8f6e\u5339\u914d\u7ed3\u679c", (String)"AbstractMultiRuleCompareStrategy_2", (String)"tmc-fbp-common", (Object[])new Object[0]));
            if (this.enableMultiRes) {
                if (compareRules.isEnableMultiRes() && MatchRelEnum.ONE_TO_ONE.getValue().equals(compareRules.getMatchRel())) {
                    MultiResultHandler.getInstance().handleMultiResult(resultList);
                }
                List<CompareResult> currSuccessList = this.handleResult(resultList, srcDataListCopy, tarDataListCopy, compareRules);
                for (CompareResult compareResult : currSuccessList) {
                    compareResult.setRuleId(compareRules.getRuleId());
                }
                successList.addAll(currSuccessList);
                continue;
            }
            this.handleResult(successList, resultList, srcDataListCopy, tarDataListCopy);
        }
        return successList;
    }

    protected void removeFromDataList(List<CompareData> dataList, Collection<Object> idList) {
        for (CompareData data : dataList) {
            HashSet<ComparePropValue> waitRemoveValList = new HashSet<ComparePropValue>(idList.size());
            for (Object id : idList) {
                ComparePropValue propValue = new ComparePropValue();
                propValue.setPropName(data.getPropName());
                propValue.setId(id);
                waitRemoveValList.add(propValue);
            }
            data.getPropValues().removeAll(waitRemoveValList);
        }
    }

    private List<CompareData> copyCompareData(List<CompareData> dataList) {
        LinkedList<CompareData> copyDataList = new LinkedList<CompareData>();
        for (CompareData compareData : dataList) {
            CompareData dataCopy = new CompareData(compareData.getPropName(), new HashSet<ComparePropValue>(compareData.getPropValues()));
            copyDataList.add(dataCopy);
        }
        return copyDataList;
    }

    @Deprecated
    protected void handleResult(List<CompareResult> successList, List<CompareResult> resultList, List<CompareData> srcDataList, List<CompareData> tarDataList) {
    }

    protected List<CompareResult> handleResult(List<CompareResult> resultList, List<CompareData> srcDataList, List<CompareData> tarDataList, CompareRuleGroup compareRuleGrp) {
        return new LinkedList<CompareResult>();
    }
}

