/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.dataset;

import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowFeature;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;

public class SplitByFilterExtDataSetBuilder {
    private String[] filterExprs;
    private Map<String, Object> params;
    private boolean includeOthers;
    private RowMeta rowMeta;
    private DataSet dataSet;
    private static final int DEFAULT_SPLIT_BYFILTER_MAXSIZE = 100;

    public SplitByFilterExtDataSetBuilder(DataSet dataSet, String[] filterExprs, Map<String, Object> params, boolean includeOthers) {
        this.filterExprs = filterExprs;
        this.params = params;
        this.includeOthers = includeOthers;
        this.rowMeta = dataSet.getRowMeta();
        this.dataSet = dataSet;
    }

    public DataSet[] split() {
        int size;
        int maxSize = 100;
        int n = size = this.includeOthers ? this.filterExprs.length + 1 : this.filterExprs.length;
        if (size > maxSize) {
            throw new AlgoException("splitByFilter exceed max group size:" + maxSize);
        }
        DataSetBuilder[] builders = this.buildDataSetBuilders(size);
        Calc[] calcs = this.buildCalcs(this.filterExprs, this.params);
        return this.buildDataSets(size, this.filterExprs, builders, calcs, this.includeOthers);
    }

    private DataSetBuilder[] buildDataSetBuilders(int size) {
        DataSetBuilder[] builders = new DataSetBuilder[size];
        Object algo = this.dataSet instanceof AbstractDataSet ? ((AbstractDataSet)this.dataSet).getEnvironment() : Algo.create((String)this.getClass().getName());
        for (int i = 0; i < size; ++i) {
            builders[i] = algo.createDataSetBuilder(this.rowMeta);
        }
        return builders;
    }

    private Calc[] buildCalcs(String[] filterExprs, Map<String, Object> params) {
        Calc[] calcs = new Calc[filterExprs.length];
        for (int i = 0; i < filterExprs.length; ++i) {
            Expr expr = new ExprParser(this.rowMeta, params).parse(filterExprs[i]);
            calcs[i] = CalcCompiler.compile((RowMeta)this.rowMeta, (Expr)expr);
        }
        return calcs;
    }

    private DataSet[] buildDataSets(int size, String[] filterExprs, DataSetBuilder[] builders, Calc[] calcs, boolean includeOthers) {
        if (this.dataSet == null) {
            return new DataSet[size];
        }
        while (this.dataSet.hasNext()) {
            Row next = this.dataSet.next();
            boolean allNotContain = true;
            for (int i = 0; i < filterExprs.length; ++i) {
                if (!((Boolean)calcs[i].execute((RowFeature)next, null)).booleanValue()) continue;
                builders[i].append(next);
                allNotContain = false;
            }
            if (!includeOthers || !allNotContain) continue;
            builders[size - 1].append(next);
        }
        DataSet[] dataSets = new DataSet[size];
        for (int i = 0; i < builders.length; ++i) {
            dataSets[i] = builders[i].build();
        }
        if (this.dataSet != null) {
            this.dataSet.close();
        }
        return dataSets;
    }
}

