/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.enums;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;

public enum GuaranteeWayEnum {
    ENSURE("ensure", "2"),
    ENSUAMT("ensuamt", "3"),
    MORTGAGE("mortgage", "4"),
    PLEDGE("pledge", "5"),
    OTHER("other", "6"),
    NONE("none", "7");

    private String value;
    private String numberValue;

    private GuaranteeWayEnum(String value, String numberValue) {
        this.value = value;
        this.numberValue = numberValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getNumberValue() {
        return this.numberValue;
    }

    public static String getName(String value) {
        switch (value) {
            case "2": 
            case "ensure": {
                return ResManager.loadKDString((String)"\u4fdd\u8bc1", (String)"GuaranteeWayEnum_0", (String)"tmc-fbp-common", (Object[])new Object[0]);
            }
            case "3": 
            case "ensuamt": {
                return ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1", (String)"GuaranteeWayEnum_1", (String)"tmc-fbp-common", (Object[])new Object[0]);
            }
            case "4": 
            case "mortgage": {
                return ResManager.loadKDString((String)"\u62b5\u62bc", (String)"GuaranteeWayEnum_2", (String)"tmc-fbp-common", (Object[])new Object[0]);
            }
            case "5": 
            case "pledge": {
                return ResManager.loadKDString((String)"\u8d28\u62bc", (String)"GuaranteeWayEnum_3", (String)"tmc-fbp-common", (Object[])new Object[0]);
            }
            case "6": 
            case "other": {
                return ResManager.loadKDString((String)"\u5176\u4ed6", (String)"GuaranteeWayEnum_5", (String)"tmc-fbp-common", (Object[])new Object[0]);
            }
            case "7": 
            case "none": {
                return ResManager.loadKDString((String)"\u4fe1\u7528/\u65e0\u62c5\u4fdd", (String)"GuaranteeWayEnum_6", (String)"tmc-fbp-common", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public static boolean isAllValueSelect(String newGuaranteeWayValues, String oldGuaranteeWayValues) {
        GuaranteeWayEnum[] values;
        if (EmptyUtil.isEmpty(newGuaranteeWayValues)) {
            return false;
        }
        boolean exceptNone = true;
        for (GuaranteeWayEnum value : values = GuaranteeWayEnum.values()) {
            if (value == ENSUAMT) continue;
            if (!newGuaranteeWayValues.contains(value.getValue())) {
                return false;
            }
            if (value == NONE || !EmptyUtil.isNoEmpty(oldGuaranteeWayValues) || oldGuaranteeWayValues.contains(value.getValue())) continue;
            exceptNone = false;
        }
        if (exceptNone && EmptyUtil.isNoEmpty(oldGuaranteeWayValues)) {
            return oldGuaranteeWayValues.contains(NONE.getValue());
        }
        return true;
    }

    public static boolean isAllNumValueSelect(String newGuaranteeWayValues, String oldGuaranteeWayValues) {
        GuaranteeWayEnum[] values;
        if (EmptyUtil.isEmpty(newGuaranteeWayValues)) {
            return false;
        }
        boolean exceptNone = true;
        for (GuaranteeWayEnum value : values = GuaranteeWayEnum.values()) {
            if (value == ENSUAMT) continue;
            if (!newGuaranteeWayValues.contains(value.getNumberValue())) {
                return false;
            }
            if (value == NONE || !EmptyUtil.isNoEmpty(oldGuaranteeWayValues) || oldGuaranteeWayValues.contains(value.getNumberValue())) continue;
            exceptNone = false;
        }
        if (exceptNone && EmptyUtil.isNoEmpty(oldGuaranteeWayValues)) {
            return oldGuaranteeWayValues.contains(NONE.getValue());
        }
        return true;
    }

    public static String genAllGuaranteeWayValues() {
        GuaranteeWayEnum[] values = GuaranteeWayEnum.values();
        return Arrays.stream(values).map(GuaranteeWayEnum::getValue).filter(eValue -> !eValue.equals("none") && !eValue.equals("ensuamt")).collect(Collectors.joining(","));
    }

    public static String genAllGuaranteeWayNumValues() {
        GuaranteeWayEnum[] values = GuaranteeWayEnum.values();
        return Arrays.stream(values).map(GuaranteeWayEnum::getNumberValue).filter(eNumberValue -> !eNumberValue.equals("7") && !eNumberValue.equals("3")).collect(Collectors.joining(","));
    }

    public static String exchangeNumberValueToValue(String numberValue) {
        GuaranteeWayEnum[] values;
        for (GuaranteeWayEnum val : values = GuaranteeWayEnum.values()) {
            if (!val.getNumberValue().equals(numberValue)) continue;
            return val.getValue();
        }
        return "";
    }

    public static String exchangeValueToNumberValue(String value) {
        GuaranteeWayEnum[] values;
        for (GuaranteeWayEnum val : values = GuaranteeWayEnum.values()) {
            if (!val.getValue().equals(value)) continue;
            return val.getNumberValue();
        }
        return "";
    }
}

