/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.enums;

import java.util.Arrays;
import java.util.List;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum InvestTypeEnum {
    finance(new MultiLangEnumBridge("\u7406\u8d22\u4ea7\u54c1", "InvestTypeEnum_0", "tmc-fbp-common"), "finance"),
    fixed(new MultiLangEnumBridge("\u5b9a\u671f\u5b58\u6b3e", "InvestTypeEnum_1", "tmc-fbp-common"), "fixed"),
    notice(new MultiLangEnumBridge("\u901a\u77e5\u5b58\u6b3e", "InvestTypeEnum_2", "tmc-fbp-common"), "notice"),
    surety(new MultiLangEnumBridge("\u4fdd\u8bc1\u91d1", "InvestTypeEnum_3", "tmc-fbp-common"), "surety"),
    structure(new MultiLangEnumBridge("\u7ed3\u6784\u6027\u5b58\u6b3e", "InvestTypeEnum_4", "tmc-fbp-common"), "structure"),
    huge(new MultiLangEnumBridge("\u5927\u989d\u5b58\u5355", "InvestTypeEnum_5", "tmc-fbp-common"), "huge");

    private MultiLangEnumBridge name;
    private String value;

    private InvestTypeEnum(MultiLangEnumBridge name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getValue() {
        return this.value;
    }

    public static String getName(String value) {
        String name = null;
        for (InvestTypeEnum status : InvestTypeEnum.values()) {
            if (!status.getValue().equals(value)) continue;
            name = status.getName();
        }
        return name;
    }

    public static InvestTypeEnum getEnumByValue(String value) {
        InvestTypeEnum adjustMethodEnum = null;
        for (InvestTypeEnum status : InvestTypeEnum.values()) {
            if (!status.getValue().equals(value)) continue;
            adjustMethodEnum = status;
            break;
        }
        return adjustMethodEnum;
    }

    public static boolean isFixed(String investType) {
        List<String> fixedList = Arrays.asList(InvestTypeEnum.getFixedGroup());
        return fixedList.contains(investType);
    }

    public static boolean isNotice(String investType) {
        return notice.getValue().equals(investType);
    }

    public static String[] getFixedGroup() {
        return new String[]{fixed.getValue(), structure.getValue(), huge.getValue()};
    }

    public static boolean isStructure(String investType) {
        return structure.getValue().equals(investType);
    }
}

