/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.enums;

import java.util.Date;
import kd.tmc.fbp.common.util.DateUtils;

public enum PayFrequeEnum {
    twoWeek("2w", "twoWeek"),
    threeWeek("3w", "threeWeek"),
    month("1m", "month"),
    twoMonth("2m", "twoMonth"),
    season("3m", "season"),
    fourMonth("4m", "fourMonth"),
    fiveMonth("5m", "fiveMonth"),
    hyear("6m", "hyear"),
    sevenMonth("7m", "sevenMonth"),
    eightMonth("8m", "eightMonth"),
    nineMonth("9m", "nineMonth"),
    tenMonth("10m", "tenMonth"),
    elevenMonth("11m", "elevenMonth"),
    oneYear("1y", "oneYear"),
    twoYear("2y", "twoYear"),
    threeYear("3y", "threeYear"),
    fourYear("4y", "fourYear"),
    fiveYear("5y", "fiveYear"),
    sixYear("6y", "sixYear"),
    sevenYear("7y", "sevenYear"),
    eightYear("8y", "eightYear"),
    nineYear("9y", "nineYear"),
    tenYear("10y", "tenYear"),
    twentyYear("20y", "twentyYear"),
    thirtyYear("30y", "thirtyYear"),
    year("12m", "year"),
    twoweek("14d", "twoweek"),
    sevenDay("7d", "sevenDay"),
    week("1w", "week"),
    day("1d", "day"),
    atsight("atsight", "atsight"),
    exprie("exprie", "exprie");

    private String name;
    private String value;

    private PayFrequeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static String getName(String value) {
        String name = null;
        for (PayFrequeEnum data : PayFrequeEnum.values()) {
            if (!data.getValue().equals(value)) continue;
            name = data.getName();
            break;
        }
        return name;
    }

    public int getFreque() {
        switch (this) {
            case year: {
                return 1;
            }
            case hyear: {
                return 2;
            }
            case season: {
                return 4;
            }
            case month: {
                return 12;
            }
        }
        return 1;
    }

    public int getMonth() {
        switch (this) {
            case year: {
                return 12;
            }
            case hyear: {
                return 6;
            }
            case season: {
                return 3;
            }
            case month: {
                return 1;
            }
        }
        return 1;
    }

    public int getDay() {
        switch (this) {
            case threeWeek: {
                return 21;
            }
            case twoweek: {
                return 14;
            }
            case week: {
                return 7;
            }
            case day: {
                return 1;
            }
        }
        return 0;
    }

    public String payFrequeType() {
        if (this.getName().contains("m")) {
            return "month";
        }
        if (this.getName().contains("d")) {
            return "day";
        }
        if (this.getName().contains("atsight")) {
            return "atsight";
        }
        return null;
    }

    public static int compareFreq(Date referdate, PayFrequeEnum freqEnum0, PayFrequeEnum freqEnum1) {
        Date date0 = PayFrequeEnum.getNextDateByPayfreq(referdate, freqEnum0);
        Date date1 = PayFrequeEnum.getNextDateByPayfreq(referdate, freqEnum1);
        return date0.compareTo(date1);
    }

    public static PayFrequeEnum getFreqMax(PayFrequeEnum freqEnum0, PayFrequeEnum freqEnum1) {
        Date date1;
        Date date = DateUtils.getCurrentDate();
        Date date0 = PayFrequeEnum.getNextDateByPayfreq(date, freqEnum0);
        return date0.compareTo(date1 = PayFrequeEnum.getNextDateByPayfreq(date, freqEnum1)) > 0 ? freqEnum0 : freqEnum1;
    }

    public static PayFrequeEnum getFreqMin(PayFrequeEnum freqEnum0, PayFrequeEnum freqEnum1) {
        Date date1;
        Date date = DateUtils.getCurrentDate();
        Date date0 = PayFrequeEnum.getNextDateByPayfreq(date, freqEnum0);
        return date0.compareTo(date1 = PayFrequeEnum.getNextDateByPayfreq(date, freqEnum1)) < 0 ? freqEnum0 : freqEnum1;
    }

    public static Date getNextDateByPayfreq(Date referdate, PayFrequeEnum freqEnum) {
        Date date;
        if (freqEnum == atsight) {
            date = referdate;
        } else {
            String name = freqEnum.getName();
            int period = 0;
            if (name.contains("m")) {
                period = Integer.parseInt(name.split("m")[0]);
                date = DateUtils.getNextMonth(referdate, period);
            } else if (name.contains("d")) {
                period = Integer.parseInt(name.split("d")[0]);
                date = DateUtils.getNextDay(referdate, period);
            } else if (name.contains("y")) {
                period = Integer.parseInt(name.split("y")[0]);
                date = DateUtils.getNextYear(referdate, period);
            } else if (name.contains("w")) {
                period = Integer.parseInt(name.split("w")[0]);
                date = DateUtils.getNextDay(referdate, period * 7);
            } else {
                date = referdate;
            }
        }
        return date;
    }

    public static Date getNextDateByPayfreq(Date referdate, PayFrequeEnum freqEnum, Date endDate) {
        if (freqEnum == exprie) {
            return endDate;
        }
        return PayFrequeEnum.getNextDateByPayfreq(referdate, freqEnum);
    }

    public static Date getLastDateByPayfreq(Date referdate, PayFrequeEnum freqEnum) {
        Date date;
        if (freqEnum == atsight) {
            date = referdate;
        } else {
            String name = freqEnum.getName();
            int period = 0;
            if (name.contains("m")) {
                period = Integer.parseInt(name.split("m")[0]);
                date = DateUtils.getLastMonth(referdate, period);
            } else if (name.contains("d")) {
                period = Integer.parseInt(name.split("d")[0]);
                date = DateUtils.getLastDay(referdate, period);
            } else if (name.contains("y")) {
                period = Integer.parseInt(name.split("y")[0]);
                date = DateUtils.getLastYear(referdate, period);
            } else if (name.contains("w")) {
                period = Integer.parseInt(name.split("w")[0]);
                date = DateUtils.getLastDay(referdate, period * 7);
            } else {
                date = referdate;
            }
        }
        return date;
    }

    public static PayFrequeEnum getEnumByName(String name) {
        PayFrequeEnum payFrequeEnum = null;
        for (PayFrequeEnum data : PayFrequeEnum.values()) {
            if (!data.getName().equals(name)) continue;
            payFrequeEnum = data;
            break;
        }
        return payFrequeEnum;
    }
}

