/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.enums;

import kd.tmc.fbp.common.enums.MultiLangEnumBridge;

public enum TradeToolEnum {
    Cash(new MultiLangEnumBridge("\u73b0\u91d1", "TradeToolEnum_0", "tmc-fbp-common"), "Cash", 1),
    FRA(new MultiLangEnumBridge("\u8fdc\u671f\u5229\u7387\u534f\u8bae", "TradeToolEnum_1", "tmc-fbp-common"), "FRA", 2),
    Future(new MultiLangEnumBridge("\u671f\u8d27", "TradeToolEnum_2", "tmc-fbp-common"), "Future", 3),
    Swap(new MultiLangEnumBridge("\u4e92\u6362", "TradeToolEnum_3", "tmc-fbp-common"), "Swap", 4),
    Bond(new MultiLangEnumBridge("\u503a\u5238", "TradeToolEnum_4", "tmc-fbp-common"), "Bond", 5);

    private MultiLangEnumBridge name;
    private String value;
    private int seq;

    private TradeToolEnum(MultiLangEnumBridge name, String value, int seq) {
        this.name = name;
        this.value = value;
        this.seq = seq;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public String getValue() {
        return this.value;
    }

    public static String getName(String value) {
        String name = null;
        for (TradeToolEnum status : TradeToolEnum.values()) {
            if (!status.getValue().equals(value)) continue;
            name = status.getName();
        }
        return name;
    }

    public static boolean isCash(String value) {
        return Cash.getValue().equals(value);
    }

    public static boolean isFra(String value) {
        return FRA.getValue().equals(value);
    }

    public static boolean isFuture(String value) {
        return Future.getValue().equals(value);
    }

    public static boolean isBond(String value) {
        return Bond.getValue().equals(value);
    }

    public static boolean isSwap(String value) {
        return Swap.getValue().equals(value);
    }

    public int getSeq() {
        return this.seq;
    }
}

