/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.formula;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.tmc.fbp.common.formula.FormulaUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.distribution.NormalDistribution;

public class MathFormulaUtils {
    public static double cumulativeProbability(double x) {
        NormalDistribution normalDistribution = new NormalDistribution();
        return normalDistribution.cumulativeProbability(x);
    }

    public static Map<Integer, BigDecimal> getDataMapByMethod(String insertmethod, Integer[] px, Map<Integer, BigDecimal> finDataMap) {
        double[] x = new double[finDataMap.size()];
        double[] y = new double[finDataMap.size()];
        Set<Integer> set = finDataMap.keySet();
        Object[] arr = set.toArray();
        Arrays.sort(arr);
        for (int i = 0; i < arr.length; ++i) {
            x[i] = ((Integer)arr[i]).doubleValue();
            y[i] = finDataMap.get(arr[i]).doubleValue();
        }
        UnivariateFunction function = MathFormulaUtils.getFunctionByXY(insertmethod, x, y);
        LinkedHashMap<Integer, BigDecimal> pxyMap = new LinkedHashMap<Integer, BigDecimal>(px.length);
        double minX = x[0];
        double minY = y[0];
        double maxX = x[x.length - 1];
        double maxY = y[x.length - 1];
        for (int i = 0; i < px.length; ++i) {
            BigDecimal py = BigDecimal.ZERO;
            if ((double)px[i].intValue() >= minX && (double)px[i].intValue() <= maxX) {
                py = BigDecimal.valueOf(function.value((double)px[i].intValue()));
            } else if ((double)px[i].intValue() < minX) {
                py = FormulaUtils.getLineCompRate(BigDecimal.valueOf(px[i].intValue()), BigDecimal.valueOf(minX), BigDecimal.ZERO, BigDecimal.valueOf(minY), BigDecimal.ZERO);
            } else if ((double)px[i].intValue() > maxX) {
                py = FormulaUtils.getLineCompRate(BigDecimal.valueOf(px[i].intValue()), BigDecimal.valueOf(maxX), BigDecimal.ZERO, BigDecimal.valueOf(maxY), BigDecimal.ZERO);
            }
            pxyMap.put(px[i], py);
        }
        return pxyMap;
    }

    public static Map<BigDecimal, BigDecimal> getDataMapByMethod(String insertmethod, BigDecimal[] px, Map<BigDecimal, BigDecimal> finDataMap) {
        double[] x = new double[finDataMap.size()];
        double[] y = new double[finDataMap.size()];
        Set<BigDecimal> set = finDataMap.keySet();
        Object[] arr = set.toArray();
        Arrays.sort(arr);
        for (int i = 0; i < arr.length; ++i) {
            x[i] = ((BigDecimal)arr[i]).doubleValue();
            y[i] = finDataMap.get(arr[i]).doubleValue();
        }
        UnivariateFunction function = MathFormulaUtils.getFunctionByXY(insertmethod, x, y);
        LinkedHashMap<BigDecimal, BigDecimal> pxyMap = new LinkedHashMap<BigDecimal, BigDecimal>(px.length);
        double minX = x[0];
        double minY = y[0];
        double maxX = x[x.length - 1];
        double maxY = y[x.length - 1];
        for (int i = 0; i < px.length; ++i) {
            BigDecimal py = BigDecimal.ZERO;
            if (px[i].doubleValue() >= minX && px[i].doubleValue() <= maxX) {
                py = BigDecimal.valueOf(function.value(px[i].doubleValue()));
            } else if (px[i].doubleValue() < minX) {
                py = FormulaUtils.getLineCompRate(px[i], BigDecimal.valueOf(minX), BigDecimal.ZERO, BigDecimal.valueOf(minY), BigDecimal.ZERO);
            } else if (px[i].doubleValue() > maxX) {
                py = FormulaUtils.getLineCompRate(px[i], BigDecimal.valueOf(maxX), BigDecimal.ZERO, BigDecimal.valueOf(maxY), BigDecimal.ZERO);
            }
            pxyMap.put(px[i], py);
        }
        return pxyMap;
    }

    private static UnivariateFunction getFunctionByXY(String insertmethod, double[] x, double[] y) {
        UnivariateFunction function = null;
        Object sp = null;
        sp = insertmethod.equals("linear") ? new LinearInterpolator() : new SplineInterpolator();
        function = sp.interpolate(x, y);
        return function;
    }

    public static double inverseCumulativeProbability(double p) {
        NormalDistribution normalDistribution = new NormalDistribution();
        return normalDistribution.inverseCumulativeProbability(p);
    }
}

