/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.tmc.fbp.common.graph.Edge;
import kd.tmc.fbp.common.graph.Path;
import kd.tmc.fbp.common.graph.Vertex;
import org.apache.commons.lang3.tuple.Pair;

public class Graph
implements Serializable {
    private static final long serialVersionUID = 4141049168056021461L;
    public static final int VISIT_COLOR_WHITE = 1;
    public static final int VISIT_COLOR_GREY = 2;
    public static final int VISIT_COLOR_BLACK = 3;
    private final List<Vertex> verticies = new ArrayList<Vertex>();
    private final List<Edge> edges = new ArrayList<Edge>();

    public boolean isEmpty() {
        return this.verticies.size() == 0;
    }

    public boolean addVertex(Vertex v) {
        boolean added = false;
        if (!this.verticies.contains(v)) {
            added = this.verticies.add(v);
        }
        return added;
    }

    public int size() {
        return this.verticies.size();
    }

    public Vertex getVertex(int n) {
        return this.verticies.get(n);
    }

    public List<Vertex> getVerticies() {
        return this.verticies;
    }

    public boolean addEdge(Vertex from, Vertex to, Set<Long> id) throws IllegalArgumentException {
        if (!this.verticies.contains(from)) {
            throw new IllegalArgumentException("from is not in graph");
        }
        if (!this.verticies.contains(to)) {
            throw new IllegalArgumentException("to is not in graph");
        }
        Edge e = new Edge(from, to, id);
        if (from.findEdge(to) != null) {
            return false;
        }
        from.addEdge(e);
        to.addEdge(e);
        this.edges.add(e);
        return true;
    }

    public boolean insertBiEdge(Vertex from, Vertex to, Set<Long> id) throws IllegalArgumentException {
        return this.addEdge(from, to, id) && this.addEdge(to, from, id);
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public boolean removeVertex(Vertex v) {
        Edge e;
        int n;
        if (!this.verticies.contains(v)) {
            return false;
        }
        this.verticies.remove(v);
        for (n = 0; n < v.getOutgoingEdgeCount(); ++n) {
            e = v.getOutgoingEdge(n);
            v.remove(e);
            Vertex to = e.getTo();
            to.remove(e);
            this.edges.remove(e);
        }
        for (n = 0; n < v.getIncomingEdgeCount(); ++n) {
            e = v.getIncomingEdge(n);
            v.remove(e);
            Vertex predecessor = e.getFrom();
            predecessor.remove(e);
        }
        return true;
    }

    public boolean removeEdge(Vertex from, Vertex to) {
        Edge e = from.findEdge(to);
        if (e == null) {
            return false;
        }
        from.remove(e);
        to.remove(e);
        this.edges.remove(e);
        return true;
    }

    public void clearMark() {
        for (Vertex w : this.verticies) {
            w.clearMark();
        }
    }

    public void clearEdges() {
        for (Edge e : this.edges) {
            e.clearMark();
        }
    }

    public Vertex findVertexByName(String name) {
        Vertex match = null;
        for (Vertex v : this.verticies) {
            if (!name.equals(v.getName())) continue;
            match = v;
            break;
        }
        return match;
    }

    public Pair<Edge[], List<List<Path>>> findCycles() {
        ArrayList<List<Path>> allPaths = new ArrayList<List<Path>>();
        ArrayList<Edge> cycleEdges = new ArrayList<Edge>();
        this.verticies.sort((o1, o2) -> Integer.compare(o2.getOutgoingEdgeCount(), o1.getOutgoingEdgeCount()));
        for (int n = 0; n < this.verticies.size(); ++n) {
            Vertex v = this.getVertex(n);
            this.visit(allPaths, v, cycleEdges);
        }
        Edge[] cycles = new Edge[cycleEdges.size()];
        cycleEdges.toArray(cycles);
        return Pair.of((Object)cycles, allPaths);
    }

    private void visit(List<List<Path>> allPaths, Vertex v, List<Edge> cycleEdges) {
        v.setMarkState(2);
        int count = v.getOutgoingEdgeCount();
        for (int n = 0; n < count; ++n) {
            Edge e = v.getOutgoingEdge(n);
            Vertex u = e.getTo();
            List<Path> pathList = v.getPathList();
            ArrayList<Path> currPath = new ArrayList<Path>();
            if (pathList.size() > 0) {
                currPath.addAll(pathList);
            }
            Path path = new Path();
            path.setAccount(v.getName());
            Set<Long> ids = e.getIds();
            if (ids != null && ids.size() > 0) {
                path.getIds().addAll(ids);
            }
            currPath.add(path);
            u.setPathList(currPath);
            if (u.getMarkState() == 2) {
                cycleEdges.add(e);
                List<Path> tmp = u.getPathList();
                path = new Path();
                String tmpAccount = u.getName();
                path.setAccount(tmpAccount);
                Set<Long> billIdByAccount = u.getBillIdByAccount(tmpAccount);
                if (billIdByAccount != null && billIdByAccount.size() > 0) {
                    path.getIds().addAll(billIdByAccount);
                }
                tmp.add(path);
                u.setPathList(new ArrayList<Path>());
                allPaths.add(tmp);
                continue;
            }
            if (u.getMarkState() != 1) continue;
            this.visit(allPaths, u, cycleEdges);
        }
        v.setMarkState(3);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("Graph{");
        for (Vertex v : this.verticies) {
            tmp.append(v);
        }
        tmp.append('}');
        return tmp.toString();
    }

    public static void main(String[] args) {
    }
}

