/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.bean.BalanceModelBean;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.bean.ModelRequestBean;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.CalFormulaEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class BalanceModelHelper {
    private static final Log logger = LogFactory.getLog(BalanceModelHelper.class);
    private static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newCachedExecutorService((String)"fcs.batchQueryAmount", (int)5, (int)10);

    public static BigDecimal getBankJournalBalance(BalanceModelBean bean, long bankacctId, long currencyId) {
        bean.setDetailEntity("cas_bankjournalformrpt");
        bean.setCalBillName(BalanceTypeEnum.BOOK.getName());
        bean.setLastTimeStr(ResManager.loadKDString((String)"\u6700\u540e\u66f4\u65b0\u65f6\u95f4\uff1a%s", (String)"BalanceModelHelper_2", (String)"tmc-fbp-common", (Object[])new Object[]{DateUtils.formatString(DateUtils.getCurrentTime(), "yyyy-MM-dd HH:mm:ss")}));
        bean.setLastTime(DateUtils.getCurrentTime());
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company,acctstatus", (QFilter[])new QFilter("id", "=", (Object)bankacctId).toArray());
        if (EmptyUtil.isEmpty(account)) {
            logger.info("\u8d26\u53f7\u4e0d\u5b58\u5728\u8fd4\u56denull,\u8d26\u53f7ID\uff1a" + bankacctId);
            return null;
        }
        long orgId = account.getLong("company");
        bean.setAccountId(bankacctId);
        bean.setCompanyId(orgId);
        return CasBusinessHelper.getBalance(orgId, bankacctId, currencyId);
    }

    public static BigDecimal getBalanceTable(BalanceModelBean bean, long bankacctId, long currencyId) {
        bean.setCalBillName(BalanceTypeEnum.BALANCE.getName());
        bean.setDetailEntity("bei_bankbalance");
        QFilter qFilter = new QFilter("accountbank", "=", (Object)bankacctId);
        qFilter.and("currency", "=", (Object)currencyId);
        QFilter amountFilter = new QFilter("valibalance", "is not null", null);
        amountFilter.or("amount", "is not null", null);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bei_bankbalance", (String)"id,modifytime,valibalance,amount", (QFilter[])qFilter.and(amountFilter).toArray(), (String)"bizdate desc", (int)1);
        if (query.size() > 0) {
            BigDecimal valiBalance;
            bean.setDetailIds(query.stream().map(s -> s.getLong("id")).collect(Collectors.toSet()));
            Date modifyTime = ((DynamicObject)query.get(0)).getDate("modifytime");
            if (EmptyUtil.isNoEmpty(modifyTime)) {
                bean.setLastTimeStr(ResManager.loadKDString((String)"\u6700\u540e\u66f4\u65b0\u65f6\u95f4\uff1a%s", (String)"BalanceModelHelper_2", (String)"tmc-fbp-common", (Object[])new Object[]{DateUtils.formatString(modifyTime, "yyyy-MM-dd HH:mm:ss")}));
                bean.setLastTime(modifyTime);
            }
            if ((valiBalance = ((DynamicObject)query.get(0)).getBigDecimal("valibalance")) != null && BigDecimal.ZERO.compareTo(valiBalance) != 0) {
                return valiBalance;
            }
            return ((DynamicObject)query.get(0)).getBigDecimal("amount");
        }
        return null;
    }

    public static BigDecimal getBalanceTableOrBankJournalBalance(BalanceModelBean bean, long bankacctId, long currencyId) {
        DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"company,issetbankinterface,finorgtype", (QFilter[])new QFilter("id", "=", (Object)bankacctId).toArray());
        if (EmptyUtil.isEmpty(account)) {
            logger.info("\u8d26\u53f7\u4e0d\u5b58\u5728\u8fd4\u56denull,\u8d26\u53f7ID\uff1a" + bankacctId);
            return null;
        }
        if (account.getBoolean("issetbankinterface") || FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(account.getString("finorgtype"))) {
            return BalanceModelHelper.getBalanceTable(bean, bankacctId, currencyId);
        }
        return BalanceModelHelper.getBankJournalBalance(bean, bankacctId, currencyId);
    }

    public static BigDecimal getAmount(BalanceModelBean bean, String balanceType, long bankacctId, long currencyId) {
        BigDecimal returnAmount;
        if (BalanceTypeEnum.BOOK.getValue().equals(balanceType)) {
            returnAmount = BalanceModelHelper.getBankJournalBalance(bean, bankacctId, currencyId);
        } else if (BalanceTypeEnum.BALANCE.getValue().equals(balanceType)) {
            returnAmount = BalanceModelHelper.getBalanceTable(bean, bankacctId, currencyId);
        } else if (BalanceTypeEnum.IS_BALANCE_BOOK.getValue().equals(balanceType)) {
            returnAmount = BalanceModelHelper.getBalanceTableOrBankJournalBalance(bean, bankacctId, currencyId);
        } else {
            returnAmount = BalanceModelHelper.getBalanceTable(bean, bankacctId, currencyId);
            if (returnAmount == null) {
                returnAmount = BalanceModelHelper.getBankJournalBalance(bean, bankacctId, currencyId);
            }
        }
        return returnAmount;
    }

    public static BizBalanceModelBean genResponseBean(String balanceType, long accountId, long currencyId) {
        BizBalanceModelBean returnBean = new BizBalanceModelBean();
        BalanceModelBean balanceModelBean = new BalanceModelBean();
        BigDecimal amount = BalanceModelHelper.getAmount(balanceModelBean, balanceType, accountId, currencyId);
        returnBean.setAmount(amount);
        returnBean.setLastTime(balanceModelBean.getLastTime());
        return returnBean;
    }

    public static BigDecimal getCalAmount(BalanceModelBean bean, String modelName, DynamicObject entry, long bankacctId, long currencyId, Long billId) {
        return (BigDecimal)BalanceModelHelper.getCalIdsAndAmount(bean, modelName, entry, bankacctId, currencyId, billId).getRight();
    }

    public static Pair<Set<Long>, BigDecimal> getCalIdsAndAmount(BalanceModelBean bean, String modelName, DynamicObject entry, long bankacctId, long currencyId, Long billId) {
        BigDecimal returnAmount = BigDecimal.ZERO;
        DynamicObject linkApp = entry.getDynamicObject("linkapp");
        boolean custom = entry.getBoolean("custom");
        if (EmptyUtil.isNoEmpty(linkApp)) {
            returnAmount = BalanceModelHelper.genLinkAmount(bean, modelName, entry, bankacctId, currencyId);
        } else if (!custom) {
            returnAmount = BalanceModelHelper.genBizAmount(bean, modelName, entry, bankacctId, currencyId, billId);
        } else {
            Object serviceAmt = BalanceModelHelper.genMicroService(modelName, entry);
            if (EmptyUtil.isNoEmpty(serviceAmt)) {
                returnAmount = new BigDecimal(String.valueOf(serviceAmt));
            }
        }
        return Pair.of(bean.getDetailIds(), (Object)returnAmount);
    }

    private static BigDecimal genLinkAmount(BalanceModelBean bean, String modelName, DynamicObject entry, long bankacctId, long currencyId) {
        Set collectIds;
        BigDecimal returnAmount = BigDecimal.ZERO;
        String linkEntity = entry.getDynamicObject("linkapp").getString("number");
        String linkAccountProp = entry.getString("linkaccountprop");
        QFilter linkFilter = new QFilter(linkAccountProp, "=", (Object)bankacctId);
        String selectField = entry.getString("linkappprop");
        DynamicObjectCollection queryLink = QueryServiceHelper.query((String)linkEntity, (String)selectField, (QFilter[])linkFilter.toArray());
        if (EmptyUtil.isNoEmpty(queryLink) && (collectIds = queryLink.stream().filter(s -> !"0".equals(s.getString(selectField))).map(s -> s.get(selectField)).collect(Collectors.toSet())).size() > 0) {
            String queryEntity = entry.getDynamicObject("calbill").getString("number");
            QFilter qFilter = BalanceModelHelper.getApplyConditionFilter(entry, queryEntity);
            qFilter.and("id", "in", collectIds);
            returnAmount = BalanceModelHelper.queryCommonAmount(bean, modelName, entry, qFilter, currencyId, null);
        }
        return returnAmount;
    }

    private static BigDecimal genBizAmount(BalanceModelBean bean, String modelName, DynamicObject entry, long bankacctId, long currencyId, Long billId) {
        String queryEntity = entry.getDynamicObject("calbill").getString("number");
        QFilter qFilter = BalanceModelHelper.getApplyConditionFilter(entry, queryEntity);
        String accountProp = entry.getString("accountprop");
        if (EmptyUtil.isNoEmpty(accountProp)) {
            qFilter.and(accountProp, "=", (Object)bankacctId);
        }
        return BalanceModelHelper.queryCommonAmount(bean, modelName, entry, qFilter, currencyId, billId);
    }

    public static int getCountModelNum(DynamicObject entry, String modelName, long accountId, long currencyId, Long billId) {
        int returnCount = 0;
        boolean custom = entry.getBoolean("custom");
        if (!custom) {
            String queryEntity = entry.getDynamicObject("calbill").getString("number");
            if ("am_strategy".equals(queryEntity)) {
                String countProp = entry.getString("countprop");
                QFilter filter = new QFilter("id", "=", (Object)accountId);
                String selField = "strategy." + countProp;
                DynamicObject accountBanks = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)selField, (QFilter[])filter.toArray());
                if (EmptyUtil.isNoEmpty(accountBanks)) {
                    returnCount = accountBanks.getInt(selField);
                }
            } else {
                DynamicObjectCollection query;
                String currencyProp;
                QFilter qFilter = BalanceModelHelper.getApplyConditionFilter(entry, queryEntity);
                String accountProp = entry.getString("accountprop");
                if (EmptyUtil.isNoEmpty(accountProp)) {
                    qFilter.and(accountProp, "=", (Object)accountId);
                }
                if (EmptyUtil.isNoEmpty(currencyProp = entry.getString("currencyprop"))) {
                    qFilter.and(currencyProp, "=", (Object)currencyId);
                }
                if (billId != null) {
                    qFilter.and("id", "!=", (Object)billId);
                }
                if (EmptyUtil.isNoEmpty(query = QueryServiceHelper.query((String)queryEntity, (String)"id", (QFilter[])qFilter.toArray()))) {
                    returnCount = query.size();
                }
            }
        } else {
            Object serviceCount = BalanceModelHelper.genMicroService(modelName, entry);
            if (EmptyUtil.isNoEmpty(serviceCount)) {
                returnCount = Integer.parseInt(String.valueOf(serviceCount));
            }
        }
        return returnCount;
    }

    private static BigDecimal queryCommonAmount(BalanceModelBean bean, String modelName, DynamicObject entry, QFilter qFilter, long currencyId, Long billId) {
        BigDecimal returnAmount = BigDecimal.ZERO;
        String queryEntity = entry.getDynamicObject("calbill").getString("number");
        String queryName = entry.getDynamicObject("calbill").getString("name");
        String currencyProp = entry.getString("currencyprop");
        if (EmptyUtil.isNoEmpty(currencyProp)) {
            qFilter.and(currencyProp, "=", (Object)currencyId);
        }
        if (billId != null) {
            qFilter.and("id", "!=", (Object)billId);
        }
        String amountProp = entry.getString("amountprop");
        ArrayList<String> selectField = new ArrayList<String>(10);
        selectField.add("id");
        selectField.add(amountProp);
        DynamicObjectCollection query = QueryServiceHelper.query((String)queryEntity, (String)String.join((CharSequence)",", selectField), (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty(query)) {
            bean.setDetailEntity(queryEntity);
            bean.setDetailIds(query.stream().map(s -> s.getLong("id")).collect(Collectors.toSet()));
            try {
                if (!amountProp.contains(".")) {
                    HashSet seenIds = new HashSet(16);
                    List distinctList = query.stream().filter(o -> seenIds.add(o.getLong("id"))).collect(Collectors.toList());
                    returnAmount = distinctList.stream().map(s -> new BigDecimal(s.get(amountProp).toString())).reduce(BigDecimal.ZERO, BigDecimal::add);
                } else {
                    returnAmount = query.stream().map(s -> new BigDecimal(s.get(amountProp).toString())).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
            }
            catch (Exception e) {
                logger.error("genBizAmount\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u6a21\u578b\u3010%1$s\u3011,\u53c2\u4e0e\u8ba1\u7b97\u5355\u636e\uff08\u6216\u57fa\u7840\u8d44\u6599\uff09\u3010%2$s\u3011,\u91d1\u989d\u5b57\u6bb5\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"BalanceModelHelper_1", (String)"tmc-fbp-common", (Object[])new Object[0]), modelName, queryName));
            }
        }
        return returnAmount;
    }

    private static Object genMicroService(String modelName, DynamicObject entry) {
        Object amtOrCount;
        String mserviceConfig = entry.getString("mserviceconfig_tag");
        Map cfg = (Map)SerializationUtils.fromJsonString((String)mserviceConfig, Map.class);
        String cloudId = ((String)cfg.get("cloud")).toLowerCase();
        String appId = (String)cfg.get("appid");
        String serviceName = (String)cfg.get("servicename");
        String methodName = (String)cfg.get("methodname");
        ArrayList params = (ArrayList)cfg.get("params");
        Object[] vals = params.stream().map(s -> s.get("val")).toArray();
        try {
            amtOrCount = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])vals);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u670d\u52a1\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u3010%1$s\u3011,\u5fae\u670d\u52a1\u3010%2$s\u3011,\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5fae\u670d\u52a1\u914d\u7f6e\u3002", (String)"BalanceModelHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]), modelName, serviceName));
        }
        return amtOrCount;
    }

    private static QFilter getApplyConditionFilter(DynamicObject entry, String queryEntity) {
        String applyCondition = entry.getString("applycondition_tag");
        if (EmptyUtil.isNoEmpty(applyCondition)) {
            CRCondition filter = (CRCondition)SerializationUtils.fromJsonString((String)applyCondition, CRCondition.class);
            FilterCondition filterCondition = filter.getFilterCondition();
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)queryEntity);
            FilterBuilder fb = new FilterBuilder(dataType, filterCondition);
            fb.buildFilter();
            return fb.getQFilter();
        }
        return QFilter.of((String)"1 = 1", (Object[])new Object[0]);
    }

    public static void drawModelFormula(IFormView view, long billid, long accountId, long currencyId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_dynamic_showmodel");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("balanceModelId", (Object)String.valueOf(billid));
        showParameter.setCustomParam("accountId", (Object)String.valueOf(accountId));
        showParameter.setCustomParam("currencyId", (Object)String.valueOf(currencyId));
        view.showForm(showParameter);
    }

    public static List<BalanceModelBean> getBalaceModelBeanList(long billid, long accountId, long currencyId) {
        ArrayList<BalanceModelBean> beanLists = new ArrayList<BalanceModelBean>(10);
        DynamicObject balanceModel = TmcDataServiceHelper.loadSingle((Object)billid, (String)"fcs_balancemodel");
        String modelName = balanceModel.getString("name");
        DynamicObjectCollection entrys = balanceModel.getDynamicObjectCollection("entry");
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty(entrys)) {
            QFilter qFilter = new QFilter("id", "=", (Object)accountId);
            DynamicObject queryAccount = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"bankaccountnumber,bank.name as bank,bank.bank_cate.name as banktype,bank.logo as banklogo", (QFilter[])qFilter.toArray());
            BalanceModelBean bankBean = new BalanceModelBean();
            bankBean.setCalCard(false);
            DynamicObject modelType = balanceModel.getDynamicObject("modeltype");
            if (EmptyUtil.isNoEmpty(modelType)) {
                bankBean.setBalanceType(modelType.getString("name"));
            }
            bankBean.setCurrency(currencyId);
            bankBean.setAccount(queryAccount.getString("bankaccountnumber"));
            bankBean.setBank(queryAccount.getString("bank"));
            bankBean.setBankType(queryAccount.getString("banktype"));
            bankBean.setBankLogo(queryAccount.getString("banklogo"));
            beanLists.add(bankBean);
            boolean partCal = balanceModel.getBoolean("partcal");
            if (partCal) {
                BalanceModelBean bean = new BalanceModelBean();
                bean.setCalFormula(CalFormulaEnum.ADD.getValue());
                bean.setExplain(ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d", (String)"BalanceModelHelper_3", (String)"tmc-fbp-common", (Object[])new Object[0]));
                String balanceType = balanceModel.getString("balancetype");
                BigDecimal amount = BalanceModelHelper.getAmount(bean, balanceType, accountId, currencyId);
                if (amount != null) {
                    bean.setAmount(amount);
                    bean.setCurrency(currencyId);
                    totalAmount = totalAmount.add(amount);
                }
                BalanceModelHelper.setShowDetailInfo(bean, amount);
                beanLists.add(bean);
            }
            for (DynamicObject entry : entrys) {
                BalanceModelBean bean = new BalanceModelBean();
                String calFormula = entry.getString("calformula");
                bean.setCalFormula(calFormula);
                DynamicObject calBill = entry.getDynamicObject("calbill");
                if (EmptyUtil.isNoEmpty(calBill)) {
                    bean.setCalBillName(calBill.getString("name"));
                }
                bean.setExplain(entry.getString("explain"));
                Pair<Set<Long>, BigDecimal> pair = BalanceModelHelper.getCalIdsAndAmount(bean, modelName, entry, accountId, currencyId, null);
                BigDecimal amount = (BigDecimal)pair.getRight();
                bean.setAmount(amount);
                bean.setCurrency(currencyId);
                boolean custom = entry.getBoolean("custom");
                if (custom) {
                    bean.setShowDetail(false);
                } else {
                    BalanceModelHelper.setShowDetailInfo(bean, amount);
                }
                beanLists.add(bean);
                if (CalFormulaEnum.ADD.getValue().equals(calFormula)) {
                    totalAmount = totalAmount.add(amount);
                    continue;
                }
                totalAmount = totalAmount.subtract(amount);
            }
            bankBean.setAmount(totalAmount);
        }
        return beanLists;
    }

    private static void setShowDetailInfo(BalanceModelBean bean, BigDecimal amount) {
        if (amount == null || BigDecimal.ZERO.compareTo(amount) == 0) {
            bean.setShowDetail(false);
        }
    }

    public static ModelRequestBean getAmountBatch(ModelRequestBean requestBean) throws Exception {
        try {
            List<BizBalanceModelBean> bizBeans = requestBean.getBizBeans();
            ModelRequestBean returnBean = new ModelRequestBean();
            ArrayList<BizBalanceModelBean> bizReturnList = new ArrayList<BizBalanceModelBean>(10);
            ArrayList<Future<BizBalanceModelBean>> futureList = new ArrayList<Future<BizBalanceModelBean>>(10);
            for (BizBalanceModelBean bizBalanceModelBean : bizBeans) {
                Future<BizBalanceModelBean> future = EXECUTOR_SERVICE.submit(() -> {
                    BizBalanceModelBean bizBean = BalanceModelHelper.genResponseBean(bean.getBalanceType(), bean.getAccountId(), bean.getCurrencyId());
                    bean.setAmount(bizBean.getAmount());
                    bean.setLastTime(bizBean.getLastTime());
                    return bean;
                });
                futureList.add(future);
            }
            for (Future future : futureList) {
                BizBalanceModelBean bean = (BizBalanceModelBean)future.get();
                bizReturnList.add(bean);
                returnBean.setBizBeans(bizReturnList);
            }
            return returnBean;
        }
        catch (Throwable e) {
            logger.error(e);
            throw new KDBizException(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
        }
    }

    public static DynamicObject queryBalanceModel(String modelType, String bizBill, String accountBankProp, String balanceType) {
        QFilter qFilter = new QFilter("enable", "=", (Object)true);
        qFilter.and("modeltype.number", "=", (Object)modelType);
        qFilter.and("bizbillset.bizbill.number", "=", (Object)bizBill);
        qFilter.and("bizbillset.accountbankprop", "=", (Object)accountBankProp);
        if (EmptyUtil.isNoEmpty(balanceType)) {
            qFilter.and("partcal", "=", (Object)true);
            qFilter.and("balancetype", "=", (Object)balanceType);
        } else {
            qFilter.and("partcal", "=", (Object)false);
        }
        DynamicObject balanceModel = TmcDataServiceHelper.loadSingleFromCache((String)"fcs_balancemodel", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty(balanceModel)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u4f59\u989d\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u4f59\u989d\u6a21\u578b\u914d\u7f6e\u3002", (String)"BalanceModelHelper_4", (String)"tmc-fbp-common", (Object[])new Object[0]));
        }
        return balanceModel;
    }
}

