/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CashTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.FloatRateHelper;
import kd.tmc.fbp.common.helper.InvestCommonHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.model.cash.CashFundsRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CashFundsCommonHelper {
    private static final Log logger = LogFactory.getLog(CashFundsCommonHelper.class);
    private static final String FUND_TYPE_NAME = "fundtypename";
    private static final String FUND_TYPE = "fundtype";
    private static final int PREVIOUS_MONTHS = 11;
    private static final String CURRENCY = "currency";
    private static final String STRING_FORMAT = "'%s'";
    private static final List<String> INVEST_TYPE_LIST = Arrays.asList(InvestTypeEnum.notice.getValue(), InvestTypeEnum.fixed.getValue(), InvestTypeEnum.structure.getValue(), InvestTypeEnum.huge.getValue());
    private static final String[] FUND_TYPE_ARRAY = new String[]{"fundtypename", "fundtype"};

    public static DataSet getFundDatas(CashFundsRequest cashFundsRequest) {
        long start = System.currentTimeMillis();
        String algoKey = cashFundsRequest.getAlgoKey();
        List<Long> orgIds = cashFundsRequest.getOrgIds();
        Date queryDate = cashFundsRequest.getQueryDate();
        Boolean includeLastYear = cashFundsRequest.getIncludeLastYear();
        HashSet<Long> currencys = new HashSet<Long>(16);
        DataSet accountDs = CashFundsCommonHelper.getAvailableFundsOld(algoKey, orgIds, queryDate, includeLastYear, currencys);
        accountDs = accountDs.addFields(new String[]{String.format(STRING_FORMAT, CashTypeEnum.ACCOUNT.getText()), "" + CashTypeEnum.ACCOUNT.getNumber(), "0.0"}, new String[]{FUND_TYPE_NAME, FUND_TYPE, "frate"});
        long accountTime = System.currentTimeMillis();
        logger.info("CashFundsDataHelper\u8d26\u6237\u53d6\u6570\u8017\u65f6" + algoKey + "cost : " + (accountTime - start));
        DataSet depositDs = CashFundsCommonHelper.getDeposit(algoKey + "deposit", orgIds, queryDate, INVEST_TYPE_LIST, includeLastYear);
        String fundTypeName = String.format("case when fundtypevalue='notice' then '%1$s' when fundtypevalue='fixed' then '%2$s' when fundtypevalue='structure' then '%3$s' when fundtypevalue='huge' then '%4$s' else '' end", CashTypeEnum.NOTICE.getText(), CashTypeEnum.FIX.getText(), CashTypeEnum.STRUCT.getText(), CashTypeEnum.HUGE.getText());
        String fundType = String.format("case when fundtypevalue='notice' then %1$s when fundtypevalue='fixed' then %2$s when fundtypevalue='structure' then %3$s when fundtypevalue='huge' then %4$s else 99 end", CashTypeEnum.NOTICE.getNumber(), CashTypeEnum.FIX.getNumber(), CashTypeEnum.STRUCT.getNumber(), CashTypeEnum.HUGE.getNumber());
        depositDs = depositDs.addFields(new String[]{fundTypeName, fundType}, FUND_TYPE_ARRAY);
        DataSet financeDs = CashFundsCommonHelper.getFinsubScribe(algoKey, orgIds, queryDate, null, includeLastYear);
        if (financeDs != null) {
            financeDs = financeDs.addFields(new String[]{String.format(STRING_FORMAT, CashTypeEnum.FINANCE.getText()), "" + CashTypeEnum.FINANCE.getNumber()}, FUND_TYPE_ARRAY);
        }
        String[] fieldNames = accountDs.getRowMeta().getFieldNames();
        DataSet allDs = financeDs != null ? accountDs.union(new DataSet[]{depositDs.select(fieldNames), financeDs.select(fieldNames)}) : accountDs.union(depositDs.select(fieldNames));
        allDs = allDs.updateFields(new String[]{"realrestrictedamt", "realvalibalance", "frate"}, new String[]{"case when realrestrictedamt is null or realrestrictedamt < 0 then 0 else realrestrictedamt end", "case when realvalibalance is null or realvalibalance < 0 then 0 else realvalibalance end", "case when frate is null or frate < 0 then 0 else frate end"});
        allDs = allDs.addFields(new String[]{"amount", "realvalibalance", "realrestrictedamt"}, new String[]{"amountoriginal", "realvalibalanceoriginal", "realrestrictedamtoriginal"});
        logger.info("CashFundsDataHelper.getFundDatas\u53d6\u6570\u603b\u8017\u65f6" + algoKey + "cost : " + (System.currentTimeMillis() - start));
        allDs = CashFundsCommonHelper.tranDataSetRate(allDs, CashFundsCommonHelper.getTransFields(), queryDate, cashFundsRequest.getOrgViewId(), cashFundsRequest.getBaseCurrency());
        return allDs;
    }

    public static DataSet getTrendFundDatas(CashFundsRequest cashFundsRequest) {
        long start = System.currentTimeMillis();
        String algoKey = cashFundsRequest.getAlgoKey();
        List<Long> orgIds = cashFundsRequest.getOrgIds();
        Date queryDate = cashFundsRequest.getQueryDate();
        Boolean includeLastYear = cashFundsRequest.getIncludeLastYear();
        DataSet accountDs = CashFundsCommonHelper.getAvailableFunds(algoKey, orgIds, queryDate, includeLastYear);
        accountDs = accountDs.addFields(new String[]{String.format(STRING_FORMAT, CashTypeEnum.ACCOUNT.getText()), "" + CashTypeEnum.ACCOUNT.getNumber(), "0.0"}, new String[]{FUND_TYPE_NAME, FUND_TYPE, "frate"});
        long accountTime = System.currentTimeMillis();
        logger.info("CashFundsDataHelper\u8d26\u6237\u53d6\u6570\u8017\u65f6" + algoKey + "cost : " + (accountTime - start));
        DataSet depositDs = CashFundsCommonHelper.getDeposit(algoKey + "deposit", orgIds, queryDate, INVEST_TYPE_LIST, includeLastYear);
        String fundTypeName = String.format("case when fundtypevalue='notice' then '%1$s' when fundtypevalue='fixed' then '%2$s' when fundtypevalue='structure' then '%3$s' when fundtypevalue='huge' then '%4$s' else '' end", CashTypeEnum.NOTICE.getText(), CashTypeEnum.FIX.getText(), CashTypeEnum.STRUCT.getText(), CashTypeEnum.HUGE.getText());
        String fundType = String.format("case when fundtypevalue='notice' then %1$s when fundtypevalue='fixed' then %2$s when fundtypevalue='structure' then %3$s when fundtypevalue='huge' then %4$s else 99 end", CashTypeEnum.NOTICE.getNumber(), CashTypeEnum.FIX.getNumber(), CashTypeEnum.STRUCT.getNumber(), CashTypeEnum.HUGE.getNumber());
        depositDs = depositDs.addFields(new String[]{fundTypeName, fundType}, FUND_TYPE_ARRAY);
        DataSet financeDs = CashFundsCommonHelper.getFinsubScribe(algoKey, orgIds, queryDate, null, includeLastYear);
        if (financeDs != null) {
            financeDs = financeDs.addFields(new String[]{String.format(STRING_FORMAT, CashTypeEnum.FINANCE.getText()), "" + CashTypeEnum.FINANCE.getNumber()}, FUND_TYPE_ARRAY);
        }
        String[] fieldNames = accountDs.getRowMeta().getFieldNames();
        DataSet allDs = financeDs != null ? accountDs.union(new DataSet[]{depositDs.select(fieldNames), financeDs.select(fieldNames)}) : accountDs.union(depositDs.select(fieldNames));
        allDs = allDs.updateFields(new String[]{"realrestrictedamt", "realvalibalance", "frate"}, new String[]{"case when realrestrictedamt is null or realrestrictedamt < 0 then 0 else realrestrictedamt end", "case when realvalibalance is null or realvalibalance < 0 then 0 else realvalibalance end", "case when frate is null or frate < 0 then 0 else frate end"});
        allDs = allDs.addFields(new String[]{"amount", "realvalibalance", "realrestrictedamt"}, new String[]{"amountoriginal", "realvalibalanceoriginal", "realrestrictedamtoriginal"});
        logger.info("CashFundsDataHelper.getFundDatas\u53d6\u6570\u603b\u8017\u65f6" + algoKey + "cost : " + (System.currentTimeMillis() - start));
        allDs = CashFundsCommonHelper.tranDataSetRate(allDs, CashFundsCommonHelper.getTransFields(), queryDate, cashFundsRequest.getOrgViewId(), cashFundsRequest.getBaseCurrency());
        return allDs;
    }

    private static DataSet getAvailableFundsOld(String algoKey, List<Long> orgIds, Date queryDate, boolean includeLastYear, Set<Long> currencys) {
        List<Long> accountIds = CashFundsCommonHelper.getAccountIds(orgIds, queryDate);
        DataSet orinalDs = CashFundsCommonHelper.getOrinalBalanceOld(algoKey, queryDate, includeLastYear, accountIds);
        DataSet usageLimitDs = CashFundsCommonHelper.getLimitedFundsOld(orinalDs, algoKey, queryDate, accountIds);
        if (includeLastYear) {
            usageLimitDs = usageLimitDs.orderBy(new String[]{"bizdate DESC"});
            usageLimitDs = CashFundsCommonHelper.dealOneYearDataSetOld(usageLimitDs, queryDate, algoKey);
        }
        return usageLimitDs;
    }

    private static void splitAccountIds(Set<Long> accountIds, Date queryDate, Set<Long> twoDateIds, Set<Long> currencys, Set<Long> notTwoDateAccount) {
        logger.info("allaccount count:" + accountIds.size());
        QFilter filter = new QFilter("accountbank", "in", accountIds);
        filter.and("bizdate", "<=", (Object)DateUtils.getDataFormat(queryDate, false));
        filter.and("bizdate", ">=", (Object)DateUtils.getDataFormat(DateUtils.getLastDay(queryDate, 1), true));
        DataSet twoDayDataSet = QueryServiceHelper.queryDataSet((String)"splitAccountIds", (String)"bei_bankbalance", (String)"id,accountbank,bizdate,currency", (QFilter[])filter.toArray(), (String)"bizdate desc");
        HashSet<Long> extisAccounts = new HashSet<Long>(16);
        HashSet<String> extisAccountsKeys = new HashSet<String>(16);
        for (Row row : twoDayDataSet) {
            String twoDateIdsKey = String.valueOf(row.getLong("accountbank")) + row.getLong(CURRENCY);
            if (extisAccountsKeys.add(twoDateIdsKey)) {
                twoDateIds.add(row.getLong("id"));
                extisAccounts.add(row.getLong("accountbank"));
            }
            currencys.add(row.getLong(CURRENCY));
        }
        accountIds.removeAll(extisAccounts);
        notTwoDateAccount.addAll(accountIds);
        logger.info("extis towdate account count:" + extisAccounts.size());
        logger.info("extis towdate balanceid count:" + twoDateIds.size());
        logger.info("not extis towdate account count:" + notTwoDateAccount.size());
        logger.info("currencys count:" + currencys.size() + JSON.toJSONString(currencys));
    }

    private static DataSet dealOneYearDataSetOld(DataSet usageLimitDs, Date queryDate, String algoKey) {
        long start = System.currentTimeMillis();
        Date[] rangeDates = CashFundsCommonHelper.rangeDate(queryDate, 11);
        DataSetBuilder[] dataSetBuilders = CashFundsCommonHelper.buildDataSetBuilders(rangeDates.length, usageLimitDs.getRowMeta(), Algo.create((String)algoKey));
        Iterator it = usageLimitDs.iterator();
        HashMap<String, List<Date>> afterDealedIdMap = new HashMap<String, List<Date>>(1024);
        while (it.hasNext()) {
            Row row = (Row)it.next();
            String accountbankId = row.getString("accountbank");
            String currency = row.getString(CURRENCY);
            String key = accountbankId + currency;
            Date bizDate = row.getDate("bizDate");
            List<Date> afterDealedIds = new ArrayList(10);
            if (afterDealedIdMap.containsKey(key)) {
                afterDealedIds = (List)afterDealedIdMap.get(key);
            }
            int count = 0;
            for (Date lastDate : rangeDates) {
                Date endData = DateUtils.getDataFormat(lastDate, false);
                Date startData = DateUtils.getDataFormat(CashFundsCommonHelper.getLastAnyMonth(lastDate, -1), true);
                if (!afterDealedIds.contains(lastDate) && bizDate.compareTo(startData) >= 0 && bizDate.compareTo(endData) <= 0) {
                    dataSetBuilders[count].append(row);
                    afterDealedIds.add(lastDate);
                }
                ++count;
            }
            afterDealedIdMap.put(key, afterDealedIds);
        }
        for (int i = 0; i < dataSetBuilders.length; ++i) {
            DataSetBuilder dataSetBuilder = dataSetBuilders[i];
            usageLimitDs = i == 0 ? dataSetBuilder.build().updateField("bizdate", "to_date('" + DateUtils.formatString(rangeDates[i], "yyyy-MM-dd") + "', 'yy-MM-dd')") : usageLimitDs.union(dataSetBuilder.build().updateField("bizdate", "to_date('" + DateUtils.formatString(rangeDates[i], "yyyy-MM-dd") + "', 'yy-MM-dd')"));
        }
        long end = System.currentTimeMillis();
        logger.info("CashFundsDataHelper__dealOneYearDataSet" + algoKey + "cost : " + (end - start));
        return usageLimitDs;
    }

    public static Date getLastAnyMonth(Date date, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, i);
        return cal.getTime();
    }

    private static DataSet getLimitedFundsOld(DataSet orinalDs, String algoKey, Date queryDate, List<Long> accountIds) {
        long start = System.currentTimeMillis();
        Pair<DataSet, DataSet> splitUsageLimitDs = CashFundsCommonHelper.getLimitUsageAmountOld(orinalDs);
        DataSet usageLimitDs = ((DataSet)splitUsageLimitDs.getValue0()).addFields(new String[]{"amount", CashFundsCommonHelper.getUsageLimite()}, new String[]{"realrestrictedamt", "limitusage"});
        DataSet notusageLimitDs = (DataSet)splitUsageLimitDs.getValue1();
        DataSet fundsLimitDs = CashFundsCommonHelper.getLimitFundsAmountOld(algoKey, notusageLimitDs, queryDate, accountIds);
        List fieldNames = Arrays.stream(fundsLimitDs.getRowMeta().getFieldNames()).collect(Collectors.toList());
        fieldNames.remove("realrestrictedamt");
        fundsLimitDs = fundsLimitDs.select(String.join((CharSequence)",", fieldNames) + ", case when realrestrictedamt < 0 then 0 else realrestrictedamt end realrestrictedamt").addField(CashFundsCommonHelper.getNotUsageLimite(), "limitusage");
        fundsLimitDs = fundsLimitDs.updateField("realrestrictedamt", "case when realrestrictedamt > amount then amount else realrestrictedamt end");
        long end = System.currentTimeMillis();
        logger.info("CashFundsDataHelper__getLimitedFunds" + algoKey + "cost : " + (end - start));
        return usageLimitDs.union(fundsLimitDs).select(String.join((CharSequence)",", fundsLimitDs.getRowMeta().getFieldNames()) + ", case when amount - realrestrictedamt < 0 then 0 else amount - realrestrictedamt end realvalibalance");
    }

    private static DataSet getLimitFundsAmountOld(String algoKey, DataSet notusageLimitDs, Date queryDate, List<Long> ids) {
        CharSequence[] filedNames = notusageLimitDs.getRowMeta().getFieldNames();
        QFilter filter = new QFilter("bankacct", "in", ids);
        Date endData = DateUtils.getDataFormat(queryDate, false);
        filter.and("restricteddate", "<=", (Object)endData);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("businesstype", "=", (Object)"1");
        DataSet manager = QueryServiceHelper.queryDataSet((String)(algoKey + "getLimitFundsAmount"), (String)"am_restrictedfundsmanager", (String)"bankacct,currency,billno,restrictedamt", (QFilter[])new QFilter[]{filter}, null);
        QFilter liftFilter = new QFilter("bankacct", "in", ids);
        liftFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        liftFilter.and("businesstype", "=", (Object)"2");
        liftFilter.and("liftdate", "<=", (Object)endData);
        DataSet managerEntry = QueryServiceHelper.queryDataSet((String)(algoKey + "getLimitFundsAmount"), (String)"am_restrictedfundsmanager", (String)"srcbillno,thistimeunblockamt", (QFilter[])new QFilter[]{liftFilter}, null).groupBy(new String[]{"srcbillno"}).sum("thistimeunblockamt").finish();
        manager = manager.leftJoin(managerEntry).on("billno", "srcbillno").select(new String[]{"bankacct", CURRENCY, "restrictedamt"}, new String[]{"thistimeunblockamt"}).finish().select("bankacct,currency,restrictedamt,case when thistimeunblockamt is null then 0 else thistimeunblockamt end thistimeunblockamt").groupBy(new String[]{"bankacct", CURRENCY}).sum("restrictedamt").sum("thistimeunblockamt").finish();
        notusageLimitDs = notusageLimitDs.leftJoin(manager).on("accountbank", "bankacct").on(CURRENCY, CURRENCY).select((String[])filedNames, new String[]{"restrictedamt", "thistimeunblockamt"}).finish();
        notusageLimitDs = notusageLimitDs.select(String.join((CharSequence)",", filedNames) + ", case when restrictedamt is null then amount - valibalance else restrictedamt - thistimeunblockamt end realrestrictedamt");
        return notusageLimitDs;
    }

    private static Pair<DataSet, DataSet> getLimitUsageAmountOld(DataSet orinalBalance) {
        Pair pair;
        List<Long> usageId = CashFundsCommonHelper.getLimitUsageIds();
        if (EmptyUtil.isNoEmpty(usageId)) {
            String filterString = "acctproperty in (" + TmcBusinessBaseHelper.idListToString(usageId) + ")";
            DataSet[] splitResult = orinalBalance.splitByFilter(new String[]{filterString}, true);
            pair = new Pair((Object)splitResult[0], (Object)splitResult[1]);
        } else {
            pair = new Pair((Object)DataSetHelper.createEmptyDataSet(orinalBalance.getRowMeta()), (Object)orinalBalance);
        }
        return pair;
    }

    private static DataSet getOrinalBalanceOld(String algoKey, Date queryDate, boolean includeLastYear, List<Long> accountIds) {
        long start = System.currentTimeMillis();
        String sic = "id,company, company.name companyname,bizdate,currency,currency.number currencynumber,accountbank.id accountbank, accountbank.name accountbankname, accountbank.acctproperty.id acctproperty,accountbank.bank.finorgtype.type finorgtype,accountbank.bank.id bank, accountbank.bank.name bankname,accountbank.bank.bank_cate.id bankcateid, accountbank.bank.bank_cate.name bankcatename, accountbank.bank.bank_cate.bankproperty bankcateproperty,accountbank.bank.country.id country, accountbank.bank.country.name countryname,case when amount < 0 OR amount is null then 0 else amount end amount,case when amount >= 0 AND valibalance > 0 AND amount < valibalance then amount else case when valibalance < 0 OR valibalance is null then 0 else valibalance end end valibalance,lstbalance,datasource,case when accountbank.bank.country.twocountrycode = 'CN' then '1' else case when accountbank.bank.country.threecountrycode = 'CHN' then '1' else case when accountbank.bank.country = 0 or (TRIM(accountbank.bank.country.twocountrycode) = '' and TRIM(accountbank.bank.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,'0' as isoffset, accountbank.bank.org businessunit,'account' fundtypevalue";
        String detailsic = ",'' as productname,'' as detailbillno,accountbank.bankaccountnumber bankaccountnumber,accountbank.acctproperty.name acctpropertyname,currency.name currencyname, 0 as depositamountoriginal,0 as depositamountrpt,modifytime as bizupdatedate,null as startdate,null as enddate,null as deadline,null as interestrate";
        StringBuilder sicSb = new StringBuilder(sic).append(detailsic);
        QFilter filter = new QFilter("accountbank.id", "in", accountIds);
        QFilter dateFilter = CashFundsCommonHelper.getDateFilterOld(queryDate, includeLastYear);
        filter.and(dateFilter);
        DataSet ds = QueryServiceHelper.queryDataSet((String)(algoKey + "orinalBalance"), (String)"bei_bankbalance", (String)sicSb.toString(), (QFilter[])new QFilter[]{filter}, (String)"");
        long end = System.currentTimeMillis();
        logger.info("CashFundsDataHelper__getOrinalBalance" + algoKey + "cost : " + (end - start));
        return ds;
    }

    private static DataSet getLastBalance(DataSet dataSet) {
        String[] fieldName = dataSet.getRowMeta().getFieldNames();
        DataSet lastBalance = dataSet.select("accountbank,currency,bizdate").groupBy(new String[]{"accountbank", CURRENCY}).max("bizdate").finish();
        dataSet = dataSet.join(lastBalance).on("accountbank", "accountbank").on(CURRENCY, CURRENCY).on("bizdate", "bizdate").select(fieldName).finish();
        return dataSet;
    }

    private static QFilter getDateFilterOld(Date queryDate, boolean includeLastYear) {
        Date nextDate = DateUtils.getDataFormat(DateUtils.getNextDay(queryDate, 1), true);
        QFilter dateFilter = new QFilter("bizdate", "<", (Object)nextDate);
        dateFilter.and("enddate", ">=", (Object)nextDate);
        return dateFilter;
    }

    public static List<Long> getAccountIds(List<Long> orgIds, Date queryDate) {
        QFilter accountFilter = new QFilter("openorg", "in", orgIds);
        accountFilter.and("opendate", "<", (Object)DateUtils.getNextDay(DateUtils.getDataFormat(queryDate, true), 1));
        QFilter closeDateFilter = new QFilter("closedate", "is null", null).or("closedate", ">=", (Object)DateUtils.getNextDay(DateUtils.getDataFormat(queryDate, true), 1));
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{accountFilter, closeDateFilter}, null);
        ArrayList<Long> accountIds = new ArrayList<Long>(10);
        while (bankAcctSet.hasNext()) {
            accountIds.add(bankAcctSet.next().getLong("id"));
        }
        return accountIds;
    }

    private static DataSet getAvailableFunds(String algoKey, List<Long> orgIds, Date queryDate, boolean includeLastYear) {
        DataSet orinalDs = CashFundsCommonHelper.getOrinalBalance(algoKey, queryDate, includeLastYear, orgIds);
        DataSet usageLimitDs = CashFundsCommonHelper.getLimitedFunds(orinalDs, algoKey, queryDate, orgIds);
        return usageLimitDs;
    }

    private static DataSet tranDataSetRate(DataSet ds, Set<String> transFields, Date queryDate, Long orgViewId, Long baseCurrency) {
        return AmountTransHelper.tranDataSetRate(ds, orgViewId, baseCurrency, CURRENCY, transFields, queryDate);
    }

    private static DataSet createCurrencyDs(List<Object[]> currencyRow) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{CURRENCY}, (DataType[])new DataType[]{DataType.LongType});
        CollectionInput inputs = new CollectionInput(rowMeta, currencyRow);
        return Algo.create((String)"financecostcommonhelper.new").createDataSet(new Input[]{inputs});
    }

    private static Set<String> getTransFields() {
        HashSet<String> transFields = new HashSet<String>(8);
        transFields.add("amount");
        transFields.add("realvalibalance");
        transFields.add("realrestrictedamt");
        transFields.add("valibalance");
        transFields.add("lstbalance");
        transFields.add("depositamountrpt");
        return transFields;
    }

    private static DataSet getLimitedFunds(DataSet orinalDs, String algoKey, Date queryDate, List<Long> orgIds) {
        long start = System.currentTimeMillis();
        Pair<DataSet, DataSet> splitUsageLimitDs = CashFundsCommonHelper.getLimitUsageAmount(orinalDs);
        DataSet usageLimitDs = ((DataSet)splitUsageLimitDs.getValue0()).addFields(new String[]{"amount", CashFundsCommonHelper.getUsageLimite()}, new String[]{"realrestrictedamt", "limitusage"});
        DataSet notusageLimitDs = (DataSet)splitUsageLimitDs.getValue1();
        DataSet fundsLimitDs = CashFundsCommonHelper.getLimitFundsAmount(algoKey, notusageLimitDs, queryDate, orgIds);
        List fieldNames = Arrays.stream(fundsLimitDs.getRowMeta().getFieldNames()).collect(Collectors.toList());
        fieldNames.remove("realrestrictedamt");
        fundsLimitDs = fundsLimitDs.select(String.join((CharSequence)",", fieldNames) + ", case when realrestrictedamt < 0 then 0 else realrestrictedamt end realrestrictedamt").addField(CashFundsCommonHelper.getNotUsageLimite(), "limitusage");
        fundsLimitDs = fundsLimitDs.updateField("realrestrictedamt", "case when amount < realrestrictedamt then amount else realrestrictedamt end");
        long end = System.currentTimeMillis();
        logger.info("CashFundsDataHelper__getLimitedFunds" + algoKey + "cost : " + (end - start));
        return usageLimitDs.union(fundsLimitDs).select(String.join((CharSequence)",", fundsLimitDs.getRowMeta().getFieldNames()) + ", case when amount - realrestrictedamt < 0 then 0 else amount - realrestrictedamt end realvalibalance");
    }

    private static Pair<DataSet, DataSet> getLimitUsageAmount(DataSet orinalBalance) {
        Pair pair;
        List<Long> usageId = CashFundsCommonHelper.getLimitUsageIds();
        if (EmptyUtil.isNoEmpty(usageId)) {
            String filterString = "acctproperty in (" + TmcBusinessBaseHelper.idListToString(usageId) + ")";
            DataSet[] splitResult = orinalBalance.splitByFilter(new String[]{filterString}, true);
            pair = new Pair((Object)splitResult[0], (Object)splitResult[1]);
        } else {
            pair = new Pair((Object)DataSetHelper.createEmptyDataSet(orinalBalance.getRowMeta()), (Object)orinalBalance);
        }
        return pair;
    }

    private static DataSet getLimitUsageAmount(DataSet ds, String acctPropertyField) {
        List<Long> usageId = CashFundsCommonHelper.getLimitUsageIds();
        if (EmptyUtil.isNoEmpty(usageId)) {
            String filterString = acctPropertyField + " in (" + TmcBusinessBaseHelper.idListToString(usageId) + ")";
            DataSet[] splitResult = ds.splitByFilter(new String[]{filterString}, true);
            DataSet limitDs = splitResult[0].updateFields(new String[]{"realrestrictedamt", "limitusage"}, new String[]{"realvalibalance", CashFundsCommonHelper.getUsageLimite()});
            limitDs = limitDs.updateField("realvalibalance", "0.0");
            ds = limitDs.union(splitResult[1].updateField("limitusage", CashFundsCommonHelper.getNotUsageLimite()));
        }
        return ds;
    }

    private static List<Long> getLimitUsageIds() {
        String sic = "usage,bizdate";
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"am_restrictedfundusage", (String)sic, (QFilter[])filter.toArray());
        List<Long> usageId = colls.stream().map(v -> v.getLong("usage")).collect(Collectors.toList());
        return usageId;
    }

    private static DataSet getLimitFundsAmount(String algoKey, DataSet notusageLimitDs, Date queryDate, List<Long> orgIds) {
        CharSequence[] filedNames = notusageLimitDs.getRowMeta().getFieldNames();
        QFilter filter = new QFilter("org", "in", orgIds);
        Date endData = DateUtils.getDataFormat(queryDate, false);
        filter.and("restricteddate", "<=", (Object)endData);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("businesstype", "=", (Object)"1");
        DataSet manager = QueryServiceHelper.queryDataSet((String)(algoKey + "getLimitFundsAmount"), (String)"am_restrictedfundsmanager", (String)"bankacct,currency,billno,restrictedamt", (QFilter[])new QFilter[]{filter}, null);
        QFilter liftFilter = new QFilter("org", "in", orgIds);
        liftFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        liftFilter.and("businesstype", "=", (Object)"2");
        liftFilter.and("liftdate", "<=", (Object)endData);
        DataSet managerEntry = QueryServiceHelper.queryDataSet((String)(algoKey + "getLimitFundsAmount"), (String)"am_restrictedfundsmanager", (String)"srcbillno,thistimeunblockamt", (QFilter[])new QFilter[]{liftFilter}, null).groupBy(new String[]{"srcbillno"}).sum("thistimeunblockamt").finish();
        manager = manager.leftJoin(managerEntry).on("billno", "srcbillno").select(new String[]{"bankacct", CURRENCY, "restrictedamt"}, new String[]{"thistimeunblockamt"}).finish().select("bankacct,currency,restrictedamt,case when thistimeunblockamt is null then 0 else thistimeunblockamt end thistimeunblockamt").groupBy(new String[]{"bankacct", CURRENCY}).sum("restrictedamt").sum("thistimeunblockamt").finish();
        notusageLimitDs = notusageLimitDs.leftJoin(manager).on("accountbank", "bankacct").on(CURRENCY, CURRENCY).select((String[])filedNames, new String[]{"restrictedamt", "thistimeunblockamt"}).finish();
        notusageLimitDs = notusageLimitDs.select(String.join((CharSequence)",", filedNames) + ", case when restrictedamt is null then amount - valibalance else restrictedamt - thistimeunblockamt end realrestrictedamt");
        return notusageLimitDs;
    }

    private static DataSet getOrinalBalance(String algoKey, Date queryDate, boolean includeLastYear, List<Long> orgIds) {
        long start = System.currentTimeMillis();
        String sic = "id,company, company.name companyname,bizdate,currency,currency.number currencynumber,accountbank.id accountbank, accountbank.name accountbankname, accountbank.acctproperty.id acctproperty,accountbank.bank.finorgtype.type finorgtype,accountbank.bank.id bank, accountbank.bank.name bankname, accountbank.bank.bank_cate.id bankcateid, accountbank.bank.bank_cate.name bankcatename,accountbank.bank.country.id country, accountbank.bank.country.name countryname,case when amount < 0 OR amount is null then 0 else amount end amount, case when valibalance < 0 OR valibalance is null then 0 else valibalance end valibalance,lstbalance,datasource,case when accountbank.bank.country.twocountrycode = 'CN' then '1' else case when accountbank.bank.country.threecountrycode = 'CHN' then '1' else case when accountbank.bank.country = 0 or (TRIM(accountbank.bank.country.twocountrycode) = '' and TRIM(accountbank.bank.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,'0' as isoffset, accountbank.bank.org businessunit,'account' fundtypevalue";
        String detailsic = ",'' as productname,'' as detailbillno,accountbank.bankaccountnumber bankaccountnumber,accountbank.acctproperty.name acctpropertyname,currency.name currencyname, 0 as depositamountoriginal,0 as depositamountrpt,modifytime as bizupdatedate,null as startdate,null as enddate,null as deadline,null as interestrate";
        StringBuilder sicSb = new StringBuilder(sic).append(detailsic);
        QFilter orgFilter = new QFilter("company", "in", orgIds);
        QFilter dateFilter = CashFundsCommonHelper.getDateFilter(queryDate, includeLastYear);
        DataSet ds = QueryServiceHelper.queryDataSet((String)(algoKey + "orinalBalance"), (String)"bei_bankbalance", (String)sicSb.toString(), (QFilter[])new QFilter[]{dateFilter, orgFilter}, null);
        ds = ds.updateField("valibalance", "case when amount < valibalance then amount else valibalance end");
        long end = System.currentTimeMillis();
        logger.info("CashFundsDataHelper__getOrinalBalance" + algoKey + "cost : " + (end - start));
        return ds;
    }

    private static QFilter getDateFilter(Date queryDate, boolean includeLastYear) {
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat(queryDate, true));
        dateFilter.and("bizdate", "<=", (Object)DateUtils.getDataFormat(queryDate, false));
        if (includeLastYear) {
            for (int i = 0; i < 11; ++i) {
                Date lastMonthDate = DateUtils.getLastDateOfAnyMonth(queryDate, -(i + 1));
                QFilter tempFilter = new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat(lastMonthDate, true));
                tempFilter.and("bizdate", "<=", (Object)DateUtils.getDataFormat(lastMonthDate, false));
                dateFilter = dateFilter.or(tempFilter);
            }
        }
        return dateFilter;
    }

    public static DataSet getDeposit(String algoKey, List<Long> orgIds, Date queryDate, List<String> investTypeList, boolean includeLastYear) {
        QFilter filter = new QFilter("investvarieties.investtype", "in", investTypeList).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("bizstatus", "!=", (Object)"subscribe_ing");
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isredepositgenerate='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and("org", "in", orgIds);
        queryDate = DateUtils.getDataFormat(queryDate, true);
        Date[] rangeDates = includeLastYear ? CashFundsCommonHelper.rangeDate(queryDate, 11) : null;
        filter.and(CashFundsCommonHelper.getDepositDateFilter(queryDate, rangeDates));
        String sic = "id,interesttype,referencerate,ratesign,ratefloatpoint,interestrate frate, org company,org.name companyname, intdate, cleardate, currency,currency.number currencynumber, amount, 0 lstbalance, ' ' datasource,settleaccount.id accountbank, settleaccount.name accountbankname, settleaccount.acctproperty.id acctproperty, finaccountf7.acctproperty.id finacctproperty,finorginfo.finorgtype.type finorgtype,finorginfo bank, finorginfo.name bankname,finorginfo.bank_cate.id bankcateid, finorginfo.bank_cate.name bankcatename, finorginfo.bank_cate.bankproperty bankcateproperty,finorginfo.country.id country, finorginfo.country.name countryname,case when finorginfo.country.twocountrycode = 'CN' then '1' else case when finorginfo.country.threecountrycode = 'CHN' then '1' else case when finorginfo.country = 0 or (TRIM(finorginfo.country.twocountrycode) = '' and TRIM(finorginfo.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,'0' as isoffset, finorginfo.org businessunit,investvarieties.investtype fundtypevalue";
        sic = sic + ",billno detailbillno,investvarieties.name productname,finaccount bankaccountnumber,finaccountf7.acctproperty.name as acctpropertyname,'' as limitusage,currency.name currencyname,amount as depositamountoriginal,amount as depositamountrpt, null as bizupdatedate,intdate as startdate,expiredate as enddate,term as deadline,interestrate";
        DataSet depositDs = QueryServiceHelper.queryDataSet((String)(algoKey + "Deposit"), (String)"cim_deposit", (String)sic, (QFilter[])filter.toArray(), null);
        DataSet releaseDs = CashFundsCommonHelper.queryDepositRelease(algoKey, queryDate, orgIds);
        DataSet allDs = CashFundsCommonHelper.handleDepositDateSet(depositDs, releaseDs, queryDate, rangeDates);
        allDs = allDs.updateField("ramount", "case when ramount is null then 0 else ramount end");
        allDs = allDs.addField("amount - ramount", "valibalance");
        allDs = allDs.addField("0", "realrestrictedamt").addField("valibalance", "realvalibalance");
        allDs = allDs.updateField("amount", "realvalibalance + realrestrictedamt").removeFields(new String[]{"ramount"});
        allDs = FloatRateHelper.updateFloatRate(allDs, queryDate);
        allDs = CashFundsCommonHelper.getLimitUsageAmount(allDs, "finacctproperty");
        return allDs;
    }

    private static DataSet handleDepositDateSet(DataSet depositDs, DataSet releaseDs, Date queryDate, Date[] rangeDates) {
        if (rangeDates == null) {
            DataSet depositFilterDs = depositDs;
            DataSet releaseFilterDs = releaseDs;
            releaseFilterDs = releaseFilterDs.groupBy(new String[]{"finbillno"}).sum("amount", "ramount").finish();
            DataSet ds = depositFilterDs.leftJoin(releaseFilterDs).on("id", "finbillno").select(depositFilterDs.getRowMeta().getFieldNames(), new String[]{"ramount"}).finish();
            ds = ds.addField("to_date('" + DateUtils.formatString(queryDate, "yyyy-MM-dd") + "', 'yy-MM-dd')", "bizdate");
            return ds;
        }
        DataSet depositFilterDs = CashFundsCommonHelper.getDepositDsForOneYear(depositDs, rangeDates);
        DataSet releaseFilterDs = releaseDs;
        DataSetBuilder[] dataSetBuilders = CashFundsCommonHelper.buildDataSetBuilders(rangeDates.length, releaseFilterDs.getRowMeta(), Algo.create((String)"handleDepositDateSet"));
        Iterator it = releaseFilterDs.iterator();
        while (it.hasNext()) {
            int count = 0;
            Row row = (Row)it.next();
            Date redeemdate = row.getDate("redeemdate");
            for (Date lastDate : rangeDates) {
                if (lastDate.compareTo(redeemdate) >= 0) {
                    dataSetBuilders[count].append(row);
                }
                ++count;
            }
        }
        for (int i = 0; i < dataSetBuilders.length; ++i) {
            releaseFilterDs = i == 0 ? dataSetBuilders[i].build().addField("to_date('" + DateUtils.formatString(rangeDates[i], "yyyy-MM-dd") + "', 'yy-MM-dd')", "releaseBizdate") : releaseFilterDs.union(dataSetBuilders[i].build().addField("to_date('" + DateUtils.formatString(rangeDates[i], "yyyy-MM-dd") + "', 'yy-MM-dd')", "releaseBizdate"));
        }
        releaseFilterDs = releaseFilterDs.groupBy(new String[]{"finbillno", "releaseBizdate"}).sum("amount", "ramount").finish();
        DataSet ds = depositFilterDs.leftJoin(releaseFilterDs).on("id", "finbillno").on("bizdate", "releaseBizdate").select(depositFilterDs.getRowMeta().getFieldNames(), new String[]{"ramount"}).finish();
        return ds;
    }

    private static DataSet getDepositDsForOneYear(DataSet depositDs, Date[] rangeDates) {
        DataSetBuilder[] depositFilterBuilders = CashFundsCommonHelper.buildDataSetBuilders(rangeDates.length, depositDs.getRowMeta(), Algo.create((String)"handleDepositDateSet"));
        for (Row row : depositDs) {
            Date cleardate = row.getDate("cleardate");
            Date intdate = row.getDate("intdate");
            int count = 0;
            for (Date lastDate : rangeDates) {
                if ((cleardate == null || cleardate.after(lastDate)) && intdate.compareTo(lastDate) <= 0) {
                    depositFilterBuilders[count].append(row);
                }
                ++count;
            }
        }
        DataSet depositFilterDs = null;
        for (int i = 0; i < depositFilterBuilders.length; ++i) {
            if (i == 0) {
                depositFilterDs = depositFilterBuilders[i].build().addField("to_date('" + DateUtils.formatString(rangeDates[i], "yyyy-MM-dd") + "', 'yy-MM-dd')", "bizdate");
                continue;
            }
            if (depositFilterDs == null) continue;
            depositFilterDs = depositFilterDs.union(depositFilterBuilders[i].build().addField("to_date('" + DateUtils.formatString(rangeDates[i], "yyyy-MM-dd") + "', 'yy-MM-dd')", "bizdate"));
        }
        return depositFilterDs;
    }

    private static Date[] rangeDate(Date queryDate, int months) {
        Date[] array = new Date[months + 1];
        array[0] = queryDate;
        for (int i = 0; i < months; ++i) {
            Date lastMonthDate;
            array[i + 1] = lastMonthDate = DateUtils.getLastDateOfAnyMonth(queryDate, -(i + 1));
        }
        return array;
    }

    private static QFilter getDepositDateFilter(Date queryDate, Date[] rangeDates) {
        if (rangeDates == null) {
            QFilter dateFilter = new QFilter("intdate", "<=", (Object)queryDate);
            dateFilter.and(QFilter.of((String)"(cleardate IS NULL OR cleardate > ?)", (Object[])new Object[]{queryDate}));
            return dateFilter;
        }
        QFilter dateFilter = new QFilter("intdate", "<=", (Object)queryDate);
        dateFilter.and(QFilter.of((String)"(cleardate IS NULL OR cleardate > ?)", (Object[])new Object[]{rangeDates[rangeDates.length - 1]}));
        return dateFilter;
    }

    private static DataSet queryDepositRelease(String algoKey, Date queryDate, List<Long> orgIds) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR expireredeposit in('principalredeposit','principalintredeposit'))", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and("org", "in", orgIds);
        filter.and("redeemdate", "<=", (Object)queryDate);
        DataSet releaseDs = QueryServiceHelper.queryDataSet((String)(algoKey + "NoticeDepositRelease"), (String)"cim_release", (String)"finbillno,amount,redeemdate", (QFilter[])filter.toArray(), null);
        return releaseDs;
    }

    public static DataSet getFinsubScribe(String algoKey, List<Long> orgIds, Date queryDate, Map<String, Object> paramMap, boolean includeLastYear) {
        String sic = "id,redeemway,investvarieties.name productname,amount,cleardate,valuedate,planrevenue,iopv,buycopies,org company,org.name companyname, currency,currency.number currencynumber,finaccountf7.id accountbank, finaccountf7.name accountbankname, finaccountf7.acctproperty.id acctproperty,finorginfo.finorgtype.type finorgtype,finorginfo bank, finorginfo.name bankname,finorginfo.bank_cate.id bankcateid, finorginfo.bank_cate.name bankcatename, finorginfo.bank_cate.bankproperty bankcateproperty,finorginfo.country.id country, finorginfo.country.name countryname,case when finorginfo.country.twocountrycode = 'CN' then '1' else case when finorginfo.country.threecountrycode = 'CHN' then '1' else case when finorginfo.country = 0 or (TRIM(finorginfo.country.twocountrycode) = '' and TRIM(finorginfo.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,'0' as isoffset, finorginfo.org businessunit,'finance' fundtypevalue";
        sic = sic + ",billno detailbillno,finaccount bankaccountnumber,finaccountf7.acctproperty.name as acctpropertyname,'' as limitusage,currency.name currencyname,amount as depositamountoriginal,amount as depositamountrpt,null as bizupdatedate,valuedate as startdate,expiredate as enddate,term as deadline,planrevenue as interestrate";
        QFilter filter = new QFilter("org.id", "in", orgIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("finservicestatus", "!=", (Object)"subscribe_ing");
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isrenewal='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        ArrayList<Date> dateList = new ArrayList<Date>();
        queryDate = DateUtils.getDataFormat(queryDate, true);
        dateList.add(queryDate);
        if (includeLastYear) {
            Date[] dateRange = CashFundsCommonHelper.rangeDate(queryDate, 11);
            dateList.addAll(Arrays.asList(Arrays.copyOfRange(dateRange, 1, dateRange.length)));
            dateList.sort(Date::compareTo);
        }
        QFilter dateFilter = new QFilter("valuedate", "<=", dateList.get(dateList.size() - 1));
        QFilter clearDateFilter = QFilter.isNull((String)"cleardate").or(new QFilter("cleardate", ">", dateList.get(0)));
        filter.and(dateFilter).and(clearDateFilter);
        DataSet finsubscribeDs = QueryServiceHelper.queryDataSet((String)(algoKey + "NoticeDeposit"), (String)"cim_finsubscribe", (String)sic, (QFilter[])filter.toArray(), null);
        DataSet[] copyDs = DataSetHelper.copy(finsubscribeDs);
        finsubscribeDs = copyDs[0];
        Set<Long> finsubscribeIds = InvestCommonHelper.getFieldValues(copyDs[1], "id", Long.class);
        DataSet redeemDs = CashFundsCommonHelper.queryRedeem(algoKey, finsubscribeIds, queryDate);
        redeemDs = CashFundsCommonHelper.getfinsubscribeAndredeemDataset(finsubscribeDs, redeemDs, dateList);
        redeemDs = CashFundsCommonHelper.getLimitUsageAmount(redeemDs, "acctproperty");
        return redeemDs;
    }

    private static DataSet getfinsubscribeAndredeemDataset(DataSet finsubscribeDataset, DataSet redeemDataset, List<Date> dateList) {
        DataSet result = null;
        for (Date queryDate : dateList) {
            Map<String, Date> dateParam = Collections.singletonMap("dateParam", queryDate);
            DataSet finsubscribeDs = finsubscribeDataset.filter("(cleardate IS NULL OR cleardate > dateParam) AND valuedate <= dateParam", dateParam);
            DataSet redeemDs = redeemDataset.filter("redeemdate <= dateParam", dateParam);
            DataSet joinResult = CashFundsCommonHelper.joinRedeem(finsubscribeDs, redeemDs, "amount");
            String dateStr = "to_date('" + DateUtils.formatString(queryDate, "yyyy-MM-dd") + "', 'yy-MM-dd')";
            joinResult = joinResult.addFields(new String[]{dateStr, "0", "' '", "0", "0", "amount", "planrevenue"}, new String[]{"bizdate", "lstbalance", "datasource", "realrestrictedamt", "valibalance", "realvalibalance", "frate"});
            if (result != null) {
                result = joinResult.union(result);
                continue;
            }
            result = joinResult;
        }
        return result;
    }

    private static DataSet queryRedeem(String algoKey, Set<Long> finsubscribeIds, Date queryDate) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isrenewal='1' OR isrollcapital='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and("finbillno", "in", finsubscribeIds);
        if (queryDate != null) {
            filter.and("redeemdate", "<=", (Object)queryDate);
        }
        String sic = "finbillno,redeemdate,redeemway,copies,amount,realrevenue,case when redeemway='amount_redeem' then amount when redeemway='copies_redeem' then 0.0 else 0.0 end redeemamount";
        return QueryServiceHelper.queryDataSet((String)(algoKey + "redeem"), (String)"cim_redeem", (String)sic, (QFilter[])filter.toArray(), null);
    }

    private static DataSet joinRedeem(DataSet finsubscribeDs, DataSet redeemDs, String amountName) {
        redeemDs = redeemDs.groupBy(new String[]{"finbillno"}).sum("copies").sum("redeemamount").finish();
        DataSet ds = finsubscribeDs.leftJoin(redeemDs).on("id", "finbillno").select(finsubscribeDs.getRowMeta().getFieldNames(), new String[]{"copies", "redeemamount"}).finish();
        ds = ds.updateFields(new String[]{"iopv", "copies", "redeemamount"}, new String[]{"case when iopv is null then 0.0 else iopv end", "case when copies is null then 0.0 else copies end", "case when redeemamount is null then 0.0 else redeemamount end"});
        String s = String.format("case when redeemway='copies_redeem' then %1$s-(copies*iopv) when redeemway='amount_redeem' then %1$s-redeemamount else %1$s end", amountName);
        return ds.updateField(amountName, s).removeFields(new String[]{"copies", "redeemamount"});
    }

    private static DataSetBuilder[] buildDataSetBuilders(int size, RowMeta rowMeta, Algo algo) {
        DataSetBuilder[] builders = new DataSetBuilder[size];
        for (int i = 0; i < size; ++i) {
            builders[i] = algo.createDataSetBuilder(rowMeta);
        }
        return builders;
    }

    private static String getUsageLimite() {
        return ResManager.loadKDString((String)"'\u53d7\u9650'", (String)"CashFundsDataHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]);
    }

    private static String getNotUsageLimite() {
        return ResManager.loadKDString((String)"'\u975e\u53d7\u9650'", (String)"CashFundsDataHelper_1", (String)"tmc-fbp-common", (Object[])new Object[0]);
    }
}

