/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.DispatchGetParamHelper;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DataSetCacheManagerHelper {
    private static final DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
    private static final Log logger = LogFactory.getLog(DataSetCacheManagerHelper.class);
    private static Set<String> nocacheKeySet = new ConcurrentHashSet();
    public static final String TDASNAPKEYPREFIX = "tda.snap.";

    public static byte[] tranDataSetToByte(String key, DataSet dataSet) throws IOException {
        Long beginTime = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u8c03\u7528DataSet\u7f13\u5b58: key = " + key);
        ArrayList<Row> tranList = new ArrayList<Row>(10);
        for (Row row : dataSet) {
            tranList.add(row);
        }
        int cacheMaxDataSize = DataSetCacheManagerHelper.getCacheMaxDataSize();
        if (tranList.size() >= cacheMaxDataSize) {
            String bathno = (String)ThreadCache.get((Object)"bathno");
            nocacheKeySet.add(bathno + key);
            logger.info("\u7f13\u5b58DataSet\u6570\u636e\u91cf\u4e3a\uff1a" + tranList.size() + "; \u5927\u4e8e" + cacheMaxDataSize / 10000 + "\u4e07\u6570\u636e\u4e0d\u7f13\u5b58\uff0c key = " + key);
            return null;
        }
        logger.info("\u7f13\u5b58DataSet\u6570\u636e\u91cf\u4e3a\uff1a" + tranList.size() + "; key = " + key);
        byte[] result = DataSetCacheManagerHelper.toByte(tranList);
        Long endTime = System.currentTimeMillis();
        logger.info("\u7f13\u5b58DataSet\u6570\u636e\u91cf\u4e3a\uff1a" + tranList.size() + "; \u8017\u65f6\uff1a" + (endTime - beginTime) + "; key = " + key);
        dataSet.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByte(Object o) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(out);
        try {
            os.writeObject(o);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            os.close();
            out.close();
        }
    }

    public static Object fromByte(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new IOException("Serialize.fromByte err", e);
        }
        finally {
            ois.close();
            bais.close();
        }
    }

    public static DataSet tranByteToDataSet(String algoKey, Field[] fields, byte[] tranByte) throws IOException {
        Long beginTime = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u8c03\u7528\u4ece\u7f13\u5b58\u53d6DataSet,key = " + algoKey);
        List tranList = (List)DataSetCacheManagerHelper.fromByte(tranByte);
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(new RowMeta(fields));
        for (Row row : tranList) {
            dataSetBuilder.append(row);
        }
        logger.info("\u4ece\u7f13\u5b58\u83b7\u53d6\u5230\u7684DataSet\u6570\u636e\u91cf\u4e3a\uff1a" + tranList.size() + "; key = " + algoKey);
        DataSet ds = dataSetBuilder.build();
        Long endTime = System.currentTimeMillis();
        logger.info("\u4ece\u7f13\u5b58\u83b7\u53d6\u5230\u7684DataSet\u6570\u636e\u91cf\u4e3a\uff1a" + tranList.size() + "; \u8017\u65f6\uff1a" + (endTime - beginTime) + "; key = " + algoKey);
        return ds;
    }

    public static void putDataSetToCache(String key, DataSet dataSet, int timeout) throws IOException {
        Field[] fields = dataSet.getRowMeta().getFields();
        String fieldString = SerializationUtils.serializeToBase64((Object)fields);
        byte[] tranBytes = DataSetCacheManagerHelper.tranDataSetToByte(key, dataSet);
        if (tranBytes == null) {
            return;
        }
        cache.put(TDASNAPKEYPREFIX + key + "Fields", (Object)fieldString, timeout);
        cache.put(TDASNAPKEYPREFIX + key, tranBytes, timeout);
    }

    public static DataSet getDataSetFromCache(String algoKey, String key) throws IOException {
        String fieldString = (String)cache.get(TDASNAPKEYPREFIX + key + "Fields");
        if (EmptyUtil.isEmpty(fieldString)) {
            return null;
        }
        Field[] fields = (Field[])SerializationUtils.deSerializeFromBase64((String)fieldString);
        byte[] tranBytes = cache.getByteValue(TDASNAPKEYPREFIX + key);
        return DataSetCacheManagerHelper.tranByteToDataSet(algoKey, fields, tranBytes);
    }

    public static void remove(String[] key) {
        cache.remove((String[])Arrays.stream(key).map(k -> TDASNAPKEYPREFIX + k).toArray(String[]::new));
        cache.remove((String[])Arrays.stream(key).map(k -> TDASNAPKEYPREFIX + k + "Fields").toArray(String[]::new));
    }

    public static boolean isNoCache(String key) {
        String bathno = (String)ThreadCache.get((Object)"bathno");
        return nocacheKeySet.contains(bathno + key);
    }

    private static int getCacheMaxDataSize() {
        Integer cacheMaxDataSize = DispatchGetParamHelper.getParamValue("cachemaxdatasize", Integer.class);
        cacheMaxDataSize = EmptyUtil.isEmpty(cacheMaxDataSize) ? Integer.valueOf(200000) : cacheMaxDataSize;
        logger.info("\u7f13\u5b58\u6700\u5927\u6570\u636e\u91cf\u5927\u5c0f\uff1a" + cacheMaxDataSize);
        return cacheMaxDataSize;
    }
}

