/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DynamicObjectCompareHelper {
    public static Map<String, List<Object>> entriesDiffering(Map<String, Object> leftObjMap, Map<String, Object> rightObjMap) {
        if (leftObjMap == null) {
            leftObjMap = Collections.emptyMap();
        }
        if (rightObjMap == null) {
            rightObjMap = Collections.emptyMap();
        }
        MapDifference mapDifference = Maps.difference(leftObjMap, rightObjMap);
        Map differenceMap = mapDifference.entriesDiffering();
        HashMap<String, List<Object>> resultMap = new HashMap<String, List<Object>>(differenceMap.size());
        differenceMap.forEach((key, value) -> {
            ArrayList<Object> diffValueList = new ArrayList<Object>(2);
            diffValueList.add(value.leftValue());
            diffValueList.add(value.rightValue());
            resultMap.put((String)key, (List<Object>)diffValueList);
        });
        return resultMap;
    }

    public static Map<String, List<Object>> entriesDiffering(DynamicObject leftObj, DynamicObject rightObj) {
        return DynamicObjectCompareHelper.entriesDiffering(DynamicObjectCompareHelper.dynamicObj2Map(leftObj), DynamicObjectCompareHelper.dynamicObj2Map(rightObj));
    }

    public static Map<String, Object> entriesInCommon(Map<String, Object> leftObjMap, Map<String, Object> rightObjMap) {
        MapDifference mapDifference = Maps.difference(leftObjMap, rightObjMap);
        return mapDifference.entriesInCommon();
    }

    public static Map<String, Object> entriesInCommon(DynamicObject leftObj, DynamicObject rightObj) {
        return DynamicObjectCompareHelper.entriesInCommon(DynamicObjectCompareHelper.dynamicObj2Map(leftObj), DynamicObjectCompareHelper.dynamicObj2Map(rightObj));
    }

    public static Map<String, Object> entriesOnlyOnLeft(Map<String, Object> leftObjMap, Map<String, Object> rightObjMap) {
        return Maps.difference(leftObjMap, rightObjMap).entriesOnlyOnLeft();
    }

    public static Map<String, Object> entriesOnlyOnRight(Map<String, Object> leftObjMap, Map<String, Object> rightObjMap) {
        return Maps.difference(leftObjMap, rightObjMap).entriesOnlyOnRight();
    }

    public static Map<String, Object> dynamicObj2Map(DynamicObject dynamicObj) {
        return DynamicObjectCompareHelper.dynamicObj2Map(dynamicObj, false);
    }

    private static Map<String, Object> dynamicObj2Map(DynamicObject dynamicObject, DataEntityPropertyCollection props, boolean includeEntry) {
        HashMap<String, Object> objMap = new HashMap<String, Object>(16);
        for (IDataEntityProperty prop : props) {
            String name = prop.getName();
            Object value = dynamicObject.get(prop.getName());
            if ("multilanguagetext".equals(prop.getName())) continue;
            if (value instanceof DynamicObject) {
                objMap.put(name, ((DynamicObject)value).getPkValue());
                continue;
            }
            if (value instanceof Date) {
                objMap.put(name, DateUtils.formatString((Date)value, "yyyy-MM-dd"));
                continue;
            }
            if (value instanceof BigDecimal) {
                objMap.put(name, ((BigDecimal)value).setScale(10, RoundingMode.HALF_UP));
                continue;
            }
            if (value instanceof OrmLocaleValue) {
                objMap.put(name, ((OrmLocaleValue)value).getLocaleValue());
                continue;
            }
            if (value instanceof MulBasedataDynamicObjectCollection) {
                objMap.put(name, DynamicObjectCompareHelper.mulBasedataDynamicObjColl2Map((MulBasedataDynamicObjectCollection)value));
                continue;
            }
            if (includeEntry && value instanceof DynamicObjectCollection) {
                objMap.put(name, DynamicObjectCompareHelper.dynamicObjColl2Map((DynamicObjectCollection)value));
                continue;
            }
            objMap.put(name, value);
        }
        return objMap;
    }

    public static Map<String, Object> dynamicObj2Map(DynamicObject dynamicObj, boolean includeEntry) {
        DataEntityPropertyCollection props = dynamicObj.getDataEntityType().getProperties();
        return DynamicObjectCompareHelper.dynamicObj2Map(dynamicObj, props, includeEntry);
    }

    public static List<Map<String, Object>> dynamicObjColl2Map(DynamicObjectCollection entrys) {
        DynamicObjectType entryObjType = entrys.getDynamicObjectType();
        DataEntityPropertyCollection entryProps = entryObjType.getProperties();
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(entrys.size());
        for (DynamicObject entry : entrys) {
            Map<String, Object> objMap = DynamicObjectCompareHelper.dynamicObj2Map(entry, entryProps, false);
            entryList.add(objMap);
        }
        return entryList;
    }

    public static List<Long> mulBasedataDynamicObjColl2Map(MulBasedataDynamicObjectCollection datas) {
        ArrayList<Long> returnList = new ArrayList<Long>(datas.size());
        for (DynamicObject entry : datas) {
            returnList.add((Long)entry.getPkValue());
        }
        return returnList;
    }

    public static boolean comparePropForEntryGrid(IDataModel model, DynamicObject oldBill, String entryName, String entryKey) {
        DynamicObjectCollection nowEntitys = model.getEntryEntity(entryName);
        DynamicObjectCollection oldEntitys = oldBill.getDynamicObjectCollection(entryName);
        if (nowEntitys.size() != oldEntitys.size()) {
            return true;
        }
        HashMap<Object, Map<String, Object>> nextRecord = new HashMap<Object, Map<String, Object>>(nowEntitys.size());
        if (oldEntitys.size() > 0) {
            for (DynamicObject nowEntity : nowEntitys) {
                Map<String, Object> nextjMap = DynamicObjectCompareHelper.dynamicObj2Map(nowEntity, true);
                nextRecord.put(nextjMap.get(entryKey), nextjMap);
            }
        }
        for (DynamicObject entry : oldEntitys) {
            Map nextObjMap;
            Map<String, Object> lastObjMap = DynamicObjectCompareHelper.dynamicObj2Map(entry, true);
            Map<String, List<Object>> entriesDiffering = DynamicObjectCompareHelper.entriesDiffering(lastObjMap, nextObjMap = (Map)nextRecord.get(lastObjMap.get(entryKey)));
            if (!EmptyUtil.isNoEmpty(entriesDiffering)) continue;
            entriesDiffering.remove("id");
            entriesDiffering.remove("seq");
            entriesDiffering.remove("multilanguagetext");
            return entriesDiffering.size() > 0;
        }
        return false;
    }
}

