/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;

public class EvalRefDataHelper {
    public static final String AMOUNT_UNIT = "100000000";

    public static List<Object> getAllFinOrgId(Long finOrgId, boolean isBank) {
        ArrayList<Object> finOrgList = new ArrayList<Object>(10);
        if (isBank) {
            DynamicObject bank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorgtype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)FinOrgTypeEnum.BANK.getNumber()).toArray());
            Set idSet = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("finorgtype.id", "=", bank.getPkValue()), new QFilter("bank_cate.id", "=", (Object)finOrgId)}).keySet();
            finOrgList.addAll(idSet);
        } else {
            DynamicObject finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)finOrgId, (String)"bd_finorginfo", (String)"id");
            finOrgList.add(finOrg.getPkValue());
            Set<Object> orgIds = Collections.singleton(finOrg.getPkValue());
            while (!orgIds.isEmpty()) {
                Map objectMap = TmcDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"id,country", (QFilter[])new QFilter("parent", "in", orgIds).toArray());
                orgIds = objectMap.keySet();
                finOrgList.addAll(objectMap.values());
            }
        }
        return finOrgList;
    }

    public static Map<Long, Set<Long>> getAllFinOrgIds(List<Long> finOrgIds, boolean isBank) {
        HashMap<Long, Set<Long>> orgMap = new HashMap(16);
        if (isBank) {
            DynamicObject bank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorgtype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)FinOrgTypeEnum.BANK.getNumber()).toArray());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getAllFinOrgId", (String)"bd_finorginfo", (String)"id,bank_cate.id bank", (QFilter[])new QFilter[]{new QFilter("finorgtype.id", "=", bank.getPkValue()), new QFilter("bank_cate.id", "in", finOrgIds)}, null);){
                for (Row row : dataSet) {
                    Long bankId = row.getLong("bank");
                    Set list = orgMap.computeIfAbsent(bankId, t -> new HashSet(16));
                    list.add(row.getLong("id"));
                }
            }
        } else {
            orgMap = finOrgIds.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.toSet()));
            for (Long finOrg : finOrgIds) {
                EvalRefDataHelper.putFinOrgMap(orgMap, finOrg, Collections.singleton(finOrg));
            }
        }
        return orgMap;
    }

    private static void putFinOrgMap(Map<Long, Set<Long>> resMap, Long rid, Set<Long> cidSet) {
        Map<Long, Set<Long>> childMap = EvalRefDataHelper.getFinOrgChildren(cidSet);
        Set<Long> children = childMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (children.size() > 0) {
            Set hasSet = resMap.computeIfAbsent(rid, t -> new HashSet(16));
            hasSet.addAll(children);
            EvalRefDataHelper.putFinOrgMap(resMap, rid, children);
        }
    }

    private static Map<Long, Set<Long>> getFinOrgChildren(Collection<Long> finOrgs) {
        HashMap<Long, Set<Long>> finOrgMap = new HashMap<Long, Set<Long>>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getFinOrgChildren", (String)"bd_finorginfo", (String)"id,parent", (QFilter[])new QFilter("parent", "in", finOrgs).toArray(), null);){
            for (Row row : dataSet) {
                Long parent = row.getLong("parent");
                Long fid = row.getLong("id");
                Set idSet = finOrgMap.computeIfAbsent(parent, t -> new HashSet(16));
                idSet.add(fid);
            }
        }
        return finOrgMap;
    }

    public static QFilter getDateFilter(String field, Date fromDate, Date toDate) {
        QFilter qFilter = new QFilter(field, ">=", (Object)fromDate);
        return qFilter.and(field, "<=", (Object)toDate);
    }

    public static String getTotalAmount(DataSet dataSet) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Row row : dataSet) {
            totalAmount = totalAmount.add(row.getBigDecimal("amount"));
        }
        return String.format("%.2f", totalAmount);
    }

    public static List<Long> getAllSubOrgIds(Long orgId) {
        return TmcOrgDataHelper.getAllSubordinateOrgsForCache(8L, Collections.singletonList(orgId), true);
    }

    public static String[] calcFieldExpress(String[] fields) {
        return (String[])Arrays.stream(fields).map(t -> t + "/" + AMOUNT_UNIT).toArray(String[]::new);
    }
}

