/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SingleOrgContextHelper;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;

public class ExpressionFromHelper {
    public static List<IDataEntityProperty> getFilterFields(IDataEntityType dataEntityType, boolean filter) {
        ArrayList<IDataEntityProperty> oneLevelProp = new ArrayList<IDataEntityProperty>(10);
        MainEntityType mainType = (MainEntityType)dataEntityType;
        for (IDataEntityProperty fieldProp : mainType.getAllFields().values()) {
            IDataEntityType parentType;
            if (!(fieldProp instanceof IFieldHandle) || null != (parentType = fieldProp.getParent()) && parentType instanceof LinkEntryType || SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)fieldProp)) continue;
            if (filter) {
                String alias = fieldProp.getAlias();
                if (!StringUtils.isNotBlank((CharSequence)alias)) continue;
                oneLevelProp.add(fieldProp);
                continue;
            }
            oneLevelProp.add(fieldProp);
        }
        return oneLevelProp;
    }

    public static Map<String, LocaleString> getFieldColumn(String pageStr, boolean haveParent, boolean filter, String ... filterEntrys) {
        Map<String, LocaleString> map = new HashMap<String, LocaleString>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pageStr);
        List<IDataEntityProperty> entryProps = ExpressionFromHelper.getFilterFields((IDataEntityType)entityType, filter);
        for (IDataEntityProperty prop : entryProps) {
            String fullFieldName = haveParent ? ExpressionFromHelper.getParentSign(pageStr, prop.getParent(), prop.getName()) : prop.getName();
            LocaleString localeName = prop.getDisplayName();
            map.put(fullFieldName, localeName);
        }
        if (null != filterEntrys && filterEntrys.length > 0) {
            map = map.entrySet().stream().filter(o -> {
                boolean bool = true;
                for (String filterEntry : filterEntrys) {
                    boolean bl = bool = bool && !((String)o.getKey()).startsWith(filterEntry);
                    if (!bool) break;
                }
                return bool;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return map;
    }

    public static String getParentSign(String pageStr, IDataEntityType propType, String prefix) {
        if (null == propType) {
            return prefix;
        }
        String parentName = propType.getName();
        if (!pageStr.equalsIgnoreCase(parentName)) {
            prefix = String.format("%s.%s", parentName, prefix);
            ExpressionFromHelper.getParentSign(pageStr, propType.getParent(), prefix);
        }
        return prefix;
    }

    public static void openExpressionForm(String formId, String sourceBillId, String conditionJson, String fieldNode, String callbackId, AbstractFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", sourceBillId);
        showParameter.getCustomParams().put("treenodes", fieldNode);
        String funcsXML = plugin.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            plugin.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callbackId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        plugin.getView().showForm(showParameter);
    }

    public static void dealCallbackOfCloseForm(ClosedCallBackEvent evt, String signCondiDesc, String signCondiSave, AbstractFormPlugin plugin) {
        IDataModel model = plugin.getView().getModel();
        String condition = Optional.ofNullable(evt.getReturnData()).map(Objects::toString).orElseGet(() -> null);
        if (StringUtils.isBlank((CharSequence)condition)) {
            model.setValue(signCondiDesc, model.getValue(signCondiDesc));
        } else {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
            model.setValue(signCondiSave, (Object)condition);
            String desp = "";
            if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                desp = filterObj.getExprTran();
            }
            if (desp.length() > 1024) {
                desp = desp.substring(0, 1024);
            }
            model.setValue(signCondiDesc, (Object)desp);
        }
    }

    public static String getSourceBillFieldNode(String formId, String casheKey, ExpressionType exType, boolean readChildEntity, Class<?> cls, AbstractFormPlugin plugin) {
        String fieldJson = plugin.getPageCache().get(casheKey);
        if (StringUtils.isBlank((CharSequence)fieldJson)) {
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)formId);
            fieldJson = Optional.ofNullable(entity).map(o -> {
                EntityFieldTreeOption option = EntityFieldTreeOption.create();
                option.setEntityType((IDataEntityType)o);
                option.setReadEntryEntity(readChildEntity);
                option.setExprType(exType);
                option.setFieldType(cls);
                EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
                TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
                String fields = SerializationUtils.toJsonString((Object)tree);
                plugin.getPageCache().put(casheKey, fields);
                return fields;
            }).orElseGet(() -> "");
        }
        return fieldJson;
    }

    public static DynamicObjectCollection getFilterProperties(Map<String, DynamicProperty> fldProperties, QFilter[] filters, String billNo) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billNo);
        HashSet<String> propSet = new HashSet<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ExpressionFromHelper.seekProperties(propSet, "", properties);
        String propStr = propSet.stream().collect(Collectors.joining(","));
        DynamicObjectCollection rows = null;
        try (DataSet dsn = QueryServiceHelper.queryDataSet((String)ExpressionFromHelper.class.getName(), (String)billNo, (String)propStr, (QFilter[])filters, null);){
            rows = ORM.create().toPlainDynamicObjectCollection(dsn);
        }
        Optional.ofNullable(rows).filter(o -> !o.isEmpty()).ifPresent(doc -> {
            DynamicObjectType dType = doc.getDynamicObjectType();
            propSet.forEach(elem -> fldProperties.put((String)elem, dType.getProperty(elem)));
            doc.forEach(o -> o.getDynamicObjectType().setName(billNo));
        });
        return rows;
    }

    public static void seekProperties(Set<String> propSets, String propName, DataEntityPropertyCollection properties) {
        for (IDataEntityProperty property : properties) {
            String tempPropName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || property.getName().contains("_id")) continue;
            String string = tempPropName = StringUtils.isBlank((CharSequence)propName) ? property.getName() : String.format("%s.%s", propName, property.getName()).trim();
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                ExpressionFromHelper.seekProperties(propSets, tempPropName, bdProperties);
                continue;
            }
            propSets.add(tempPropName);
        }
    }

    private ExpressionFromHelper() {
    }
}

