/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.RowUtil;
import kd.bos.algo.input.CollectionInput;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.model.tda.finance.FinCostRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinanceCostCommonHelper {
    public static final String SELECT_FIELDS = "case when loantype = 'entrust' or loantype = 'ec' then 2 when loantype = 'bond' then 1 when ( loantype = 'loan' or loantype = 'sl' ) and creditortype = 'bank' then 0 else 3 end as financetype,org.id as orgid,org.id as company,org.name companyname,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,finproduct.name as finproductname,finproduct.id as finproductid,textcreditor,isnofixedterm,region,loantype,interesttype,drawamount,startintdate,endinstdate,drawtype,cleardate,interestsettledplan.intereststpd as intereststpd,case when renewalexpiredate is null then expiredate else renewalexpiredate end as expiredate,expiredate as srcexpiredate,billno,contractno,loancontractbill.number  contractbillno,creditortype,creditor,id";
    public static final String SELECT_FIELDS_LEASE = "3 as financetype,org.id as orgid,org.id as company,org.name companyname,currency.id as currency,currency.number as currencynumber,currency.name as currencyname,finproduct.name as finproductname,finproduct.id as finproductid,textcreditor,isnofixedterm,region,'lease' as loantype,interesttype,amount as drawamount,startdate as startintdate,null as endinstdate,'' as drawtype,null as cleardate,interestsettledplan.intereststpd as intereststpd,enddate as expiredate,enddate as srcexpiredate,billno,contractno,billno as contractbillno,creditortype,creditor,id,null as inttype,null as partnerorgid,null as lrenewalexpiredate,entry_rentplan.paydate as paydate,entry_rentplan.startrevdate as interestbegindate,entry_rentplan.endrevdate as interestenddate,entry_rentplan.principal as interestprinciple,0.0 as interestrate,entry_rentplan.intamt as intamt";
    private static final String[] INT_FIELD_NAMES = new String[]{"principle", "intrate", "begindate", "enddate", "daynum", "dayweight", "datetype", "term", "residueterm", "inststartdate", "instenddate", "customtype"};
    private static final String[] INT_JOIN_FIELDS = new String[]{"interestbegindate", "interestenddate", "interestprinciple", "interestrate"};
    private static final DataType[] INT_DATA_TYPES = new DataType[]{DataType.BigDecimalType, DataType.BigDecimalType, DataType.DateType, DataType.DateType, DataType.IntegerType, DataType.BigDecimalType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.DateType, DataType.DateType, DataType.StringType};

    public static DataSet splitBankcateData(QFilter filter, DataSet result) {
        result = result.filter("financetype = 0");
        DataSet slLoanDataSet = FinanceCostCommonHelper.querySlDataSet(filter);
        String[] fieldNames = result.getRowMeta().getFieldNames();
        result = result.leftJoin(slLoanDataSet).on("id", "id").select(fieldNames, new String[]{"ebankcate", "ebankcatename", "edrawamount", "ebankname"}).finish();
        result = result.updateFields(new String[]{"principle", "avgbalance", "interest", "drawamount", "bankcate", "bankcatename", "textcreditor"}, new String[]{"case when edrawamount is null then principle else principle * (edrawamount / drawamount) end", "case when edrawamount is null then avgbalance else avgbalance * (edrawamount / drawamount) end", "case when edrawamount is null then interest else interest * (edrawamount / drawamount) end", "case when edrawamount is null then drawamount else edrawamount end", "case when edrawamount is null then bankcate else ebankcate end", "case when edrawamount is null then bankcatename else ebankcatename end", "case when edrawamount is null then textcreditor else ebankname end"});
        return result;
    }

    private static DataSet querySlDataSet(QFilter filter) {
        DataSet slDataSet = FinanceCostCommonHelper.getFinanceCostDataSet("FinanceCostDataHelper.querySlDataSet", filter, "id,drawamount,banksyndicate_entry.e_bank.bank_cate.id as ebankcate,banksyndicate_entry.e_bank.bank_cate.name as ebankcatename,banksyndicate_entry.e_shareamount as edrawamount,banksyndicate_entry.e_bank.name as ebankname");
        return slDataSet;
    }

    public static DataSet getAllViewData(FinCostRequest request) {
        QFilter filter = request.getFilter();
        DataSet financeCostDataSet = FinanceCostCommonHelper.getFinanceCostDataSet(request.getAlgoKey(), filter, SELECT_FIELDS).addField("0", "inttype");
        final RowMeta rowMeta = financeCostDataSet.getRowMeta();
        financeCostDataSet = financeCostDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String drawType = row.getString("drawtype");
                Date endinstDate = row.getDate("endinstdate");
                Date clearDate = row.getDate("cleardate");
                int inttypeIndex = rowMeta.getFieldIndex("inttype", false);
                boolean clearFlag = "closeout".equals(drawType) || clearDate != null;
                boolean dateEquals = clearDate != null && endinstDate != null && clearDate.compareTo(DateUtils.getNextDay(endinstDate, 1)) <= 0;
                data[inttypeIndex] = clearFlag && dateEquals ? Integer.valueOf(0) : Integer.valueOf(1);
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        HashSet<Long> loanBillIds = new HashSet<Long>(16);
        HashSet<Long> intType0Ids = new HashSet<Long>(16);
        HashSet<Long> intType1Ids = new HashSet<Long>(16);
        HashSet<Long> bankCreditorIds = new HashSet<Long>(16);
        HashSet<Long> companyCreditorIds = new HashSet<Long>(16);
        HashSet<Long> currencys = new HashSet<Long>(16);
        ArrayList<Object[]> currencyRow = new ArrayList<Object[]>(10);
        DataSet[] copy = financeCostDataSet.splitByFilter(new String[]{"true", "true"}, false);
        financeCostDataSet = copy[0];
        for (Row row : copy[1]) {
            Long loanBillid = row.getLong("id");
            loanBillIds.add(loanBillid);
            Long currency = row.getLong("currency");
            if (currencys.add(currency)) {
                currencyRow.add(new Object[]{currency});
            }
            if (0 == row.getInteger("inttype")) {
                intType0Ids.add(loanBillid);
            } else {
                intType1Ids.add(loanBillid);
            }
            if (CreditorTypeEnum.BANK.getValue().equals(row.getString("creditortype")) || CreditorTypeEnum.FINORG.getValue().equals(row.getString("creditortype"))) {
                bankCreditorIds.add(row.getLong("creditor"));
            }
            if (!CreditorTypeEnum.CUSTOM.getValue().equals(row.getString("creditortype"))) continue;
            companyCreditorIds.add(row.getLong("creditor"));
        }
        QFilter qFilter = new QFilter("id", "in", bankCreditorIds);
        DataSet finOrgInfos = QueryServiceHelper.queryDataSet((String)"financecostdatahelper.getfinorginfo", (String)"bd_finorginfo", (String)"id,org.id as finorgid,bank_cate.id as bankcate,bank_cate.name as bankcatename", (QFilter[])qFilter.toArray(), null);
        QFilter companyCreditorFilter = new QFilter("id", "in", companyCreditorIds);
        DataSet partnerUnits = QueryServiceHelper.queryDataSet((String)"financecostdatahelper.getpartner", (String)"bd_bizpartner", (String)"id,internal_company.id as partnerorgid", (QFilter[])companyCreditorFilter.toArray(), null);
        String[] fieldNames = financeCostDataSet.getRowMeta().getFieldNames();
        financeCostDataSet = financeCostDataSet.leftJoin(finOrgInfos).on("creditor", "id").select(fieldNames, new String[]{"finorgid", "bankcate", "bankcatename"}).finish();
        String[] fieldNames2 = financeCostDataSet.getRowMeta().getFieldNames();
        financeCostDataSet = financeCostDataSet.leftJoin(partnerUnits).on("creditor", "id").select(fieldNames2, new String[]{"partnerorgid"}).finish();
        financeCostDataSet = financeCostDataSet.addField("case when finorgid is not null then finorgid when creditortype = 'innerunit' then creditor when partnerorgid is not null then partnerorgid else 0 end", "creditorinnerorg");
        QFilter extendBillFilter = new QFilter("loanbilllist.drawbillid", "in", loanBillIds);
        extendBillFilter.and("bizdate", "<=", (Object)request.getQueryDate());
        DataSet extendBillSet = QueryServiceHelper.queryDataSet((String)"financecostdatahelper.getextendBill", (String)"cfm_contractextendbill", (String)"contractbillno,loanbilllist.drawbillid as loanbillid,loanbilllist.lrenewalexpiredate as lrenewalexpiredate", (QFilter[])extendBillFilter.toArray(), null);
        extendBillSet = extendBillSet.select("loanbillid,lrenewalexpiredate").groupBy(new String[]{"loanbillid"}).max("lrenewalexpiredate").finish();
        String[] fieldNames3 = financeCostDataSet.getRowMeta().getFieldNames();
        financeCostDataSet = financeCostDataSet.leftJoin(extendBillSet).on("id", "loanbillid").select(fieldNames3, new String[]{"lrenewalexpiredate"}).finish().updateField("expiredate", "case when lrenewalexpiredate is null then expiredate else lrenewalexpiredate end");
        QFilter intType0Filter = new QFilter("sourcebillid", "in", intType0Ids);
        intType0Filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet loanInt0 = QueryServiceHelper.queryDataSet((String)"FinanceCostDataHelper.getIntBillInfo0", (String)"cfm_interestbill", (String)"sourcebillid as loanbillid,entrys.inststartdate interestbegindate,entrys.instenddate interestenddate,entrys.instprincipalamt interestprinciple,entrys.rate interestrate", (QFilter[])intType0Filter.toArray(), null);
        QFilter intType1Filter = new QFilter("loanbillid", "in", intType1Ids);
        DataSet loanInt1 = QueryServiceHelper.queryDataSet((String)"FinanceCostDataHelper.getIntBillInfo2", (String)"tda_loanbillintinfo", (String)"loanbillid,intstartdate as interestbegindate,intenddate as interestenddate,intprinciple as interestprinciple,intrate as interestrate", (QFilter[])intType1Filter.toArray(), null);
        String[] fieldNames4 = financeCostDataSet.getRowMeta().getFieldNames();
        DataSet[] splitDataSet = financeCostDataSet.splitByFilter(new String[]{"inttype = 0", "inttype = 1"}, false);
        DataSet joinIntResult0 = splitDataSet[0].leftJoin(loanInt0).on("id", "loanbillid").select(fieldNames4, INT_JOIN_FIELDS).finish().filter("interestprinciple is not null");
        DataSet joinIntResult1 = splitDataSet[1].leftJoin(loanInt1).on("id", "loanbillid").select(fieldNames4, INT_JOIN_FIELDS).finish().filter("interestprinciple is not null");
        DataSet unionDataSet = joinIntResult0.union(joinIntResult1);
        if (request.getLeaseFilter() != null) {
            DataSet leaseCostDataSet = FinanceCostCommonHelper.getLeaseCostDataSet(request, currencys, currencyRow);
            unionDataSet = unionDataSet.union(leaseCostDataSet.select(unionDataSet.getRowMeta().getFieldNames()));
        }
        unionDataSet = unionDataSet.addFields(new String[]{"drawamount", "interestprinciple"}, new String[]{"srcdrawamount", "srcprinciple"});
        if (EmptyUtil.isNoEmpty(request.getOrgViewId())) {
            DataSet currencyDs = FinanceCostCommonHelper.createCurrencyDs(currencyRow);
            unionDataSet = AmountTransHelper.tranDataSetRate(unionDataSet, currencyDs, request.getOrgViewId(), request.getBaseCurrency(), "currency", Arrays.asList("drawamount", "interestprinciple").stream().collect(Collectors.toSet()), request.getQueryDate());
        }
        financeCostDataSet = FinanceCostCommonHelper.handleIntCalc(unionDataSet, request.getDateList(), request.getQueryDate());
        financeCostDataSet = financeCostDataSet.addFields(new String[]{"principle * dayweight", "principle * dayweight * intrate / 100"}, new String[]{"avgbalance", "interest"});
        return financeCostDataSet;
    }

    private static DataSet createCurrencyDs(List<Object[]> currencyRow) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"currency"}, (DataType[])new DataType[]{DataType.LongType});
        CollectionInput inputs = new CollectionInput(rowMeta, currencyRow);
        return Algo.create((String)"financecostcommonhelper.new").createDataSet(new Input[]{inputs});
    }

    public static DataSet handleIntCalc(DataSet unionDataSet, List<Object[]> dateList, Date queryDate) {
        DataType[] dataTypes = unionDataSet.getRowMeta().getDataTypes();
        String[] fieldNames = unionDataSet.getRowMeta().getFieldNames();
        String[] newFieldNames = new String[fieldNames.length + INT_FIELD_NAMES.length];
        DataType[] newDataTypes = new DataType[dataTypes.length + INT_DATA_TYPES.length];
        System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
        System.arraycopy(INT_FIELD_NAMES, 0, newFieldNames, fieldNames.length, INT_FIELD_NAMES.length);
        System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
        System.arraycopy(INT_DATA_TYPES, 0, newDataTypes, dataTypes.length, INT_DATA_TYPES.length);
        RowMeta builderMeta = RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
        DataSetBuilder builder = Algo.create((String)"FinanceCostDataHelper.handleIntCalc").createDataSetBuilder(builderMeta);
        for (Row row : unionDataSet) {
            if (EmptyUtil.isAnyoneEmpty(row.getDate("interestbegindate"), row.getDate("interestenddate"), row.getBigDecimal("interestprinciple"), row.getBigDecimal("interestrate"))) continue;
            FinanceCostCommonHelper.dealQueryDate(dateList, fieldNames, builder, row, queryDate);
        }
        return builder.build();
    }

    public static void dealQueryDate(List<Object[]> dateList, String[] fieldNames, DataSetBuilder builder, Row row, Date queryDate) {
        for (int i = 0; i < dateList.size(); ++i) {
            Date beginDate = row.getDate("interestbegindate");
            Date endDate = row.getDate("interestenddate");
            Date queryBeginDate = (Date)dateList.get(i)[0];
            Date queryEndDate = (Date)dateList.get(i)[1];
            if (beginDate.compareTo(queryEndDate) > 0 || endDate.compareTo(queryBeginDate) < 0) continue;
            ArrayList<Object> appendRow = new ArrayList<Object>(fieldNames.length + INT_FIELD_NAMES.length);
            Date lastBeginDate = beginDate.compareTo(queryBeginDate) >= 0 ? beginDate : queryBeginDate;
            Date lastEndDate = endDate.compareTo(queryEndDate) <= 0 ? endDate : queryEndDate;
            int realDays = DateUtils.getDiffDays(lastBeginDate, lastEndDate);
            int queryDays = DateUtils.getDiffDays(queryBeginDate, queryEndDate);
            for (int j = 0; j < fieldNames.length; ++j) {
                appendRow.add(row.get(j));
            }
            appendRow.add(row.get("interestprinciple"));
            appendRow.add(row.get("interestrate"));
            appendRow.add(lastBeginDate);
            appendRow.add(lastEndDate);
            appendRow.add(realDays);
            appendRow.add(new BigDecimal(realDays).divide(new BigDecimal(queryDays), 10, RoundingMode.HALF_UP));
            appendRow.add(i < 6 ? i : i + 12);
            appendRow.add(DateUtils.getDiff_ymd(row.getDate("startintdate"), row.getDate("expiredate")));
            appendRow.add(DateUtils.getDiff_ymd(queryDate, row.getDate("expiredate")));
            appendRow.add(beginDate);
            appendRow.add(endDate);
            appendRow.add(dateList.get(i)[2]);
            builder.append(appendRow.toArray());
        }
    }

    public static DataSet getFinanceCostDataSet(String algoKey, QFilter filter, String selectField) {
        return QueryServiceHelper.queryDataSet((String)(algoKey + "getFinanceDataSet"), (String)"cfm_loanbill", (String)selectField, (QFilter[])new QFilter[]{filter}, null);
    }

    public static DataSet getLeaseCostDataSet(FinCostRequest request, Set<Long> currencys, List<Object[]> currencyRow) {
        QFilter leaseFilter = request.getLeaseFilter();
        DataSet leaseDataSet = QueryServiceHelper.queryDataSet((String)(request.getAlgoKey() + "getLeaseCostDataSet"), (String)"fl_leasecontractbill", (String)SELECT_FIELDS_LEASE, (QFilter[])leaseFilter.toArray(), null);
        DataSet[] copy = leaseDataSet.splitByFilter(new String[]{"true", "true"}, false);
        leaseDataSet = copy[0];
        HashSet<Long> creditorIds = new HashSet<Long>(16);
        for (Row row : copy[1]) {
            Long currency = row.getLong("currency");
            if (currencys.add(currency)) {
                currencyRow.add(new Object[]{currency});
            }
            creditorIds.add(row.getLong("creditor"));
        }
        QFilter qFilter = new QFilter("id", "in", creditorIds);
        DataSet finOrgInfos = QueryServiceHelper.queryDataSet((String)"getLeaseCostDataSet.getfinorginfo", (String)"bd_finorginfo", (String)"id,org.id as finorgid,bank_cate.id as bankcate,bank_cate.name as bankcatename", (QFilter[])qFilter.toArray(), null);
        String[] fieldNames = leaseDataSet.getRowMeta().getFieldNames();
        leaseDataSet = leaseDataSet.leftJoin(finOrgInfos).on("creditor", "id").select(fieldNames, new String[]{"finorgid", "bankcate", "bankcatename"}).finish();
        leaseDataSet = leaseDataSet.addField("case when finorgid is not null then finorgid  else 0 end", "creditorinnerorg");
        final RowMeta rowMeta = leaseDataSet.getRowMeta();
        int interestprincipleIndex = rowMeta.getFieldIndex("interestprinciple");
        DataSet[] splitGroupDataSet = leaseDataSet.splitByGroup(new String[]{"id"});
        DataSetBuilder builder = Algo.create((String)"FinanceCostDataHelper.getLeaseCostDataSet").createDataSetBuilder(rowMeta);
        for (DataSet tempDataSet : splitGroupDataSet) {
            BigDecimal oneTotal = new BigDecimal(0);
            tempDataSet = tempDataSet.orderBy(new String[]{"paydate asc"});
            for (Row row : tempDataSet) {
                BigDecimal interestPrinciple = row.getBigDecimal("interestprinciple");
                Object[] data = RowUtil.toArray((Row)row);
                data[interestprincipleIndex] = row.getBigDecimal("drawamount").subtract(oneTotal);
                builder.append(data);
                oneTotal = oneTotal.add(interestPrinciple);
            }
        }
        leaseDataSet = builder.build();
        leaseDataSet = leaseDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                Date interestBeginDate = row.getDate("interestbegindate");
                Date interestEnddate = row.getDate("interestenddate");
                BigDecimal interestPrinciple = row.getBigDecimal("interestprinciple");
                BigDecimal intAmt = row.getBigDecimal("intamt");
                if (!EmptyUtil.isAnyoneEmpty(interestBeginDate, interestEnddate, interestPrinciple, intAmt)) {
                    int interestrateIndex = rowMeta.getFieldIndex("interestrate", false);
                    int daynum = DateUtils.getDiffDays(interestBeginDate, interestEnddate);
                    BigDecimal interestRate = intAmt.multiply(new BigDecimal(360)).divide(interestPrinciple.multiply(new BigDecimal(daynum)), 4, 4).multiply(new BigDecimal(100));
                    data[interestrateIndex] = interestRate;
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        return leaseDataSet.removeFields(new String[]{"paydate"});
    }

    public static QFilter getQFilter(List<Long> allorgids, Date beginDate, Date endDate, boolean containCompany, boolean containSettle) {
        QFilter qFilter = new QFilter("org", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("finproduct.equitytool", "=", (Object)Boolean.FALSE);
        qFilter.and("startintdate", "<=", (Object)DateUtils.getDataFormat(endDate, false));
        qFilter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat(beginDate, true)).or(new QFilter("cleardate", "is null", null)));
        QFilter bankFilter = new QFilter("loantype", "in", Arrays.asList("loan", "sl"));
        if (!containSettle) {
            bankFilter.and("creditortype", "!=", (Object)"settlecenter");
        }
        QFilter companyFilter = new QFilter("loantype", "in", Arrays.asList("entrust", "ec"));
        QFilter bonfFilter = new QFilter("loantype", "=", (Object)"bond");
        QFilter loadTypeFilter = bankFilter.or(bonfFilter);
        if (containCompany) {
            loadTypeFilter = loadTypeFilter.or(companyFilter);
        }
        return qFilter.and(loadTypeFilter);
    }

    public static QFilter getLeaseQFilter(List<Long> allorgids, Date beginDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("contractstatus", "not in", Arrays.asList("A", "B"));
        qFilter.and("loantype", "=", (Object)"finlease");
        qFilter.and("startdate", "<=", (Object)DateUtils.getDataFormat(endDate, false));
        qFilter.and("enddate", ">=", (Object)DateUtils.getDataFormat(beginDate, true));
        return qFilter;
    }

    public static QFilter getSlQFilter(List<Long> allorgids, Date beginDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "in", allorgids);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("startintdate", "<=", (Object)DateUtils.getDataFormat(endDate, false));
        qFilter.and(new QFilter("cleardate", ">", (Object)DateUtils.getDataFormat(beginDate, true)).or(new QFilter("cleardate", "is null", null)));
        QFilter slFilter = new QFilter("loantype", "=", (Object)"sl").and("creditortype", "!=", (Object)"settlecenter");
        return qFilter.and(slFilter);
    }
}

