/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.model.tda.invest.DepositRow;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FloatRateHelper {
    private static final String FRATE = "frate";

    public static DataSet updateFloatRate(DataSet ds, Set<Long> referRateIds, final Date queryDate) {
        final Map<Long, Map<Date, String>> allReferRateDataMap = FloatRateHelper.getReferRateDataMap(referRateIds, queryDate);
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                String interestType = row.getString("interesttype");
                if (!InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
                    for (String fieldName : rowMetas.getFieldNames()) {
                        rowInfo.add(row.get(fieldName));
                    }
                    return rowInfo.toArray();
                }
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (FloatRateHelper.FRATE.equals(fieldName)) {
                        Long referenceRate = row.getLong("referencerate");
                        Date bizDate = row.getDate("bizdate");
                        if (referenceRate == null || bizDate == null) continue;
                        Map referRateDataMap = (Map)allReferRateDataMap.get(referenceRate);
                        DepositRow depositRow = new DepositRow(row, queryDate, queryDate, "", referRateDataMap);
                        rowInfo.add(depositRow.getFrate());
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    public static DataSet updateFloatRate(DataSet ds, Date queryDate) {
        Set<Long> referRateIds = FloatRateHelper.getReferRateIds(ds.copy());
        return FloatRateHelper.updateFloatRate(ds, referRateIds, queryDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getReferRateIds(DataSet ds) {
        try {
            HashSet<Long> set = new HashSet<Long>(32);
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                Long referenceRate = ((Row)iterator.next()).getLong("referencerate");
                if (referenceRate == null) continue;
                set.add(referenceRate);
            }
            HashSet<Long> hashSet = set;
            return hashSet;
        }
        finally {
            if (ds != null) {
                ds.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Map<Date, String>> getReferRateDataMap(Set<Long> referRateIds, Date queryDate) {
        HashMap<Long, Map<Date, String>> allDataMap = new HashMap<Long, Map<Date, String>>(16);
        try (DataSet ds = null;){
            ds = FloatRateHelper.getReferRateData(referRateIds, queryDate);
            for (Row row : ds) {
                Long referRateId = row.getLong("referrate");
                Date bizDate = row.getDate("bizdate");
                String price = row.getString("endprice");
                if (EmptyUtil.isAnyoneEmpty(referRateId, bizDate, price)) continue;
                LinkedHashMap<Date, String> dataMap = (LinkedHashMap<Date, String>)allDataMap.get(referRateId);
                if (dataMap == null) {
                    dataMap = new LinkedHashMap<Date, String>(128);
                    allDataMap.put(referRateId, dataMap);
                }
                dataMap.put(bizDate, price);
            }
            HashMap<Long, Map<Date, String>> hashMap = allDataMap;
            return hashMap;
        }
    }

    private static DataSet getReferRateData(Set<Long> referRateIds, Date queryDate) {
        String sic = "referrate,bizdate,endprice";
        QFilter filter = new QFilter("referrate", "in", referRateIds);
        filter.and("bizdate", "<=", (Object)queryDate);
        return QueryServiceHelper.queryDataSet((String)"getReferRateData", (String)"md_datarate", (String)sic, (QFilter[])filter.toArray(), (String)"referrate ASC,bizdate DESC");
    }
}

