/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.FloatRateHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.tda.invest.DepositRow;
import kd.tmc.fbp.common.model.tda.invest.InvestRequest;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InvestCommonHelper {
    private static final String[] BALANCE_FIELD_NAMES = new String[]{"id", "amount", "frate", "investtype", "investtname", "company", "companyname", "currency", "currencynumber", "currencyname", "finorgtype", "bank", "bankname", "bankcatename", "bankcateid", "accountbank", "accountbankname", "acctproperty", "isoffset", "businessunit", "initialrate", "bizdate", "residueterm", "term", "billno", "intdate", "expiredate", "bankaccountnumber", "originalamount", "initialamount", "initialamountrpt"};
    private static final String[] FIELD_NAMES = new String[]{"id", "amount", "frate", "investtype", "investtname", "company", "companyname", "currency", "currencynumber", "currencyname", "finorgtype", "bank", "bankname", "bankcatename", "bankcateid", "accountbank", "accountbankname", "acctproperty", "isoffset", "businessunit", "initialrate", "bizdate", "residueterm", "term", "billno", "intdate", "expiredate", "bankaccountnumber", "originalamount", "initialamount", "initialamountrpt", "billtype", "revenuesort", "principle", "startdate", "enddate", "days", "convertdays", "expectrate", "expectprofit", "realprofit", "datetype", "dayweight", "avgprinciple", "customtype", "querydays", "isdomestic"};
    private static final String[] BENEFIT_INFO_FIELD_ARRAY = new String[]{"revenuesort", "principle", "startdate", "enddate", "days", "convertdays", "expectrate", "expectprofit", "realprofit"};
    private static final String[] EXTRA_FIELD_NAMES = new String[]{"datetype", "dayweight", "avgprinciple", "customtype", "querydays"};
    private static final DataType[] EXTRA_DATA_TYPES = new DataType[]{DataType.IntegerType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.IntegerType};
    private static final String BILL_TYPE_DEPOSIT = "10";
    private static final String BILL_TYPE_COPIED_REDEEM = "30";
    private static final String IS_REAL_BENEFIT = "isrealbenifit";
    private static final String IS_REAL_BENEFIT_YES = "1";
    private static final BigDecimal HUNDRED = new BigDecimal("100");
    private static final String EXPECTED = "'expected'";

    public static DataSet getAllViewData(InvestRequest request) {
        DataSet depositDs = InvestCommonHelper.getDeposit(request);
        DataSet finsubScribeDs = InvestCommonHelper.getFinsubScribe(request);
        boolean isBalanceOnly = request.getDateList() == null;
        String[] selectProps = isBalanceOnly ? BALANCE_FIELD_NAMES : FIELD_NAMES;
        HashSet<String> tranFieldNames = new HashSet<String>(16);
        tranFieldNames.add("amount");
        tranFieldNames.add("initialamountrpt");
        if (!isBalanceOnly) {
            tranFieldNames.add("principle");
            tranFieldNames.add("avgprinciple");
            tranFieldNames.add("expectprofit");
            tranFieldNames.add("realprofit");
        }
        DataSet unionDs = depositDs.select(selectProps).union(finsubScribeDs.select(selectProps));
        if (EmptyUtil.isEmpty(request.getOrgViewId())) {
            return unionDs;
        }
        return AmountTransHelper.tranDataSetRate(unionDs, request.getOrgViewId(), request.getBaseCurrency(), "currency", tranFieldNames, request.getQueryDate());
    }

    private static DataSet getFinsubScribe(InvestRequest request) {
        String algoKey = request.getAlgoKey();
        Date queryDate = request.getQueryDate();
        List<Object[]> dateList = request.getDateList();
        QFilter filter = request.getFilter();
        boolean isBalanceOnly = dateList == null;
        String sic = "id,'20' billtype,'0' isrealbenifit,billno,finaccount bankaccountnumber,redeemway,basis,investvarieties.investtype investtype,investvarieties.name investtname,amount,cleardate,valuedate intdate,expiredate,endinstdate lastrevenuedate,planrevenue frate,iopv,buycopies,surpluscopies,org company,org.name companyname, currency,currency.number currencynumber,currency.name currencyname,finaccountf7.id accountbank, finaccountf7.name accountbankname, finaccountf7.acctproperty.id acctproperty,finorginfo.finorgtype.type finorgtype,finorginfo bank, finorginfo.name bankname, finorginfo.bank_cate.id bankcateid, finorginfo.bank_cate.name bankcatename, finorginfo.country.id country, finorginfo.country.name countryname,case when finorginfo.country.twocountrycode = 'CN' then '1' else case when finorginfo.country.threecountrycode = 'CHN' then '1' else case when finorginfo.country = 0 or (TRIM(finorginfo.country.twocountrycode) = '' and TRIM(finorginfo.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,'0' as isoffset, finorginfo.org businessunit";
        sic = sic + ",amount initialamount, amount initialamountrpt, amount amounttemp";
        DataSet finsubscribeDs = QueryServiceHelper.queryDataSet((String)(algoKey + "finsubscribe"), (String)"cim_finsubscribe", (String)sic, (QFilter[])filter.toArray(), null);
        Set<Long> finsubscribeIds = InvestCommonHelper.getFieldValues(finsubscribeDs.copy(), "id", Long.class);
        finsubscribeDs = InvestCommonHelper.handleRedeem(algoKey, finsubscribeDs, finsubscribeIds, queryDate, "amount");
        finsubscribeDs = finsubscribeDs.addFields(new String[]{"amount", "frate", "to_date('" + DateUtils.formatString(queryDate, "yyyy-MM-dd") + "', 'yy-MM-dd')"}, new String[]{"originalamount", "initialrate", "bizdate"});
        finsubscribeDs = InvestCommonHelper.addTerm(finsubscribeDs, queryDate);
        if (isBalanceOnly) {
            return finsubscribeDs;
        }
        DataSet[] dataSets = finsubscribeDs.splitByFilter(new String[]{"redeemway='amount_redeem'", "redeemway='copies_redeem'"}, false);
        DataSet amountRedeemDs = dataSets[0];
        Set<Long> amountRedeemIds = InvestCommonHelper.getFieldValues(amountRedeemDs.copy(), "id", Long.class);
        amountRedeemDs = InvestCommonHelper.handleRedeem(algoKey, amountRedeemDs, amountRedeemIds, null, "amounttemp");
        DataSet allDs = InvestCommonHelper.amountRedeemBenefits(algoKey, amountRedeemDs, amountRedeemIds);
        DataSet copiesRedeemDs = dataSets[1];
        copiesRedeemDs = copiesRedeemDs.updateField("billtype", "'30'");
        Set<Long> copiesRedeemIds = InvestCommonHelper.getFieldValues(copiesRedeemDs.copy(), "id", Long.class);
        DataSet redeemDs = InvestCommonHelper.queryRedeem(algoKey, copiesRedeemIds, queryDate);
        redeemDs = copiesRedeemDs.rightJoin(redeemDs).on("id", "finbillno").select(copiesRedeemDs.getRowMeta().getFieldNames(), new String[]{"'redeem_revenue' revenuesort", "copies*iopv principle", "redeemdate startdate", "redeemdate enddate", "0 days", "0 convertdays", "0.0 expectrate", "realrevenue expectprofit", "realrevenue realprofit"}).finish();
        redeemDs = redeemDs.updateFields(new String[]{"startdate", IS_REAL_BENEFIT, "expectprofit", "realprofit"}, new String[]{"intdate", "'1'", "case when expectprofit is null then 0.0 else expectprofit end", "case when realprofit is null then 0.0 else realprofit end"});
        copiesRedeemDs = copiesRedeemDs.addFields(new String[]{EXPECTED, "surpluscopies*iopv", "intdate", "expiredate", "0", "0", "case when frate is not null then frate else 0.0 end", "0.0", "0.0"}, BENEFIT_INFO_FIELD_ARRAY);
        allDs = allDs.union(new DataSet[]{redeemDs, copiesRedeemDs});
        return InvestCommonHelper.calculateProfit(allDs, dateList, false, null);
    }

    private static DataSet handleRedeem(String algoKey, DataSet finsubscribeDs, Set<Long> finsubscribeIds, Date queryDate, String amountName) {
        DataSet redeemDs = InvestCommonHelper.queryRedeem(algoKey, finsubscribeIds, queryDate);
        redeemDs = redeemDs.groupBy(new String[]{"finbillno"}).sum("copies").sum("redeemamount").finish();
        DataSet ds = finsubscribeDs.leftJoin(redeemDs).on("id", "finbillno").select(finsubscribeDs.getRowMeta().getFieldNames(), new String[]{"copies", "redeemamount"}).finish();
        ds = ds.updateFields(new String[]{"iopv", "copies", "redeemamount"}, new String[]{"case when iopv is null then 0.0 else iopv end", "case when copies is null then 0.0 else copies end", "case when redeemamount is null then 0.0 else redeemamount end"});
        String s = String.format("case when redeemway='copies_redeem' then %1$s-(copies*iopv) when redeemway='amount_redeem' then %1$s-redeemamount else %1$s end", amountName);
        return ds.updateField(amountName, s).removeFields(new String[]{"copies", "redeemamount"});
    }

    private static DataSet queryRedeem(String algoKey, Set<Long> finsubscribeIds, Date queryDate) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isrenewal='1' OR isrollcapital='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and("finbillno", "in", finsubscribeIds);
        if (queryDate != null) {
            filter.and("redeemdate", "<=", (Object)queryDate);
        }
        String sic = "finbillno,redeemdate,redeemway,copies,amount,realrevenue,case when redeemway='amount_redeem' then amount when redeemway='copies_redeem' then 0.0 else 0.0 end redeemamount";
        return QueryServiceHelper.queryDataSet((String)(algoKey + "redeem"), (String)"cim_redeem", (String)sic, (QFilter[])filter.toArray(), null);
    }

    private static DataSet amountRedeemBenefits(String algoKey, DataSet finsubscribeDs, Set<Long> ids) {
        QFilter filter = new QFilter("finbillno", "in", ids);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("datasource", "=", (Object)"revenue");
        String props = "id benefitid, finbillno sourcebillid,amount realsumprofit,revenuesort,entrys.erevenueamount realprofit,entrys.startdate startdate,entrys.enddate enddate,entrys.days days,entrys.finamount principle,entrys.eplanrevenue expectrate,entrys.convertdays convertdays,entrys.erevenueamount expectprofit";
        DataSet benefitsDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cim_revenue", (String)props, (QFilter[])filter.toArray(), (String)"finbillno,entrys.enddate");
        benefitsDs = InvestCommonHelper.fixExpectProfit(benefitsDs);
        DataSet realDs = finsubscribeDs.rightJoin(benefitsDs).on("id", "sourcebillid").select(finsubscribeDs.getRowMeta().getFieldNames(), BENEFIT_INFO_FIELD_ARRAY).finish();
        realDs = realDs.updateField(IS_REAL_BENEFIT, "'1'");
        finsubscribeDs = finsubscribeDs.addFields(new String[]{EXPECTED, "amounttemp", "case when lastrevenuedate is not null then lastrevenuedate else intdate end", "expiredate", "0", "0", "case when frate is not null then frate else 0.0 end", "0.0", "0.0"}, BENEFIT_INFO_FIELD_ARRAY);
        return realDs.union(finsubscribeDs);
    }

    private static DataSet getDeposit(InvestRequest request) {
        String algoKey = request.getAlgoKey();
        Date queryDate = request.getQueryDate();
        List<Object[]> dateList = request.getDateList();
        QFilter filter = request.getDepositFilter();
        boolean isBalanceOnly = dateList == null;
        String sic = "id,'10' billtype,'0' isrealbenifit,billno,finaccount bankaccountnumber,investvarieties.investtype investtype,investvarieties.name investtname,interesttype,referencerate,ratesign,ratefloatpoint,amount,interestrate frate, intdate,cleardate,expiredate,lastrevenuedate,org company,org.name companyname, currency,currency.number currencynumber,currency.name currencyname,case when finorginfo.country.twocountrycode = 'CN' then '1' else case when finorginfo.country.threecountrycode = 'CHN' then '1' else case when finorginfo.country = 0 or (TRIM(finorginfo.country.twocountrycode) = '' and TRIM(finorginfo.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,settleaccount.id accountbank, settleaccount.name accountbankname, settleaccount.acctproperty.id acctproperty,finorginfo.finorgtype.type finorgtype,finorginfo bank,finorginfo.name bankname, finorginfo.bank_cate.name bankcatename,finorginfo.bank_cate.id bankcateid,'0' as isoffset, finorginfo.org businessunit";
        sic = sic + ",amount initialamount, amount initialamountrpt, amount amounttemp";
        DataSet depositDs = QueryServiceHelper.queryDataSet((String)(algoKey + "Deposit"), (String)"cim_deposit", (String)sic, (QFilter[])filter.toArray(), null);
        Set<Long> depositIds = InvestCommonHelper.getFinBillNos(depositDs);
        depositDs = InvestCommonHelper.handleDepositRelease(algoKey, depositDs, depositIds, queryDate, "amount");
        depositDs = depositDs.addFields(new String[]{"amount", "frate", "to_date('" + DateUtils.formatString(queryDate, "yyyy-MM-dd") + "', 'yy-MM-dd')"}, new String[]{"originalamount", "initialrate", "bizdate"});
        Set<Long> referRateIds = FloatRateHelper.getReferRateIds(depositDs.copy());
        depositDs = FloatRateHelper.updateFloatRate(depositDs, referRateIds, queryDate);
        depositDs = InvestCommonHelper.addTerm(depositDs, queryDate);
        if (isBalanceOnly) {
            return depositDs;
        }
        depositDs = InvestCommonHelper.handleDepositRelease(algoKey, depositDs, depositIds, null, "amounttemp");
        DataSet allDs = InvestCommonHelper.depositBenefits(algoKey, depositDs, depositIds);
        return InvestCommonHelper.calculateProfit(allDs, dateList, true, referRateIds);
    }

    private static DataSet handleDepositRelease(String algoKey, DataSet depositDs, Set<Long> depositIds, Date queryDate, String amountName) {
        DataSet releaseDs = InvestCommonHelper.queryDepositRelease(algoKey, depositIds, queryDate);
        depositDs = depositDs.leftJoin(releaseDs).on("id", "finbillno").select(depositDs.getRowMeta().getFieldNames(), new String[]{"ramount"}).finish();
        return depositDs.updateField(amountName, String.format("case when ramount is null then %1$s else %1$s-ramount end", amountName)).removeFields(new String[]{"ramount"});
    }

    private static DataSet queryDepositRelease(String algoKey, Set<Long> depositIds, Date queryDate) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR expireredeposit in('principalredeposit','principalintredeposit'))", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and("finbillno", "in", depositIds);
        if (queryDate != null) {
            filter.and("redeemdate", "<=", (Object)queryDate);
        }
        String sic = "finbillno,amount ramount,redeemdate";
        DataSet releaseDs = QueryServiceHelper.queryDataSet((String)(algoKey + "NoticeDepositRelease"), (String)"cim_release", (String)sic, (QFilter[])filter.toArray(), null);
        return releaseDs.groupBy(new String[]{"finbillno"}).sum("ramount").finish();
    }

    private static DataSet depositBenefits(String algoKey, DataSet depositDs, Set<Long> depositIds) {
        QFilter filter = new QFilter("sourcebillid", "in", depositIds);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        String props = "id benefitid, sourcebillid,actpreinstamt realsumprofit,revenuesort,entrys.instprincipalamt principle,entrys.inststartdate startdate,entrys.instenddate enddate,entrys.instdays days,entrys.ratetrandays convertdays,entrys.rate expectrate,entrys.instamt expectprofit,entrys.instamt realprofit";
        DataSet benefitsDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cim_dptrevenue", (String)props, (QFilter[])filter.toArray(), (String)"sourcebillid,entrys.instenddate");
        benefitsDs = InvestCommonHelper.fixExpectProfit(benefitsDs);
        DataSet realDs = depositDs.rightJoin(benefitsDs).on("id", "sourcebillid").select(depositDs.getRowMeta().getFieldNames(), BENEFIT_INFO_FIELD_ARRAY).finish();
        realDs = realDs.updateField(IS_REAL_BENEFIT, "'1'");
        depositDs = depositDs.addFields(new String[]{EXPECTED, "amounttemp", "case when lastrevenuedate is not null then lastrevenuedate else intdate end", "expiredate", "0", "0", "case when frate is not null then frate else 0.0 end", "0.0", "0.0"}, BENEFIT_INFO_FIELD_ARRAY);
        return realDs.union(depositDs);
    }

    private static DataSet fixExpectProfit(DataSet ds) {
        DataSet daysRateDs = ds.groupBy(new String[]{"benefitid"}).sum("expectprofit", "days_rate_sum").finish();
        ds = ds.leftJoin(daysRateDs).on("benefitid", "benefitid").select(ds.getRowMeta().getFieldNames(), new String[]{"days_rate_sum"}).finish();
        return ds.updateField("expectprofit", "case when days_rate_sum is null or days_rate_sum=0 then expectprofit when realsumprofit is null then 0.0 else realsumprofit*(expectprofit/days_rate_sum) end");
    }

    private static DataSet calculateProfit(DataSet ds, List<Object[]> dateList, boolean handleFloatRate, Set<Long> referRateIds) {
        DataType[] dataTypes = ds.getRowMeta().getDataTypes();
        String[] fieldNames = ds.getRowMeta().getFieldNames();
        String[] newFieldNames = new String[fieldNames.length + EXTRA_FIELD_NAMES.length];
        DataType[] newDataTypes = new DataType[dataTypes.length + EXTRA_DATA_TYPES.length];
        System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
        System.arraycopy(EXTRA_FIELD_NAMES, 0, newFieldNames, fieldNames.length, EXTRA_FIELD_NAMES.length);
        System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
        System.arraycopy(EXTRA_DATA_TYPES, 0, newDataTypes, dataTypes.length, EXTRA_DATA_TYPES.length);
        RowMeta builderMeta = RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
        DataSetBuilder builder = Algo.create((String)"InvestDataHelper.calculateProfit").createDataSetBuilder(builderMeta);
        Map<Long, Map<Date, String>> allReferRateDataMap = null;
        HashMap<String, DepositRow> depositRowMap = null;
        if (handleFloatRate) {
            Date queryEndDate = (Date)dateList.get(dateList.size() - 1)[1];
            allReferRateDataMap = FloatRateHelper.getReferRateDataMap(referRateIds, queryEndDate);
            depositRowMap = new HashMap<String, DepositRow>(1024);
        }
        for (Row row : ds) {
            InvestCommonHelper.dealQueryDate(dateList, fieldNames, builder, row, allReferRateDataMap, depositRowMap);
        }
        DataSet buildDs = builder.build();
        if (!handleFloatRate) {
            return buildDs;
        }
        builder = Algo.create((String)"InvestDataHelper.calculateProfit2").createDataSetBuilder(builderMeta);
        for (Row row : buildDs) {
            InvestCommonHelper.splitOnFloatRate(newFieldNames, builder, row, depositRowMap);
        }
        return builder.build();
    }

    private static void dealQueryDate(List<Object[]> dateList, String[] fieldNames, DataSetBuilder builder, Row row, Map<Long, Map<Date, String>> allReferRateDataMap, Map<String, DepositRow> depositRowMap) {
        BigDecimal principle = row.getBigDecimal("principle");
        if (EmptyUtil.isEmpty(principle)) {
            return;
        }
        String billType = row.getString("billtype");
        String isRealBenefit = row.getString(IS_REAL_BENEFIT);
        BigDecimal expectRate = row.getBigDecimal("expectrate");
        if (BILL_TYPE_COPIED_REDEEM.equals(billType) && !IS_REAL_BENEFIT_YES.equals(isRealBenefit) && EmptyUtil.isEmpty(expectRate)) {
            return;
        }
        for (int i = 0; i < dateList.size(); ++i) {
            BigDecimal days;
            boolean isIntersect;
            if (dateList.get(i).length < 3) {
                return;
            }
            Date queryBeginDate = (Date)dateList.get(i)[0];
            Date queryEndDate = (Date)dateList.get(i)[1];
            Date beginDate = (Date)row.get("startdate");
            Date endDate = (Date)row.get("enddate");
            if (BILL_TYPE_COPIED_REDEEM.equals(billType) && IS_REAL_BENEFIT_YES.equals(isRealBenefit) && endDate != null) {
                endDate = DateUtils.getNextDay(endDate, -1);
            }
            if (beginDate == null) {
                beginDate = queryBeginDate;
            }
            if (endDate == null) {
                endDate = queryEndDate;
            }
            boolean bl = isIntersect = beginDate.compareTo(queryEndDate) <= 0 && endDate.compareTo(queryBeginDate) >= 0;
            if (!isIntersect) continue;
            ArrayList<Object> appendRow = new ArrayList<Object>(fieldNames.length + EXTRA_FIELD_NAMES.length);
            Date lastBeginDate = beginDate.compareTo(queryBeginDate) >= 0 ? beginDate : queryBeginDate;
            Date lastEndDate = endDate.compareTo(queryEndDate) <= 0 ? endDate : queryEndDate;
            int realDays = DateUtils.getDiffDays(lastBeginDate, lastEndDate);
            int queryDays = DateUtils.getDiffDays(queryBeginDate, queryEndDate);
            BigDecimal dayWeight = new BigDecimal(realDays).divide(new BigDecimal(queryDays), 8, RoundingMode.HALF_UP);
            Integer convertDays = row.getInteger("convertdays");
            if (EmptyUtil.isEmpty(convertDays)) {
                convertDays = InvestCommonHelper.getBasisDays(row, lastEndDate);
            }
            if (EmptyUtil.isEmpty(days = new BigDecimal(row.getString("days")))) {
                days = new BigDecimal(DateUtils.getDiffDays(beginDate, endDate));
            }
            BigDecimal expectProfit = row.getBigDecimal("expectprofit");
            if (IS_REAL_BENEFIT_YES.equals(isRealBenefit)) {
                expectProfit = EmptyUtil.isEmpty(expectProfit) ? BigDecimal.ZERO : expectProfit.multiply(new BigDecimal(realDays)).divide(days, 8, RoundingMode.HALF_UP);
            }
            for (int j = 0; j < fieldNames.length; ++j) {
                boolean isEmpty;
                String fieldName = fieldNames[j];
                if (IS_REAL_BENEFIT_YES.equals(isRealBenefit) && "expectprofit".equals(fieldName)) {
                    appendRow.add(expectProfit);
                    continue;
                }
                if (IS_REAL_BENEFIT_YES.equals(isRealBenefit) && "expectrate".equals(fieldName)) {
                    isEmpty = EmptyUtil.isEmpty(expectProfit);
                    appendRow.add(isEmpty ? BigDecimal.ZERO : expectProfit.multiply(HUNDRED).multiply(new BigDecimal(convertDays)).divide(principle, 8, RoundingMode.HALF_UP).divide(new BigDecimal(realDays), 8, RoundingMode.HALF_UP));
                    continue;
                }
                if (!IS_REAL_BENEFIT_YES.equals(isRealBenefit) && "expectprofit".equals(fieldName)) {
                    isEmpty = EmptyUtil.isEmpty(expectRate);
                    appendRow.add(isEmpty ? BigDecimal.ZERO : principle.multiply(expectRate).multiply(new BigDecimal(realDays)).divide(new BigDecimal(convertDays), 8, RoundingMode.HALF_UP).divide(HUNDRED, 8, RoundingMode.HALF_UP));
                    continue;
                }
                if ("startdate".equals(fieldName)) {
                    appendRow.add(lastBeginDate);
                    continue;
                }
                if ("enddate".equals(fieldName)) {
                    appendRow.add(lastEndDate);
                    continue;
                }
                if ("days".equals(fieldName)) {
                    appendRow.add(realDays);
                    continue;
                }
                if ("convertdays".equals(fieldName)) {
                    appendRow.add(convertDays);
                    continue;
                }
                appendRow.add(row.get(fieldName));
            }
            appendRow.add(i);
            appendRow.add(dayWeight);
            appendRow.add(principle.multiply(dayWeight));
            String customType = (String)dateList.get(i)[2];
            appendRow.add(customType);
            appendRow.add(queryDays);
            builder.append(appendRow.toArray());
            if (!BILL_TYPE_DEPOSIT.equals(billType)) continue;
            InvestCommonHelper.buildDepositRowMap(row, lastBeginDate, lastEndDate, customType, allReferRateDataMap, depositRowMap);
        }
    }

    private static void buildDepositRowMap(Row row, Date lastBeginDate, Date lastEndDate, String customType, Map<Long, Map<Date, String>> allReferRateDataMap, Map<String, DepositRow> depositRowMap) {
        Map<Date, String> referRateDataMap;
        if (IS_REAL_BENEFIT_YES.equals(row.getString(IS_REAL_BENEFIT))) {
            return;
        }
        String interestType = row.getString("interesttype");
        Long referenceRateId = row.getLong("referencerate");
        if ("float".equals(interestType) && referenceRateId != null && !EmptyUtil.isEmpty(referRateDataMap = allReferRateDataMap.get(referenceRateId))) {
            DepositRow depositRow = new DepositRow(row, lastBeginDate, lastEndDate, customType, referRateDataMap);
            depositRowMap.put(depositRow.key(), depositRow);
        }
    }

    private static void splitOnFloatRate(String[] newFieldNames, DataSetBuilder builder, Row row, Map<String, DepositRow> depositRowMap) {
        if (IS_REAL_BENEFIT_YES.equals(row.getString(IS_REAL_BENEFIT))) {
            InvestCommonHelper.appendRow(newFieldNames, builder, row);
            return;
        }
        String key = DepositRow.generateKey(row.getLong("id"), row.getString("customtype"), row.getDate("startdate"));
        DepositRow depositRow = depositRowMap.get(key);
        if (depositRow == null) {
            InvestCommonHelper.appendRow(newFieldNames, builder, row);
            return;
        }
        BigDecimal principle = row.getBigDecimal("principle");
        int convertDays = row.getInteger("convertdays");
        BigDecimal queryDays = row.getBigDecimal("querydays");
        List<Object[]> dateList = depositRow.getDateList();
        for (int i = 0; i < dateList.size(); ++i) {
            Object[] dateArray = dateList.get(i);
            if (dateArray.length < 3) continue;
            ArrayList<Object> appendRow = new ArrayList<Object>(newFieldNames.length);
            Date startDate = (Date)dateArray[0];
            Date endDate = (Date)dateArray[1];
            BigDecimal expectRate = (BigDecimal)dateArray[2];
            int realDays = DateUtils.getDiffDays(startDate, endDate);
            BigDecimal newDayWeight = new BigDecimal(realDays).divide(queryDays, 10, RoundingMode.HALF_UP);
            for (int j = 0; j < newFieldNames.length; ++j) {
                String fieldName = newFieldNames[j];
                if ("startdate".equals(fieldName)) {
                    appendRow.add(startDate);
                    continue;
                }
                if ("enddate".equals(fieldName)) {
                    appendRow.add(endDate);
                    continue;
                }
                if ("expectrate".equals(fieldName)) {
                    appendRow.add(dateArray[2]);
                    continue;
                }
                if ("days".equals(fieldName)) {
                    appendRow.add(realDays);
                    continue;
                }
                if ("expectprofit".equals(fieldName)) {
                    boolean isEmpty = EmptyUtil.isEmpty(expectRate);
                    appendRow.add(isEmpty ? BigDecimal.ZERO : principle.multiply(expectRate).multiply(new BigDecimal(realDays)).divide(new BigDecimal(convertDays), 4, RoundingMode.HALF_UP).divide(HUNDRED, 4, RoundingMode.HALF_UP));
                    continue;
                }
                if ("dayweight".equals(fieldName)) {
                    appendRow.add(newDayWeight);
                    continue;
                }
                if ("avgprinciple".equals(fieldName)) {
                    appendRow.add(principle.multiply(newDayWeight));
                    continue;
                }
                appendRow.add(row.get(fieldName));
            }
            builder.append(appendRow.toArray());
        }
    }

    private static void appendRow(String[] newFieldNames, DataSetBuilder builder, Row row) {
        Object[] appendRow = new Object[newFieldNames.length];
        for (int i = 0; i < newFieldNames.length; ++i) {
            appendRow[i] = row.get(newFieldNames[i]);
        }
        builder.append(appendRow);
    }

    private static Set<Long> getFinBillNos(DataSet depositDs) {
        return InvestCommonHelper.getFieldValues(depositDs.copy(), "id", Long.class);
    }

    private static int getBasisDays(Row row, Date bizDate) {
        try {
            String basis = row.getString("basis");
            BasisEnum basisEnum = BasisEnum.getEnum(basis);
            if (basisEnum == null) {
                return 365;
            }
            int year = DateUtils.getYear(bizDate);
            return TermHelper.getBasis_YearDay(year, basisEnum);
        }
        catch (Exception e) {
            return 365;
        }
    }

    private static DataSet addTerm(DataSet ds, final Date queryDate) {
        ds = ds.addFields(new String[]{"''", "''"}, new String[]{"residueterm", "term"});
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                String residueTerm;
                String term;
                Date expireDate = row.getDate("expiredate");
                if (expireDate == null) {
                    term = "";
                    residueTerm = "";
                } else if (queryDate.compareTo(expireDate) > 0) {
                    term = DateUtils.getDiff_ymd(row.getDate("intdate"), expireDate);
                    residueTerm = "-1d";
                } else if (queryDate.compareTo(expireDate) == 0) {
                    term = DateUtils.getDiff_ymd(row.getDate("intdate"), expireDate);
                    residueTerm = "0d";
                } else {
                    Date intDate = row.getDate("intdate");
                    term = DateUtils.getDiff_ymd(intDate, expireDate);
                    residueTerm = DateUtils.getDiff_ymd(queryDate, expireDate);
                }
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("term".equals(fieldName)) {
                        rowInfo.add(term);
                        continue;
                    }
                    if ("residueterm".equals(fieldName)) {
                        rowInfo.add(residueTerm);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<T> getFieldValues(DataSet ds, String fieldName, Class<T> clazz) {
        HashSet<Object> set = new HashSet<Object>(1024);
        try {
            for (Row row : ds) {
                Object value;
                if (Long.class.equals(clazz)) {
                    value = row.getLong(fieldName);
                    if (value == null) continue;
                    set.add(value);
                    continue;
                }
                value = row.getString(fieldName);
                if (value == null) continue;
                set.add(value);
            }
            HashSet<Object> hashSet = set;
            return hashSet;
        }
        finally {
            ds.close();
        }
    }
}

