/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.enums.ReturnValTypeEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MarketDataHelper {
    public static PriceRuleInfo yieldCurve(IFormView view, DynamicObject priceRule, Long[] marketIds, Date referDate, Date[] intDate, YieldTypeEnum yieldType, ReturnValTypeEnum valType, String fxquote) {
        return MarketDataHelper.yieldCurve(view, priceRule, marketIds, referDate, null, intDate, yieldType, valType, fxquote);
    }

    public static PriceRuleInfo yieldCurve(IFormView view, DynamicObject priceRule, Long[] marketIds, Date referDate, Date[] intDate, YieldTypeEnum yieldType, ReturnValTypeEnum valType) {
        return MarketDataHelper.yieldCurve(view, priceRule, marketIds, referDate, null, intDate, yieldType, valType, null);
    }

    public static BigDecimal getRateOrFurRateByYieldCurve(IFormView view, YieldTypeEnum yieldType, ReturnValTypeEnum valType, DynamicObject priceRule, Long marketId, Date referDate, Date furdate, Date intDate) {
        PriceRuleInfo info = MarketDataHelper.yieldCurve(view, priceRule, new Long[]{marketId}, referDate, furdate, new Date[]{intDate}, yieldType, valType, null);
        return info.getYieldCurve()[0].getDfMap().get(intDate);
    }

    public static Map<Date, BigDecimal> getRateByYieldCurve(IFormView view, YieldTypeEnum yieldType, DynamicObject priceRule, Long marketId, Date referdate, Date[] intDate) {
        PriceRuleInfo info = MarketDataHelper.yieldCurve(view, priceRule, new Long[]{marketId}, referdate, null, intDate, yieldType, ReturnValTypeEnum.rate, null);
        return info.getYieldCurve()[0].getDfMap();
    }

    public static Map<Date, BigDecimal> getFurRateByYieldCurve(IFormView view, YieldTypeEnum yieldType, DynamicObject priceRule, Long marketId, Date referdate, Date furdate, Date[] intDate) {
        PriceRuleInfo info = MarketDataHelper.yieldCurve(view, priceRule, new Long[]{marketId}, referdate, furdate, intDate, yieldType, ReturnValTypeEnum.furrate, null);
        return info.getYieldCurve()[0].getDfMap();
    }

    public static Map<Date, BigDecimal> getFurRateByBatchYieldCurve(IFormView view, YieldTypeEnum yieldType, DynamicObject priceRule, Long marketId, Date referdate, Map<Date, List<Date>> dataMap) {
        PriceRuleInfo info = MarketDataHelper.batchYieldCurve(view, priceRule, new Long[]{marketId}, referdate, dataMap, yieldType, ReturnValTypeEnum.furrate, null);
        return info.getYieldCurve()[0].getDfMap();
    }

    public static PriceRuleInfo getDiscfactor(IFormView view, Date referdate, DynamicObject priceRule, Long[] marketIds, Date[] intDate) {
        return MarketDataHelper.yieldCurve(view, priceRule, marketIds, referdate, null, intDate, YieldTypeEnum.disc, ReturnValTypeEnum.df, null);
    }

    public static Map<Date, BigDecimal> getDiscfactor(IFormView view, Date referdate, DynamicObject priceRule, Long marketId, Date intDate) {
        PriceRuleInfo info = MarketDataHelper.yieldCurve(view, priceRule, new Long[]{marketId}, referdate, null, new Date[]{intDate}, YieldTypeEnum.disc, ReturnValTypeEnum.df, null);
        return info.getYieldCurve()[0].getDfMap();
    }

    private static PriceRuleInfo yieldCurve(IFormView view, DynamicObject priceRule, Long[] marketIds, Date referDate, Date furDate, Date[] intDates, YieldTypeEnum yieldType, ReturnValTypeEnum valType, String fxquote) {
        PriceRuleInfo param = new PriceRuleInfo();
        YieldCurveInfo[] YieldCurve = new YieldCurveInfo[marketIds.length];
        for (int index = 0; index < marketIds.length; ++index) {
            YieldCurveInfo yieldCurve = new YieldCurveInfo();
            yieldCurve.setReferDate(referDate);
            yieldCurve.setYieldType(yieldType);
            yieldCurve.setValType(valType);
            yieldCurve.setMarketId(marketIds[index]);
            HashMap<Date, BigDecimal> dfMap = new HashMap<Date, BigDecimal>(512);
            if (ReturnValTypeEnum.furrate == valType && EmptyUtil.isNoEmpty(furDate)) {
                yieldCurve.setFurDate(furDate);
                dfMap.put(furDate, null);
            }
            for (Date intDate : intDates) {
                dfMap.put(intDate, null);
            }
            yieldCurve.setDfMap(dfMap);
            YieldCurve[index] = yieldCurve;
        }
        param.setYieldCurve(YieldCurve);
        if (EmptyUtil.isNotEmpty((CharSequence)fxquote)) {
            ForexQuoteInfo forexQuote = new ForexQuoteInfo();
            param.setForexQuote(new ForexQuoteInfo[]{forexQuote});
            forexQuote.setFxquote(fxquote);
        }
        return MarketDataServiceHelper.getPriceRule(view, priceRule.getLong("id"), param);
    }

    private static PriceRuleInfo batchYieldCurve(IFormView view, DynamicObject priceRule, Long[] marketIds, Date referDate, Map<Date, List<Date>> DateMap, YieldTypeEnum yieldType, ReturnValTypeEnum valType, String fxquote) {
        PriceRuleInfo param = new PriceRuleInfo();
        ArrayList<YieldCurveInfo> list = new ArrayList<YieldCurveInfo>(marketIds.length);
        for (int index = 0; index < marketIds.length; ++index) {
            YieldCurveInfo yieldCurve = new YieldCurveInfo();
            yieldCurve.setReferDate(referDate);
            yieldCurve.setYieldType(yieldType);
            yieldCurve.setValType(valType);
            yieldCurve.setMarketId(marketIds[index]);
            yieldCurve.setFurDateToQueryDateMap(DateMap);
            list.add(yieldCurve);
        }
        param.setYieldCurve(list.toArray(new YieldCurveInfo[0]));
        if (EmptyUtil.isNotEmpty((CharSequence)fxquote)) {
            ForexQuoteInfo forexQuote = new ForexQuoteInfo();
            param.setForexQuote(new ForexQuoteInfo[]{forexQuote});
            forexQuote.setFxquote(fxquote);
        }
        return MarketDataServiceHelper.getPriceRule(view, priceRule.getLong("id"), param);
    }

    public static ForexQuoteInfo spotExRate(IFormView view, DynamicObject priceRule, String fxquote, Date issueTime) {
        if (!priceRule.getDynamicObjectType().getProperties().containsKey((Object)"forexquote")) {
            priceRule = TmcDataServiceHelper.loadSingleFromCache((Object)priceRule.getPkValue(), (String)"md_pricerule", (String)"forexquote");
        }
        Long forexQuoteId = priceRule.getDynamicObject("forexquote").getLong("id");
        ForexQuoteInfo forexQuote = new ForexQuoteInfo();
        forexQuote.setFxquote(fxquote);
        forexQuote.setIssuetime(issueTime);
        return MarketDataServiceHelper.querySpotForexQuote(view, forexQuoteId, forexQuote);
    }

    public static ForexQuoteInfo getForexQuoteInfo(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        return MarketDataServiceHelper.getForexQuoteInfo(forexQuoteId, currencyPair, issueTime, Dm);
    }

    public static BigDecimal yieldCurve(long yieldCurveId, YieldTypeEnum yieldType, ReturnValTypeEnum valType, Date referDate, Date furDate, Date intDate) {
        YieldCurveInfo yieldCurve = new YieldCurveInfo();
        yieldCurve.setYieldCurveId(yieldCurveId);
        yieldCurve.setReferDate(referDate);
        yieldCurve.setYieldType(yieldType);
        yieldCurve.setValType(valType);
        HashMap<Date, BigDecimal> dfMap = new HashMap<Date, BigDecimal>(16);
        if (ReturnValTypeEnum.furrate == valType && EmptyUtil.isNoEmpty(furDate)) {
            yieldCurve.setFurDate(furDate);
            dfMap.put(furDate, null);
        }
        dfMap.put(intDate, null);
        yieldCurve.setDfMap(dfMap);
        YieldCurveInfo yieldCurveInfo = MarketDataServiceHelper.yieldCurve(yieldCurve);
        return yieldCurveInfo.getDfMap().get(intDate);
    }

    public static Map<String, Map<Date, BigDecimal>> batchReferRate(Set<String> rateNums, Date beginDate, Date endDate) {
        if (EmptyUtil.isEmpty(beginDate) || EmptyUtil.isEmpty(endDate) || beginDate.compareTo(endDate) > 0) {
            return null;
        }
        TreeMap<String, Map<Date, BigDecimal>> result = new TreeMap<String, Map<Date, BigDecimal>>();
        QFilter filter = new QFilter("referrate.number", "in", rateNums).and(new QFilter("enable", "=", (Object)"1")).and("bizdate", "<", (Object)DateUtils.getNextDay(endDate, 1));
        DynamicObjectCollection referRates = QueryServiceHelper.query((String)"md_datarate", (String)"id,referrate.number,bizdate,endprice", (QFilter[])filter.toArray(), (String)"bizdate asc");
        if (EmptyUtil.isNoEmpty(referRates)) {
            Map<String, List<DynamicObject>> referrateMap = referRates.stream().collect(Collectors.groupingBy(o -> o.getString("referrate.number")));
            for (Map.Entry<String, List<DynamicObject>> referRateEntry : referrateMap.entrySet()) {
                TreeMap tempFirstMap = new TreeMap(Comparator.reverseOrder());
                TreeMap<Date, BigDecimal> valResult = new TreeMap<Date, BigDecimal>(Date::compareTo);
                String rateNumKey = referRateEntry.getKey();
                List<DynamicObject> referRateVals = referRateEntry.getValue();
                for (DynamicObject referRateVal : referRateVals) {
                    Date bizdate = DateUtils.truncateDate(referRateVal.getDate("bizdate"));
                    BigDecimal endprice = referRateVal.getBigDecimal("endprice");
                    if (bizdate.compareTo(beginDate) <= 0) {
                        tempFirstMap.put(bizdate, endprice);
                        continue;
                    }
                    valResult.put(bizdate, endprice);
                }
                if (EmptyUtil.isNoEmpty(tempFirstMap)) {
                    tempFirstMap.entrySet().stream().findFirst().ifPresent(o -> {
                        BigDecimal cfr_ignored_0 = (BigDecimal)valResult.put((Date)o.getKey(), (BigDecimal)o.getValue());
                    });
                }
                result.put(rateNumKey, valResult);
            }
        }
        return result;
    }
}

