/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MutexServiceHelper {
    protected static final String MUTEX_DATAOBJID = "dataObjId";
    protected static final String MUTEX_GROUPID = "groupId";
    protected static final String MUTEX_ENTITYKEY = "entityKey";
    protected static final String MUTEX_OPERATIONKEY = "operationKey";
    protected static final String MUTEX_ISSTRICT = "isStrict";
    protected static final String MUTEX_AUTOCLEARLOSTLOCK = "autoclearlostlock";
    protected static final String MUTEX_MAXLOCKTIME = "maxlocktime_s";

    public static Map<String, Boolean> batchRequest(List<String> ids, String entityKey, String opKey) {
        String group = "op_" + opKey;
        if (EmptyUtil.isNoEmpty(ids)) {
            ids = ids.stream().distinct().collect(Collectors.toList());
        }
        return MutexServiceHelper.batchRequest(ids, group, entityKey, opKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> batchRequest(List<String> ids, String group, String entityKey, String opKey) {
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (int index = 0; index < ids.size(); ++index) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, ids.get(index));
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, Boolean.TRUE);
            mutexRequireList.add(requireParam);
        }
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            Map map = dataMutex.batchrequire(mutexRequireList);
            return map;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Map<String, Boolean> batchRelease(List<String> ids, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.batchRelease(ids, group, entityKey, opKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> batchRelease(List<String> ids, String group, String entityKey, String opKey) {
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (int index = 0; index < ids.size(); ++index) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, ids.get(index));
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, Boolean.TRUE);
            mutexRequireList.add(requireParam);
        }
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            Map map = dataMutex.batchRelease(mutexRequireList);
            return map;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean request(String id, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.request(id, group, entityKey, opKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean request(String id, String group, String entityKey, String opKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            boolean bl = dataMutex.require(id, group, entityKey, opKey, true);
            return bl;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean requestWithLostTime(String id, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.requestWithLostTime(id, group, entityKey, opKey, true, 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requestWithLostTime(String id, String group, String entityKey, String opKey, boolean autoClearLostLock, long maxLockTime) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        MutexLockInfo lockInfo = new MutexLockInfo(id, (String)null, group, entityKey, opKey, true, (String)null, autoClearLostLock, maxLockTime);
        try {
            boolean bl = dataMutex.require(lockInfo);
            return bl;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Map<String, Boolean> batchRequestWithLostTime(List<String> ids, String entityKey, String opKey) {
        String group = "op_" + opKey;
        if (EmptyUtil.isNoEmpty(ids)) {
            ids = ids.stream().distinct().collect(Collectors.toList());
        }
        return MutexServiceHelper.batchRequestWithLostTime(ids, group, entityKey, opKey, true, 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> batchRequestWithLostTime(List<String> ids, String group, String entityKey, String opKey, boolean autoClearLostLock, long maxLockTime) {
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (int index = 0; index < ids.size(); ++index) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, ids.get(index));
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, Boolean.TRUE);
            requireParam.put(MUTEX_AUTOCLEARLOSTLOCK, autoClearLostLock);
            requireParam.put(MUTEX_MAXLOCKTIME, maxLockTime);
            mutexRequireList.add(requireParam);
        }
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            Map map = dataMutex.batchrequire(mutexRequireList);
            return map;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean release(String id, String entityKey, String operationKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            boolean bl = dataMutex.release(id, entityKey, operationKey);
            return bl;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<String> getRequestResultList(DynamicObject[] dataEntities, List<OperateErrorInfo> errors, Map<String, Boolean> request) {
        ArrayList<String> requestIds = new ArrayList<String>();
        TmcErrorCode tmcErrorCode = new TmcErrorCode();
        for (Map.Entry<String, Boolean> entry : request.entrySet()) {
            String id = entry.getKey();
            if (!entry.getValue().booleanValue()) {
                OperateErrorInfo error = new OperateErrorInfo();
                error.setPkValue((Object)id);
                error.setLevel(ErrorLevel.Error);
                error.setMessage(tmcErrorCode.BILL_MUTEX_LOCK().getMessage());
                errors.add(error);
                continue;
            }
            for (DynamicObject info : dataEntities) {
                if (!info.getString("id").equals(id)) continue;
                requestIds.add(id);
            }
        }
        return requestIds;
    }

    public static List<String> getRequestResultList(List<String> originIdList, List<OperateErrorInfo> errors, Map<String, Boolean> request) {
        ArrayList<String> requestIds = new ArrayList<String>();
        TmcErrorCode tmcErrorCode = new TmcErrorCode();
        for (Map.Entry<String, Boolean> entry : request.entrySet()) {
            String id = entry.getKey();
            if (!entry.getValue().booleanValue()) {
                OperateErrorInfo error = new OperateErrorInfo();
                error.setPkValue((Object)id);
                error.setLevel(ErrorLevel.Error);
                error.setMessage(tmcErrorCode.BILL_MUTEX_LOCK().getMessage());
                errors.add(error);
                continue;
            }
            for (String originId : originIdList) {
                if (!originId.equals(id)) continue;
                requestIds.add(id);
            }
        }
        return requestIds;
    }
}

