/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.LinkedList;
import java.util.Queue;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SerialNumberHelper {
    private static Log logger = LogFactory.getLog(SerialNumberHelper.class);
    private static final String LOCK_PREFIX = "__FBD_SERIALNUM_DLOCK_";
    private static final String FBD_ENTRY_MAXSERIALNUM = "fbd_maxserialnum";

    private SerialNumberHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue<String> getSerialNum(String entityType, String propType, String prefix, int len, int cnt) {
        String key = LOCK_PREFIX + entityType + "_" + propType;
        DLock dl = DLock.create((String)key);
        boolean locked = dl.tryLock(3000L);
        if (!locked) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u6d41\u6c34\u53f7\u5931\u8d25:\u5f53\u524d\u5b57\u6bb5\u6b63\u5728\u751f\u6210\u6d41\u6c34\u53f7\u3002", (String)"SerialNumberHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
        }
        try {
            logger.info(ResManager.loadKDString((String)String.format("FBP \u6d41\u6c34\u53f7\u751f\u6210\u5668\u83b7\u5f97DLock\u9501:%s", key), (String)"SerialNumberHelper_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
            QFilter entityTypeFilter = new QFilter("entityname", "=", (Object)entityType);
            QFilter propTypeFilter = new QFilter("propkey", "=", (Object)propType);
            QFilter prefixFilter = new QFilter("prefix", "=", (Object)prefix);
            DynamicObject maxNumBill = BusinessDataServiceHelper.loadSingle((String)FBD_ENTRY_MAXSERIALNUM, (String)"maxserialnum", (QFilter[])new QFilter[]{entityTypeFilter, propTypeFilter, prefixFilter});
            if (maxNumBill == null) {
                maxNumBill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FBD_ENTRY_MAXSERIALNUM));
                maxNumBill.set("entityname", (Object)entityType);
                maxNumBill.set("propkey", (Object)propType);
                maxNumBill.set("prefix", (Object)prefix);
            }
            Long curMaxNum = maxNumBill.getLong("maxserialnum");
            LinkedList<String> serialNumList = new LinkedList<String>();
            for (int i = 0; i < cnt; ++i) {
                curMaxNum = curMaxNum + 1L;
                String numStr = "" + curMaxNum;
                if (len < numStr.length()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u8d85\u8fc7\u6700\u5927\u9650\u5ea6:%s\u3002", (String)"SerialNumberHelper_2", (String)"tmc-fbp-common", (Object[])new Object[]{Long.parseLong(numStr) - 1L}));
                }
                StringBuilder serialNumSb = new StringBuilder();
                for (int j = 0; j < len - numStr.length(); ++j) {
                    serialNumSb.append("0");
                }
                String number = String.format("%s%s%s", prefix, serialNumSb, numStr);
                serialNumList.add(number);
            }
            maxNumBill.set("maxserialnum", (Object)curMaxNum);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{maxNumBill});
            LinkedList<String> linkedList = serialNumList;
            return linkedList;
        }
        finally {
            logger.info("FBD \u6d41\u6c34\u53f7\u751f\u6210\u5668\u91ca\u653e DLock \u9501: " + key);
            dl.unlock();
        }
    }
}

