/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.util.GzipUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.bean.TdaLog;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.DispatchGetParamHelper;
import kd.tmc.fbp.common.helper.FilterSchemeHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.log.bean.SnapLog;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SnapDataHelper {
    private static final Log logger = LogFactory.getLog(SnapDataHelper.class);
    private static int cacheTime = 600000;
    public static final String FORMAT_YMDHMS = "yyyyMMddHHmmss";

    public static int getSnapCacheTime() {
        Integer cachetime = DispatchGetParamHelper.getParamValue("cachetime", Integer.class);
        if (EmptyUtil.isEmpty(cachetime) || cachetime <= 0) {
            cachetime = cacheTime;
        }
        return cachetime * 60 * 1000;
    }

    public static Pair<String, CachedDataSet> createCacheDataSet(String formid, Long orgId, String snapItem, Date queryDate) {
        String cacheKey = formid + snapItem;
        if (EmptyUtil.isNoEmpty(orgId)) {
            cacheKey = formid + orgId + snapItem;
        }
        CachedDataSet ds = null;
        try {
            ds = SnapDataHelper.queryFromCache(cacheKey);
            return Pair.of((Object)"cached", (Object)ds);
        }
        catch (AlgoException e) {
            CacheHint hint = new CacheHint();
            hint.setTimeout((long)SnapDataHelper.getSnapCacheTime());
            hint.setCacheId(cacheKey);
            try {
                DynamicObject dataSnap = SnapDataHelper.getDataSnap(formid, orgId, snapItem, queryDate);
                if (dataSnap != null) {
                    String snapTag = GzipUtils.uncompress((String)dataSnap.getString("snap_tag"), (String)"UTF-8");
                    String fieldsTag = GzipUtils.uncompress((String)dataSnap.getString("fields_tag"), (String)"UTF-8");
                    Field[] fields = (Field[])SerializationUtils.deSerializeFromBase64((String)fieldsTag);
                    CachedDataSet.Builder cacheDataSetBuilder = Algo.create((String)cacheKey).createCachedDataSetBuilder(new RowMeta(fields), hint);
                    List rows = (List)SerializationUtils.deSerializeFromBase64((String)snapTag);
                    for (Row row : rows) {
                        if (!EmptyUtil.isNoEmpty(row)) continue;
                        cacheDataSetBuilder.append(row);
                    }
                    ds = cacheDataSetBuilder.build();
                }
            }
            catch (Exception ex) {
                throw new KDBizException(e.getMessage());
            }
            return Pair.of((Object)"snapdata", (Object)ds);
        }
    }

    protected static CachedDataSet queryFromCache(String cacheKey) {
        return Algo.getCacheDataSet((String)cacheKey);
    }

    public static CacheHint getHint(String formid, Long orgId, String snapItem) {
        String cacheKey = formid + snapItem;
        if (EmptyUtil.isNoEmpty(orgId)) {
            cacheKey = formid + orgId + snapItem;
        }
        CacheHint hint = new CacheHint();
        hint.setTimeout((long)SnapDataHelper.getSnapCacheTime());
        hint.setCacheId(cacheKey);
        return hint;
    }

    public static void saveDataSet(String formid, Long orgId, String batchno, DataSet dataSet, List<AbstractReportColumn> columns) throws IOException, NoSuchAlgorithmException {
        DynamicObject dataSnap = SnapDataHelper.createOrGetDynamicObject(formid, orgId, batchno, dataSet);
        ArrayList<AbstractRow> rows = new ArrayList<AbstractRow>(0);
        for (Row row : dataSet) {
            rows.add(((AbstractRow)row).persist());
        }
        String str = SerializationUtils.serializeToBase64(rows);
        dataSnap.set("snap_tag", (Object)GzipUtils.compress((String)str, (String)"UTF-8"));
        if (null != columns) {
            String columnStr = SerializationUtils.serializeToBase64(columns);
            dataSnap.set("columns_tag", (Object)GzipUtils.compress((String)columnStr, (String)"UTF-8"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSnap});
        dataSet.close();
    }

    private static DynamicObject createOrGetDynamicObject(String formid, Long orgId, String batchno, DataSet dataSet) throws IOException, NoSuchAlgorithmException {
        DynamicObject dataSnap;
        if (EmptyUtil.isNoEmpty(batchno)) {
            dataSnap = TmcDataServiceHelper.newDynamicObject((String)"fcs_datasnap");
            if (EmptyUtil.isNoEmpty(batchno)) {
                dataSnap.set("number", (Object)batchno);
            }
        } else {
            dataSnap = SnapDataHelper.getUpdateDataSnap(formid);
            if (EmptyUtil.isEmpty(dataSnap)) {
                dataSnap = TmcDataServiceHelper.newDynamicObject((String)"fcs_datasnap");
                String datetime = DateUtils.formatString(DateUtils.getCurrentDate(), "yyyyMMddhhssmm");
                dataSnap.set("number", (Object)("Snap-" + datetime + "-" + SecureRandom.getInstance("SHA1PRNG").nextInt(1000)));
            }
        }
        QFilter filter = new QFilter("number", "=", (Object)formid);
        DynamicObject reportForm = TmcDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id, number, name", (QFilter[])filter.toArray());
        DynamicObject version = TmcDataServiceHelper.loadSingleFromCache((String)"tda_decisanlsversion", (String)"querydate", (QFilter[])new QFilter("number", "=", (Object)batchno).toArray());
        String date = DateUtils.formatString(DateUtils.getCurrentDate(), "yyyyMMdd");
        dataSnap.set("name", (Object)("snap-" + reportForm.get("name") + "-" + date));
        dataSnap.set("formid", (Object)reportForm);
        dataSnap.set("org", (Object)orgId);
        dataSnap.set("snapdate", (Object)(EmptyUtil.isEmpty(version) ? DateUtils.getCurrentDate() : version.getDate("querydate")));
        dataSnap.set("creator", (Object)RequestContext.get().getCurrUserId());
        dataSnap.set("createtime", (Object)DateUtils.getCurrentTime());
        dataSnap.set("enable", (Object)1);
        Field[] fields = dataSet.getRowMeta().getFields();
        dataSnap.set("fields_tag", (Object)GzipUtils.compress((String)SerializationUtils.serializeToBase64((Object)fields), (String)"UTF-8"));
        return dataSnap;
    }

    public static ReportQueryParam getReportQueryParam(String formid, String schemeid, String batchno) throws IOException {
        DynamicObject snapSchedule = SnapDataHelper.getSnapSchedule(formid);
        String param_tag = snapSchedule.getString("queryparam_tag");
        ReportQueryParam param = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)GzipUtils.uncompress((String)param_tag, (String)"UTF-8"));
        try {
            FilterScheme filterScheme = FilterSchemeHelper.getSchemeById(schemeid);
            if (filterScheme != null) {
                Map<String, Object> filtersMap = SnapDataHelper.getSchemeFilters(filterScheme);
                SnapDataHelper.setSchemeFilterToParam(param, filtersMap);
            } else if (EmptyUtil.isEmpty(batchno)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u67e5\u8be2\u65b9\u6848", (String)"SnapDataHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return param;
    }

    public static void setSchemeFilterToParam(ReportQueryParam param, Map<String, Object> filtersMap) {
        List filterItems = param.getFilter().getFilterItems();
        FilterInfo filterInfo = new FilterInfo();
        for (FilterItemInfo filterItem : filterItems) {
            filterInfo.addFilterItem(filterItem.getPropName(), filtersMap.get(filterItem.getPropName()) == null ? filterItem.getValue() : SnapDataHelper.transferFilterValue(filtersMap, filterItem.getPropName()));
        }
        param.setFilter(filterInfo);
    }

    public static Map<String, Object> getSchemeFilters(FilterScheme filterScheme) {
        JSONObject jsonObj = JSON.parseObject((String)filterScheme.getScheme());
        String custfilters = jsonObj.getString("custfilters");
        JSONObject filtersMap = JSONObject.parseObject((String)custfilters);
        return filtersMap;
    }

    public static Object transferFilterValue(Map<String, Object> filtersMap, String propName) {
        Object filterValue = filtersMap.get(propName);
        if (filterValue instanceof String && DateUtils.isValidDate((String)filterValue, "yyyy-MM-dd HH:mm:ss")) {
            return DateUtils.stringToDate((String)filterValue, "yyyy-MM-dd HH:mm:ss");
        }
        if (filterValue instanceof JSONArray) {
            JSONArray filterArray = (JSONArray)filterValue;
            DynamicObjectCollection coll = new DynamicObjectCollection();
            for (int i = 0; i < filterArray.size(); ++i) {
                JSONObject obj = (JSONObject)filterArray.get(i);
                JSONObject baseData = obj.getJSONObject("fbasedataid");
                Long id = baseData.getLong("id");
                String entityName = baseData.getString("_Type_");
                DynamicObject value = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
                coll.add((Object)value);
            }
            return coll;
        }
        if (filterValue instanceof JSONObject) {
            JSONObject obj = (JSONObject)filterValue;
            String entityName = obj.getString("_Type_");
            Long id = obj.getLong("id");
            if (EmptyUtil.isNoEmpty(entityName) && EmptyUtil.isNoEmpty(id)) {
                DynamicObject value = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityName);
                return value;
            }
            return "";
        }
        return filterValue;
    }

    public static Map<String, Object> transQueryParam(ReportQueryParam param) {
        List filterItems = param.getFilter().getFilterItems();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(filterItems.size());
        for (FilterItemInfo filterItem : filterItems) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    public static DynamicObject getDataSnap(String number, Long orgId, String snapItem, Date queryDate) {
        DynamicObject[] snaps;
        QFilter filter = new QFilter("formid.number", "=", (Object)number);
        filter = filter.and(new QFilter("enable", "=", (Object)true));
        if (EmptyUtil.isNoEmpty(orgId)) {
            filter = filter.and(new QFilter("org.id", "=", (Object)orgId));
        }
        if (EmptyUtil.isNoEmpty(queryDate)) {
            filter = filter.and(new QFilter("snapdate", "=", (Object)queryDate));
        }
        if (EmptyUtil.isNoEmpty(snapItem) && !"default".equals(snapItem)) {
            filter.and(new QFilter("number", "=", (Object)snapItem));
        }
        return (snaps = BusinessDataServiceHelper.load((String)"fcs_datasnap", (String)"id, number, snap, snap_tag, fields_tag, columns_tag, createtime", (QFilter[])filter.toArray(), (String)"createtime desc", (int)1)).length == 0 ? null : snaps[0];
    }

    public static DynamicObject getUpdateDataSnap(String number) {
        QFilter filter = new QFilter("formid.number", "=", (Object)number);
        filter.and(new QFilter("snapdate", "=", (Object)DateUtils.getCurrentDate()));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fcs_datasnap", (String)"id, number, snap, formid, org, snapdate, snap_tag, fields_tag,columns_tag,creator,createtime,enable", (QFilter[])filter.toArray());
    }

    public static DynamicObject getSnapSchedule(String number) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fcs_snapschedule", (String)"id, number, name, queryparam, queryparam_tag", (QFilter[])new QFilter[]{new QFilter("reportform.number", "=", (Object)number)});
    }

    /*
     * WARNING - void declaration
     */
    public static DataSet ChangeRowToColDataSet(DataSet ds, String changeField, String groupFieldName, String beginChangeField) {
        DataSet tempDs = ds.copy();
        HashSet<DataSet> dsSet = new HashSet<DataSet>(10);
        HashMap<String, String> dsFieldName = new HashMap<String, String>(10);
        while (tempDs.hasNext()) {
            void var11_11;
            Row row = tempDs.next();
            DataType dateType = tempDs.getRowMeta().getField(changeField).getDataType();
            String fieldValue = row.getString(changeField);
            String fieldName = beginChangeField + fieldValue;
            String string = changeField + " = '" + fieldValue + "'";
            if (!dateType.equals((Object)DataType.StringType)) {
                String string2 = changeField + " = " + fieldValue;
            }
            if (dsFieldName.get(fieldValue) != null) continue;
            DataSet ds1 = ds.copy().filter((String)var11_11).select(groupFieldName + ", count as " + fieldName);
            dsSet.add(ds1);
            dsFieldName.put(fieldValue, "");
        }
        DataSet result = ds.copy().select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        for (DataSet dsTemp : dsSet) {
            void var11_17;
            if (result == null) {
                result = dsTemp;
                continue;
            }
            ArrayList<String> fieldNameList = new ArrayList<String>();
            Collections.addAll(fieldNameList, dsTemp.getRowMeta().getFieldNames());
            for (String fieldName : result.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet joinDataSet = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                JoinDataSet joinDataSet2 = var11_17.on(groupField.trim(), groupField.trim());
            }
            result = var11_17.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return result;
    }

    public static String createDecisAnlsVersion(DynamicObject orgview) {
        String time = DateUtils.formatString(DateUtils.getCurrentTime(), FORMAT_YMDHMS);
        String version = "DecAnls-" + orgview.getString("number") + "-" + time + "-";
        try {
            version = version + SecureRandom.getInstance("SHA1PRNG").nextInt(10000);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to generate decision analysis version number.");
        }
        return version;
    }

    public static IFormView getParantView(IPageCache pageCache) {
        String pageid = SnapDataHelper.getMainPageId(pageCache);
        if (EmptyUtil.isEmpty(pageid)) {
            return null;
        }
        return SessionManager.getCurrent().getViewNoPlugin(pageid);
    }

    public static DynamicObject getSnapVersion(IFormView parentView, boolean onlyCurOrgSnap) {
        if (EmptyUtil.isEmpty(parentView)) {
            return null;
        }
        DynamicObject orgView = (DynamicObject)parentView.getModel().getValue("orgview");
        Date queryDate = DateUtils.truncateDate((Date)parentView.getModel().getValue("querydate"));
        if (EmptyUtil.isNoEmpty(orgView)) {
            return SnapDataHelper.getSnapVersion(orgView.getLong("id"), queryDate);
        }
        return null;
    }

    public static DynamicObject getSnapVersion(long orgViewId, Date queryDate) {
        QFilter filter = new QFilter("orgview.id", "=", (Object)orgViewId);
        filter.and("querydate", "=", (Object)queryDate);
        filter.and("enable", "=", (Object)true);
        filter.and("versionstate", "=", (Object)"active");
        filter.and("isupdate", "=", (Object)Boolean.FALSE);
        return TmcDataServiceHelper.loadSingleFromCache((String)"tda_decisanlsversion", (String)SnapDataHelper.getFilterSetSelector(), (QFilter[])filter.toArray());
    }

    private static DynamicObject getSnapSetOrg(DynamicObject orgView, Long orgId, boolean onlyCurOrgSnap) {
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        orgIdList.add(orgId);
        if (!onlyCurOrgSnap) {
            List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgView.getString("number"), (long)orgId);
            orgIdList.addAll(superOrgIds);
        }
        QFilter filter = new QFilter("orgview.id", "=", orgView.getPkValue());
        DynamicObject snapSet = TmcDataServiceHelper.loadSingleFromCache((String)"tda_decisanlssnapset", (String)"org", (QFilter[])(filter = filter.and(new QFilter("org.id", "in", orgIdList))).toArray());
        if (EmptyUtil.isNoEmpty(snapSet)) {
            return snapSet.getDynamicObject("org");
        }
        return null;
    }

    public static Pair<Long, Long> getOrgAndOrgViewId(QFilter[] filters) {
        Long orgViewId = 0L;
        Long orgId = 0L;
        for (QFilter filter : filters) {
            if (filter.getProperty().equals("orgview")) {
                orgViewId = ((DynamicObject)filter.getValue()).getLong("id");
            }
            if (filter.getProperty().equals("org")) {
                orgId = ((DynamicObject)filter.getValue()).getLong("id");
            }
            ThreadCache.put((Object)"orgViewId", (Object)orgViewId);
        }
        return Pair.of((Object)orgId, (Object)orgViewId);
    }

    public static String getMainPageId(IPageCache pageCache) {
        if (pageCache == null) {
            return null;
        }
        if (!pageCache.getAll().containsKey("mainpageid")) {
            String pageid = (String)AppCache.get((String)"tda").get(RequestContext.get().getCurrUserId() + "mainpageid", String.class);
            pageCache.put("mainpageid", pageid);
        }
        return pageCache.get("mainpageid");
    }

    public static TdaLog createScheduleLog(String report, DynamicObject schedule, String snapitem, Pair<Long, Long> orgAndOrgView) {
        TdaLog log = new TdaLog();
        log.setOrgView(TmcDataServiceHelper.loadSingleFromCache((Object)orgAndOrgView.getRight(), (String)"fbd_companysysviewsch"));
        log.setOrg(TmcDataServiceHelper.loadSingleFromCache((Object)orgAndOrgView.getLeft(), (String)"bos_org"));
        log.setType("snapschedule");
        log.setSchedule(schedule);
        return SnapDataHelper.createLog(log, report, snapitem);
    }

    public static SnapLog createSnapLog(DynamicObject snapScheme, DynamicObject report) {
        SnapLog snapLog = new SnapLog();
        snapLog.setSnapScheme(snapScheme);
        snapLog.setReport(report);
        snapLog.setTraceid(RequestContext.get().getTraceId());
        return snapLog;
    }

    public static TdaLog createRunLog(String report) {
        TdaLog log = new TdaLog();
        log.setType("querydata");
        return SnapDataHelper.createLog(log, report, null);
    }

    private static DynamicObject getReport(String report) {
        QFilter filter = new QFilter("number", "=", (Object)report);
        return TmcDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])filter.toArray());
    }

    public static TdaLog createLog(TdaLog log, String report, String snapitem) {
        log.setReport(SnapDataHelper.getReport(report));
        log.setSnapitem(snapitem);
        log.setTraceid(RequestContext.get().getTraceId());
        return log;
    }

    public static void saveLog(TdaLog log) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "fcs.log");){
            HashMap<String, Object> msgParamMap = new HashMap<String, Object>();
            msgParamMap.put("type", "tdalog");
            msgParamMap.put("data", Collections.singletonList(log));
            pub.publish(msgParamMap);
        }
    }

    public static String getCheckChangeProperty() {
        return "orgview,querydate";
    }

    public static String getFilterSetSelector() {
        return "number,currency,querydate,orgview,amountunit,versionstate";
    }

    public static void saveQueryParam(String formId, ReportQueryParam queryParam, String pluginClass, boolean isForceAdd) {
        boolean isAutoAddOrUpdateSchedule = false;
        if (System.getProperties().containsKey("isAutoAddOrUpdateSchedule")) {
            isAutoAddOrUpdateSchedule = "true".equalsIgnoreCase(System.getProperty("isAutoAddOrUpdateSchedule"));
        }
        if (!isAutoAddOrUpdateSchedule) {
            return;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"saveQueryParam", () -> SnapDataHelper.addOrUpdateSchedule(formId, queryParam, pluginClass, isForceAdd));
    }

    private static synchronized void addOrUpdateSchedule(String formId, ReportQueryParam queryParam, String pluginClass, boolean isForceAdd) {
        QFilter filter = new QFilter("reportform.number", "=", (Object)formId);
        DynamicObject snapSchedule = BusinessDataServiceHelper.loadSingle((String)"fcs_snapschedule", (String)"id,queryplugin,queryparam_tag", (QFilter[])filter.toArray());
        try {
            if (isForceAdd && EmptyUtil.isEmpty(snapSchedule)) {
                SnapDataHelper.addReportSchedule(formId, queryParam, pluginClass);
            } else {
                if (EmptyUtil.isNoEmpty(queryParam) && EmptyUtil.isNoEmpty(snapSchedule) && EmptyUtil.isEmpty(snapSchedule.getString("queryparam_tag"))) {
                    snapSchedule = TmcDataServiceHelper.loadSingle((String)"fcs_snapschedule", (String)"queryparam_tag", (QFilter[])filter.toArray());
                    snapSchedule.set("queryparam_tag", (Object)GzipUtils.compress((String)SerializationUtils.serializeToBase64((Object)queryParam), (String)"UTF-8"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{snapSchedule});
                }
                if (EmptyUtil.isNoEmpty(pluginClass) && EmptyUtil.isNoEmpty(snapSchedule) && EmptyUtil.isEmpty(snapSchedule.getString("queryplugin"))) {
                    snapSchedule = TmcDataServiceHelper.loadSingle((String)"fcs_snapschedule", (String)"queryplugin", (QFilter[])filter.toArray());
                    snapSchedule.set("queryplugin", (Object)pluginClass);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{snapSchedule});
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addReportSchedule(String formId, ReportQueryParam queryParam, String pluginClass) throws IOException {
        DynamicObject snapSchedule = TmcDataServiceHelper.newDynamicObject((String)"fcs_snapschedule");
        snapSchedule.set("number", (Object)formId);
        QFilter filter = new QFilter("number", "=", (Object)formId);
        DynamicObject reportForm = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])filter.toArray());
        snapSchedule.set("name", (Object)reportForm.getString("name"));
        snapSchedule.set("reportform", (Object)reportForm);
        if (reportForm.getString("inheritpath").indexOf("a4312e19000000ac") > 0) {
            snapSchedule.set("reporttype", (Object)"qing");
        } else {
            snapSchedule.set("reporttype", (Object)"common");
        }
        if (EmptyUtil.isNoEmpty(queryParam)) {
            snapSchedule.set("queryparam_tag", (Object)GzipUtils.compress((String)SerializationUtils.serializeToBase64((Object)queryParam), (String)"UTF-8"));
        }
        if (EmptyUtil.isNoEmpty(pluginClass)) {
            snapSchedule.set("queryplugin", (Object)pluginClass);
        }
        snapSchedule.set("enable", (Object)BaseEnableEnum.ENABLE.getValue());
        snapSchedule.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        TmcOperateServiceHelper.execOperate("save", "fcs_snapschedule", new DynamicObject[]{snapSchedule}, OperateOption.create());
    }
}

