/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.bean.tc.FreqPeriodListBean;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;

public class SwapHelper {
    private static Log logger = LogFactory.getLog(SwapHelper.class);

    private static BigDecimal calPVForFloatPlAmt(Date referDate, DynamicObject tradeBill, Boolean isPay) {
        QFilter filter = new QFilter("billid", "=", (Object)tradeBill.getLong("id"));
        QFilter filter_dir = new QFilter("cfdirection", "=", (Object)(isPay != false ? "buy" : "sell"));
        QFilter filter_cfpaydate = new QFilter("cfpaydate", ">=", (Object)referDate);
        DynamicObject[] cashflowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"id,cfpaydate,cfamount,cftype,cfispay,cfosprincipal,cfratefixindex,cfisratecfg,cfratefixdate,cfresetpredictrate,cfisratecfg,cfuserate,cfamount,cfdiscfactor,cfpv,cfadjstartdate,cfadjenddate,cfpayamount,cfinterest,cftheta", (QFilter[])new QFilter[]{filter, filter_dir, filter_cfpaydate}, (String)"TO_DECIMAL(billno) asc");
        ArrayList<Date> dateList = new ArrayList<Date>(cashflowCol.length * 2);
        for (DynamicObject cashflow : cashflowCol) {
            Date payDate = cashflow.getDate("cfpaydate");
            dateList.add(payDate);
            dateList.add(TcDateUtils.getLastDay(payDate, 1));
        }
        DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
        DynamicObject market = isPay != false ? tradeBill.getDynamicObject("market") : tradeBill.getDynamicObject("recmarket");
        PriceRuleInfo prInfo = MarketDataHelper.getDiscfactor(null, referDate, priceRule, new Long[]{market.getLong("id")}, dateList.toArray(new Date[0]));
        Map<Date, BigDecimal> dfs = prInfo.getYieldCurve()[0].getDfMap();
        SwapHelper.calCashFlows_swap(cashflowCol, referDate, tradeBill, dfs, isPay);
        BigDecimal PV = BigDecimal.ZERO;
        for (DynamicObject cashflow : cashflowCol) {
            boolean cfispay = cashflow.getBoolean("cfispay");
            if (cfispay) continue;
            BigDecimal pv = cashflow.getBigDecimal("cfpv");
            PV = PV.add(pv);
        }
        return PV;
    }

    public static void calCashFlows_swap(DynamicObject[] cashFlows, Date referDate, DynamicObject tradeBill, Map<Date, BigDecimal> dfs, Boolean isPay) {
        DynamicObject pricerule = tradeBill.getDynamicObject("pricerule");
        if (EmptyUtil.isAnyoneEmpty(referDate, pricerule)) {
            return;
        }
        FreqPeriodListBean freqPeriodResolver = SwapHelper.genFreqPeriodListBean(tradeBill, isPay);
        Date payDayBefore = null;
        for (DynamicObject cashFlow : cashFlows) {
            BigDecimal amount;
            BigDecimal dft_1;
            BigDecimal disCFactor;
            String type = cashFlow.getString("cftype");
            boolean cfispay = cashFlow.getBoolean("cfispay");
            BigDecimal orPricipal = cashFlow.getBigDecimal("cfosprincipal");
            Date payDay = cashFlow.getDate("cfpaydate");
            if ("fixedrate".equals(type) || "capital".equals(type)) {
                Date payDate = cashFlow.getDate("cfpaydate");
                BigDecimal amount2 = cashFlow.getBigDecimal("cfpayamount");
                disCFactor = dfs.get(payDate);
                dft_1 = dfs.get(TcDateUtils.getLastDay(payDate, 1));
                if (dft_1 == null) {
                    dft_1 = BigDecimal.ZERO;
                }
                cashFlow.set("cftheta", (Object)SwapHelper.roundDecimal(disCFactor.subtract(dft_1).multiply(amount2)).negate());
                cashFlow.set("cfpv", (Object)SwapHelper.roundDecimal(amount2.multiply(disCFactor)));
                cashFlow.set("cfdiscfactor", (Object)disCFactor);
                logger.info(String.format("%7$s:date=%1$s,df=%2$s,df_1=%3$s,amount=%4$s,theta=%5$s,pv=%6$s", DateUtils.formatString(payDate, "yyyy-MM-dd"), disCFactor, dft_1, amount2, cashFlow.getBigDecimal("cftheta"), cashFlow.getBigDecimal("cfpv"), isPay != false ? "pay" : "rec"));
            }
            if (!"floatrate".equals(type)) continue;
            if (!cfispay) {
                Date indexDate;
                DynamicObjectCollection resetCashFlows = cashFlow.getDynamicObjectCollection("entrys");
                HashMap<Date, List<Date>> dateMap = new HashMap<Date, List<Date>>();
                HashMap<Long, Date> indexDateMap = new HashMap<Long, Date>();
                for (int i = 0; i < resetCashFlows.size(); ++i) {
                    DynamicObject resetCashFlow = (DynamicObject)resetCashFlows.get(i);
                    DynamicObject ratefixindex = resetCashFlow.getDynamicObject("cfratefixindex");
                    boolean isratecfg = resetCashFlow.getBoolean("cfisratecfg");
                    Date ratefixDate = resetCashFlow.getDate("cfratefixdate");
                    String term = SwapHelper.isRateQuoteDays(tradeBill, isPay) ? ratefixindex.getString("term") : RateTermEnum.getEnum(SwapHelper.getRateResetFreq(tradeBill, isPay)).getValue();
                    if (!ratefixDate.after(referDate) || isratecfg) continue;
                    indexDate = TermUtils.getDateByTerm(RateTermEnum.valueOf(term).getName(), ratefixDate);
                    dateMap.put(ratefixDate, Collections.singletonList(indexDate));
                    indexDateMap.put(resetCashFlow.getLong("id"), indexDate);
                }
                Map<Date, BigDecimal> furRateByYieldCurveResult = MarketDataHelper.getFurRateByBatchYieldCurve(null, YieldTypeEnum.ref, pricerule, SwapHelper.getMarket(tradeBill, isPay), referDate, dateMap);
                BigDecimal useRate = BigDecimal.ONE;
                for (DynamicObject finalCash : resetCashFlows) {
                    boolean isratecfg = finalCash.getBoolean("cfisratecfg");
                    indexDate = (Date)indexDateMap.get(finalCash.getLong("id"));
                    if (!(isratecfg || cfispay || EmptyUtil.isEmpty(furRateByYieldCurveResult))) {
                        if (!EmptyUtil.isEmpty(indexDate)) {
                            finalCash.set("cfresetpredictrate", (Object)furRateByYieldCurveResult.get(indexDate));
                        }
                        BigDecimal resetPreRate = finalCash.get("cfresetpredictrate") == null ? BigDecimal.ZERO : (BigDecimal)finalCash.get("cfresetpredictrate");
                        BigDecimal muUseRate = resetPreRate.add(SwapHelper.getRateMargin(tradeBill, isPay));
                        finalCash.set("cfuserate", (Object)muUseRate);
                    }
                    BigDecimal baseBasis = SwapHelper.getBaseBasis(finalCash, tradeBill, isPay, freqPeriodResolver);
                    BigDecimal tempUseRate = (BigDecimal)finalCash.get("cfuserate");
                    useRate = useRate.multiply(BigDecimal.ONE.add(tempUseRate.divide(Constants.ONE_HUNDRED, 10, 4).multiply(baseBasis)));
                }
                useRate = useRate.subtract(BigDecimal.ONE);
                amount = orPricipal.multiply(useRate);
                if (SwapHelper.isPayDateFoward(tradeBill, isPay) && SwapHelper.isDiscount(tradeBill, isPay).booleanValue()) {
                    amount = payDayBefore == null ? amount.multiply(dfs.get(payDay)) : amount.multiply(dfs.get(payDay).divide(dfs.get(payDayBefore), 10, 4));
                }
                payDayBefore = payDay;
                amount = amount.multiply(SwapHelper.getAmtDir(isPay));
                amount = SwapHelper.roundDecimal(amount);
                cashFlow.set("cfamount", (Object)amount);
                cashFlow.set("cfpayamount", (Object)amount);
                cashFlow.set("cfinterest", (Object)amount);
            } else {
                amount = cashFlow.getBigDecimal("cfpayamount");
            }
            Date payDate = (Date)cashFlow.get("cfpaydate");
            disCFactor = dfs.get(payDate);
            dft_1 = dfs.get(TcDateUtils.getLastDay(payDate, 1));
            if (dft_1 == null) {
                dft_1 = BigDecimal.ZERO;
            }
            cashFlow.set("cftheta", (Object)SwapHelper.roundDecimal(disCFactor.subtract(dft_1).multiply(amount)).negate());
            cashFlow.set("cfpv", (Object)SwapHelper.roundDecimal(amount.multiply(disCFactor)));
            cashFlow.set("cfdiscfactor", (Object)disCFactor);
            logger.info(String.format("%7$s:date=%1$s,df=%2$s,df_1=%3$s,amount=%4$s,theta=%5$s,pv=%6$s", DateUtils.formatString(payDate, "yyyy-MM-dd"), disCFactor, dft_1, amount, cashFlow.getBigDecimal("cftheta"), cashFlow.getBigDecimal("cfpv"), isPay != false ? "pay" : "rec"));
        }
    }

    public static BigDecimal calPayFloatPlAmt(DynamicObject plInfo, DynamicObject tradeBill) {
        Date referDate = plInfo.getDate("updatedate");
        BigDecimal PV_Pay = SwapHelper.calPVForFloatPlAmt(referDate, tradeBill, Boolean.TRUE);
        return SwapHelper.calForexAmt(plInfo, tradeBill, PV_Pay);
    }

    private static BigDecimal calForexAmt(DynamicObject plInfo, DynamicObject tradeBill, BigDecimal pv) {
        if ("currency".equals(tradeBill.getString("rateswaptype"))) {
            DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
            DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
            if (!EmptyUtil.isAnyoneEmpty(plCurrency, payCurrency)) {
                int amtprecision = plCurrency.getInt("amtprecision");
                String fquote = plInfo.getString("fxquotetype");
                BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
                if (plCurrency.getLong("id") != payCurrency.getLong("id")) {
                    pv = plCurrency.getString("number").equals(fquote.split("/")[0]) ? (EmptyUtil.isEmpty(referExrate) ? BigDecimal.ZERO : pv.divide(referExrate, amtprecision, RoundingMode.HALF_UP)) : pv.multiply(referExrate).setScale(amtprecision, RoundingMode.HALF_UP);
                }
            }
        }
        return pv;
    }

    public static BigDecimal calRecFloatPlAmt(DynamicObject plInfo, DynamicObject tradeBill) {
        Date referDate = plInfo.getDate("updatedate");
        BigDecimal PV_Rec = SwapHelper.calPVForFloatPlAmt(referDate, tradeBill, Boolean.FALSE);
        if ("currency".equals(tradeBill.getString("rateswaptype"))) {
            DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
            DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
            if (!EmptyUtil.isAnyoneEmpty(plCurrency, payCurrency)) {
                String fquote = plInfo.getString("fxquotetype");
                BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
                if (plCurrency.getLong("id") == payCurrency.getLong("id")) {
                    PV_Rec = plCurrency.getString("number").equals(fquote.split("/")[0]) ? (EmptyUtil.isEmpty(referExrate) ? BigDecimal.ZERO : PV_Rec.divide(referExrate, 10, 4)) : PV_Rec.multiply(referExrate);
                }
            }
        }
        return PV_Rec;
    }

    private static Long getMarket(DynamicObject tradeBill, boolean ispay) {
        String market = ispay ? "market" : "recmarket";
        return tradeBill.getDynamicObject(market).getLong("id");
    }

    private static boolean isRateQuoteDays(DynamicObject tradeBill, boolean ispay) {
        String rateQuoteType = ispay ? "ratequotafreq" : "recratequotafreq";
        return "day".equals(tradeBill.getString(rateQuoteType));
    }

    private static String getRateResetFreq(DynamicObject tradeBill, boolean ispay) {
        String rateQuoteType = ispay ? "rateresetfreq" : "recrateresetfreq";
        return tradeBill.getBigDecimal(rateQuoteType).intValue() + "m";
    }

    private static BigDecimal getRateMargin(DynamicObject tradeBill, boolean ispay) {
        String ratemargin = ispay ? "ratemargin" : "recratemargin";
        return tradeBill.getBigDecimal(ratemargin);
    }

    private static String getBasis(DynamicObject tradeBill, boolean ispay) {
        String basis = ispay ? "basis" : "recbasis";
        return tradeBill.getString(basis);
    }

    private static String getPayFreq(DynamicObject tradeBill, boolean ispay) {
        String payfrequency = ispay ? "payfrequency" : "recpayfrequency";
        return tradeBill.getString(payfrequency);
    }

    private static boolean isPayStage(DynamicObject tradeBill, boolean ispay) {
        String payfrequency = tradeBill.getString(ispay ? "paytype" : "recpaytype");
        return "stages".equals(payfrequency);
    }

    private static Date getFirstCopDate(DynamicObject tradeBill, boolean ispay) {
        String firstpaycopdate = ispay ? "firstpaycopdate" : "recfirstpaycopdate";
        return tradeBill.getDate(firstpaycopdate);
    }

    private static Date getPenuCopDate(DynamicObject tradeBill, boolean ispay) {
        String penupaycopdate = ispay ? "penupaycopdate" : "recpenupaycopdate";
        return tradeBill.getDate(penupaycopdate);
    }

    private static Date getValueDate(DynamicObject tradeBill, boolean ispay) {
        String valuedate = ispay ? "valuedate" : "recvaluedate";
        return tradeBill.getDate(valuedate);
    }

    private static boolean isStub(DynamicObject tradeBill, boolean ispay) {
        String stub = ispay ? "stub" : "recstub";
        return tradeBill.getBoolean(stub);
    }

    private static boolean isStubFront(DynamicObject tradeBill, boolean ispay) {
        String stubtype = tradeBill.getString(ispay ? "stubtype" : "recstubtype");
        return "front".equals(stubtype);
    }

    private static DynamicObjectCollection getWorkCalendars(DynamicObject tradeBill, boolean ispay) {
        String payworkcalendar = ispay ? "payworkcalendar" : "recworkcalendar";
        return tradeBill.getDynamicObjectCollection(payworkcalendar);
    }

    private static String getAdjustMethod(DynamicObject tradeBill, boolean ispay) {
        String dateadjustmethod = ispay ? "dateadjustmethod" : "recdateadjustmethod";
        return tradeBill.getString(dateadjustmethod);
    }

    private static boolean isPayDateFoward(DynamicObject tradeBill, boolean ispay) {
        String paydatetype = tradeBill.getString(ispay ? "paydatetype" : "recpaydatetype");
        return "forward".equals(paydatetype);
    }

    private static Boolean isDiscount(DynamicObject tradeBill, boolean ispay) {
        String discount = ispay ? "discount" : "recdiscount";
        return tradeBill.getBoolean(discount);
    }

    private static BigDecimal getAmtDir(boolean ispay) {
        return ispay ? BigDecimal.ONE.negate() : BigDecimal.ONE;
    }

    private static BigDecimal getBaseBasis(DynamicObject resetRow, DynamicObject tradeBill, boolean ispay, FreqPeriodListBean freqPeriodResolver) {
        BasisEnum basis = BasisEnum.getEnum(SwapHelper.getBasis(tradeBill, ispay));
        return TradeBusinessHelper.getBaseBasis((Date)resetRow.get("cfadjstartdate"), (Date)resetRow.get("cfadjenddate"), basis, (DynamicObject[])SwapHelper.getWorkCalendars(tradeBill, ispay).toArray((Object[])new DynamicObject[0]), null, freqPeriodResolver != null ? freqPeriodResolver.getFreqEnum() : null, freqPeriodResolver);
    }

    private static FreqPeriodListBean genFreqPeriodListBean(DynamicObject tradeBill, boolean ispay) {
        BasisEnum basis = BasisEnum.getEnum(SwapHelper.getBasis(tradeBill, ispay));
        String payFreq = SwapHelper.getPayFreq(tradeBill, ispay);
        if (SwapHelper.isPayStage(tradeBill, ispay) && BasisEnum.ICMA_Actual_actual == basis) {
            PayFrequeEnum freq = PayFrequeEnum.valueOf(payFreq);
            Date firstCop = SwapHelper.getFirstCopDate(tradeBill, ispay);
            Date penuCopDate = SwapHelper.getPenuCopDate(tradeBill, ispay);
            Date valueDate = SwapHelper.getValueDate(tradeBill, ispay);
            boolean isStub = SwapHelper.isStub(tradeBill, ispay);
            boolean isStubFront = SwapHelper.isStubFront(tradeBill, ispay);
            DynamicObjectCollection wc = SwapHelper.getWorkCalendars(tradeBill, ispay);
            Date endDate = tradeBill.getDate("enddate");
            String adjMethod = SwapHelper.getAdjustMethod(tradeBill, ispay);
            return new FreqPeriodListBean(valueDate, endDate, isStub, isStubFront, firstCop, penuCopDate, freq, AdjustMethodEnum.getEnumByValue(adjMethod), wc, true);
        }
        return null;
    }

    private static BigDecimal roundDecimal(BigDecimal deci) {
        return deci.setScale(10, RoundingMode.HALF_UP);
    }
}

