/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.tmc.fbp.common.bean.CalcBasisInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.WorkCalendarAdjustHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

@KSObject
public class TermHelper {
    public static final String YEAR = "y";
    public static final String MONTH = "m";
    public static final String DAY = "d";

    @KSMethod
    public static String callTermLargeEqualZore(Date startDate, Date endDate) {
        String term = DateUtils.getDiff_ymd(startDate, endDate);
        if (term.startsWith("-")) {
            term = "0d";
        }
        return term;
    }

    public static int callSettleDelayDay(DynamicObjectCollection workCalendars, Date bizDate, Date settleDate) {
        return WorkCalendarAdjustHelper.callSettleDelayDay(workCalendars, bizDate, settleDate);
    }

    public static Date callSettleDelayDate(DynamicObjectCollection workCalendars, Date date, int settleDelay) {
        return WorkCalendarAdjustHelper.callSettleDelayDate(workCalendars, date, settleDelay);
    }

    public static Date callBasicSettleDelayDate(DynamicObjectCollection workCalendars, Date date, int settleDelay) {
        return WorkCalendarAdjustHelper.callBasicSettleDelayDate(workCalendars, date, settleDelay);
    }

    public static Date callAdjustSettleDate(DynamicObjectCollection workCalendars, Date date, AdjustMethodEnum adjustMethod) {
        return WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendars, date, adjustMethod);
    }

    public static Date callAdjustSettleDate(Map<Date, Boolean> workCalendarMap, Date date, AdjustMethodEnum adjustMethod) {
        return WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendarMap, date, adjustMethod);
    }

    public static Map<Date, Date> callAdjustSettleDate(Map<Date, Boolean> workCalendarMap, Date beginDate, Date endDate, AdjustMethodEnum adjustMethod) {
        return WorkCalendarAdjustHelper.callAdjustSettleDate(workCalendarMap, beginDate, endDate, adjustMethod);
    }

    public static boolean isWorkDay(Map<Date, Boolean> workCalendarMap, Date date) {
        return WorkCalendarAdjustHelper.isWorkDay(workCalendarMap, date);
    }

    public static Date callDelayAdjustSettleDate(DynamicObjectCollection workCalendars, Date date, int settleDelay, AdjustMethodEnum adjustMethod) {
        return WorkCalendarAdjustHelper.callDelayAdjustSettleDate(workCalendars, date, settleDelay, adjustMethod);
    }

    @Deprecated
    @KSMethod
    public static int getBasis_YearDay(int year, BasisEnum basisEnum) {
        switch (basisEnum) {
            case Actual_actual: 
            case ISDA_Actual_365: 
            case ISDA_Actual_actual: {
                return DateUtils.isLeapYear(year) ? 366 : 365;
            }
            case SIA_30_360: 
            case Actual_360: 
            case BMA_30_360: 
            case ISDA_30_360: 
            case European_30_360: 
            case DEP_30_360: 
            case ICMA_30_360: 
            case ICMA_Actual_360: {
                return 360;
            }
            case Actual_365: 
            case Japanese_Actual_365: 
            case ICMA_Actual_365: {
                return 365;
            }
            case BUS_252: {
                return 252;
            }
        }
        return 365;
    }

    public static int getBasis_YearDay(Date startIntDate, Date beginDate, BasisEnum basisEnum) {
        switch (basisEnum) {
            case Actual_actual: {
                return TermHelper.getActBasisYearDay(startIntDate != null ? startIntDate : beginDate, beginDate);
            }
            case ISDA_Actual_365: {
                return DateUtils.isLeapYear(DateUtils.getYear(startIntDate != null ? startIntDate : beginDate)) ? 366 : 365;
            }
            case ISDA_Actual_actual: {
                return DateUtils.isLeapYear(DateUtils.getYear(beginDate)) ? 366 : 365;
            }
            case SIA_30_360: 
            case Actual_360: 
            case BMA_30_360: 
            case ISDA_30_360: 
            case European_30_360: 
            case DEP_30_360: 
            case ICMA_30_360: 
            case ICMA_Actual_360: {
                return 360;
            }
            case Actual_365: 
            case Japanese_Actual_365: 
            case ICMA_Actual_365: {
                return 365;
            }
            case BUS_252: {
                return 252;
            }
        }
        return 365;
    }

    private static int getActBasisYearDay(Date startIntDate, Date beginDate) {
        Date endIntDate = DateUtils.getNextYear(startIntDate, 1);
        while (beginDate.compareTo(endIntDate) >= 0) {
            startIntDate = endIntDate;
            endIntDate = DateUtils.getNextYear(endIntDate, 1);
        }
        return DateUtils.getDiffDays(startIntDate, endIntDate) - 1;
    }

    public static int getBasis_BetweenDay(Date startDate, Date endDate, BasisEnum basisEnum, DynamicObject[] workCalendars) {
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        int y1 = start.get(1);
        int m1 = start.get(2);
        int d1 = start.get(5);
        int maxDayStart = start.getActualMaximum(5);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        int y2 = end.get(1);
        int m2 = end.get(2);
        int d2 = end.get(5);
        int maxDayEnd = end.getActualMaximum(5);
        int years = y2 - y1;
        int months = m2 - m1;
        switch (basisEnum) {
            case Actual_actual: 
            case ISDA_Actual_365: 
            case ISDA_Actual_actual: 
            case Actual_360: 
            case Actual_365: 
            case ICMA_Actual_actual: {
                return TermHelper.getDiffDays(startDate, endDate);
            }
            case SIA_30_360: {
                if (m1 == 1 && d1 == maxDayStart && m2 == 1 && d2 == maxDayEnd) {
                    d2 = 30;
                }
                if (d1 == maxDayStart) {
                    d1 = 30;
                }
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                return d2 - d1 + 30 * months + 360 * years;
            }
            case BMA_30_360: {
                if (d1 == maxDayStart) {
                    d1 = 30;
                }
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                return d2 - d1 + 30 * months + 360 * years;
            }
            case ISDA_30_360: {
                if (d1 == 31) {
                    d1 = 30;
                }
                if (d2 == 31 && d1 == 30) {
                    d2 = 30;
                }
                return d2 - d1 + 30 * months + 360 * years;
            }
            case European_30_360: {
                if (d1 == 31) {
                    d1 = 30;
                }
                if (d2 == 31) {
                    d2 = 30;
                }
                return d2 - d1 + 30 * months + 360 * years;
            }
            case BUS_252: {
                return TermHelper.getBasisDaysByBus252(workCalendars, start, end);
            }
            case Japanese_Actual_365: {
                int N = TermHelper.getDiffDays(start.getTime(), end.getTime());
                int times = TermHelper.countLeapDays(DateUtils.date2LocalDate(startDate), DateUtils.date2LocalDate(endDate));
                return N - times;
            }
            case DEP_30_360: {
                return TermHelper.getBasisDaysByDeposit(startDate, endDate);
            }
        }
        return TermHelper.getDiffDays(startDate, endDate);
    }

    public static int countLeapDays(LocalDate startDate, LocalDate endDate) {
        int count = 0;
        for (int year = startDate.getYear(); year <= endDate.getYear(); ++year) {
            LocalDate leapDay;
            if (!DateUtils.isLeapYear(year) || (leapDay = LocalDate.of(year, 2, 29)).isBefore(startDate) || leapDay.isAfter(endDate)) continue;
            ++count;
        }
        return count;
    }

    private static int getBasisDaysByBus252(DynamicObject[] workCalendars, Calendar start, Calendar end) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        Long[] calendarIds = new Long[]{};
        if (workCalendars != null) {
            for (DynamicObject wc : workCalendars) {
                if (wc == null) continue;
                ids.add(wc.getLong("fbasedataid_id"));
            }
        }
        return WorkCalendarHelper.getWorkDayCount(ids.toArray(calendarIds), start.getTime(), end.getTime());
    }

    private static int getBasisDaysByDeposit(Date startDate, Date endDate) {
        String term = DateUtils.getDiff_ymd(startDate, endDate);
        Map<String, Integer> ymd = TermHelper.getYMD(term);
        int years = ymd.get(YEAR);
        int months = ymd.get(MONTH);
        int days = ymd.get(DAY);
        return days + 30 * months + 360 * years;
    }

    @KSMethod
    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = (int)diff;
        return days;
    }

    public static CalcBasisInfo getBaseBasisInfo(Date startDate, Date endDate, BasisEnum basisEnum, DynamicObject[] workCalendars) {
        return TermHelper.getBaseBasisInfo(startDate, endDate, basisEnum, startDate, workCalendars);
    }

    public static CalcBasisInfo getBaseBasisInfo(Date startDate, Date endDate, BasisEnum basisEnum, Date startIntDate, DynamicObject[] workCalendars) {
        switch (basisEnum) {
            case ISDA_Actual_365: 
            case ISDA_Actual_actual: {
                return TermHelper.getBaseBasisAct0Act(startDate, endDate, basisEnum);
            }
            case Actual_actual: {
                return TermHelper.getBaseBasisActActByStartIntDate(startDate, endDate, basisEnum, startIntDate);
            }
        }
        int betweenDays = TermHelper.getBasis_BetweenDay(startDate, endDate, basisEnum, workCalendars);
        int yearDay = TermHelper.getBasis_YearDay(startDate, endDate, basisEnum);
        BigDecimal amount = new BigDecimal(betweenDays).divide(new BigDecimal(yearDay), 20, RoundingMode.HALF_UP);
        return CalcBasisInfo.build(betweenDays, amount).setBasisDay(yearDay);
    }

    private static CalcBasisInfo getBaseBasisActActByStartIntDate(Date startDate, Date endDate, BasisEnum basisEnum, Date startIntDate) {
        IntBillDetailInfo detailInfo = new IntBillDetailInfo();
        detailInfo.setBeginDate(startDate);
        detailInfo.setEndDate(DateUtils.getLastDay(endDate, 1));
        List<IntBillDetailInfo> details = TermHelper.splitByStartIntDate(Collections.singletonList(detailInfo), startIntDate, basisEnum);
        return TermHelper.getCalcBasisInfo(startDate, endDate, basisEnum, startIntDate, details);
    }

    private static CalcBasisInfo getCalcBasisInfo(Date startDate, Date endDate, BasisEnum basisEnum, Date startIntDate, List<IntBillDetailInfo> details) {
        int betweenDays = 0;
        int basisDay = 365;
        BigDecimal intAmount = BigDecimal.ZERO;
        if (details.size() == 1) {
            betweenDays = TermHelper.getDiffDays(startDate, endDate);
            basisDay = TermHelper.getBasis_YearDay(startIntDate, startDate, basisEnum);
            intAmount = new BigDecimal(betweenDays).divide(new BigDecimal(basisDay), 20, RoundingMode.HALF_UP);
            return CalcBasisInfo.build(betweenDays, intAmount).setBasisDay(basisDay);
        }
        int size = details.size();
        for (int i = 0; i < size; ++i) {
            IntBillDetailInfo detail = details.get(i);
            basisDay = detail.getBasisDay();
            int diffDays = i == size - 1 ? TermHelper.getDiffDays(detail.getBeginDate(), detail.getEndDate()) : DateUtils.getDiffDays(detail.getBeginDate(), detail.getEndDate());
            betweenDays += diffDays;
            intAmount = intAmount.add(new BigDecimal(diffDays).divide(new BigDecimal(basisDay), 20, RoundingMode.HALF_UP));
        }
        return CalcBasisInfo.build(betweenDays, intAmount).setBasisDay(basisDay);
    }

    public static BigDecimal getBaseBasis(Date startDate, Date endDate, BasisEnum basisEnum, DynamicObject[] workCalendars) {
        CalcBasisInfo calcBasisInfo = TermHelper.getBaseBasisInfo(startDate, endDate, basisEnum, startDate, workCalendars);
        return calcBasisInfo.getBasisAmt();
    }

    private static CalcBasisInfo getBaseBasisAct0Act(Date startDate, Date endDate, BasisEnum basisEnum) {
        IntBillDetailInfo detailInfo = new IntBillDetailInfo();
        detailInfo.setBeginDate(startDate);
        detailInfo.setEndDate(DateUtils.getLastDay(endDate, 1));
        List<IntBillDetailInfo> details = TermHelper.splitByLeapYear(Collections.singletonList(detailInfo), basisEnum);
        return TermHelper.getCalcBasisInfo(startDate, endDate, basisEnum, startDate, details);
    }

    public static Matcher getMatcher(String value) {
        String pattern = "([0-9]{1,}y)?([0-9]{1,}m)?([0-9]{1,}d)?";
        Pattern r = Pattern.compile(pattern);
        Matcher Matcher2 = r.matcher(value);
        return Matcher2;
    }

    public static boolean isRightFormat(IDataModel model, IFormView view, String value) {
        Matcher Matcher2 = TermHelper.getMatcher(value);
        if (!Matcher2.matches()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u65e5\u671f\u95f4\u9694\u683c\u5f0f\u4e0d\u6b63\u786e:**y**m**d\u3002", (String)"TermUtils_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return false;
        }
        BigDecimal year = Constants.ZERO;
        BigDecimal month = Constants.ZERO;
        BigDecimal day = Constants.ZERO;
        String group1 = Matcher2.group(1);
        if (!EmptyUtil.isEmpty(group1) && (year = new BigDecimal(group1.split(YEAR)[0])).compareTo(Constants.ONE_HUNDRED) > 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u5927\u4e8e100y", (String)"TermUtils_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return false;
        }
        String group2 = Matcher2.group(2);
        if (!EmptyUtil.isEmpty(group2) && (month = new BigDecimal(group2.split(MONTH)[0])).compareTo(new BigDecimal(1200)) > 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u5927\u4e8e1200m", (String)"TermUtils_2", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return false;
        }
        String group3 = Matcher2.group(3);
        if (!EmptyUtil.isEmpty(group3) && (day = new BigDecimal(group3.split(DAY)[0])).compareTo(new BigDecimal(36600)) > 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u5927\u4e8e36600d", (String)"TermUtils_3", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @KSMethod
    public static Map<String, Integer> getYMD(String value) {
        Matcher Matcher2 = TermHelper.getMatcher(value.trim());
        int year = 0;
        int month = 0;
        int day = 0;
        if (Matcher2.find()) {
            String group3;
            String group2;
            String group1 = Matcher2.group(1);
            if (!EmptyUtil.isEmpty(group1)) {
                year = Integer.parseInt(group1.split(YEAR)[0]);
            }
            if (!EmptyUtil.isEmpty(group2 = Matcher2.group(2))) {
                month = Integer.parseInt(group2.split(MONTH)[0]);
            }
            if (!EmptyUtil.isEmpty(group3 = Matcher2.group(3))) {
                day = Integer.parseInt(group3.split(DAY)[0]);
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put(YEAR, year);
            result.put(MONTH, month);
            result.put(DAY, day);
            return result;
        }
        throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u65f6\u95f4\u95f4\u9694\u683c\u5f0f\u6709\u8bef", (String)"TermUtils_4", (String)"tmc-fbp-common", (Object[])new Object[0])});
    }

    public static int transToMonth(String value) {
        Map<String, Integer> result = TermHelper.getYMD(value);
        int month = result.get(MONTH);
        int year = result.get(YEAR);
        return year * 12 + month;
    }

    public static String getFormatStr(int year, int month, int day) {
        StringBuilder str = new StringBuilder();
        if (year != 0) {
            str.append(year).append(YEAR);
        }
        if (month != 0) {
            str.append(month).append(MONTH);
        }
        if (day != 0) {
            str.append(day).append(DAY);
        }
        return str.toString();
    }

    public static Date getDateByBaseDate4ymd(String value, Date basedate) {
        Map<String, Integer> ymd = TermHelper.getYMD(value);
        Calendar temp = Calendar.getInstance();
        temp.setTime(basedate);
        temp.add(1, ymd.get(YEAR));
        temp.add(2, ymd.get(MONTH));
        temp.add(5, ymd.get(DAY));
        return temp.getTime();
    }

    public static Date getLastDateByBaseDate4ymd(String value, Date basedate) {
        Map<String, Integer> ymd = TermHelper.getYMD(value);
        Calendar temp = Calendar.getInstance();
        temp.setTime(basedate);
        temp.add(1, -ymd.get(YEAR).intValue());
        temp.add(2, -ymd.get(MONTH).intValue());
        temp.add(5, -ymd.get(DAY).intValue());
        return temp.getTime();
    }

    public static Date getNextDateByBaseDate4ymd(String value, Date basedate) {
        Map<String, Integer> ymd = TermHelper.getYMD(value);
        Calendar temp = Calendar.getInstance();
        temp.setTime(basedate);
        temp.add(1, ymd.get(YEAR));
        temp.add(2, ymd.get(MONTH));
        temp.add(5, ymd.get(DAY));
        return temp.getTime();
    }

    public static Date getDateByTerm(String termStr, Date date) {
        return TermHelper.getNextDateByBaseDate4ymd(termStr, date);
    }

    public static String getIntervalByTerm(String termStr) {
        Map<String, Integer> ymd = TermHelper.getYMD(termStr);
        if (EmptyUtil.isNoEmpty(ymd.get(DAY)) && ymd.get(DAY) != 0) {
            return "1d";
        }
        if (EmptyUtil.isNoEmpty(ymd.get(MONTH)) && ymd.get(MONTH) != 0 && ymd.get(MONTH) < 3) {
            return "1m";
        }
        if (EmptyUtil.isNoEmpty(ymd.get(MONTH)) && ymd.get(MONTH) != 0 && ymd.get(MONTH) >= 3 && ymd.get(MONTH) < 6) {
            return "3m";
        }
        return "6m";
    }

    public static String getTerm_ymd(Date startDate, Date endDate) {
        return DateUtils.getDiff_ymd(startDate, endDate);
    }

    public static List<IntBillDetailInfo> splitByLeapYear(List<IntBillDetailInfo> detailList, BasisEnum basisEnum) {
        if (EmptyUtil.isEmpty(detailList)) {
            return detailList;
        }
        TreeMap<Date, IntBillDetailInfo> detailInfoMap = new TreeMap<Date, IntBillDetailInfo>(detailList.stream().collect(Collectors.toMap(IntBillDetailInfo::getEndDate, r -> r, (r1, r2) -> r1)));
        for (IntBillDetailInfo detailInfo : detailList) {
            LocalDate startLocalDate = DateUtils.date2LocalDate(detailInfo.getBeginDate());
            LocalDate endLocalDate = DateUtils.date2LocalDate(detailInfo.getEndDate());
            int basisDay = startLocalDate.lengthOfYear();
            LocalDate tmpLocalDate = startLocalDate;
            while (startLocalDate.compareTo(endLocalDate) < 0) {
                if (startLocalDate.lengthOfYear() != basisDay) {
                    IntBillDetailInfo addDetailInfo = new IntBillDetailInfo();
                    addDetailInfo.setBeginDate(DateUtils.localDate2Date(tmpLocalDate));
                    addDetailInfo.setEndDate(DateUtils.localDate2Date(startLocalDate.minusDays(1L)));
                    addDetailInfo.setPrinciple(detailInfo.getPrinciple());
                    addDetailInfo.setRate(detailInfo.getRate());
                    addDetailInfo.setBasisDay(tmpLocalDate.lengthOfYear());
                    detailInfoMap.put(addDetailInfo.getEndDate(), addDetailInfo);
                    tmpLocalDate = startLocalDate;
                }
                startLocalDate = LocalDate.of(startLocalDate.getYear(), 1, 1);
                basisDay = startLocalDate.lengthOfYear();
                startLocalDate = startLocalDate.plusYears(1L);
            }
            if (tmpLocalDate.compareTo(endLocalDate) > 0) continue;
            detailInfo.setBeginDate(DateUtils.localDate2Date(tmpLocalDate));
            detailInfo.setBasisDay(tmpLocalDate.lengthOfYear());
            detailInfoMap.put(detailInfo.getEndDate(), detailInfo);
        }
        return new ArrayList<IntBillDetailInfo>(detailInfoMap.values());
    }

    private static List<IntBillDetailInfo> getIntDetailsByStartIntDate(Date startIntDate, Date beginDate, Date endDate) {
        LinkedList<IntBillDetailInfo> detailInfos = new LinkedList<IntBillDetailInfo>();
        Date curStartIntDate = startIntDate;
        int lastBasisDay = 0;
        while (endDate.compareTo(curStartIntDate) > 0) {
            Date nextStartIntDate = DateUtils.getNextYear(curStartIntDate, 1);
            Date curEndDate = DateUtils.getLastDay(nextStartIntDate, 1);
            if (beginDate.after(curEndDate)) {
                curStartIntDate = nextStartIntDate;
                continue;
            }
            IntBillDetailInfo detailInfo = new IntBillDetailInfo();
            detailInfo.setBeginDate(curStartIntDate.after(beginDate) ? curStartIntDate : beginDate);
            detailInfo.setEndDate(curEndDate.after(endDate) ? endDate : curEndDate);
            int basisDay = DateUtils.getDiffDays(curStartIntDate, nextStartIntDate) - 1;
            detailInfo.setBasisDay(basisDay);
            if (lastBasisDay != basisDay) {
                detailInfos.add(detailInfo);
            } else {
                IntBillDetailInfo lastDetailInfo = detailInfos.getLast();
                lastDetailInfo.setEndDate(detailInfo.getEndDate());
            }
            lastBasisDay = basisDay;
            curStartIntDate = nextStartIntDate;
        }
        if (endDate.compareTo(curStartIntDate) >= 0) {
            IntBillDetailInfo detailInfo = new IntBillDetailInfo();
            detailInfo.setBeginDate(curStartIntDate);
            detailInfo.setBasisDay(DateUtils.getDiffDays(curStartIntDate, DateUtils.getNextYear(curStartIntDate, 1)) - 1);
            detailInfo.setEndDate(endDate);
            detailInfos.add(detailInfo);
        }
        return detailInfos;
    }

    public static List<IntBillDetailInfo> splitByStartIntDate(IntBillDetailInfo intBillDtailInfo, Date startIntDate, BasisEnum basisEnum) {
        List<IntBillDetailInfo> details = TermHelper.getIntDetailsByStartIntDate(startIntDate, intBillDtailInfo.getBeginDate(), intBillDtailInfo.getEndDate());
        for (IntBillDetailInfo detail : details) {
            detail.setPrinciple(intBillDtailInfo.getPrinciple());
            detail.setRate(intBillDtailInfo.getRate());
            detail.setIntType(intBillDtailInfo.getIntType());
        }
        return details;
    }

    public static List<IntBillDetailInfo> splitByStartIntDate(List<IntBillDetailInfo> detailList, Date startIntDate, BasisEnum basisEnum) {
        if (EmptyUtil.isEmpty(detailList) || startIntDate == null) {
            return detailList;
        }
        detailList.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        ArrayList<IntBillDetailInfo> detailInfos = new ArrayList<IntBillDetailInfo>(10);
        for (IntBillDetailInfo detailInfo : detailList) {
            detailInfos.addAll(TermHelper.splitByStartIntDate(detailInfo, startIntDate, basisEnum));
        }
        return detailInfos;
    }
}

