/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcAccountHelper {
    public static DynamicObject getBankAcctByInnerAcct(DynamicObject innerAcct) {
        if (EmptyUtil.isEmpty(innerAcct)) {
            return null;
        }
        QFilter acctFlt = new QFilter("inneracct.id", "=", innerAcct.getPkValue());
        String selectProps = "id";
        DynamicObject acc = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)selectProps, (QFilter[])new QFilter[]{acctFlt});
        if (acc != null) {
            acc = TmcDataServiceHelper.loadSingleFromCache((Object)acc.getPkValue(), (String)"bd_accountbanks");
        }
        return acc;
    }

    public static DynamicObject getBankAcctBySrcInnerAcct(DynamicObject innerAcct) {
        return TmcBotpHelper.getTargetBill("ifm_inneracct", innerAcct.getPkValue(), "bd_accountbanks");
    }

    public static DynamicObject getBankAcctBySrcBankAcctApplyId(Long bankAcctApplyId) {
        return TmcBotpHelper.getTargetBill("am_accopenbill", bankAcctApplyId, "bd_accountbanks");
    }

    public static Set<Long> getCurrencysByBankAcct(long bankAcctId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(bankAcctId);
        return TmcAccountHelper.getCurrencysByBankAcct(idList);
    }

    public static Set<Long> getCurrencysByBankAcct(List<Long> acctIds) {
        DynamicObjectCollection queryAcctColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,currency.fbasedataid.id,currency.fbasedataid.enable", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds), new QFilter("currency.fbasedataid.enable", "=", (Object)"1")}, null);
        HashSet<Long> idSet = new HashSet<Long>(queryAcctColl.size());
        for (int i = 0; i < queryAcctColl.size(); ++i) {
            DynamicObject acctObj = (DynamicObject)queryAcctColl.get(i);
            idSet.add(acctObj.getLong("currency.fbasedataid.id"));
        }
        return idSet;
    }

    public static boolean canUseAcctbank(long orgId, long acctBankId) {
        return TmcDataServiceHelper.exists("cas_accountassign", new QFilter[]{new QFilter("usagecompany", "=", (Object)orgId), new QFilter("accountbank", "=", (Object)acctBankId), new QFilter("isunassign", "=", (Object)"0")});
    }

    public static QFilter getAccountBankFilterByOrg(Long orgID) {
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)orgID);
    }

    public static DynamicObject[] getAccountBanksByOrg(Long orgID) {
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)orgID);
        return BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,openorg,createorg,bankaccountnumber", (QFilter[])new QFilter[]{qFilter});
    }

    public static QFilter getAccountBankFilterByOrg(Collection<Long> orgIDs) {
        QFilter resQFilter = null;
        int index = 0;
        for (Long orgID : orgIDs) {
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)orgID);
            if (qFilter == null) continue;
            if (index == 0) {
                resQFilter = qFilter;
            } else {
                resQFilter.or(qFilter);
            }
            ++index;
        }
        return resQFilter;
    }

    public static DynamicObject getCreateOrgDOByBankAcct(DynamicObject accountBank) {
        if (EmptyUtil.isEmpty(accountBank)) {
            return null;
        }
        DynamicObject obj = null;
        try {
            obj = accountBank.getDynamicObject("createorg");
        }
        catch (Exception e) {
            DynamicObject acctBank = TmcDataServiceHelper.loadSingle((Object)accountBank.getPkValue(), (String)accountBank.getDynamicObjectType().getName());
            obj = acctBank.getDynamicObject("createorg");
        }
        return obj;
    }

    public static long getCreateOrgByBankAcct(DynamicObject accountBank) {
        if (EmptyUtil.isEmpty(accountBank)) {
            return 0L;
        }
        DynamicObject obj = TmcAccountHelper.getCreateOrgDOByBankAcct(accountBank);
        return null != obj ? obj.getLong("id") : 0L;
    }
}

