/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.ExchangeRateService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ExchangeRateMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.resource.TmcBizResource;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.tuple.Pair;

public class TmcBusinessBaseHelper {
    public static DynamicObject getBaseCurrency(long orgId) {
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        if (null == baseAccountingInfo || baseAccountingInfo.size() == 0) {
            return null;
        }
        Long baseCurrencyId = (Long)baseAccountingInfo.get("baseCurrencyID");
        if (null == baseCurrencyId) {
            return null;
        }
        return TmcDataServiceHelper.loadSingleFromCache((Object)baseCurrencyId, (String)"bd_currency");
    }

    public static DynamicObject getCasBaseCurrency(long orgId) {
        try {
            return TmcBusinessBaseHelper.getStandardCurrency(orgId);
        }
        catch (KDBizException e) {
            return null;
        }
    }

    public static DynamicObject getStandardCurrency(long orgId) {
        DynamicObject systemStatusCtrol = TmcBusinessBaseHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("standardcurrency") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"TmcBusinessBaseHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
        }
        return systemStatusCtrol.getDynamicObject("standardcurrency");
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
    }

    public static DataSet getExChangeDataSet(List<Long> currencyIdList, Long tarCurrencyId, long orgId, Date bizDate, boolean orgQueryWay) {
        boolean isNeedRandom;
        String exchangeRateMethod = TmcParameterHelper.getAppStringParameter(TmcAppEnum.FCS.getId(), RequestContext.get().getOrgId(), "exchangeratemethod");
        long tempOrgId = orgId;
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("tarcurrency", (DataType)DataType.LongType));
        field.add(new Field("rate", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"tmc_getExChangeDataSet");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        currencyIdList = currencyIdList.stream().distinct().collect(Collectors.toList());
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>(currencyIdList.size());
        ArrayList<Long> exChangeTableIds = new ArrayList<Long>(10);
        while (true) {
            DynamicObject superiorOrg;
            Long exchageTableId;
            if (EmptyUtil.isNoEmpty(exchageTableId = TmcBusinessBaseHelper.getExchageTableId(tempOrgId))) {
                exChangeTableIds.add(exchageTableId);
            }
            if ((superiorOrg = TmcOrgDataHelper.getSuperiorOrgs(tempOrgId, "01")) == null || superiorOrg.getLong("id") == tempOrgId) break;
            tempOrgId = superiorOrg.getLong("id");
        }
        if (EmptyUtil.isNoEmpty(exChangeTableIds)) {
            rateMap.putAll(TmcBusinessBaseHelper.getExchageRateBatchByTable(exChangeTableIds, currencyIdList, tarCurrencyId, bizDate));
        }
        boolean bl = isNeedRandom = exchangeRateMethod != null && exchangeRateMethod.equals(ExchangeRateMethodEnum.stepupandrandom.getValue()) && rateMap.size() < currencyIdList.size();
        if (isNeedRandom) {
            ArrayList<Long> tempCurrencyList = new ArrayList<Long>(currencyIdList);
            tempCurrencyList.removeAll(rateMap.keySet());
            List<Long> exchageTables = TmcBusinessBaseHelper.getExchageTableIdWithoutOrg();
            exchageTables.removeAll(exChangeTableIds);
            rateMap.putAll(TmcBusinessBaseHelper.getExchageRateBatchByTable(exchageTables, tempCurrencyList, tarCurrencyId, bizDate));
        }
        currencyIdList.removeAll(rateMap.keySet());
        if (currencyIdList.size() > 0) {
            DynamicObject targetCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)tarCurrencyId, (String)"bd_currency", (String)"name");
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyIdList.get(0), (String)"bd_currency");
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
            throw new KDBizException(String.format(TmcBizResource.getReportExChangeRate(), EmptyUtil.isNoEmpty(org) ? org.getString("name") : null, EmptyUtil.isNoEmpty(currency) ? currency.getString("name") : null, EmptyUtil.isNoEmpty(targetCurrency) ? targetCurrency.getString("name") : null));
        }
        for (Map.Entry entry : rateMap.entrySet()) {
            Long key = (Long)entry.getKey();
            BigDecimal value = (BigDecimal)entry.getValue();
            Object[] obj = new Object[]{key, value};
            dsBuilder.append(obj);
        }
        return dsBuilder.build();
    }

    public static Map<Long, BigDecimal> getExchageRateBatchByTable(List<Long> exchangeTableIDs, List<Long> sourceCurrencyIDs, Long targetCurrencyID, Date date) {
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>(sourceCurrencyIDs.size());
        ArrayList<Pair> currencyGroups = new ArrayList<Pair>(sourceCurrencyIDs.size());
        for (Long sourceCurrencyID : sourceCurrencyIDs) {
            if (sourceCurrencyID.equals(targetCurrencyID)) {
                rateMap.put(sourceCurrencyID, BigDecimal.ONE);
                continue;
            }
            currencyGroups.add(Pair.of((Object)(sourceCurrencyID + "_" + targetCurrencyID), (Object)(targetCurrencyID + "_" + sourceCurrencyID)));
        }
        ArrayList<Long> currencyIDs = new ArrayList<Long>(sourceCurrencyIDs.size() + 1);
        currencyIDs.addAll(sourceCurrencyIDs);
        if (!currencyIDs.contains(targetCurrencyID)) {
            currencyIDs.add(targetCurrencyID);
        }
        QFilter filter = new QFilter("orgcur", "in", currencyIDs);
        filter.and("cur", "in", currencyIDs);
        filter.and("enable", "=", (Object)"1");
        if (date != null) {
            filter.and("effectdate", "<=", (Object)date);
        }
        for (Long exchangeTableID : exchangeTableIDs) {
            QFilter qFilterTable = new QFilter("exctable", "=", (Object)exchangeTableID);
            if (ExchangeRateService.isEnableExchangeRateExpiryDate((Long)exchangeTableID)) {
                qFilterTable.and("expirydate", ">=", (Object)date);
            }
            List<DynamicObject> list = TmcBusinessBaseHelper.queryExrateTree(new QFilter[]{filter, qFilterTable});
            LinkedHashMap collect = list.stream().collect(Collectors.groupingBy(e -> e.get("orgcur") + "_" + e.get("cur"), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
            ArrayList<Pair> foundCurrencyGroups = new ArrayList<Pair>(10);
            for (Pair currencyGroup : currencyGroups) {
                DynamicObject rate;
                ArrayList rates;
                if (collect.containsKey(currencyGroup.getLeft())) {
                    rates = (ArrayList)collect.get(currencyGroup.getLeft());
                    rate = (DynamicObject)rates.get(0);
                    rateMap.put(rate.getLong("orgcur"), rate.getBigDecimal("excval"));
                    foundCurrencyGroups.add(currencyGroup);
                    continue;
                }
                if (!collect.containsKey(currencyGroup.getRight())) continue;
                rates = (ArrayList)collect.get(currencyGroup.getRight());
                rate = (DynamicObject)rates.get(0);
                rateMap.put(rate.getLong("cur"), rate.getBigDecimal("indirectexrate"));
                foundCurrencyGroups.add(currencyGroup);
            }
            currencyGroups.removeAll(foundCurrencyGroups);
        }
        return rateMap;
    }

    private static List<DynamicObject> queryExrateTree(QFilter[] qFilters) {
        ORM orm = ORM.create();
        return orm.query("bd_exrate_tree", "id,orgcur,cur,excval,indirectexrate,effectdate", qFilters, "effectdate desc");
    }

    public static List<Long> getExchageTableIdWithoutOrg() {
        Map exRateTable = TmcDataServiceHelper.loadFromCache((String)"bd_exratetable", (String)"id,enable,expirydate", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return exRateTable.keySet().stream().map(t -> Long.parseLong(t.toString())).collect(Collectors.toList());
    }

    public static BigDecimal getExchangeRate(long sourceCurrencyID, long targetCurrencyID, long orgId, Date bizDate) {
        Long exchangeTableID = TmcBusinessBaseHelper.getExchageTableId(orgId);
        if (null == exchangeTableID) {
            return null;
        }
        return BaseDataServiceHelper.getExchangeRate((Long)exchangeTableID, (Long)sourceCurrencyID, (Long)targetCurrencyID, (Date)bizDate);
    }

    public static List<Long> objectsToIdList(DynamicObject[] infos) {
        ArrayList<Long> idList = new ArrayList<Long>(infos.length);
        for (DynamicObject info : infos) {
            idList.add(info.getLong("id"));
        }
        return idList;
    }

    public static String idListToString(List<Long> idList) {
        ArrayList<String> list = new ArrayList<String>(idList.size());
        for (Long id : idList) {
            list.add(String.valueOf(id));
        }
        return TmcBusinessBaseHelper.listToString(list);
    }

    public static String listToString(List<String> idList) {
        return String.join((CharSequence)",", idList);
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(TmcBusinessBaseHelper.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String toPattern(int scale) {
        StringBuilder s = new StringBuilder(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append('0');
        }
        return s.toString();
    }

    public static String toBase64String(byte[] bytes) {
        String result = null;
        try {
            result = new String(Base64.encodeBase64((byte[])bytes), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static byte[] decodeBase64(String base64String) {
        return Base64.decodeBase64((String)base64String);
    }

    public static BigDecimal getTransPayingAmt(Long bankAcctId, Long currencyId, boolean isPay) {
        BigDecimal upAmount = Constants.ZERO;
        QFilter status = new QFilter("billstatus", "=", (Object)BillStatusEnum.PAYING.getValue()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
        if (!isPay) {
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
            status.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(status);
        filters.add(new QFilter("entrys.subacct", "=", (Object)bankAcctId));
        filters.add(new QFilter("entrys.state", "=", (Object)"normal"));
        filters.add(new QFilter("entrys.paystatus", "in", (Object)new String[]{"init", "beiproc", "payproc", "noconfirm"}));
        filters.add(new QFilter("currency", "=", (Object)currencyId));
        DataSet payBillSet = QueryServiceHelper.queryDataSet((String)"paymentbill", (String)"fca_transupbill", (String)"entrys.transamt", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        DataSet ds = payBillSet.groupBy(new String[0]).sum("entrys.transamt").finish();
        if (ds.hasNext()) {
            upAmount = ds.next().getBigDecimal("entrys.transamt");
        }
        ds.close();
        BigDecimal downAmount = Constants.ZERO;
        filters = new ArrayList();
        filters.add(status);
        filters.add(new QFilter("accountbank", "=", (Object)bankAcctId));
        filters.add(new QFilter("entrys.state", "=", (Object)"normal"));
        filters.add(new QFilter("entrys.paystatus", "in", (Object)new String[]{"init", "beiproc", "payproc", "noconfirm"}));
        filters.add(new QFilter("currency", "=", (Object)currencyId));
        payBillSet = QueryServiceHelper.queryDataSet((String)"paymentbill", (String)"fca_transdownbill", (String)"entrys.transamt", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        ds = payBillSet.groupBy(new String[0]).sum("entrys.transamt").finish();
        if (ds.hasNext()) {
            downAmount = ds.next().getBigDecimal("entrys.transamt");
        }
        ds.close();
        return upAmount.add(downAmount);
    }

    public static BigDecimal getSchePayingAmt(Long bankAcctId, Long currencyId) {
        DynamicObject[] sCheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("acctbank", "=", (Object)bankAcctId), new QFilter("paycurrency", "=", (Object)currencyId), new QFilter("schedulstatus", "=", (Object)"yetschedule")});
        BigDecimal sChePayingAmt = Arrays.stream(sCheBills).map(v -> v.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sChePayingAmt;
    }

    public static BigDecimal getAcctPayingAmt(Long bankAcctId, Long currencyId) {
        BigDecimal agentPayBillOnWayAmt = CasBusinessHelper.getAgentPayBillOnWayAmt(bankAcctId, currencyId, false);
        BigDecimal payBillOnWayAmt = CasBusinessHelper.getPayBillOnWayAmt(bankAcctId, currencyId);
        BigDecimal schePayingAmt = TmcBusinessBaseHelper.getSchePayingAmt(bankAcctId, currencyId);
        BigDecimal transPayingAmt = TmcBusinessBaseHelper.getTransPayingAmt(bankAcctId, currencyId, false);
        return agentPayBillOnWayAmt.add(payBillOnWayAmt).add(schePayingAmt).add(transPayingAmt);
    }

    public static BigDecimal getD_MinRemainedAmt(DynamicObject bankAcct, DynamicObject stratg) {
        if (stratg == null) {
            return new BigDecimal(0);
        }
        BigDecimal minRemainAmt = stratg.getBigDecimal("miniacctlimit");
        return minRemainAmt;
    }

    public static DynamicObject getAcctStratg(Long bankAcctId, Long currencyId) {
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingle((Object)bankAcctId, (String)"bd_accountbanks");
        DynamicObject stratg = bankAcct.getDynamicObject("strategy");
        if (stratg == null) {
            return null;
        }
        if ((stratg = TmcDataServiceHelper.loadSingle((Object)stratg.getPkValue(), (String)"am_strategy")).get("currency") == null) {
            return null;
        }
        Long curCurrencyId = (Long)stratg.getDynamicObject("currency").getPkValue();
        if (curCurrencyId == null) {
            return null;
        }
        if (currencyId.longValue() == curCurrencyId.longValue()) {
            return stratg;
        }
        return null;
    }

    public static BigDecimal getLastestBeBalance(Long acctBankId, Long currencyId) {
        QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", (Object)acctBankId), new QFilter("currency", "=", (Object)currencyId)};
        DynamicObjectCollection balanceInquires = QueryServiceHelper.query((String)"getLastestBalanceInquire", (String)"bei_bankbalance", (String)"amount,bizdate,modifytime", (QFilter[])filters, (String)"modifytime desc", (int)1);
        return balanceInquires.isEmpty() ? BigDecimal.ZERO : ((DynamicObject)balanceInquires.get(0)).getBigDecimal("amount");
    }

    public static DynamicObject getInternalOrg(DynamicObject basedata) {
        if (basedata == null) {
            return null;
        }
        String entity = basedata.getDataEntityType().getName();
        return (basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)entity, (String)"internal_company")) == null ? null : basedata.getDynamicObject("internal_company");
    }

    public static QFilter getTradeTypeFilter(IFormView view) {
        return TmcBusinessBaseHelper.getTradeTypeFilter(view, "id");
    }

    public static QFilter getTradeTypeFilter(IFormView view, String filterField) {
        ArrayList<Long> productTypeIds = new ArrayList<Long>(0);
        String appId = view.getFormShowParameter().getAppId();
        String billFormId = view.getFormShowParameter().getFormId();
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            billFormId = ((ListShowParameter)view.getFormShowParameter()).getBillFormId();
        }
        if ("fbd_feescheme_lc".equals(billFormId)) {
            productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId("lc", billFormId));
        } else {
            productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId(appId, billFormId));
        }
        return new QFilter(filterField, "in", productTypeIds);
    }

    public static String getAppSource(String formId) {
        if (Arrays.asList(ProductTypeEnum.LOANCONTRACT_BO.getFormId(), ProductTypeEnum.LOANBILL_BOND.getFormId()).contains(formId)) {
            return "bdim";
        }
        if (ProductTypeEnum.CFM_CREDITLIMIT.getFormId().equals(formId)) {
            return "creditm";
        }
        if (formId.startsWith("lc_")) {
            return "lc";
        }
        if (formId.startsWith("cdm_")) {
            return "cdm";
        }
        if (formId.startsWith("tm_")) {
            return "tm";
        }
        if (formId.startsWith("cfm_")) {
            return "cfm";
        }
        if (formId.startsWith("gm_")) {
            return "gm";
        }
        if (formId.startsWith("am_")) {
            return "am";
        }
        if (formId.startsWith("scf_")) {
            return "scf";
        }
        if (formId.startsWith("fl_")) {
            return "fl";
        }
        return " ";
    }

    public static QFilter getOrgFilter(String productTypeNum) {
        String entity = ProductTypeEnum.getEnumByValue(productTypeNum).getEntity();
        QFilter tQFilter = new QFilter(Arrays.asList("cfm_creditlimit", "creditm_limit_framework").contains(entity) ? "status" : "billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId(RequestContext.get().getCurrUserId(), dataEntityType.getAppId(), entity, "47150e89000000ac");
        if (entity != null) {
            if (entity.startsWith("cdm")) {
                tQFilter.and("company", "in", (Object)authorizedBankOrgId);
            } else if (entity.equals("am_acctclosebill") || entity.equals("am_accopenbill") || entity.equals("am_changeapply")) {
                tQFilter.and("company", "in", (Object)authorizedBankOrgId);
            } else if (entity.equals("gm_letterofguarantee")) {
                tQFilter.and(new QFilter("org", "in", (Object)authorizedBankOrgId).or("applyorg", "in", (Object)authorizedBankOrgId));
            } else if (entity.equals("gm_pledgebill")) {
                tQFilter.and(new QFilter("org", "in", (Object)authorizedBankOrgId).or("realrightpersonid", "in", (Object)authorizedBankOrgId));
            } else {
                tQFilter.and("org", "in", (Object)authorizedBankOrgId);
            }
        }
        return tQFilter;
    }

    public static String getDefaultBizType(String billFormId) {
        if ("lc_feebill".equals(billFormId)) {
            return "lc";
        }
        if ("bdim_feebill".equals(billFormId)) {
            return "bdim";
        }
        if (billFormId != null && billFormId.endsWith("_feebill")) {
            return billFormId.replaceAll("_feebill", "");
        }
        if (billFormId != null && billFormId.endsWith("_pledgefeebill")) {
            return billFormId.replaceAll("_pledgefeebill", "");
        }
        if (billFormId != null && billFormId.endsWith("_contractfeebill")) {
            return billFormId.replaceAll("_contractfeebill", "");
        }
        return "cfm";
    }

    public static List<Long> getProductTypeId(String bizType) {
        return TmcBusinessBaseHelper.getProductTypeId(bizType, null);
    }

    public static List<Long> getProductTypeId(String bizType, String billFormId) {
        ArrayList<Long> productTypeIds = new ArrayList<Long>(10);
        if ("cfm".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LOANCONTRACT_BL_L.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LOANCONTRACT_IC_L.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LOANBILL_B_L.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LOANBILL_E_L.getId()));
        } else if ("bdim".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LOANCONTRACT_BO.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LOANBILL_BOND.getId()));
        } else if ("lc".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LC_LETTER.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LC_ARRIVAL.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LC_PRESENT.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LC_FORFAIT.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.LC_RECEIPT.getId()));
        } else if ("cdm".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.CDM_PAYABLEBILL_APPLY.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.CDM_PAYABLEBILL.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.CDM_RECEIVABLEBILL.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.CDM_DRAFTTRADEBILL.getId()));
        } else if ("am".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.AM_BUSINESS_APPLY.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.AM_HOLD_GOODS_INFO.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.AM_ACCOUNTBANK.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.AM_ACCOPENBILL.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.AM_ACCTCLOSEBILL.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.AM_CHANGEAPPLY.getId()));
        } else if ("tm".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.FOREXSPOT.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.FOREXFORWARD.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.FOREXSWAPS.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.FOREXOPTION.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.BONDFIX.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.BONDFLOAT.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.BONDOPTION.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.FORWRATEAGREE.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.SWAP.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.RATEBOUND.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.STRUCTDEPOSIT.getId()));
            if (EmptyUtil.isNoEmpty(ProductTypeEnum.DEPOSIT.getId())) {
                productTypeIds.add(Long.valueOf(ProductTypeEnum.DEPOSIT.getId()));
            }
            if (EmptyUtil.isNoEmpty(ProductTypeEnum.LOAN.getId())) {
                productTypeIds.add(Long.valueOf(ProductTypeEnum.LOAN.getId()));
            }
        } else if ("gm".equals(bizType)) {
            if (billFormId != null && billFormId.endsWith("_feebill")) {
                productTypeIds.add(Long.valueOf(ProductTypeEnum.GM_LETTEROFGUARANTEE.getId()));
            } else if (billFormId != null && billFormId.endsWith("_pledgefeebill")) {
                productTypeIds.add(Long.valueOf(ProductTypeEnum.GM_PLEDGEBILL.getId()));
            } else if (billFormId != null && billFormId.endsWith("_contractfeebill")) {
                productTypeIds.add(Long.valueOf(ProductTypeEnum.GM_GUARANTEECONTRACT.getId()));
            } else {
                productTypeIds.add(Long.valueOf(ProductTypeEnum.GM_LETTEROFGUARANTEE.getId()));
                productTypeIds.add(Long.valueOf(ProductTypeEnum.GM_PLEDGEBILL.getId()));
                productTypeIds.add(Long.valueOf(ProductTypeEnum.GM_GUARANTEECONTRACT.getId()));
            }
        } else if ("scf".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.SCF_FIN_DEBTS.getId()));
            productTypeIds.add(Long.valueOf(ProductTypeEnum.SCF_FIN_CREDIT.getId()));
        } else if ("creditm".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.CFM_CREDITLIMIT.getId()));
        } else if ("fl".equals(bizType)) {
            productTypeIds.add(Long.valueOf(ProductTypeEnum.FL_LEASE_CONTRACT_BILL.getId()));
        }
        return productTypeIds;
    }

    public static Long getExchageTableId(Long orgId) {
        DynamicObject standardExRateTable;
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        Long exchangeTableId = null;
        if (EmptyUtil.isNoEmpty(baseAccountingInfo)) {
            exchangeTableId = (Long)baseAccountingInfo.get("exchangeRateTableID");
        }
        if (EmptyUtil.isEmpty(exchangeTableId) && EmptyUtil.isNoEmpty(standardExRateTable = SystemStatusCtrolHelper.getStandardExRateTable(orgId))) {
            exchangeTableId = standardExRateTable.getLong("id");
        }
        return exchangeTableId;
    }

    public static BigDecimal getExchangeRateNew(long sourceCurrencyID, long targetCurrencyID, long orgId, Date bizDate) {
        Long exchangeTableID = TmcBusinessBaseHelper.getExchageTableId(orgId);
        if (null == exchangeTableID) {
            return null;
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)sourceCurrencyID, (Long)targetCurrencyID, (Long)exchangeTableID, (Date)bizDate);
        if (EmptyUtil.isEmpty(exchangeRateMap) || EmptyUtil.isEmpty(exchangeRateMap.get("exchangeRate"))) {
            return null;
        }
        boolean quoteType = false;
        if (exchangeRateMap.get("quoteType") != null) {
            quoteType = (Boolean)exchangeRateMap.get("quoteType");
        }
        BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
        exchangeRate = quoteType ? BigDecimal.ONE.divide(exchangeRate, 10, 0).setScale(6, 0) : exchangeRate.setScale(6, 0);
        return exchangeRate;
    }

    public static boolean checkFormISV(String formId) {
        String thisISV = (String)DB.query((DBRoute)DBRoute.meta, (String)"select fisv from t_meta_formdesign where fnumber = ? and ftype != '2'", (Object[])new Object[]{formId}, rs -> {
            String isv = null;
            if (rs.next()) {
                isv = rs.getString("fisv");
            }
            return isv;
        });
        return thisISV.equals("kingdee");
    }

    public static String getBillFormId(String billFormId) {
        if ("creditm_limit_framework".equals(billFormId)) {
            return "cfm_creditlimit";
        }
        if ("fl_leasecontractbill_init".equals(billFormId)) {
            return "fl_leasecontractbill";
        }
        return billFormId;
    }
}

