/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import kd.bos.exception.KDBizException;

public class TmcDigestHelper {
    public static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("TmcDigestHelper:[%s] args:[%s]", e.getMessage(), message));
        }
    }

    public static void main(String[] args) {
        String message = "accountbank:1340576638097727488,bizdate:2022-02-22 00:00:00.0,company:100000,currency:1,";
        String digest = TmcDigestHelper.getSHA256Base64Str(message);
        System.out.println(digest);
        message = "accountbank:1336180396043314176,bizdate:2022-02-22 00:00:00.0,company:100000,currency:1,";
        digest = TmcDigestHelper.getSHA256Base64Str(message);
        System.out.println(digest);
    }
}

