/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;

@KSObject
public class TmcOperateServiceHelper
extends OperationServiceHelper {
    @KSMethod
    public static OperationResult execOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option, boolean RequireNew) {
        if (RequireNew) {
            try (TXHandle tx = TX.requiresNew();){
                OperationResult operationResult = TmcOperateServiceHelper.execOperate(operationKey, entityNumber, dataEntities, option);
                return operationResult;
            }
        }
        return TmcOperateServiceHelper.execOperate(operationKey, entityNumber, dataEntities, option);
    }

    @KSMethod
    public static OperationResult execOperate(String operationKey, String entityNumber, Object[] ids, OperateOption option, boolean RequireNew) {
        if (RequireNew) {
            try (TXHandle tx = TX.requiresNew();){
                OperationResult operationResult = TmcOperateServiceHelper.execOperate(operationKey, entityNumber, ids, option);
                return operationResult;
            }
        }
        return TmcOperateServiceHelper.execOperate(operationKey, entityNumber, ids, option);
    }

    @KSMethod
    public static OperationResult execOperateNoTransaction(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        try (TXHandle tx = TX.notSupported();){
            OperationResult operationResult = TmcOperateServiceHelper.execOperate(operationKey, entityNumber, ids, option);
            return operationResult;
        }
    }

    @KSMethod
    public static OperationResult execOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        TmcOperateServiceHelper.setVariableHasRight(option);
        OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{TmcOperateServiceHelper.decodeErrorMsg(operationResult)});
        }
        return operationResult;
    }

    private static void setVariableHasRight(OperateOption option) {
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", "true");
    }

    @KSMethod
    public static OperationResult execOperate(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        TmcOperateServiceHelper.setVariableHasRight(option);
        OperationResult operationResult = TmcOperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{TmcOperateServiceHelper.decodeErrorMsg(operationResult)});
        }
        return operationResult;
    }

    @KSMethod
    public static OperationResult execOperateWithoutThrow(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        TmcOperateServiceHelper.setVariableHasRight(option);
        return TmcOperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])ids, (OperateOption)option);
    }

    public static OperationResult execOperateWithoutThrow(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        TmcOperateServiceHelper.setVariableHasRight(option);
        return TmcOperateServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
    }

    @KSMethod
    public static OperationResult execOperateNoWorkFlow(String operationKey, String entityNumber, Object[] ids, OperateOption option, boolean isRequireNew) {
        option.setVariableValue("WF", "TRUE");
        return TmcOperateServiceHelper.execOperate(operationKey, entityNumber, ids, option, isRequireNew);
    }

    @KSMethod
    public static OperationResult execOperateNoWorkFlowWithoutThrow(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        option.setVariableValue("WF", "TRUE");
        return TmcOperateServiceHelper.execOperateWithoutThrow(operationKey, entityNumber, ids, option);
    }

    @KSMethod
    public static OperationResult execOperateNoWorkFlow(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option, boolean isRequireNew) {
        option.setVariableValue("WF", "TRUE");
        return TmcOperateServiceHelper.execOperate(operationKey, entityNumber, dataEntities, option, isRequireNew);
    }

    @KSMethod
    public static OperationResult execOperateNoWorkFlowWithoutThrow(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        option.setVariableValue("WF", "TRUE");
        return TmcOperateServiceHelper.execOperateWithoutThrow(operationKey, entityNumber, dataEntities, option);
    }

    public static String decodeErrorMsg(OperationResult operationResult) {
        String errMsg;
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            errMsg = TmcOperateServiceHelper.decodeMultiErrorMsg(operationResult);
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            errMsg = errorInfo.getMessage();
        } else {
            errMsg = operationResult.getMessage();
        }
        return errMsg;
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        StringBuilder buf = new StringBuilder();
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            buf.append(((IOperateInfo)errorInfos.get(i)).getMessage()).append('\n');
        }
        return buf.toString();
    }

    public static String getErrorMsgByBill(OperationResult operationResult, Long billId) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        List Infos = errorInfos.stream().filter(i -> i.getPkValue().equals(billId)).collect(Collectors.toList());
        StringBuilder buf = new StringBuilder();
        for (IOperateInfo info : Infos) {
            buf.append(info.getMessage()).append('\n');
        }
        return buf.toString();
    }
}

