/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.CompanySysAuthScopeEnum;
import kd.tmc.fbp.common.enums.CompanySysAuthTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.OrgCacheManager;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TmcOrgDataHelper {
    private static final Log logger = LogFactory.getLog(TmcOrgDataHelper.class);
    private static final String entityID_bos_org = "bos_org";
    private static final String entityID_org_pattern = "bos_org_pattern";
    private static final int NO_LEGAL_PERSON = 3;

    public static long getCurrentOrgId() {
        return RequestContext.get().getOrgId();
    }

    public static DynamicObject getCurrentOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)entityID_bos_org);
        return TmcDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
    }

    public static DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)entityID_bos_org);
        DynamicObject currentOrg = TmcDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }

    public static DynamicObject getCurrentPermOrg(String appId, String permissionEntity, String permissionItem) throws KDBizException {
        MainEntityType orgType;
        DynamicObject currentOrg;
        Long userPK = Long.valueOf(RequestContext.get().getUserId());
        Long orgId = RequestContext.get().getOrgId();
        if (TmcOrgDataHelper.hasPermission(appId, userPK, orgId, permissionEntity, permissionItem) && (currentOrg = TmcDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)(orgType = EntityMetadataCache.getDataEntityType((String)entityID_bos_org)))).getBoolean("fisbankroll")) {
            return currentOrg;
        }
        DynamicObjectCollection orgList = TmcOrgDataHelper.getAuthorizedBankOrg(userPK, appId, permissionEntity, permissionItem, true);
        if (orgList.size() > 0) {
            return (DynamicObject)orgList.get(0);
        }
        throw new TmcBizException(new TmcErrorCode().NOT_PERMORG());
    }

    public static QFilter getAuthorizedBankOrgFilter(Long userID, String appId, String entityID, String permissionItem) {
        List<Long> orgIdList = TmcOrgDataHelper.getCacheUserPermission(userID, appId, entityID, permissionItem);
        QFilter filter = new QFilter("fisbankroll", "=", (Object)"1").and("enable", "=", (Object)"1");
        if (orgIdList != null) {
            filter = filter.and("id", "in", orgIdList);
        }
        return filter;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String appId, String entityID, String permissionItem, boolean isBankRollFilter) {
        QFilter filter = TmcOrgDataHelper.getAuthorizedBankOrgFilter(userID, appId, entityID, permissionItem);
        Map orgMap = TmcDataServiceHelper.loadFromCache((String)entityID_bos_org, (QFilter[])filter.toArray());
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)entityID_bos_org);
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (Map.Entry entry : orgMap.entrySet()) {
            orgColl.add(entry.getValue());
        }
        return orgColl;
    }

    public static DynamicObjectCollection getAuthorizedBankOrgFromCache(Long userID, String appId, String entityID, String permissionItem) {
        QFilter filter = TmcOrgDataHelper.getAuthorizedBankOrgFilter(userID, appId, entityID, permissionItem);
        Map orgMap = TmcDataServiceHelper.loadFromCache((String)entityID_bos_org, (String)"id", (QFilter[])filter.toArray());
        DynamicObjectCollection orgColl = new DynamicObjectCollection();
        for (Map.Entry entry : orgMap.entrySet()) {
            orgColl.add(entry.getValue());
        }
        return orgColl;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String appId, String entityID, String permissionItem) {
        QFilter filter = TmcOrgDataHelper.getAuthorizedBankOrgFilter(userID, appId, entityID, permissionItem);
        return QueryServiceHelper.query((String)entityID_bos_org, (String)"id", (QFilter[])filter.toArray());
    }

    public static DynamicObject getCurrentAuthPermOrg(String appId, String entityID, String permissionItem, long orgId) {
        DynamicObject currentAuthPermOrg = null;
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"01")) {
            currentAuthPermOrg = TmcOrgDataHelper.getCurrentPermAdminOrgGradually(appId, entityID, permissionItem, orgId);
        }
        if (EmptyUtil.isEmpty(currentAuthPermOrg)) {
            currentAuthPermOrg = TmcOrgDataHelper.getCurrentPermOrgGradually(appId, entityID, permissionItem, orgId, "15");
        }
        return currentAuthPermOrg;
    }

    public static DynamicObject getCurrentPermAdminOrgGradually(String appId, String entityID, String permissionItem, long orgId) {
        long currUserId = RequestContext.get().getCurrUserId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)entityID_bos_org);
        long tempOrgId = orgId;
        while (true) {
            DynamicObject superiorOrg;
            List relationOrgIds;
            if (EmptyUtil.isNoEmpty(relationOrgIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(tempOrgId), (boolean)false))) {
                for (Long relationOrgId : relationOrgIds) {
                    boolean hasPerm = TmcOrgDataHelper.hasPermission(appId, currUserId, relationOrgId, entityID, permissionItem);
                    if (!hasPerm || !OrgUnitServiceHelper.checkOrgFunction((Long)relationOrgId, (String)"08")) continue;
                    return TmcDataServiceHelper.loadSingleFromCache((Object)relationOrgId, (DynamicObjectType)orgType);
                }
            }
            if ((superiorOrg = TmcOrgDataHelper.getSuperiorOrgs(tempOrgId, "01")) == null || superiorOrg.getLong("id") == tempOrgId) {
                return null;
            }
            tempOrgId = superiorOrg.getLong("id");
        }
    }

    public static DynamicObject getCurrentPermOrgGradually(String appId, String entityID, String permissionItem, long orgId, String viewType) {
        DynamicObject currentOrg;
        long userPK = RequestContext.get().getCurrUserId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)entityID_bos_org);
        if (TmcOrgDataHelper.hasPermission(appId, userPK, orgId, entityID, permissionItem) && (currentOrg = TmcDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType)).getBoolean("fisbankroll")) {
            return currentOrg;
        }
        long tempOrgId = orgId;
        while (true) {
            DynamicObject superiorOrg;
            if (null != (superiorOrg = TmcOrgDataHelper.getSuperiorOrgs(tempOrgId, viewType)) && TmcOrgDataHelper.hasPermission(appId, userPK, superiorOrg.getLong("id"), entityID, permissionItem) && superiorOrg.getBoolean("fisbankroll")) {
                return TmcDataServiceHelper.loadSingleFromCache((Object)superiorOrg.getLong("id"), (DynamicObjectType)orgType);
            }
            if (null == superiorOrg || superiorOrg.getLong("id") == orgId) break;
            tempOrgId = superiorOrg.getLong("id");
        }
        DynamicObjectCollection orgList = TmcOrgDataHelper.getAuthorizedBankOrg(userPK, appId, entityID, permissionItem, true);
        if (orgList.size() > 0) {
            return (DynamicObject)orgList.get(0);
        }
        throw new TmcBizException(new TmcErrorCode().NOT_PERMORG());
    }

    public static List getAuthorizedBankOrgId(Long userID, String appId, String entityID, String permissionItem) {
        QFilter filter = TmcOrgDataHelper.getAuthorizedBankOrgFilter(userID, appId, entityID, permissionItem);
        ArrayList idList = new ArrayList(10);
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)entityID_bos_org, (String)entityID_bos_org, (String)"id", (QFilter[])filter.toArray(), null);
        orgDataSet.forEach(d -> idList.add(d.get("id")));
        return idList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getAuthorizedBankOrgIdList(Long userID, String appId, String entityID, String permissionItem) {
        List<Long> orgIdList = TmcOrgDataHelper.getCacheUserPermission(userID, appId, entityID, permissionItem);
        if (orgIdList != null && !orgIdList.isEmpty()) {
            ArrayList<Long> arrayList;
            QFilter filter = new QFilter("fisbankroll", "=", (Object)"1").and("enable", "=", (Object)"1").and("id", "in", orgIdList);
            ArrayList<Long> orgIds = new ArrayList<Long>(orgIdList.size());
            DataSet orgDataSet = null;
            try {
                orgDataSet = QueryServiceHelper.queryDataSet((String)entityID_bos_org, (String)entityID_bos_org, (String)"id", (QFilter[])filter.toArray(), null);
                orgDataSet.forEach(d -> orgIds.add(d.getLong("id")));
                arrayList = orgIds;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(orgDataSet);
                throw throwable;
            }
            IOUtils.closeQuietly((AutoCloseable)orgDataSet);
            return arrayList;
        }
        return orgIdList;
    }

    public static List<Long> getAuthorizedAccountLegalOrgId(Long userID, String appId, String entityID, String permissionItem) {
        List<Long> orgIdList = TmcOrgDataHelper.getCacheUserPermission(userID, appId, entityID, permissionItem);
        QFilter filter = new QFilter("orgpattern.patterntype", "!=", (Object)String.valueOf(3)).and(new QFilter("enable", "=", (Object)"1"));
        if (orgIdList != null) {
            filter = filter.and(new QFilter("id", "in", orgIdList));
        }
        ArrayList<Long> idList = new ArrayList<Long>(10);
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)entityID_bos_org, (String)entityID_bos_org, (String)"id", (QFilter[])filter.toArray(), null);
        orgDataSet.forEach(d -> idList.add(d.getLong("id")));
        return idList;
    }

    public static boolean hasPermission(String appId, long userId, long orgId, String entityId, String permissionItemId) {
        int res;
        if (EmptyUtil.isEmpty(appId) && EmptyUtil.isNoEmpty(entityId)) {
            appId = EntityMetadataCache.getDataEntityType((String)entityId).getAppId();
        }
        return (res = PermissionServiceHelper.checkFunctionPermission((String)(appId = AppMetadataCache.getAppInfo((String)appId).getId()), (long)userId, (long)orgId, (String)entityId, (String)permissionItemId)) == 1;
    }

    public static void checkFunctionPermission(String appId, long userId, long orgId, String entityId, String permissionItemId) {
        int res;
        MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityId);
        if (EmptyUtil.isEmpty(appId)) {
            appId = EntityMetadataCache.getDataEntityType((String)entityId).getAppId();
        }
        if ((res = PermissionServiceHelper.checkFunctionPermission((String)(appId = AppMetadataCache.getAppInfo((String)appId).getId()), (long)userId, (long)orgId, (String)entityId, (String)permissionItemId)) == 0) {
            DynamicObject perm = TmcDataServiceHelper.loadSingleFromCache((Object)permissionItemId, (String)"perm_permitem");
            DynamicObject org = TmcDataServiceHelper.loadSingleFromCache((Object)orgId, (String)entityID_bos_org);
            throw new TmcBizException(new TmcErrorCode().HASNOPERM(), new Object[]{org.getString("name"), entity.getDisplayName(), perm.getString("name")});
        }
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }

    public static DynamicObject getOrgById(long id) {
        Map orgMap = TmcDataServiceHelper.loadFromCache((Object[])new Object[]{id}, (String)entityID_bos_org);
        return (DynamicObject)orgMap.get(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicObject getAccountOrgByFundsOrg(DynamicObject fundsOrg) {
        if (EmptyUtil.isEmpty(fundsOrg)) {
            return null;
        }
        DynamicObject accountOrg = null;
        boolean isAccount = fundsOrg.getBoolean("fisaccounting");
        if (isAccount) {
            DynamicObject tempSuperOrg;
            DynamicObject superOrg = fundsOrg;
            do {
                boolean isLegalPerson = false;
                if (!EmptyUtil.isEmpty(superOrg.getDynamicObject("orgpattern"))) {
                    Long id = superOrg.getLong("orgpattern.id");
                    DynamicObject orgpattern = TmcDataServiceHelper.loadSingle((Object)id, (String)entityID_org_pattern, (String)"id, patterntype");
                    boolean bl = isLegalPerson = orgpattern.getInt("patterntype") != 3;
                }
                if (isLegalPerson) {
                    return superOrg;
                }
                tempSuperOrg = TmcOrgDataHelper.getSuperiorOrgs(fundsOrg.getLong("id"));
                if (tempSuperOrg != null && tempSuperOrg.getLong("id") == fundsOrg.getLong("id")) return accountOrg;
                fundsOrg = tempSuperOrg;
            } while ((superOrg = tempSuperOrg) != null);
            return accountOrg;
        } else {
            Long orgid = OrgServiceHelper.getToOrg((String)"08", (String)"10", (Long)fundsOrg.getLong("id"), (Long)0L);
            if (!TmcDataServiceHelper.exists(orgid, entityID_bos_org)) return accountOrg;
            return TmcDataServiceHelper.loadSingle((Object)orgid, (String)entityID_bos_org);
        }
    }

    public static DynamicObject getSuperiorOrgs(long orgId) {
        return TmcOrgDataHelper.getSuperiorOrgs(orgId, "08");
    }

    public static DynamicObject getSuperiorOrgs(long orgId, String orgViewType) {
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)orgViewType, (long)orgId);
        DynamicObject org = null;
        if (EmptyUtil.isNoEmpty(superiorOrgs) && superiorOrgs.size() > 0) {
            QFilter filter = new QFilter("id", "in", superiorOrgs.get(0));
            org = TmcDataServiceHelper.loadSingle((String)entityID_bos_org, (String)"id, orgpattern, fisbankroll", (QFilter[])new QFilter[]{filter});
        }
        return org;
    }

    public static List<Long> getAllSuperiorOrgs(String orgViewNumber, Long orgid) {
        Map superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgViewNumber, Collections.singletonList(orgid));
        return (List)superiorOrgs.get(orgid);
    }

    public static List<Long> getCacheUserPermission(Long userId, String appId, String entityId, String permItem) {
        HasPermOrgResult result;
        logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650appId=" + appId);
        if (EmptyUtil.isNoEmpty(appId)) {
            appId = AppMetadataCache.getAppInfo((String)appId).getId();
        }
        if ((result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)appId, (String)entityId, (String)permItem)).hasAllOrgPerm()) {
            logger.info("\u5168\u529f\u80fd\u7528\u6237,\u62e5\u6709\u6240\u6709\u7ec4\u7ec7\u6743\u9650, userId={},appId={},entityId={},permItem={}", new Object[]{userId, appId, entityId, permItem});
            return null;
        }
        List orgIds = result.getHasPermOrgs();
        logger.info("userId={},appId={},entityId={},permItem={}, \u6709\u6743\u9650\u7ec4\u7ec7\u8bb0\u5f55\u6570: {}", new Object[]{userId, appId, entityId, permItem, orgIds.size()});
        return orgIds;
    }

    public static List<DynamicObject> getAccountOrg(Long orgId) {
        if (EmptyUtil.isEmpty(orgId)) {
            return null;
        }
        QFilter qfilter = new QFilter("typerelation.totype", "=", (Object)"08");
        qfilter.and(new QFilter("typerelation.fromtype", "=", (Object)"10"));
        qfilter.and(new QFilter("toorg", "=", (Object)orgId));
        Map relateAcctOrgMap = TmcDataServiceHelper.loadFromCache((String)"bos_org_orgrelation", (QFilter[])qfilter.toArray());
        if (EmptyUtil.isEmpty(relateAcctOrgMap)) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> relateAcctOrgs = relateAcctOrgMap.entrySet().stream().map(v -> (DynamicObject)v.getValue()).filter(EmptyUtil::isNoEmpty).map(v -> v.getDynamicObject("fromorg")).collect(Collectors.toList());
        return relateAcctOrgs;
    }

    public static DataSet getOrgDateSet(Long orgViewId) {
        String selectFields = "org orgid,org,org.name orgname,org.number orgnumber,org.simplename simplename,parent pid,parent.number pnumber,( case when isleaf='1' then '0' else '1' end ) isgroupnode,longnumber,level,sortcode,case when org.simplename = NULL OR TRIM(org.simplename) = '' then org.name else org.simplename end as mixorgname";
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"tree-org", (String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("view.treetype", "=", (Object)"08"), new QFilter("view", "=", (Object)orgViewId)}, (String)"sortcode");
        orgDataSet = orgDataSet.addFields(new String[]{"orgid", "orgname"}, new String[]{"rowid", "fullorgname"});
        return orgDataSet;
    }

    public static List<Long> getOrgIds(Long orgviewId) {
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet(orgviewId);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        Iterator it = orgDs.iterator();
        while (it.hasNext()) {
            orgIds.add(((Row)it.next()).getLong("rowid"));
        }
        return orgIds;
    }

    public static String getOrgRootId(Long orgViewId) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode != null ? rootNode.getId() : null;
    }

    public static Long getPermRootOrgId(Long userId, String appId, String entityId, String permissionItem, Long orgViewId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)appId, (String)entityId, (String)permissionItem);
        if (result.hasAllOrgPerm()) {
            return Long.valueOf(TmcOrgDataHelper.getOrgRootId(orgViewId));
        }
        List orgIdList = result.getHasPermOrgs();
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet(orgViewId);
        DataSet defaultOrg = orgDateSet.filter("orgid in orgIdList", Collections.singletonMap("orgIdList", orgIdList)).orderBy(new String[]{"level"}).top(1);
        if (defaultOrg.hasNext()) {
            Row next = defaultOrg.next();
            return next.getLong("orgid");
        }
        return null;
    }

    public static List<Long> getAllOrgIdsByViewId(Long orgViewId) {
        String orgRootId = TmcOrgDataHelper.getOrgRootId(orgViewId);
        if (orgRootId == null) {
            return Collections.EMPTY_LIST;
        }
        Long rootId = Long.valueOf(orgRootId);
        List<Long> allOrgIds = TmcOrgDataHelper.getAllSubordinateOrgs(orgViewId, Collections.singletonList(rootId), true, true);
        return allOrgIds;
    }

    public static List<Long> getAllSubordinateOrgsForCache(Long orgViewId, List orgIdSet, boolean isInCludeCurOrg, boolean isIncludeDisable) {
        return TmcOrgDataHelper.getAllSubordinateOrgs(orgViewId, orgIdSet, isInCludeCurOrg, true, isIncludeDisable);
    }

    public static List<Long> getAllSubordinateOrgsForCache(Long orgViewId, List orgIdSet, boolean isInCludeCurOrg) {
        return TmcOrgDataHelper.getAllSubordinateOrgs(orgViewId, orgIdSet, isInCludeCurOrg, true);
    }

    public static List<Long> getAllSubordinateOrgs(Long orgViewId, List orgIdSet, boolean isInCludeCurOrg, boolean useCache) {
        return TmcOrgDataHelper.getAllSubordinateOrgs(orgViewId, orgIdSet, isInCludeCurOrg, useCache, true);
    }

    public static List<Long> getAllSubordinateOrgs(Long orgViewId, List orgIdSet, boolean isInCludeCurOrg, boolean useCache, boolean isIncludeDisable) {
        List orgIds;
        if (useCache) {
            String key = orgViewId + JSON.toJSONString((Object)orgIdSet) + isInCludeCurOrg;
            DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
            String orgString = (String)cache.get(key);
            if (EmptyUtil.isEmpty(orgString)) {
                orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)orgViewId, (List)orgIdSet, (boolean)isInCludeCurOrg, (boolean)isIncludeDisable);
                cache.put(key, (Object)SerializationUtils.toJsonString((Object)orgIds), 3000);
                OrgCacheManager.putCacheOrgKey(key);
            } else {
                orgIds = SerializationUtils.fromJsonStringToList((String)orgString, Long.class);
                OrgCacheManager.putCacheOrgKey(key);
            }
        } else {
            orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)orgViewId, (List)orgIdSet, (boolean)isInCludeCurOrg, (boolean)true);
        }
        return orgIds;
    }

    public static List<Long> getSecondOrgIdsForCache(Long orgViewId, Long rootId, boolean isIncludeDisable) {
        return TmcOrgDataHelper.getSecondOrgIds(orgViewId, rootId, isIncludeDisable, true);
    }

    public static List<Long> getSecondOrgIds(Long orgViewId, Long rootId, boolean isIncludeDisable, boolean useCache) {
        List<Long> orgIds;
        if (useCache) {
            String key = orgViewId + "-" + rootId;
            List cacheOrgIds = (List)AppCache.get((String)TmcAppEnum.TMC.getValue()).get(key, List.class);
            if (EmptyUtil.isEmpty(cacheOrgIds)) {
                orgIds = TmcOrgDataHelper.getSecondOrgIds(orgViewId, rootId, isIncludeDisable);
                cacheOrgIds = orgIds.stream().map(String::valueOf).collect(Collectors.toList());
                AppCache.get((String)TmcAppEnum.TMC.getValue()).put(key, cacheOrgIds, 3000);
                OrgCacheManager.putCacheOrgKey(key);
            } else {
                orgIds = cacheOrgIds.stream().map(Long::valueOf).collect(Collectors.toList());
            }
        } else {
            orgIds = TmcOrgDataHelper.getSecondOrgIds(orgViewId, rootId, isIncludeDisable);
        }
        return orgIds;
    }

    public static List<Long> getSecondOrgIds(Long orgViewId, Long rootId, boolean isIncludeDisable) {
        List<Long> orgIds = new ArrayList<Long>();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(orgViewId.longValue());
        param.setId(rootId.longValue());
        param.setIncludeDisable(isIncludeDisable);
        List subOrgMap = OrgUnitServiceHelper.getTreeChildrenMap((OrgTreeParam)param);
        if (subOrgMap != null && subOrgMap.size() > 0) {
            orgIds = subOrgMap.stream().map(o -> (Long)o.get("id")).collect(Collectors.toList());
        }
        return orgIds;
    }

    public static DataSet getAuthorizedBankOrgViewDataSet(Long userId) {
        QFilter viewFilter = new QFilter("enable", "=", (Object)"1");
        viewFilter.and("scope", "=", (Object)CompanySysAuthScopeEnum.ALL.getValue());
        viewFilter.or(new QFilter("scope", "=", (Object)CompanySysAuthScopeEnum.SELF.getValue()).and("creator", "=", (Object)userId));
        DataSet sysViewSch = QueryServiceHelper.queryDataSet((String)"TmcBusinessBaseHelperfbd_companysysviewsch", (String)"fbd_companysysviewsch", (String)"id", (QFilter[])viewFilter.toArray(), null);
        Set roles = PermissionServiceHelper.getRolesByUser((Long)userId);
        QFilter authFilter = new QFilter("authtype", "=", (Object)CompanySysAuthTypeEnum.USER.getValue());
        authFilter.and("authuser", "=", (Object)userId);
        authFilter.or(new QFilter("authtype", "=", (Object)CompanySysAuthTypeEnum.ROLE.getValue()).and("authrole", "in", (Object)roles));
        DataSet dsauth = QueryServiceHelper.queryDataSet((String)"TmcBusinessBaseHelperfbd_companysysauth", (String)"fbd_companysysauth", (String)"companysysview.id as id", (QFilter[])authFilter.toArray(), null);
        DataSet queryViewSch = null;
        if (!sysViewSch.isEmpty() && !dsauth.isEmpty()) {
            queryViewSch = sysViewSch.union(dsauth).distinct();
        } else if (!sysViewSch.isEmpty()) {
            queryViewSch = sysViewSch;
        } else if (!dsauth.isEmpty()) {
            queryViewSch = dsauth;
        }
        return queryViewSch;
    }

    public static List<Long> getAuthorizedBankOrgViewIds(Long userId, String appId, String entityID, String permissionItem) {
        DataSet ds = TmcOrgDataHelper.getAuthorizedBankOrgViewDataSet(userId);
        ArrayList<Long> viewIdList = new ArrayList<Long>(10);
        if (ds != null) {
            for (Row row : ds) {
                viewIdList.add(row.getLong("id"));
            }
        }
        return viewIdList;
    }

    public static QFilter getBankOrgViewQFilter(Long userId, String appId, String entityID, String permissionItem) {
        return new QFilter("id", "in", TmcOrgDataHelper.getAuthorizedBankOrgViewIds(userId, appId, entityID, permissionItem));
    }

    public static List<Long> getAuthorizedAndSubordinateOrgByView(Long orgViewId, Long userID, String appId, String entityID, String permissionItem, boolean isInCludeCurOrg, boolean useCache) {
        List<Long> orgIds = TmcOrgDataHelper.getAllOrgIdsByViewId(orgViewId);
        List id = TmcOrgDataHelper.getAuthorizedBankOrgFromCache(userID, appId, entityID, permissionItem).stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        orgIds.retainAll(id);
        return TmcOrgDataHelper.getAllSubordinateOrgs(orgViewId, orgIds, isInCludeCurOrg, useCache);
    }
}

