/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbp.common.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkCalendarHelper {
    public static int getWorkDayCount(Long[] wcIds, Date startDate, Date endDate) {
        Map<Date, Boolean> workDateMap = WorkCalendarHelper.getDateTypeMap(wcIds, startDate, endDate);
        return (int)workDateMap.values().stream().filter(v -> v).count();
    }

    public static boolean isWorkDay(Long[] wcIds, Date workDate) {
        Map<Date, Boolean> workDateMap = WorkCalendarHelper.getDateTypeMap(wcIds, workDate, workDate);
        return (Boolean)workDateMap.values().toArray()[0];
    }

    public static boolean isWorkDay(DynamicObjectCollection workCalendars, Date workDate) {
        Long[] wcIds = null;
        if (workCalendars != null && workCalendars.size() > 0) {
            wcIds = (Long[])workCalendars.stream().map(w -> w.getDynamicObject("fbasedataid")).map(w -> w.getLong("id")).toArray(Long[]::new);
        }
        Map<Date, Boolean> workDateMap = WorkCalendarHelper.getNewDateTypeMap(wcIds, workDate, workDate);
        return (Boolean)workDateMap.values().toArray()[0];
    }

    public static Map<Date, Boolean> getDateTypeMap(Long[] wcIds, Date startDate, Date endDate) {
        return WorkCalendarHelper.getNewDateTypeMap(wcIds, startDate, endDate);
    }

    public static Map<Date, Boolean> getNewDateTypeMap(Long[] wcIds, Date startDate, Date endDate) {
        HashMap<Date, Boolean> workDateMap = new HashMap<Date, Boolean>();
        if (wcIds != null && wcIds.length > 0) {
            QFilter f1 = new QFilter("entitys.workdate", ">=", (Object)startDate);
            QFilter f2 = new QFilter("entitys.workdate", "<=", (Object)endDate);
            QFilter f3 = new QFilter("id", "in", (Object)wcIds);
            DynamicObjectCollection workcalendars = QueryServiceHelper.query((String)"tbd_workcalendar", (String)"id,entitys,entitys.workdate,entitys.seq,entitys.datetype", (QFilter[])new QFilter[]{f1, f2, f3}, (String)"entitys.workdate asc, entitys.seq desc");
            if (workcalendars == null) {
                return workDateMap;
            }
            for (DynamicObject workcalendar : workcalendars) {
                Date date = workcalendar.getDate("entitys.workdate");
                if (workDateMap.containsKey(date)) continue;
                boolean isWorkDay = workcalendar.getInt("entitys.datetype") == 1 || workcalendar.getInt("entitys.datetype") == 2;
                workDateMap.put(date, isWorkDay);
            }
        }
        Date workDate = startDate;
        while (workDate.compareTo(endDate) <= 0) {
            if (!workDateMap.containsKey(workDate)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(workDate);
                boolean isWorkDay = 7 != calendar.get(7) && 1 != calendar.get(7);
                workDateMap.put(workDate, isWorkDay);
            }
            workDate = DateUtils.getNextDay(workDate, 1);
        }
        return workDateMap;
    }

    public static Map<Date, Boolean> getDateTypeMap(DynamicObjectCollection workCalendars, Date workDate) {
        HashMap<Date, Boolean> workDateMap = new HashMap<Date, Boolean>();
        HashSet<String> idList = new HashSet<String>();
        HashMap<Long, Boolean> workDateTable = new HashMap<Long, Boolean>();
        if (workCalendars != null && workCalendars.size() > 0) {
            for (DynamicObject workCalendar : workCalendars) {
                idList.add(workCalendar.getDynamicObject("fbasedataid").getString("id"));
            }
            String sSQL = "Select FId, FWorkDate, FDateType From t_tbd_workcalendar_entrys Where Fid in (" + StringUtils.join(idList, (String)",") + ") and Fworkdate = ?";
            DataSet ds = DB.queryDataSet((String)"workCalendar", (DBRoute)DBRouteConst.TMC, (String)sSQL, (Object[])new Object[]{workDate});
            for (Row row : ds) {
                if (row.getInteger("FDateType") == 1 || row.getInteger("FDateType") == 2) {
                    workDateTable.put(row.getLong("FId"), Boolean.TRUE);
                    continue;
                }
                workDateTable.put(row.getLong("FId"), Boolean.FALSE);
            }
            if (workDateTable.size() == idList.size()) {
                workDateMap.put(workDate, Boolean.TRUE);
                workDateTable.forEach((key, value) -> {
                    if (!value.booleanValue()) {
                        workDateMap.put(workDate, Boolean.FALSE);
                    }
                });
            } else {
                for (DynamicObject workCalendar : workCalendars) {
                    if (workDateTable.containsKey(workCalendar.getDynamicObject("fbasedataid").getLong("id"))) continue;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(workDate);
                    boolean isWorkDay = 7 != calendar.get(7) && 1 != calendar.get(7);
                    workDateMap.put(workDate, isWorkDay);
                }
            }
        } else if (!workDateMap.containsKey(workDate)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(workDate);
            boolean isWorkDay = 7 != calendar.get(7) && 1 != calendar.get(7);
            workDateMap.put(workDate, isWorkDay);
        }
        return workDateMap;
    }

    public static Date getLastWorkDate(DynamicObjectCollection workCalendars, Date curDate, int lastDay) {
        int count = 0;
        while (count < lastDay || !WorkCalendarHelper.isWorkDay(workCalendars, curDate)) {
            if (WorkCalendarHelper.isWorkDay(workCalendars, curDate)) {
                ++count;
                curDate = DateUtils.getLastDay(curDate, 1);
                continue;
            }
            curDate = DateUtils.getLastDay(curDate, 1);
        }
        return curDate;
    }

    public static Date getNextWorkDate(DynamicObjectCollection workCalendars, Date curDate, int nextDay) {
        int count = 0;
        if (!WorkCalendarHelper.isWorkDay(workCalendars, curDate)) {
            --nextDay;
        }
        while (count < nextDay || !WorkCalendarHelper.isWorkDay(workCalendars, curDate)) {
            if (WorkCalendarHelper.isWorkDay(workCalendars, curDate)) {
                ++count;
                curDate = DateUtils.getNextDay(curDate, 1);
                continue;
            }
            curDate = DateUtils.getNextDay(curDate, 1);
        }
        return curDate;
    }
}

